/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPPreviewFrame;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintException;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintable;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintableAdapter;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrintAttributes;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.cosmic.ctrl.kdf.kdprint.RepaginationListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Dimension2D;
import java.awt.print.PrinterException;
import javax.print.attribute.standard.MediaSizeName;
import org.apache.log4j.Logger;

public class KDPrint {
    private static final Logger logger = LogUtil.getPackageLogger(KDPrint.class);
    KDPrintbase printbase = null;
    KDPPreviewFrame previewFrame = null;
    PrintableProxy printableProxy = null;
    final KDPrintableAdapter dumpPrintableObj = new KDPrintableAdapter();
    boolean isApplication = false;
    boolean isClosed = false;
    PrintAttributes printAttributes;
    private static final String[] myStringTable = new String[]{"iso-a0", "iso-a1", "iso-a2", "iso-a3", "iso-a4", "iso-a5", "iso-a6", "iso-a7", "iso-a8", "iso-a9", "iso-a10", "iso-b0", "iso-b1", "iso-b2", "iso-b3", "iso-b4", "iso-b5", "iso-b6", "iso-b7", "iso-b8", "iso-b9", "iso-b10", "jis-b0", "jis-b1", "jis-b2", "jis-b3", "jis-b4", "jis-b5", "jis-b6", "jis-b7", "jis-b8", "jis-b9", "jis-b10", "iso-c0", "iso-c1", "iso-c2", "iso-c3", "iso-c4", "iso-c5", "iso-c6", "na-letter", "na-legal", "executive", "ledger", "tabloid", "invoice", "folio", "quarto", "japanese-postcard", "oufuko-postcard", "a", "b", "c", "d", "e", "iso-designated-long", "italian-envelope", "monarch-envelope", "personal-envelope", "na-number-9-envelope", "na-number-10-envelope", "na-number-11-envelope", "na-number-12-envelope", "na-number-14-envelope", "na-6x9-envelope", "na-7x9-envelope", "na-9x11-envelope", "na-9x12-envelope", "na-10x13-envelope", "na-10x14-envelope", "na-10x15-envelope", "na-5x7", "na-8x10"};
    private static final MediaSizeName[] myMediaSizeNameTable = new MediaSizeName[]{MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10};

    public KDPrint() throws KDPrintException {
        this.printableProxy = new PrintableProxy(this.dumpPrintableObj);
        this.printbase = new KDPrintbase(this.printableProxy, null);
        this.printbase.addRePaginationListener(this.printableProxy);
    }

    public KDPPreviewFrame getPreviewFrame() {
        if (this.previewFrame == null) {
            this.previewFrame = new KDPPreviewFrame(this);
            this.previewFrame.pack();
        }
        return this.previewFrame;
    }

    public void dispose() {
        if (this.previewFrame != null) {
            this.previewFrame.dispose();
        }
    }

    public void print() {
        this.printbase.print();
    }

    public void setPrintable(KDPrintable printable) {
        this.printableProxy.setPrintable(printable);
    }

    public void setPrintableObject(KDPrintableAdapter printableObj) {
        this.printableProxy.setPrintableObject(printableObj);
    }

    public void setRepaginationListener(RepaginationListener listener) {
        this.printableProxy.setRepaginationListener(listener);
    }

    public void setPageRange(int startPage, int endPage) {
        this.printbase.setPageRange(startPage, endPage);
    }

    public MediaSizeName setPrintableArea(Dimension2D area) {
        return this.printbase.getPrinterAttrManager().setProperPrintArea(area);
    }

    public PrintPage getPrintPage() {
        return this.printbase.getPrintPage();
    }

    public KDPrintbase getBase() {
        return this.printbase;
    }

    public boolean isApplication() {
        return this.isApplication;
    }

    public void preview(boolean bModel) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int xPos = (screenSize.width - this.getPreviewFrame().getSize().width) / 2;
        int yPos = (screenSize.height - this.getPreviewFrame().getSize().height) / 2;
        this.getPreviewFrame().setLocation(xPos, yPos);
        this.getPreviewFrame().setTitle(CtrlKDFMessages.getMLS("printPreview", "\u6253\u5370\u9884\u89c8"));
        if (bModel) {
            this.isClosed = false;
            this.getPreviewFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    KDPrint.this.isClosed = true;
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    KDPrint.this.isClosed = true;
                }
            });
            this.getPreviewFrame().setVisible(true);
            while (!this.isClosed) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e1) {
                    logger.error((Object)"err", (Throwable)e1);
                }
            }
        } else {
            this.getPreviewFrame().setVisible(true);
        }
    }

    public void setKDForm(Form form) {
        this.printbase.setKDForm(form);
    }

    protected class PrintableProxy
    implements KDPrintable,
    RepaginationListener {
        private KDPrintable printable;
        private RepaginationListener repaginationListener;

        public PrintableProxy(KDPrintableAdapter printableObj) {
            this.printable = printableObj;
            this.repaginationListener = printableObj;
        }

        public void setPrintable(KDPrintable printable) {
            this.printable = printable;
        }

        public void setRepaginationListener(RepaginationListener listener) {
            this.repaginationListener = listener;
        }

        public void setPrintableObject(KDPrintableAdapter printableObj) {
            this.printable = printableObj;
            KDPrint.this.printbase.removeRePaginationListener(this.repaginationListener);
            this.repaginationListener = printableObj;
            KDPrint.this.printbase.addRePaginationListener(this.repaginationListener);
        }

        public KDPrintableAdapter getPrintableObject() {
            return (KDPrintableAdapter)this.printable;
        }

        @Override
        public int print(Graphics graphics, KDPrintable.AreaInfo areaInfo, int pageIndex) throws PrinterException {
            return this.printable.print(graphics, areaInfo, pageIndex);
        }

        @Override
        public int bodyHeightChanged(int hOld, int hNew) {
            return this.repaginationListener.bodyHeightChanged(hOld, hNew);
        }

        @Override
        public int footerHeightChanged(int hOld, int hNew) {
            return this.repaginationListener.footerHeightChanged(hOld, hNew);
        }

        @Override
        public int headerHeightChanged(int hOld, int hNew) {
            return this.repaginationListener.headerHeightChanged(hOld, hNew);
        }

        @Override
        public int PrintPageUpdated(PrintPage page) {
            return this.repaginationListener.PrintPageUpdated(page);
        }

        @Override
        public int widthChanged(int wOld, int wNew) {
            return this.repaginationListener.widthChanged(wOld, wNew);
        }
    }
}

