/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.cosmic.ctrl.kdf.kdprint.resources.KDPrintResources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class MultiPageChooseDialog
extends JDialog
implements MouseMotionListener,
MouseListener {
    private static final long serialVersionUID = 92189326407198482L;
    JLabel[] myPageIcons;
    int rows;
    int cols;
    JPanel gridPane = new JPanel();
    JLabel status = new JLabel(" ");
    String statusSubfix;
    String statusCancel;
    KDPrintbase base;
    boolean cancel = false;
    Icon icon1 = KDPrintResources.getIcon("com/kingdee/cosmic/ctrl/kdf/kdprint/resources/Page1.gif");
    Icon icon2 = KDPrintResources.getIcon("com/kingdee/cosmic/ctrl/kdf/kdprint/resources/Page2.gif");
    Component curComp;
    int iCurComp = -1;
    int selRows = 0;
    int selCols = 0;
    boolean bDrag = false;

    public MultiPageChooseDialog(KDPrintbase printbase, Frame parent, int cRows, int cCols, int cPages) {
        super(parent, true);
        this.base = printbase;
        this.rows = cRows;
        this.cols = cCols;
        this.gridPane.setLayout(new GridLayout(cRows, cCols, 4, 4));
        this.getContentPane().add((Component)this.gridPane, "North");
        this.myPageIcons = new JLabel[cRows * cCols];
        for (int i = 0; i < cRows * cCols; ++i) {
            this.myPageIcons[i] = new JLabel(this.icon1);
            this.gridPane.add(this.myPageIcons[i]);
        }
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.statusSubfix = this.base.getResources().getString("multiPageSelDialog.statusSubfix");
        this.statusCancel = this.base.getResources().getString("multiPageSelDialog.statusCancel");
        this.getContentPane().add((Component)this.status, "South");
        this.status.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MultiPageChooseDialog.this.status.setText(MultiPageChooseDialog.this.statusCancel);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                MultiPageChooseDialog.this.setCancel(true);
                MultiPageChooseDialog.this.hide();
            }
        });
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        return statusPane;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Component comp = this.gridPane.getComponentAt(e.getPoint());
        if (comp != this.curComp) {
            for (int i = 0; i < this.myPageIcons.length; ++i) {
                if (comp != this.myPageIcons[i]) continue;
                this.setSelectedEffect(this.iCurComp, i);
                this.curComp = comp;
                this.iCurComp = i;
                this.selRows = i / this.cols;
                this.selCols = i % this.cols;
                this.status.setText(this.selRows + 1 + " x " + (this.selCols + 1) + this.statusSubfix);
            }
        }
    }

    private void setSelectedEffect(int iPrev, int index) {
        int j;
        int i;
        boolean[][] isSwap = new boolean[this.rows][this.cols];
        for (int i2 = 0; i2 < this.rows; ++i2) {
            for (int j2 = 0; j2 < this.cols; ++j2) {
                isSwap[i2][j2] = false;
            }
        }
        int theRows = index / this.cols;
        int theCols = index % this.cols;
        int prevRows = iPrev / this.cols;
        int prevCols = iPrev % this.cols;
        for (i = 0; i <= theRows; ++i) {
            for (j = 0; j <= theCols; ++j) {
                isSwap[i][j] = !isSwap[i][j];
            }
        }
        if (iPrev != -1) {
            for (i = 0; i <= prevRows; ++i) {
                for (j = 0; j <= prevCols; ++j) {
                    isSwap[i][j] = !isSwap[i][j];
                }
            }
        }
        int idxComp = 0;
        for (int i3 = 0; i3 < this.rows; ++i3) {
            for (int j3 = 0; j3 < this.cols; ++j3) {
                if (isSwap[i3][j3]) {
                    if (this.myPageIcons[idxComp].getIcon() == this.icon1) {
                        this.myPageIcons[idxComp].setIcon(this.icon2);
                    } else if (this.myPageIcons[idxComp].getIcon() == this.icon2) {
                        this.myPageIcons[idxComp].setIcon(this.icon1);
                    } else {
                        this.myPageIcons[idxComp].setIcon(this.icon1);
                    }
                }
                ++idxComp;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.setCancel(false);
        this.hide();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
        this.bDrag = true;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.bDrag) {
            this.gridPane.add(new JLabel(this.icon2));
            this.gridPane.add(new JLabel(this.icon2));
            this.gridPane.add(new JLabel(this.icon2));
            this.gridPane.revalidate();
            this.gridPane.repaint();
        }
        this.bDrag = false;
    }

    public int getSelCols() {
        return this.selCols;
    }

    public int getSelRows() {
        return this.selRows;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void setCancel(boolean b) {
        this.cancel = b;
    }
}

