/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintable;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.SimpleDoc;
import org.apache.log4j.Logger;

public class PageGraphicsProxy
implements Printable {
    private static final Logger logger = LogUtil.getPackageLogger(PageGraphicsProxy.class);
    int cacheSize = 40;
    protected KDPrintable printable;
    protected KDPrintbase base;
    boolean detectingGraphics = false;
    FontRenderContext fontRenderContext = null;
    ArrayList g2Recorders = new ArrayList(this.cacheSize);
    protected static final int PAINT_MODE_INCH_DIV_72 = 2;
    protected int paintUnitMode = 2;

    protected PageGraphicsProxy(KDPrintable kdprintable, KDPrintbase printbase) {
        this.printable = kdprintable;
        this.base = printbase;
    }

    private int print1(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Rectangle area = new Rectangle((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        KDPrintable.AreaInfo areaInfo = new KDPrintable.AreaInfo();
        areaInfo.area = area;
        return this.printable.print(graphics, areaInfo, pageIndex);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.detectingGraphics) {
            this.fontRenderContext = ((Graphics2D)graphics).getFontRenderContext();
            return 1;
        }
        if (this.getPaintUnitMode() == 2) {
            return this.print1(graphics, pageFormat, pageIndex);
        }
        return 1;
    }

    protected void FlushPageGraphics() {
        for (int i = 0; i < this.g2Recorders.size(); ++i) {
            this.g2Recorders.set(i, null);
        }
    }

    protected KDPrintable getPrintable() {
        return this.printable;
    }

    public int getPaintUnitMode() {
        return this.paintUnitMode;
    }

    public FontRenderContext getFontRenderContext() {
        DocPrintJob pj = this.base.selServ.createPrintJob();
        this.detectingGraphics = true;
        try {
            SimpleDoc doc = new SimpleDoc(this, DocFlavor.SERVICE_FORMATTED.PRINTABLE, null);
            pj.print(doc, null);
        }
        catch (PrintException printException) {
            // empty catch block
        }
        this.detectingGraphics = false;
        return this.fontRenderContext;
    }
}

