/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint.util;

import com.kingdee.cosmic.ctrl.kdf.kdprint.util.JSliderEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class BasicSliderExUI
extends SliderUI
implements Serializable {
    private static final long serialVersionUID = -2023406815L;
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected transient Timer scrollTimer;
    protected transient JSliderEx slider;
    protected transient Insets focusInsets = null;
    protected transient Insets insetCache = null;
    protected boolean leftToRightCache = true;
    protected transient Rectangle focusRect = null;
    protected transient Rectangle contentRect = null;
    protected transient Rectangle labelRect = null;
    protected transient Rectangle tickRect = null;
    protected transient Rectangle trackRect = null;
    protected transient Rectangle[] thumbRect = null;
    protected int selectedThumbIndex = 0;
    protected int thumbCount = 1;
    protected int trackBuffer = 0;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(200, 21);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(21, 200);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
    private transient boolean isDragging;
    protected transient TrackListener trackListener;
    protected transient ChangeListener changeListener;
    protected transient ComponentListener componentListener;
    protected transient FocusListener focusListener;
    protected transient ScrollListener scrollListener;
    protected transient PropertyChangeListener propertyChangeListener;
    private transient Color shadowColor;
    private transient Color highlightColor;
    private transient Color focusColor;
    private static Rectangle unionRect = new Rectangle();

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent b) {
        return new BasicSliderExUI((JSliderEx)b);
    }

    public BasicSliderExUI(JSliderEx b) {
        this.thumbCount = b.getModels().length;
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    public void installUI(JComponent c) {
        this.slider = (JSliderEx)c;
        this.slider.setEnabled(this.slider.isEnabled());
        this.slider.setOpaque(true);
        this.isDragging = false;
        this.trackListener = this.createTrackListener(this.slider);
        this.changeListener = this.createChangeListener(this.slider);
        this.componentListener = this.createComponentListener(this.slider);
        this.focusListener = this.createFocusListener(this.slider);
        this.scrollListener = this.createScrollListener(this.slider);
        this.propertyChangeListener = this.createPropertyChangeListener(this.slider);
        this.installDefaults(this.slider);
        this.installListeners(this.slider);
        this.installKeyboardActions(this.slider);
        this.scrollTimer = new Timer(100, this.scrollListener);
        this.scrollTimer.setInitialDelay(300);
        this.insetCache = this.slider.getInsets();
        this.leftToRightCache = BasicSliderExUI.isLeftToRight(this.slider);
        this.focusRect = new Rectangle();
        this.contentRect = new Rectangle();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle[this.thumbCount];
        this.calculateGeometry();
    }

    @Override
    public void uninstallUI(JComponent c) {
        if (c != this.slider) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + c + " when it only knows about " + this.slider + ".");
        }
        LookAndFeel.uninstallBorder(this.slider);
        this.scrollTimer.stop();
        this.scrollTimer = null;
        this.uninstallListeners(this.slider);
        this.uninstallKeyboardActions(this.slider);
        this.focusInsets = null;
        this.insetCache = null;
        this.leftToRightCache = true;
        this.focusRect = null;
        this.contentRect = null;
        this.labelRect = null;
        this.tickRect = null;
        this.trackRect = null;
        this.thumbRect = null;
        this.trackListener = null;
        this.changeListener = null;
        this.componentListener = null;
        this.focusListener = null;
        this.scrollListener = null;
        this.propertyChangeListener = null;
        this.slider = null;
    }

    protected void installDefaults(JSliderEx slider) {
        LookAndFeel.installBorder(slider, "Slider.border");
        LookAndFeel.installColors(slider, "Slider.background", "Slider.foreground");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = (Insets)UIManager.get("Slider.focusInsets");
    }

    protected TrackListener createTrackListener(JSliderEx slider) {
        return new TrackListener();
    }

    protected ChangeListener createChangeListener(JSliderEx slider) {
        return new ChangeHandler();
    }

    protected ComponentListener createComponentListener(JSliderEx slider) {
        return new ComponentHandler();
    }

    protected FocusListener createFocusListener(JSliderEx slider) {
        return new FocusHandler();
    }

    protected ScrollListener createScrollListener(JSliderEx slider) {
        return new ScrollListener();
    }

    protected PropertyChangeListener createPropertyChangeListener(JSliderEx slider) {
        return new PropertyChangeHandler();
    }

    protected void installListeners(JSliderEx slider) {
        slider.addMouseListener(this.trackListener);
        slider.addMouseMotionListener(this.trackListener);
        slider.addFocusListener(this.focusListener);
        slider.addComponentListener(this.componentListener);
        slider.addPropertyChangeListener(this.propertyChangeListener);
        for (int i = 0; i < slider.getModels().length; ++i) {
            slider.getModel(i).addChangeListener(this.changeListener);
        }
    }

    protected void uninstallListeners(JSliderEx slider) {
        slider.removeMouseListener(this.trackListener);
        slider.removeMouseMotionListener(this.trackListener);
        slider.removeFocusListener(this.focusListener);
        slider.removeComponentListener(this.componentListener);
        slider.removePropertyChangeListener(this.propertyChangeListener);
        for (int i = 0; i < slider.getModels().length; ++i) {
            slider.getModel(i).removeChangeListener(this.changeListener);
        }
    }

    protected void installKeyboardActions(JSliderEx slider) {
        InputMap km = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(slider, 0, km);
        ActionMap am = this.getActionMap();
        SwingUtilities.replaceUIActionMap(slider, am);
    }

    InputMap getInputMap(int condition) {
        if (condition == 0) {
            InputMap rtlKeyMap;
            InputMap keyMap = (InputMap)UIManager.get("Slider.focusInputMap");
            if (this.slider.getComponentOrientation().isLeftToRight() || (rtlKeyMap = (InputMap)UIManager.get("Slider.focusInputMap.RightToLeft")) == null) {
                return keyMap;
            }
            rtlKeyMap.setParent(keyMap);
            return rtlKeyMap;
        }
        return null;
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIManager.get("Slider.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Slider.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        map.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        map.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        map.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        map.put("minScroll", new SharedActionScroller(-2, true));
        map.put("maxScroll", new SharedActionScroller(2, true));
        return map;
    }

    protected void uninstallKeyboardActions(JSliderEx slider) {
        SwingUtilities.replaceUIActionMap(slider, null);
        SwingUtilities.replaceUIInputMap(slider, 0, null);
    }

    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getPreferredVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            d = new Dimension(this.getPreferredHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return d;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension d;
        this.recalculateIfInsetsChanged();
        if (this.slider.getOrientation() == 1) {
            d = new Dimension(this.getMinimumVerticalSize());
            d.width = this.insetCache.left + this.insetCache.right;
            d.width += this.focusInsets.left + this.focusInsets.right;
            d.width += this.trackRect.width + this.tickRect.width + this.labelRect.width;
        } else {
            d = new Dimension(this.getMinimumHorizontalSize());
            d.height = this.insetCache.top + this.insetCache.bottom;
            d.height += this.focusInsets.top + this.focusInsets.bottom;
            d.height += this.trackRect.height + this.tickRect.height + this.labelRect.height;
        }
        return d;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        if (this.slider.getOrientation() == 1) {
            d.height = Short.MAX_VALUE;
        } else {
            d.width = Short.MAX_VALUE;
        }
        return d;
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.focusRect.x = this.insetCache.left;
        this.focusRect.y = this.insetCache.top;
        this.focusRect.width = this.slider.getWidth() - (this.insetCache.left + this.insetCache.right);
        this.focusRect.height = this.slider.getHeight() - (this.insetCache.top + this.insetCache.bottom);
    }

    protected void calculateThumbSize() {
        Dimension size = this.getThumbSize();
        for (int i = 0; i < this.thumbRect.length; ++i) {
            if (this.thumbRect[i] == null) {
                this.thumbRect[i] = new Rectangle();
            }
            this.thumbRect[i].setSize(size.width, size.height);
        }
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - (this.focusInsets.left + this.focusInsets.right);
        this.contentRect.height = this.focusRect.height - (this.focusInsets.top + this.focusInsets.bottom);
    }

    protected void calculateThumbLocation() {
        for (int i = 0; i < this.thumbCount; ++i) {
            this.calculateThumbLocationOf(i);
        }
    }

    protected void calculateThumbLocationOf(int thumbIndex) {
        int valuePosition;
        if (this.slider.getSnapToTicks()) {
            int sliderValue;
            int snappedValue = sliderValue = this.slider.getValue(thumbIndex);
            int majorTickSpacing = this.slider.getMajorTickSpacing();
            int minorTickSpacing = this.slider.getMinorTickSpacing();
            int tickSpacing = 0;
            if (minorTickSpacing > 0) {
                tickSpacing = minorTickSpacing;
            } else if (majorTickSpacing > 0) {
                tickSpacing = majorTickSpacing;
            }
            if (tickSpacing != 0) {
                if ((sliderValue - this.slider.getMinimum(thumbIndex)) % tickSpacing != 0) {
                    float temp = (float)(sliderValue - this.slider.getMinimum(thumbIndex)) / (float)tickSpacing;
                    int whichTick = Math.round(temp);
                    snappedValue = this.slider.getMinimum(thumbIndex) + whichTick * tickSpacing;
                }
                if (snappedValue != sliderValue) {
                    this.slider.setValue(snappedValue, thumbIndex);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            valuePosition = this.xPositionForValue(this.slider.getValue(thumbIndex));
            this.thumbRect[thumbIndex].x = valuePosition - this.thumbRect[thumbIndex].width / 2;
            this.thumbRect[thumbIndex].y = this.trackRect.y;
        } else {
            valuePosition = this.yPositionForValue(this.slider.getValue(thumbIndex));
            this.thumbRect[thumbIndex].x = this.trackRect.x;
            this.thumbRect[thumbIndex].y = valuePosition - this.thumbRect[thumbIndex].height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        if (this.slider.getPaintLabels() && this.slider.getLabelTable() != null) {
            Component highLabel = this.getHighestValueLabel();
            Component lowLabel = this.getLowestValueLabel();
            if (this.slider.getOrientation() == 0) {
                this.trackBuffer = Math.max(highLabel.getBounds().width, lowLabel.getBounds().width) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect[0].width / 2);
            } else {
                this.trackBuffer = Math.max(highLabel.getBounds().height, lowLabel.getBounds().height) / 2;
                this.trackBuffer = Math.max(this.trackBuffer, this.thumbRect[0].height / 2);
            }
        } else {
            this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect[0].width / 2 : this.thumbRect[0].height / 2;
        }
    }

    protected void calculateTrackRect() {
        int centerSpacing = 0;
        if (this.slider.getOrientation() == 0) {
            centerSpacing = this.thumbRect[0].height;
            if (this.slider.getPaintTicks()) {
                centerSpacing += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                centerSpacing += this.getHeightOfTallestLabel();
            }
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - centerSpacing - 1) / 2;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2;
            this.trackRect.height = this.thumbRect[0].height;
        } else {
            centerSpacing = this.thumbRect[0].width;
            if (BasicSliderExUI.isLeftToRight(this.slider)) {
                if (this.slider.getPaintTicks()) {
                    centerSpacing += this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing += this.getWidthOfWidestLabel();
                }
            } else {
                if (this.slider.getPaintTicks()) {
                    centerSpacing -= this.getTickLength();
                }
                if (this.slider.getPaintLabels()) {
                    centerSpacing -= this.getWidthOfWidestLabel();
                }
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - centerSpacing - 1) / 2;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect[0].width;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (BasicSliderExUI.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getPaintLabels()) {
            if (this.slider.getOrientation() == 0) {
                this.labelRect.x = this.tickRect.x - this.trackBuffer;
                this.labelRect.y = this.tickRect.y + this.tickRect.height;
                this.labelRect.width = this.tickRect.width + this.trackBuffer * 2;
                this.labelRect.height = this.getHeightOfTallestLabel();
            } else {
                if (BasicSliderExUI.isLeftToRight(this.slider)) {
                    this.labelRect.x = this.tickRect.x + this.tickRect.width;
                    this.labelRect.width = this.getWidthOfWidestLabel();
                } else {
                    this.labelRect.width = this.getWidthOfWidestLabel();
                    this.labelRect.x = this.tickRect.x - this.labelRect.width;
                }
                this.labelRect.y = this.tickRect.y - this.trackBuffer;
                this.labelRect.height = this.tickRect.height + this.trackBuffer * 2;
            }
        } else if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.tickRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.tickRect.width;
            this.labelRect.height = 0;
        } else {
            this.labelRect.x = BasicSliderExUI.isLeftToRight(this.slider) ? this.tickRect.x + this.tickRect.width : this.tickRect.x;
            this.labelRect.y = this.tickRect.y;
            this.labelRect.width = 0;
            this.labelRect.height = this.tickRect.height;
        }
    }

    protected Dimension getThumbSize() {
        Dimension size = new Dimension();
        if (this.slider.getOrientation() == 1) {
            size.width = 20;
            size.height = 11;
        } else {
            size.width = 11;
            size.height = 20;
        }
        return size;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int widest = 0;
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Component label = (Component)dictionary.get(keys.nextElement());
                widest = Math.max(label.getPreferredSize().width, widest);
            }
        }
        return widest;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int tallest = 0;
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            while (keys.hasMoreElements()) {
                Component label = (Component)dictionary.get(keys.nextElement());
                tallest = Math.max(label.getPreferredSize().height, tallest);
            }
        }
        return tallest;
    }

    protected int getWidthOfHighValueLabel() {
        Component label = this.getHighestValueLabel();
        int width = 0;
        if (label != null) {
            width = label.getPreferredSize().width;
        }
        return width;
    }

    protected int getWidthOfLowValueLabel() {
        Component label = this.getLowestValueLabel();
        int width = 0;
        if (label != null) {
            width = label.getPreferredSize().width;
        }
        return width;
    }

    protected int getHeightOfHighValueLabel() {
        Component label = this.getHighestValueLabel();
        int height = 0;
        if (label != null) {
            height = label.getPreferredSize().height;
        }
        return height;
    }

    protected int getHeightOfLowValueLabel() {
        Component label = this.getLowestValueLabel();
        int height = 0;
        if (label != null) {
            height = label.getPreferredSize().height;
        }
        return height;
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (BasicSliderExUI.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    protected Component getLowestValueLabel() {
        Enumeration keys;
        Dictionary dictionary = this.slider.getLabelTable();
        Component label = null;
        if (dictionary != null && (keys = dictionary.keys()).hasMoreElements()) {
            int lowestValue = (Integer)keys.nextElement();
            while (keys.hasMoreElements()) {
                int value = (Integer)keys.nextElement();
                lowestValue = Math.min(value, lowestValue);
            }
            label = (Component)dictionary.get(lowestValue);
        }
        return label;
    }

    protected Component getHighestValueLabel() {
        Enumeration keys;
        Dictionary dictionary = this.slider.getLabelTable();
        Component label = null;
        if (dictionary != null && (keys = dictionary.keys()).hasMoreElements()) {
            int highestValue = (Integer)keys.nextElement();
            while (keys.hasMoreElements()) {
                int value = (Integer)keys.nextElement();
                highestValue = Math.max(value, highestValue);
            }
            label = (Component)dictionary.get(highestValue);
        }
        return label;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle clip = g.getClipBounds();
        if (!clip.intersects(this.trackRect) && this.slider.getPaintTrack()) {
            this.calculateGeometry();
        }
        if (this.slider.getPaintTrack() && clip.intersects(this.trackRect)) {
            this.paintTrack(g);
        }
        if (this.slider.getPaintTicks() && clip.intersects(this.tickRect)) {
            this.paintTicks(g);
        }
        if (this.slider.getPaintLabels() && clip.intersects(this.labelRect)) {
            this.paintLabels(g);
        }
        if (this.slider.hasFocus() && clip.intersects(this.focusRect)) {
            this.paintFocus(g);
        }
        for (int i = 0; i < this.thumbRect.length; ++i) {
            if (!clip.intersects(this.thumbRect[i])) continue;
            this.paintThumb(g);
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets newInsets = this.slider.getInsets();
        if (!newInsets.equals(this.insetCache)) {
            this.insetCache = newInsets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        boolean ltr = BasicSliderExUI.isLeftToRight(this.slider);
        if (ltr != this.leftToRightCache) {
            this.leftToRightCache = ltr;
            this.calculateGeometry();
        }
    }

    public void paintFocus(Graphics g) {
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
    }

    public void paintTrack(Graphics g) {
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int pad;
            int cx = pad = this.trackBuffer;
            int cy = trackBounds.height / 2 - 2;
            int cw = trackBounds.width;
            g.translate(trackBounds.x, trackBounds.y + cy);
            g.setColor(this.getShadowColor());
            g.drawLine(0, 0, cw - 1, 0);
            g.drawLine(0, 1, 0, 2);
            g.setColor(this.getHighlightColor());
            g.drawLine(0, 3, cw, 3);
            g.drawLine(cw, 0, cw, 3);
            g.setColor(Color.black);
            g.drawLine(1, 1, cw - 2, 1);
            g.translate(-trackBounds.x, -(trackBounds.y + cy));
        } else {
            int pad = this.trackBuffer;
            int cx = trackBounds.width / 2 - 2;
            int cy = pad;
            int ch = trackBounds.height;
            g.translate(trackBounds.x + cx, trackBounds.y);
            g.setColor(this.getShadowColor());
            g.drawLine(0, 0, 0, ch - 1);
            g.drawLine(1, 0, 2, 0);
            g.setColor(this.getHighlightColor());
            g.drawLine(3, 0, 3, ch);
            g.drawLine(0, ch, 3, ch);
            g.setColor(Color.black);
            g.drawLine(1, 1, 1, ch - 2);
            g.translate(-(trackBounds.x + cx), -trackBounds.y);
        }
    }

    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        g.setColor(this.slider.getBackground());
        g.fillRect(tickBounds.x, tickBounds.y, tickBounds.width, tickBounds.height);
        g.setColor(Color.black);
        if (this.slider.getOrientation() == 0) {
            int value;
            g.translate(0, tickBounds.y);
            int xPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(0); value <= this.slider.getMaximum(0); value += this.slider.getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(0); value <= this.slider.getMaximum(0); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum(0);
            int yPos = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!BasicSliderExUI.isLeftToRight(this.slider)) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= this.slider.getMaximum(0)) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!BasicSliderExUI.isLeftToRight(this.slider)) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum(0);
                if (!BasicSliderExUI.isLeftToRight(this.slider)) {
                    g.translate(2, 0);
                }
                while (value <= this.slider.getMaximum(0)) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!BasicSliderExUI.isLeftToRight(this.slider)) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height / 2 - 1);
    }

    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height - 2);
    }

    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(0, y, tickBounds.width / 2 - 1, y);
    }

    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(0, y, tickBounds.width - 2, y);
    }

    public void paintLabels(Graphics g) {
        Rectangle labelBounds = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration keys = dictionary.keys();
            int minValue = this.slider.getMinimum(0);
            int maxValue = this.slider.getMaximum(0);
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int value = key;
                if (value < minValue || value > maxValue) continue;
                Component label = (Component)dictionary.get(key);
                if (this.slider.getOrientation() == 0) {
                    g.translate(0, labelBounds.y);
                    this.paintHorizontalLabel(g, value, label);
                    g.translate(0, -labelBounds.y);
                    continue;
                }
                int offset = 0;
                if (!BasicSliderExUI.isLeftToRight(this.slider)) {
                    offset = labelBounds.width - label.getPreferredSize().width;
                }
                g.translate(labelBounds.x + offset, 0);
                this.paintVerticalLabel(g, value, label);
                g.translate(-labelBounds.x - offset, 0);
            }
        }
    }

    protected void paintHorizontalLabel(Graphics g, int value, Component label) {
        int labelCenter = this.xPositionForValue(value);
        int labelLeft = labelCenter - label.getPreferredSize().width / 2;
        g.translate(labelLeft, 0);
        label.paint(g);
        g.translate(-labelLeft, 0);
    }

    protected void paintVerticalLabel(Graphics g, int value, Component label) {
        int labelCenter = this.yPositionForValue(value);
        int labelTop = labelCenter - label.getPreferredSize().height / 2;
        g.translate(0, labelTop);
        label.paint(g);
        g.translate(0, -labelTop);
    }

    public void paintThumb(Graphics g) {
        for (int i = 0; i < this.thumbRect.length; ++i) {
            this.paintAThumb(g, this.thumbRect[i]);
        }
    }

    private void paintAThumb(Graphics g, Rectangle knobBounds) {
        int w = knobBounds.width;
        int h = knobBounds.height;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.isEnabled()) {
            g.setColor(this.slider.getBackground());
        } else {
            g.setColor(this.slider.getBackground().darker());
        }
        if (!this.slider.getPaintTicks()) {
            g.fillRect(0, 0, w, h);
            g.setColor(Color.black);
            g.drawLine(0, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 0, w - 1, h - 1);
            g.setColor(this.highlightColor);
            g.drawLine(0, 0, 0, h - 2);
            g.drawLine(1, 0, w - 2, 0);
            g.setColor(this.shadowColor);
            g.drawLine(1, h - 2, w - 2, h - 2);
            g.drawLine(w - 2, 1, w - 2, h - 3);
        } else if (this.slider.getOrientation() == 0) {
            int cw = w / 2;
            g.fillRect(1, 1, w - 3, h - 1 - cw);
            Polygon p = new Polygon();
            p.addPoint(1, h - cw);
            p.addPoint(cw - 1, h - 1);
            p.addPoint(w - 2, h - 1 - cw);
            g.fillPolygon(p);
            g.setColor(this.highlightColor);
            g.drawLine(0, 0, w - 2, 0);
            g.drawLine(0, 1, 0, h - 1 - cw);
            g.drawLine(0, h - cw, cw - 1, h - 1);
            g.setColor(Color.black);
            g.drawLine(w - 1, 0, w - 1, h - 2 - cw);
            g.drawLine(w - 1, h - 1 - cw, w - 1 - cw, h - 1);
            g.setColor(this.shadowColor);
            g.drawLine(w - 2, 1, w - 2, h - 2 - cw);
            g.drawLine(w - 2, h - 1 - cw, w - 1 - cw, h - 2);
        } else {
            int cw = h / 2;
            if (BasicSliderExUI.isLeftToRight(this.slider)) {
                g.fillRect(1, 1, w - 1 - cw, h - 3);
                Polygon p = new Polygon();
                p.addPoint(w - cw - 1, 0);
                p.addPoint(w - 1, cw);
                p.addPoint(w - 1 - cw, h - 2);
                g.fillPolygon(p);
                g.setColor(this.highlightColor);
                g.drawLine(0, 0, 0, h - 2);
                g.drawLine(1, 0, w - 1 - cw, 0);
                g.drawLine(w - cw - 1, 0, w - 1, cw);
                g.setColor(Color.black);
                g.drawLine(0, h - 1, w - 2 - cw, h - 1);
                g.drawLine(w - 1 - cw, h - 1, w - 1, h - 1 - cw);
                g.setColor(this.shadowColor);
                g.drawLine(1, h - 2, w - 2 - cw, h - 2);
                g.drawLine(w - 1 - cw, h - 2, w - 2, h - cw - 1);
            } else {
                g.fillRect(5, 1, w - 1 - cw, h - 3);
                Polygon p = new Polygon();
                p.addPoint(cw, 0);
                p.addPoint(0, cw);
                p.addPoint(cw, h - 2);
                g.fillPolygon(p);
                g.setColor(this.highlightColor);
                g.drawLine(cw - 1, 0, w - 2, 0);
                g.drawLine(0, cw, cw, 0);
                g.setColor(Color.black);
                g.drawLine(0, h - 1 - cw, cw, h - 1);
                g.drawLine(cw, h - 1, w - 1, h - 1);
                g.setColor(this.shadowColor);
                g.drawLine(cw, h - 2, w - 2, h - 2);
                g.drawLine(w - 1, 1, w - 1, h - 2);
            }
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    public void setThumbLocation(int x, int y, int thumb) {
        unionRect.setBounds(this.thumbRect[thumb]);
        this.thumbRect[thumb].setLocation(x, y);
        SwingUtilities.computeUnion(this.thumbRect[thumb].x, this.thumbRect[thumb].y, this.thumbRect[thumb].width, this.thumbRect[thumb].height, unionRect);
        this.slider.repaint(BasicSliderExUI.unionRect.x, BasicSliderExUI.unionRect.y, BasicSliderExUI.unionRect.width, BasicSliderExUI.unionRect.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int direction) {
        JSliderEx jSliderEx = this.slider;
        synchronized (jSliderEx) {
            int oldValue = this.slider.getValue(0);
            int blockIncrement = (this.slider.getMaximum(0) - this.slider.getMinimum(0)) / 10;
            if (blockIncrement <= 0 && this.slider.getMaximum(0) > this.slider.getMinimum(0)) {
                blockIncrement = 1;
            }
            int delta = blockIncrement * (direction > 0 ? 1 : -1);
            this.slider.setValue(oldValue + delta, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int direction) {
        JSliderEx jSliderEx = this.slider;
        synchronized (jSliderEx) {
            int oldValue = this.slider.getValue(0);
            int delta = 1 * (direction > 0 ? 1 : -1);
            this.slider.setValue(oldValue + delta, 0);
        }
    }

    protected void scrollDueToClickInTrack(int dir) {
        this.scrollByBlock(dir);
    }

    protected int xPositionForValue(int value) {
        int xPosition;
        int min = this.slider.getMinimum(0);
        int max = this.slider.getMaximum(0);
        int trackLength = this.trackRect.width;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
        if (!this.drawInverted()) {
            xPosition = trackLeft;
            xPosition = (int)((long)xPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        } else {
            xPosition = trackRight;
            xPosition = (int)((long)xPosition - Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        xPosition = Math.max(trackLeft, xPosition);
        xPosition = Math.min(trackRight, xPosition);
        return xPosition;
    }

    protected int yPositionForValue(int value) {
        int yPosition;
        int min = this.slider.getMinimum(0);
        int max = this.slider.getMaximum(0);
        int trackLength = this.trackRect.height;
        double valueRange = (double)max - (double)min;
        double pixelsPerValue = (double)trackLength / valueRange;
        int trackTop = this.trackRect.y;
        int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
        if (!this.drawInverted()) {
            yPosition = trackTop;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)max - (double)value)));
        } else {
            yPosition = trackTop;
            yPosition = (int)((long)yPosition + Math.round(pixelsPerValue * ((double)value - (double)min)));
        }
        yPosition = Math.max(trackTop, yPosition);
        yPosition = Math.min(trackBottom, yPosition);
        return yPosition;
    }

    public int valueForYPosition(int yPos) {
        int value;
        int minValue = this.slider.getMinimum(0);
        int maxValue = this.slider.getMaximum(0);
        int trackLength = this.trackRect.height;
        int trackTop = this.trackRect.y;
        int trackBottom = this.trackRect.y + (this.trackRect.height - 1);
        if (yPos <= trackTop) {
            value = this.drawInverted() ? minValue : maxValue;
        } else if (yPos >= trackBottom) {
            value = this.drawInverted() ? maxValue : minValue;
        } else {
            int distanceFromTrackTop = yPos - trackTop;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackTop = (int)Math.round((double)distanceFromTrackTop * valuePerPixel);
            value = this.drawInverted() ? minValue + valueFromTrackTop : maxValue - valueFromTrackTop;
        }
        return value;
    }

    public int valueForXPosition(int xPos) {
        int value;
        int minValue = this.slider.getMinimum(0);
        int maxValue = this.slider.getMaximum(0);
        int trackLength = this.trackRect.width;
        int trackLeft = this.trackRect.x;
        int trackRight = this.trackRect.x + (this.trackRect.width - 1);
        if (xPos <= trackLeft) {
            value = this.drawInverted() ? maxValue : minValue;
        } else if (xPos >= trackRight) {
            value = this.drawInverted() ? minValue : maxValue;
        } else {
            int distanceFromTrackLeft = xPos - trackLeft;
            double valueRange = (double)maxValue - (double)minValue;
            double valuePerPixel = valueRange / (double)trackLength;
            int valueFromTrackLeft = (int)Math.round((double)distanceFromTrackLeft * valuePerPixel);
            value = this.drawInverted() ? maxValue - valueFromTrackLeft : minValue + valueFromTrackLeft;
        }
        return value;
    }

    static class SharedActionScroller
    extends AbstractAction {
        private static final long serialVersionUID = -2052302940437807339L;
        int dir;
        boolean block;

        public SharedActionScroller(int dir, boolean block) {
            this.dir = dir;
            this.block = block;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JSliderEx slider = (JSliderEx)e.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int realDir = this.dir;
                BasicSliderExUI ui = (BasicSliderExUI)slider.getUI();
                if (slider.getInverted()) {
                    int n = realDir = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    ui.scrollByBlock(realDir);
                } else {
                    ui.scrollByUnit(realDir);
                }
            } else if (slider.getInverted()) {
                if (this.dir == -2) {
                    slider.setValue(slider.getMaximum(0), 0);
                } else if (this.dir == 2) {
                    slider.setValue(slider.getMinimum(0), 0);
                }
            } else if (this.dir == -2) {
                slider.setValue(slider.getMinimum(0), 0);
            } else if (this.dir == 2) {
                slider.setValue(slider.getMaximum(0), 0);
            }
        }
    }

    public class ActionScroller
    extends AbstractAction {
        private static final long serialVersionUID = -1427431191802634667L;
        int dir;
        boolean block;
        transient JSliderEx slider;

        public ActionScroller(JSliderEx slider, int dir, boolean block) {
            this.dir = dir;
            this.block = block;
            this.slider = slider;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.dir == -1 || this.dir == 1) {
                int realDir = this.dir;
                if (BasicSliderExUI.this.drawInverted()) {
                    int n = realDir = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    BasicSliderExUI.this.scrollByBlock(realDir);
                } else {
                    BasicSliderExUI.this.scrollByUnit(realDir);
                }
            } else if (BasicSliderExUI.this.drawInverted()) {
                if (this.dir == -2) {
                    this.slider.setValue(this.slider.getMaximum(0), BasicSliderExUI.this.selectedThumbIndex);
                } else if (this.dir == 2) {
                    this.slider.setValue(this.slider.getMinimum(0), BasicSliderExUI.this.selectedThumbIndex);
                }
            } else if (this.dir == -2) {
                this.slider.setValue(this.slider.getMinimum(0), BasicSliderExUI.this.selectedThumbIndex);
            } else if (this.dir == 2) {
                this.slider.setValue(this.slider.getMaximum(0), BasicSliderExUI.this.selectedThumbIndex);
            }
        }

        @Override
        public boolean isEnabled() {
            boolean b = true;
            if (this.slider != null) {
                b = this.slider.isEnabled();
            }
            return b;
        }
    }

    public class FocusHandler
    implements FocusListener {
        @Override
        public void focusGained(FocusEvent e) {
            BasicSliderExUI.this.slider.repaint();
        }

        @Override
        public void focusLost(FocusEvent e) {
            BasicSliderExUI.this.slider.repaint();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        @Override
        public void componentResized(ComponentEvent e) {
            BasicSliderExUI.this.calculateGeometry();
            BasicSliderExUI.this.slider.repaint();
        }
    }

    public class ScrollListener
    implements ActionListener {
        int direction = 1;
        boolean useBlockIncrement;

        public ScrollListener() {
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(int dir, boolean block) {
            this.direction = dir;
            this.useBlockIncrement = block;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public void setScrollByBlock(boolean block) {
            this.useBlockIncrement = block;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.useBlockIncrement) {
                BasicSliderExUI.this.scrollByBlock(this.direction);
            } else {
                BasicSliderExUI.this.scrollByUnit(this.direction);
            }
            if (!BasicSliderExUI.this.trackListener.shouldScroll(this.direction)) {
                ((Timer)e.getSource()).stop();
            }
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!BasicSliderExUI.this.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            BasicSliderExUI.this.scrollTimer.stop();
            if (BasicSliderExUI.this.slider.getSnapToTicks()) {
                BasicSliderExUI.this.isDragging = false;
                BasicSliderExUI.this.slider.setValueIsAdjusting(false);
            } else {
                BasicSliderExUI.this.slider.setValueIsAdjusting(false);
                BasicSliderExUI.this.isDragging = false;
            }
            BasicSliderExUI.this.slider.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!BasicSliderExUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (BasicSliderExUI.this.slider.isRequestFocusEnabled()) {
                BasicSliderExUI.this.slider.requestFocus();
            }
            for (int i = 0; i < BasicSliderExUI.this.thumbRect.length; ++i) {
                if (!BasicSliderExUI.this.thumbRect[i].contains(this.currentMouseX, this.currentMouseY)) continue;
                switch (BasicSliderExUI.this.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - BasicSliderExUI.this.thumbRect[i].y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - BasicSliderExUI.this.thumbRect[i].x;
                    }
                }
                BasicSliderExUI.this.isDragging = true;
                BasicSliderExUI.this.selectedThumbIndex = i;
                return;
            }
            BasicSliderExUI.this.isDragging = false;
            BasicSliderExUI.this.slider.setValueIsAdjusting(true);
        }

        public boolean shouldScroll(int direction) {
            Rectangle r = BasicSliderExUI.this.thumbRect[BasicSliderExUI.this.selectedThumbIndex];
            if (BasicSliderExUI.this.slider.getOrientation() == 1 ? ((BasicSliderExUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.y + r.height <= this.currentMouseY : r.y >= this.currentMouseY) : ((BasicSliderExUI.this.drawInverted() ? direction < 0 : direction > 0) ? r.x + r.width >= this.currentMouseX : r.x <= this.currentMouseX)) {
                return false;
            }
            if (direction > 0 && BasicSliderExUI.this.slider.getValue(BasicSliderExUI.this.selectedThumbIndex) + BasicSliderExUI.this.slider.getExtent(BasicSliderExUI.this.selectedThumbIndex) >= BasicSliderExUI.this.slider.getMaximum(BasicSliderExUI.this.selectedThumbIndex)) {
                return false;
            }
            return direction >= 0 || BasicSliderExUI.this.slider.getValue(BasicSliderExUI.this.selectedThumbIndex) > BasicSliderExUI.this.slider.getMinimum(BasicSliderExUI.this.selectedThumbIndex);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int thumbMiddle = 0;
            if (!BasicSliderExUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (!BasicSliderExUI.this.isDragging) {
                return;
            }
            BasicSliderExUI.this.slider.setValueIsAdjusting(true);
            switch (BasicSliderExUI.this.slider.getOrientation()) {
                case 1: {
                    int halfThumbHeight = BasicSliderExUI.this.thumbRect[BasicSliderExUI.this.selectedThumbIndex].height / 2;
                    int thumbTop = e.getY() - this.offset;
                    int trackTop = BasicSliderExUI.this.trackRect.y;
                    int trackBottom = BasicSliderExUI.this.trackRect.y + (BasicSliderExUI.this.trackRect.height - 1);
                    int vMax = BasicSliderExUI.this.yPositionForValue(BasicSliderExUI.this.slider.getMaximum(BasicSliderExUI.this.selectedThumbIndex) - BasicSliderExUI.this.slider.getExtent(BasicSliderExUI.this.selectedThumbIndex));
                    if (BasicSliderExUI.this.drawInverted()) {
                        trackBottom = vMax;
                    } else {
                        trackTop = vMax;
                    }
                    thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                    thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                    BasicSliderExUI.this.setThumbLocation(BasicSliderExUI.this.thumbRect[BasicSliderExUI.this.selectedThumbIndex].x, thumbTop, BasicSliderExUI.this.selectedThumbIndex);
                    thumbMiddle = thumbTop + halfThumbHeight;
                    BasicSliderExUI.this.slider.setValue(BasicSliderExUI.this.valueForYPosition(thumbMiddle), BasicSliderExUI.this.selectedThumbIndex);
                    break;
                }
                case 0: {
                    int halfThumbWidth = BasicSliderExUI.this.thumbRect[BasicSliderExUI.this.selectedThumbIndex].width / 2;
                    int thumbLeft = e.getX() - this.offset;
                    int trackLeft = BasicSliderExUI.this.trackRect.x;
                    int trackRight = BasicSliderExUI.this.trackRect.x + (BasicSliderExUI.this.trackRect.width - 1);
                    int hMax = BasicSliderExUI.this.xPositionForValue(BasicSliderExUI.this.slider.getMaximum(BasicSliderExUI.this.selectedThumbIndex) - BasicSliderExUI.this.slider.getExtent(BasicSliderExUI.this.selectedThumbIndex));
                    if (BasicSliderExUI.this.drawInverted()) {
                        trackLeft = hMax;
                    } else {
                        trackRight = hMax;
                    }
                    thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                    thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                    BasicSliderExUI.this.setThumbLocation(thumbLeft, BasicSliderExUI.this.thumbRect[BasicSliderExUI.this.selectedThumbIndex].y, BasicSliderExUI.this.selectedThumbIndex);
                    thumbMiddle = thumbLeft + halfThumbWidth;
                    BasicSliderExUI.this.slider.setValue(BasicSliderExUI.this.valueForXPosition(thumbMiddle), BasicSliderExUI.this.selectedThumbIndex);
                    break;
                }
                default: {
                    return;
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        @Override
        public void stateChanged(ChangeEvent e) {
            if (!BasicSliderExUI.this.isDragging) {
                BasicSliderExUI.this.calculateThumbLocation();
                BasicSliderExUI.this.slider.repaint();
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (propertyName.equals("orientation") || propertyName.equals("inverted") || propertyName.equals("labelTable") || propertyName.equals("majorTickSpacing") || propertyName.equals("minorTickSpacing") || propertyName.equals("paintTicks") || propertyName.equals("paintTrack") || propertyName.equals("paintLabels")) {
                BasicSliderExUI.this.calculateGeometry();
                BasicSliderExUI.this.slider.repaint();
            } else if (propertyName.equals("componentOrientation")) {
                BasicSliderExUI.this.calculateGeometry();
                BasicSliderExUI.this.slider.repaint();
                InputMap km = BasicSliderExUI.this.getInputMap(0);
                SwingUtilities.replaceUIInputMap(BasicSliderExUI.this.slider, 0, km);
            } else if (propertyName.equals("model")) {
                ((BoundedRangeModel)e.getOldValue()).removeChangeListener(BasicSliderExUI.this.changeListener);
                ((BoundedRangeModel)e.getNewValue()).addChangeListener(BasicSliderExUI.this.changeListener);
                BasicSliderExUI.this.calculateThumbLocation();
                BasicSliderExUI.this.slider.repaint();
            }
        }
    }
}

