/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kdprint.util;

import com.kingdee.cosmic.ctrl.kdf.kdprint.util.BasicSliderExUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.SliderUI;
import javax.swing.plaf.UIResource;

public class JSliderEx
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = -1951187970089402644L;
    private static final String uiClassID = "SliderUI";
    private boolean paintTicks = false;
    private boolean paintTrack = true;
    private boolean paintLabels = false;
    private boolean isInverted = false;
    protected BoundedRangeModel[] sliderModels = new BoundedRangeModel[1];
    protected int majorTickSpacing;
    protected int minorTickSpacing;
    protected boolean snapToTicks = false;
    boolean snapToValue = true;
    protected int orientation;
    private Dictionary labelTable;
    protected ChangeListener changeListener = this.createChangeListener();
    protected transient ChangeEvent changeEvent = null;

    private void checkOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public JSliderEx() {
        this(0, 0, 100, 50);
    }

    public JSliderEx(int orientation) {
        this(orientation, 0, 100, 50);
    }

    public JSliderEx(int min, int max) {
        this(0, min, max, (min + max) / 2);
    }

    public JSliderEx(int min, int max, int value) {
        this(0, min, max, value);
    }

    public JSliderEx(int orientation, int min, int max, int value) {
        this.checkOrientation(orientation);
        this.orientation = orientation;
        if (this.sliderModels == null) {
            this.sliderModels = new BoundedRangeModel[1];
        }
        this.sliderModels[0] = new DefaultBoundedRangeModel(value, 0, min, max);
        this.sliderModels[0].addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSliderEx(BoundedRangeModel brm) {
        this.orientation = 0;
        if (this.sliderModels == null) {
            this.sliderModels = new BoundedRangeModel[1];
        }
        this.setModel(brm, 0);
        this.sliderModels[0].addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JSliderEx(BoundedRangeModel[] brms) {
        this.orientation = 0;
        if (this.sliderModels.length < brms.length) {
            this.sliderModels = new BoundedRangeModel[brms.length];
        }
        for (int i = 0; i < brms.length; ++i) {
            this.setModel(brms[i], i);
            this.sliderModels[i].addChangeListener(this.changeListener);
        }
        this.updateUI();
    }

    @Override
    public SliderUI getUI() {
        return (SliderUI)this.ui;
    }

    public void setUI(SliderUI ui) {
        super.setUI(ui);
    }

    @Override
    public void updateUI() {
        this.updateLabelUIs();
        this.setUI(new BasicSliderExUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public BoundedRangeModel getModel(int index) {
        return this.sliderModels[index];
    }

    public BoundedRangeModel[] getModels() {
        return this.sliderModels;
    }

    public void setModel(BoundedRangeModel newModel, int index) {
        BoundedRangeModel oldModel = this.getModel(index);
        if (oldModel != null) {
            oldModel.removeChangeListener(this.changeListener);
        }
        this.sliderModels[index] = newModel;
        if (newModel != null) {
            newModel.addChangeListener(this.changeListener);
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleValue", oldModel == null ? null : Integer.valueOf(oldModel.getValue()), newModel.getValue());
            }
        }
        this.firePropertyChange("model", oldModel, this.sliderModels[index]);
    }

    public void setModels(BoundedRangeModel[] newModels) {
        for (int i = 0; i < newModels.length; ++i) {
            this.setModel(newModels[i], i);
            this.sliderModels[i].addChangeListener(this.changeListener);
        }
    }

    public int getValue(int modelIndex) {
        return this.getModel(modelIndex).getValue();
    }

    public void setValue(int n, int modelIndex) {
        BoundedRangeModel m = this.getModel(modelIndex);
        int oldValue = m.getValue();
        if (oldValue == n) {
            return;
        }
        m.setValue(n);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleValue", oldValue, m.getValue());
        }
    }

    public int getMinimum(int modelIndex) {
        return this.getModel(modelIndex).getMinimum();
    }

    public void setMinimum(int minimum, int modelIndex) {
        int oldMin = this.getModel(modelIndex).getMinimum();
        this.getModel(modelIndex).setMinimum(minimum);
        this.firePropertyChange("minimum", (Object)oldMin, (Object)minimum);
    }

    public int getMaximum(int modelIndex) {
        return this.getModel(modelIndex).getMaximum();
    }

    public void setMaximum(int maximum, int modelIndex) {
        int oldMax = this.getModel(modelIndex).getMaximum();
        this.getModel(modelIndex).setMaximum(maximum);
        this.firePropertyChange("maximum", (Object)oldMax, (Object)maximum);
    }

    public boolean getValueIsAdjusting() {
        return this.getModel(0).getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean b) {
        BoundedRangeModel m = this.getModel(0);
        boolean oldValue = m.getValueIsAdjusting();
        m.setValueIsAdjusting(b);
        if (oldValue != b && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", oldValue ? AccessibleState.BUSY : null, b ? AccessibleState.BUSY : null);
        }
    }

    public int getExtent(int modelIndex) {
        return this.getModel(modelIndex).getExtent();
    }

    public void setExtent(int extent, int modelIndex) {
        this.getModel(modelIndex).setExtent(extent);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.checkOrientation(orientation);
        int oldValue = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange("orientation", oldValue, orientation);
        if (oldValue != orientation && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", oldValue == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL, orientation == 1 ? AccessibleState.VERTICAL : AccessibleState.HORIZONTAL);
        }
        if (orientation != oldValue) {
            this.revalidate();
        }
    }

    public Dictionary getLabelTable() {
        return this.labelTable;
    }

    public void setLabelTable(Dictionary labels) {
        Dictionary oldTable = this.labelTable;
        this.labelTable = labels;
        this.updateLabelUIs();
        this.firePropertyChange("labelTable", oldTable, this.labelTable);
        if (labels != oldTable) {
            this.revalidate();
            this.repaint();
        }
    }

    protected void updateLabelUIs() {
        if (this.getLabelTable() == null) {
            return;
        }
        Enumeration labels = this.getLabelTable().keys();
        while (labels.hasMoreElements()) {
            Object value = this.getLabelTable().get(labels.nextElement());
            if (!(value instanceof JComponent)) continue;
            JComponent component = (JComponent)value;
            component.updateUI();
            component.setSize(component.getPreferredSize());
        }
    }

    public Hashtable createStandardLabels(int increment) {
        return this.createStandardLabels(increment, this.getMinimum(0));
    }

    public Hashtable createStandardLabels(int increment, int start) {
        if (start > this.getMaximum(0) || start < this.getMinimum(0)) {
            throw new IllegalArgumentException("Slider label start point out of range.");
        }
        if (increment <= 0) {
            throw new IllegalArgumentException("Label incremement must be > 0");
        }
        SmartHashtable table = new SmartHashtable(increment, start);
        if (this.getLabelTable() != null && this.getLabelTable() instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)this.getLabelTable()));
        }
        this.addPropertyChangeListener(table);
        return table;
    }

    public boolean getInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean b) {
        boolean oldValue = this.isInverted;
        this.isInverted = b;
        this.firePropertyChange("inverted", oldValue, this.isInverted);
        if (b != oldValue) {
            this.repaint();
        }
    }

    public int getMajorTickSpacing() {
        return this.majorTickSpacing;
    }

    public void setMajorTickSpacing(int n) {
        int oldValue = this.majorTickSpacing;
        this.majorTickSpacing = n;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0 && this.getPaintLabels()) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("majorTickSpacing", oldValue, this.majorTickSpacing);
        if (this.majorTickSpacing != oldValue && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public int getMinorTickSpacing() {
        return this.minorTickSpacing;
    }

    public void setMinorTickSpacing(int n) {
        int oldValue = this.minorTickSpacing;
        this.minorTickSpacing = n;
        this.firePropertyChange("minorTickSpacing", oldValue, this.minorTickSpacing);
        if (this.minorTickSpacing != oldValue && this.getPaintTicks()) {
            this.repaint();
        }
    }

    public boolean getSnapToTicks() {
        return this.snapToTicks;
    }

    boolean getSnapToValue() {
        return this.snapToValue;
    }

    public void setSnapToTicks(boolean b) {
        boolean oldValue = this.snapToTicks;
        this.snapToTicks = b;
        this.firePropertyChange("snapToTicks", oldValue, this.snapToTicks);
    }

    void setSnapToValue(boolean b) {
        boolean oldValue = this.snapToValue;
        this.snapToValue = b;
        this.firePropertyChange("snapToValue", oldValue, this.snapToValue);
    }

    public boolean getPaintTicks() {
        return this.paintTicks;
    }

    public void setPaintTicks(boolean b) {
        boolean oldValue = this.paintTicks;
        this.paintTicks = b;
        this.firePropertyChange("paintTicks", oldValue, this.paintTicks);
        if (this.paintTicks != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    public boolean getPaintTrack() {
        return this.paintTrack;
    }

    public void setPaintTrack(boolean b) {
        boolean oldValue = this.paintTrack;
        this.paintTrack = b;
        this.firePropertyChange("paintTrack", oldValue, this.paintTrack);
        if (this.paintTrack != oldValue) {
            this.repaint();
        }
    }

    public boolean getPaintLabels() {
        return this.paintLabels;
    }

    public void setPaintLabels(boolean b) {
        boolean oldValue = this.paintLabels;
        this.paintLabels = b;
        if (this.labelTable == null && this.getMajorTickSpacing() > 0) {
            this.setLabelTable(this.createStandardLabels(this.getMajorTickSpacing()));
        }
        this.firePropertyChange("paintLabels", oldValue, this.paintLabels);
        if (this.paintLabels != oldValue) {
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected String paramString() {
        String paintTicksString = this.paintTicks ? "true" : "false";
        String paintTrackString = this.paintTrack ? "true" : "false";
        String paintLabelsString = this.paintLabels ? "true" : "false";
        String isInvertedString = this.isInverted ? "true" : "false";
        String snapToTicksString = this.snapToTicks ? "true" : "false";
        String snapToValueString = this.snapToValue ? "true" : "false";
        String orientationString = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",isInverted=" + isInvertedString + ",majorTickSpacing=" + this.majorTickSpacing + ",minorTickSpacing=" + this.minorTickSpacing + ",orientation=" + orientationString + ",paintLabels=" + paintLabelsString + ",paintTicks=" + paintTicksString + ",paintTrack=" + paintTrackString + ",snapToTicks=" + snapToTicksString + ",snapToValue=" + snapToValueString;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSlider();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJSlider
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -7495778499616559937L;

        protected AccessibleJSlider() {
            super(JSliderEx.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (JSliderEx.this.getValueIsAdjusting()) {
                states.add(AccessibleState.BUSY);
            }
            if (JSliderEx.this.getOrientation() == 1) {
                states.add(AccessibleState.VERTICAL);
            } else {
                states.add(AccessibleState.HORIZONTAL);
            }
            return states;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            return JSliderEx.this.getValue(0);
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            if (n instanceof Integer) {
                JSliderEx.this.setValue(n.intValue(), 0);
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return JSliderEx.this.getMinimum(0);
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return JSliderEx.this.getMaximum(0);
        }
    }

    private class ModelListener
    implements ChangeListener,
    Serializable {
        private static final long serialVersionUID = -6697964204229034721L;

        private ModelListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JSliderEx.this.fireStateChanged();
        }
    }

    final class SmartHashtable
    extends Hashtable
    implements PropertyChangeListener {
        private static final long serialVersionUID = -5367148004134104356L;
        int increment = 0;
        int start = 0;
        boolean startAtMin = false;

        public SmartHashtable(int increment, int start) {
            this.increment = increment;
            this.start = start;
            this.startAtMin = start == JSliderEx.this.getMinimum(0);
            this.createLabels();
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (this.startAtMin && e.getPropertyName().equals("minimum")) {
                this.start = JSliderEx.this.getMinimum(0);
            }
            if (e.getPropertyName().equals("minimum") || e.getPropertyName().equals("maximum")) {
                Enumeration keys = JSliderEx.this.getLabelTable().keys();
                Object key = null;
                HashMap hashMap = new HashMap();
                while (keys.hasMoreElements()) {
                    key = keys.nextElement();
                    Object value = JSliderEx.this.getLabelTable().get(key);
                    if (value instanceof LabelUIResource) continue;
                    hashMap.put(key, value);
                }
                this.clear();
                this.createLabels();
                for (Map.Entry entry : hashMap.entrySet()) {
                    this.put(entry.getKey(), entry.getValue());
                }
                ((JSliderEx)e.getSource()).setLabelTable(this);
            }
        }

        void createLabels() {
            for (int labelIndex = this.start; labelIndex <= JSliderEx.this.getMaximum(0); labelIndex += this.increment) {
                this.put(labelIndex, new LabelUIResource("" + labelIndex, 0));
            }
        }

        final class LabelUIResource
        extends JLabel
        implements UIResource {
            private static final long serialVersionUID = 3112673135952375293L;

            public LabelUIResource(String text, int alignment) {
                super(text, alignment);
            }
        }
    }
}

