/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kds;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.expr.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.kds.BaseProperty;
import com.kingdee.cosmic.ctrl.kdf.kds.IBook;
import com.kingdee.cosmic.ctrl.kdf.kds.ISheets;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.ArrayList;

public class KDSBook
extends BaseProperty
implements IBook,
ISheets {
    private String name;
    private ArrayList sheets;
    private BookStyleAttributesListener bookListener;
    private ArrayList binaryImages;
    public static final int PICTURE_TYPE_JPEG = 5;
    public static final int PICTURE_TYPE_PNG = 6;
    public static final int PICTURE_TYPE_DIB = 7;

    public KDSBook(String name) {
        super(Styles.getEmptySSA(), Styles.getDefaultStyle());
        if (name != null) {
            this.name = name.trim();
        }
        this.sheets = new ArrayList();
        this.bookListener = new BookStyleAttributesListener();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public ISheets getSheets() {
        return this;
    }

    @Override
    public StyleAttributes getBookStyleAttributes() {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.getSSA());
        sa.append((ShareStyleAttributes)this.getStyle(), false);
        sa.setOwner((Object)this.name);
        sa.setListener((StyleAttributesChangeListener)this.bookListener);
        return sa;
    }

    @Override
    public Style getBookStyle() {
        return this.getStyle();
    }

    @Override
    public KDSSheet addSheet(Object after, String name) throws Exception {
        if (StringUtil.isEmptyString((String)name)) {
            throw new IllegalArgumentException("Argument name");
        }
        if (!this.isValidNewSheetName(name = name.trim())) {
            throw new IllegalArgumentException("Argument name");
        }
        int index = this.getSheetIndex(after, "after");
        if (index < 0 || index > this.sheets.size()) {
            index = this.sheets.size();
        }
        KDSSheet sheet = new KDSSheet(this, name);
        this.sheets.add(index, sheet);
        return sheet;
    }

    @Override
    public KDSSheet addSheet(Object after, KDSSheet sheet) throws Exception {
        if (sheet == null || !this.isValidNewSheetName(sheet.getName())) {
            throw new IllegalArgumentException("Argument sheet\uff01Sheet:" + sheet);
        }
        int index = this.getSheetIndex(after, "after");
        if (index < 0 || index > this.sheets.size()) {
            index = this.sheets.size();
        }
        this.sheets.add(index, sheet);
        return sheet;
    }

    @Override
    public KDSSheet getSheet(Object objIndex) {
        int index = -1;
        if (objIndex instanceof String) {
            String name = (String)objIndex;
            for (int i = 0; i < this.sheets.size(); ++i) {
                KDSSheet sheet = (KDSSheet)this.sheets.get(i);
                if (!name.equalsIgnoreCase(sheet.getName())) continue;
                index = i;
                break;
            }
        } else {
            try {
                index = this.getIntIndex(objIndex, "index");
            }
            catch (Exception name) {
                // empty catch block
            }
        }
        KDSSheet sheet = null;
        if (index >= 0 && index < this.sheets.size()) {
            sheet = (KDSSheet)this.sheets.get(index);
        }
        return sheet;
    }

    @Override
    public int getSheetCount() {
        return this.sheets.size();
    }

    @Override
    public KDSSheet remove(Object index) {
        KDSSheet sheet = this.getSheet(index);
        if (sheet != null) {
            this.removeSheet(sheet);
        }
        return sheet;
    }

    @Override
    public void removeAll() {
        this.sheets.clear();
    }

    public void addImage(KDSImage kdsImage) {
        if (this.binaryImages == null) {
            this.binaryImages = new ArrayList();
        }
        this.binaryImages.add(kdsImage);
    }

    public ArrayList getImages() {
        return this.binaryImages;
    }

    private int getSheetIndex(Object after, String errorMsg) throws Exception {
        int index = -1;
        if (after instanceof KDSSheet) {
            index = this.sheets.indexOf(after);
            if (index < 0) {
                throw new Exception(errorMsg);
            }
            ++index;
        } else {
            index = this.getIntIndex(after, errorMsg);
        }
        return index;
    }

    private int getIntIndex(Object obj, String errorMsg) throws Exception {
        int index = -1;
        try {
            Variant var = new Variant(obj);
            if (var.isNumeric()) {
                index = var.intValue();
            }
        }
        catch (SyntaxErrorException e) {
            throw new Exception(errorMsg, e);
        }
        return index;
    }

    private boolean isValidNewSheetName(String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return false;
        }
        name = name.trim();
        for (KDSSheet sheet : this.sheets) {
            if (!name.equalsIgnoreCase(sheet.getName())) continue;
            return false;
        }
        return true;
    }

    protected void removeSheet(KDSSheet sheet) {
        int index = this.sheets.indexOf(sheet);
        if (index >= 0) {
            this.sheets.remove(index);
        }
    }

    protected boolean renameSheet(KDSSheet sheet, String newName) {
        if (this.isValidNewSheetName(newName)) {
            sheet.setName(newName);
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Book:");
        sb.append(this.getName() + "\n");
        sb.append("Sheets Count:" + this.getSheetCount() + "/n");
        for (int i = 0; i < this.getSheetCount(); ++i) {
            sb.append("Sheet" + i + ":" + this.getSheet(i).getName() + "\n");
            sb.append(this.getSheet(i) + "\n");
        }
        return sb.toString();
    }

    class BookStyleAttributesListener
    implements StyleAttributesChangeListener {
        protected BookStyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent evt) {
            if (evt.getSA().isEmpty()) {
                return;
            }
            assert (KDSBook.this.name.equals(evt.getOwner()));
            KDSBook.this.setSSA(Styles.getSSA((StyleAttributes)evt.getSA()));
            KDSBook.this.setStyle(Styles.getStyle((ShareStyleAttributes)KDSBook.this.getSSA()));
            for (KDSSheet sheet : KDSBook.this.sheets) {
                sheet.updateSheetStyle(sheet.getSSA());
            }
        }
    }

    public static class KDSImage {
        public static final int PICTURE_TYPE_EMF = 2;
        public static final int PICTURE_TYPE_WMF = 3;
        public static final int PICTURE_TYPE_PICT = 4;
        public static final int PICTURE_TYPE_JPEG = 5;
        public static final int PICTURE_TYPE_PNG = 6;
        public static final int PICTURE_TYPE_DIB = 7;
        private byte[] binaryImage;
        private int fileType;
        private int width = -1;
        private int height = -1;
        private String sheetName = "unNamedSheet";
        private int left;
        private int top;
        private int bottom;
        private int right;
        private int dx1;
        private int dy1;
        private int dx2;
        private int dy2;

        public KDSImage(byte[] binaryImage, int fileType) {
            this.binaryImage = binaryImage;
            this.fileType = fileType;
        }

        public KDSImage(byte[] binaryImage, int fileType, int width, int height) {
            this.binaryImage = binaryImage;
            this.fileType = fileType;
        }

        public byte[] getBinaryImage() {
            return this.binaryImage;
        }

        public int getFileType() {
            return this.fileType;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getTop() {
            return this.top;
        }

        public void setTop(int top) {
            this.top = top;
        }

        public int getBottom() {
            return this.bottom;
        }

        public void setBottom(int bottom) {
            this.bottom = bottom;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int right) {
            this.right = right;
        }

        public int getDx1() {
            return this.dx1;
        }

        public void setDx1(int dx1) {
            this.dx1 = dx1;
        }

        public int getDy1() {
            return this.dy1;
        }

        public void setDy1(int dy1) {
            this.dy1 = dy1;
        }

        public int getDx2() {
            return this.dx2;
        }

        public void setDx2(int dx2) {
            this.dx2 = dx2;
        }

        public int getDy2() {
            return this.dy2;
        }

        public void setDy2(int dy2) {
            this.dy2 = dy2;
        }
    }
}

