/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kds;

import com.kingdee.cosmic.ctrl.common.variant.Util;
import com.kingdee.cosmic.ctrl.kdf.kds.BaseProperty;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class KDSCell
extends BaseProperty {
    public static final short CELL_TYPE_NUMERIC = 0;
    public static final short CELL_TYPE_STRING = 1;
    public static final short CELL_TYPE_FORMULA = 2;
    public static final short CELL_TYPE_BOOLEAN = 4;
    public static final short CELL_TYPE_DATE = 6;
    private String text;
    private Object value;
    private String formula;
    private short type;

    private static short getValueType(Object value) {
        if (value instanceof Boolean) {
            return 4;
        }
        if (value instanceof Number) {
            return 0;
        }
        if (value instanceof Date || value instanceof Calendar) {
            return 6;
        }
        return 1;
    }

    public KDSCell(Object value, ShareStyleAttributes ssa, Style style) {
        super(ssa, style);
        this.type = KDSCell.getValueType(value);
        this.value = value;
    }

    public KDSCell(Object value, String formula, ShareStyleAttributes ssa, Style style) {
        super(ssa, style);
        this.type = KDSCell.getValueType(value);
        this.value = value;
        this.formula = formula;
    }

    public KDSCell(Object value, ShareStyleAttributes ssa, Style style, String text) {
        super(ssa, style);
        this.type = KDSCell.getValueType(value);
        this.value = value;
        this.text = text;
    }

    public KDSCell(Object value, String formula, ShareStyleAttributes ssa, Style style, String text) {
        super(ssa, style);
        this.type = KDSCell.getValueType(value);
        this.value = value;
        this.formula = formula;
        this.text = text;
    }

    protected KDSCell(KDSCell cell) {
        super(cell.getSSA(), cell.getStyle());
        this.value = cell.value;
        this.type = cell.type;
        this.formula = cell.formula;
        this.text = cell.text;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        if (this.value != null) {
            hash ^= this.value.hashCode();
        }
        if (this.formula != null) {
            hash ^= this.formula.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof KDSCell)) {
            return false;
        }
        KDSCell cell = (KDSCell)obj;
        if (!super.equals(cell)) {
            return false;
        }
        if (this.value == null ? cell.getValue() != null : !this.value.equals(cell.getValue())) {
            return false;
        }
        return !(this.formula == null ? cell.getFormula() != null : !this.formula.equals(cell.getFormula()));
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getFormula() {
        return this.formula;
    }

    public void setFormula(String formula) {
        this.formula = formula;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        if (this.value == null) {
            return "";
        }
        if (this.value instanceof BigDecimal) {
            return Util.bigDecimalToPlainString((BigDecimal)((BigDecimal)this.value));
        }
        return this.value.toString();
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isEmptyCell() {
        return this.value == null && this.formula == null && this.isEmptyBaseProperty();
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }
}

