/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.kds;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.kdf.export.EmbedObjectRectangle;
import com.kingdee.cosmic.ctrl.kdf.kds.BaseProperty;
import com.kingdee.cosmic.ctrl.kdf.kds.CellsBuffer;
import com.kingdee.cosmic.ctrl.kdf.kds.ColumnsBuffer;
import com.kingdee.cosmic.ctrl.kdf.kds.ICells;
import com.kingdee.cosmic.ctrl.kdf.kds.IColumns;
import com.kingdee.cosmic.ctrl.kdf.kds.IMerges;
import com.kingdee.cosmic.ctrl.kdf.kds.IRows;
import com.kingdee.cosmic.ctrl.kdf.kds.ISheet;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSColumn;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSRow;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.kds.RowsBuffer;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeEvent;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributesChangeListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class KDSSheet
extends BaseProperty
implements ICells,
IRows,
IColumns,
ISheet {
    public static final int MAX_ROWS = Integer.MAX_VALUE;
    public static final int MAX_COLS = Integer.MAX_VALUE;
    private KDSBook book;
    private KDSSheetPrintSetup printSetup = null;
    private String name;
    private HashMap rows;
    private HashMap cols;
    private HashMap cells;
    private KDSMerges merges;
    private KDSCell defaultCell;
    private KDSRow defaultRow;
    private KDSColumn defaultColumn;
    private CellStyleAttributesListener cellListener;
    private RowStyleAttributesListener rowListener;
    private ColumnStyleAttributesListener colListener;
    private SheetStyleAttributesListener sheetListener;
    private List rowSpans;
    private List colSpans;
    private boolean leftToOutlineGroup;
    private boolean aboveOfOutlineGroup;
    private ArrayList layer = new ArrayList();
    private int headRowCount = -1;

    public KDSSheet(KDSBook book, String name) {
        this(book, name, book == null ? Styles.getEmptySSA() : book.getSSA());
    }

    public KDSSheet(KDSBook book, String name, ShareStyleAttributes ssa) {
        super(ssa == null ? Styles.getEmptySSA() : ssa, book == null ? Styles.getStyle((ShareStyleAttributes)ssa) : Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, book.getSSA()}));
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Sheet Name");
        }
        this.name = name;
        this.book = book;
        this.rows = new HashMap();
        this.cols = new HashMap();
        this.cells = new HashMap(101);
        this.merges = new KDSMerges();
        this.defaultCell = new KDSCell("", Styles.getEmptySSA(), this.getStyle());
        this.cellListener = new CellStyleAttributesListener();
        this.defaultRow = new KDSRow(Styles.getEmptySSA(), this.getStyle());
        this.defaultRow.setHeight(8.0f);
        this.rowListener = new RowStyleAttributesListener();
        this.defaultColumn = new KDSColumn(Styles.getEmptySSA(), this.getStyle());
        this.defaultColumn.setWidth(20.0f);
        this.colListener = new ColumnStyleAttributesListener();
        this.sheetListener = new SheetStyleAttributesListener();
    }

    @Override
    public StyleAttributes getSheetStyleAttributes() {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.getSSA());
        sa.append((ShareStyleAttributes)this.getStyle(), false);
        sa.setOwner((Object)this.name);
        sa.setListener((StyleAttributesChangeListener)this.sheetListener);
        return sa;
    }

    @Override
    public Style getSheetStyle() {
        return this.getStyle();
    }

    public void setDoCrossTest(boolean flag) {
        this.merges.doCrossTest = flag;
    }

    public boolean isDoCrossTest() {
        return this.merges.doCrossTest;
    }

    @Override
    public int getExpandedRows() {
        return this.getExpanded(true);
    }

    @Override
    public int getExpandedColumns() {
        return this.getExpanded(false);
    }

    private int getExpanded(boolean row) {
        Iterator<Object> i;
        int max = 0;
        Iterator<Object> iterator = i = row ? this.rows.keySet().iterator() : this.cols.keySet().iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            max = Math.max(max, n);
        }
        for (Map.Entry entry : this.cells.entrySet()) {
            long rowcol = (Long)entry.getKey();
            int v = row ? (int)(rowcol >> 32) : (int)(rowcol & Integer.MAX_VALUE);
            max = Math.max(max, v);
        }
        return max;
    }

    @Override
    public ICells getCells() {
        return this;
    }

    @Override
    public IRows getRows() {
        return this;
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public IColumns getColumns() {
        return this;
    }

    @Override
    public int getColumnCount() {
        return this.cols.size();
    }

    public ISheet getSheet() {
        return this;
    }

    @Override
    public IMerges getMerges() {
        return this.merges;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public KDSSheet delete() {
        if (this.book != null) {
            this.book.removeSheet(this);
        }
        return this;
    }

    @Override
    public boolean rename(String name) {
        if (this.book == null) {
            this.name = name;
            return true;
        }
        return this.book.renameSheet(this, name);
    }

    protected void updateSheetStyle(ShareStyleAttributes ssa) {
        if (ssa instanceof StyleAttributes) {
            throw new IllegalArgumentException("ssa");
        }
        this.setSSA(ssa);
        if (this.book == null) {
            this.setStyle(Styles.getStyle((ShareStyleAttributes)this.getSSA()));
        } else {
            this.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.book.getSSA()}));
        }
        this.defaultCell.setStyle(this.getStyle());
        this.defaultRow.setStyle(this.getStyle());
        this.defaultColumn.setStyle(this.getStyle());
        for (Map.Entry e : this.rows.entrySet()) {
            int row = (Integer)e.getKey();
            this.updateRowStyle(row, null);
        }
        for (Map.Entry e : this.cols.entrySet()) {
            int col = (Integer)e.getKey();
            this.updateColumnStyle(col, null);
        }
        for (Map.Entry e : this.cells.entrySet()) {
            int col;
            long rowcol = (Long)e.getKey();
            int row = (int)(rowcol >> 32);
            if (!this.isValidRowCol(row, col = (int)(rowcol & Integer.MAX_VALUE))) {
                throw new IllegalArgumentException("cell");
            }
            this.updateCellStyle(row, col, null);
        }
    }

    private void updateCellStyle(int row, int col, ShareStyleAttributes ssa) {
        if (ssa == null) {
            ssa = this.getCell(row, col, false).getSSA();
        }
        Style stl = Styles.getStyle((ShareStyleAttributes[])this.getCellBubbleSSAs(row, col, ssa));
        this.setCell(row, col, CellsBuffer.getCell(this.getCell(row, col, false), ssa, stl), true);
    }

    private boolean isValidRowCol(int row, int col) {
        return row >= 0 && row <= Integer.MAX_VALUE && col >= 0 && col <= Integer.MAX_VALUE;
    }

    private Long getCellsHashKey(int row, int col) {
        assert (this.isValidRowCol(row, col));
        return (long)row << 32 | (long)col;
    }

    @Override
    public KDSCell setCell(int row, int col, Object value, ShareStyleAttributes ssa) {
        return this.setCell(row, col, value, ssa, null);
    }

    public KDSCell setCell(int row, int col, Object value, ShareStyleAttributes ssa, String text) {
        return this.setCell(row, col, value, null, ssa, text);
    }

    @Override
    public KDSCell setCell(int row, int col, Object value, String formula, ShareStyleAttributes ssa) {
        return this.setCell(row, col, value, formula, ssa, null);
    }

    public KDSCell setCell(int row, int col, Object value, String formula, ShareStyleAttributes ssa, String text) {
        if (ssa == null) {
            if (value == null) {
                return this.defaultCell;
            }
            ssa = Styles.getEmptySSA();
        }
        if (ssa instanceof StyleAttributes) {
            ssa = Styles.getSSA((StyleAttributes)((StyleAttributes)ssa));
        }
        Style style = Styles.getStyle((ShareStyleAttributes[])this.getCellBubbleSSAs(row, col, ssa));
        KDSCell cell = CellsBuffer.getCell(new KDSCell(value, formula, ssa, style, text));
        this.setCell(row, col, cell, true);
        return cell;
    }

    public KDSCell setCell(int row, int col, Object value, String formula, ShareStyleAttributes ssa, String text, String linkTo) {
        if (ssa == null) {
            if (value == null) {
                return this.defaultCell;
            }
            ssa = Styles.getEmptySSA();
        }
        if (ssa instanceof StyleAttributes) {
            ssa = Styles.getSSA((StyleAttributes)((StyleAttributes)ssa));
        }
        Style style = Styles.getStyle((ShareStyleAttributes[])this.getCellBubbleSSAs(row, col, ssa));
        KDSCell cell = CellsBuffer.getCell(new KDSCell(value, formula, ssa, style, text));
        this.setCell(row, col, cell, true);
        HyperLink hyper = new HyperLink();
        hyper.setLinkTo(linkTo);
        hyper.setText(text);
        cell.setHyperLink(hyper);
        return cell;
    }

    @Override
    public KDSCell getCell(int row, int col, boolean create) {
        KDSCell cell = null;
        Object obj = this.cells.get(this.getCellsHashKey(row, col));
        if (obj == null) {
            if (create) {
                ShareStyleAttributes ssa = Styles.getEmptySSA();
                cell = new KDSCell("", ssa, this.getCellBubbleStyle(row, col, ssa));
                cell = this.setCell(row, col, CellsBuffer.getCell(cell), false);
            } else {
                cell = this.defaultCell;
            }
        } else {
            cell = (KDSCell)obj;
        }
        return cell;
    }

    @Override
    public KDSCell getDefaultCell() {
        return this.defaultCell;
    }

    @Override
    public StyleAttributes getCellStyleAttributes(int row, int col) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.getCell(row, col, false).getSSA());
        sa.append((ShareStyleAttributes)this.getCellStyle(row, col), false);
        sa.setOwner((Object)this.getCellsHashKey(row, col));
        sa.setListener((StyleAttributesChangeListener)this.cellListener);
        return sa;
    }

    @Override
    public ShareStyleAttributes getCellShareStyleAttributes(int row, int col) {
        return this.getCell(row, col, false).getSSA();
    }

    @Override
    public Style getCellStyle(int row, int col) {
        Style style = null;
        KDSCell cell = this.getCell(row, col, false);
        style = cell != this.defaultCell ? cell.getStyle() : this.getCellBubbleStyle(row, col, null);
        assert (style.isFull());
        return style;
    }

    private Style getCellBubbleStyle(int row, int col, ShareStyleAttributes ssa) {
        Style style = Styles.getStyle((ShareStyleAttributes[])this.getCellBubbleSSAs(row, col, ssa == null ? Styles.getEmptySSA() : ssa));
        assert (style.isFull());
        return style;
    }

    @Override
    public KDSCell setCellValue(int row, int col, Object value) {
        KDSCell cell = null;
        if (value == null) {
            cell = this.getCell(row, col, false);
            if (cell != this.defaultCell) {
                cell = CellsBuffer.getCell(cell, "");
                this.setCell(row, col, cell, true);
            }
        } else {
            cell = CellsBuffer.getCell(this.getCell(row, col, false), value);
            this.setCell(row, col, cell, true);
        }
        assert (cell != null);
        return cell;
    }

    private KDSCell setCell(int row, int col, KDSCell cell, boolean careMerge) {
        assert (CellsBuffer.isExist(cell) && cell.getStyle().isFull());
        KDSMergeBlock merge = null;
        boolean merged = false;
        if (careMerge) {
            merge = this.merges.getMergeBlock(row, col);
            merged = !merge.isNullMergeBlock();
        }
        Long key = this.getCellsHashKey(row, col);
        if (cell.isEmptyCell()) {
            if (merged && !merge.isWholeColumn() && !merge.isWholeRow()) {
                cell = CellsBuffer.getCell(cell, merge);
                this.cells.put(key, cell);
            } else {
                this.cells.remove(key);
                cell = this.defaultCell;
            }
        } else {
            if (merged && !merge.isWholeColumn() && !merge.isWholeRow()) {
                cell = CellsBuffer.getCell(cell, merge);
            }
            this.cells.put(key, cell);
        }
        return cell;
    }

    public void removeCell(int row, int col, KDSCell cell) {
        if (cell != null) {
            Long key = this.getCellsHashKey(row, col);
            this.cells.remove(key);
        }
    }

    public void removeRow(int i) {
        this.rows.remove(i);
    }

    private ShareStyleAttributes[] getCellBubbleSSAs(int row, int col, ShareStyleAttributes ssa) {
        return new ShareStyleAttributes[]{ssa, this.getRow(row, false).getSSA(), this.getColumn(col, false).getSSA(), this.getSSA()};
    }

    @Override
    public KDSColumn getColumn(int col, boolean create) {
        KDSColumn c = null;
        Object obj = this.cols.get(col);
        if (obj == null) {
            if (create) {
                c = new KDSColumn(Styles.getEmptySSA(), this.getStyle());
                this.setColumn(col, ColumnsBuffer.getColumn(c));
            } else {
                c = this.defaultColumn;
            }
        } else {
            c = (KDSColumn)obj;
        }
        return c;
    }

    @Override
    public KDSColumn getDefaultColumn() {
        return this.defaultColumn;
    }

    @Override
    public float getColumnWidth(int col) {
        float width = this.getColumn(col, false).getWidth();
        if (ArrayUtil.isEqual((Float)Float.valueOf(width), (Float)Float.valueOf(-1.0f))) {
            width = this.defaultColumn.getWidth();
        }
        assert (width >= 0.0f);
        return width;
    }

    @Override
    public KDSColumn setColumnWidth(int col, float width) {
        KDSColumn c = ColumnsBuffer.getColumn(this.getColumn(col, true), width);
        this.setColumn(col, c);
        return c;
    }

    @Override
    public StyleAttributes getColumnStyleAttributes(int col) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.getColumn(col, false).getSSA());
        sa.append((ShareStyleAttributes)this.getColumnStyle(col), false);
        sa.setOwner((Object)col);
        sa.setListener((StyleAttributesChangeListener)this.colListener);
        return sa;
    }

    @Override
    public ShareStyleAttributes getColumnShareStyleAttributes(int col) {
        return this.getColumn(col, false).getSSA();
    }

    @Override
    public Style getColumnStyle(int col) {
        return this.getColumn(col, false).getStyle();
    }

    @Override
    public KDSRow getRow(int row, boolean create) {
        KDSRow r = null;
        Object obj = this.rows.get(row);
        if (obj == null) {
            if (create) {
                r = new KDSRow(this.getSSA(), this.getStyle());
                this.setRow(row, RowsBuffer.getRow(r));
            } else {
                r = this.defaultRow;
            }
        } else {
            r = (KDSRow)obj;
        }
        return r;
    }

    @Override
    public KDSRow getDefaultRow() {
        return this.defaultRow;
    }

    @Override
    public float getRowHeight(int row) {
        float height = this.getRow(row, false).getHeight();
        if (ArrayUtil.isEqual((Float)Float.valueOf(height), (Float)Float.valueOf(-1.0f))) {
            height = this.defaultRow.getHeight();
        }
        assert (height >= 0.0f);
        return height;
    }

    @Override
    public KDSRow setRowHeight(int row, float height) {
        KDSRow r = RowsBuffer.getRow(this.getRow(row, true), height);
        this.setRow(row, r);
        return r;
    }

    @Override
    public StyleAttributes getRowStyleAttributes(int row) {
        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)this.getRow(row, false).getSSA());
        sa.append((ShareStyleAttributes)this.getRowStyle(row), false);
        sa.setOwner((Object)row);
        sa.setListener((StyleAttributesChangeListener)this.rowListener);
        return sa;
    }

    @Override
    public ShareStyleAttributes getRowShareStyleAttributes(int row) {
        return this.getRow(row, false).getSSA();
    }

    @Override
    public Style getRowStyle(int row) {
        return this.getRow(row, false).getStyle();
    }

    private ArrayList getCellsWithinRowCol(int index, boolean row) {
        ArrayList al = new ArrayList();
        for (Map.Entry e : this.cells.entrySet()) {
            long key = (Long)e.getKey();
            int ii = (int)(row ? key >> 32 : key & Integer.MAX_VALUE);
            if (ii != index) continue;
            al.add(e);
        }
        return al;
    }

    private void updateRowStyle(int row, ShareStyleAttributes ssa) {
        if (ssa == null) {
            ssa = this.getRow(row, false).getSSA();
        }
        Style stl = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.getSSA()});
        this.setRow(row, RowsBuffer.getRow(this.getRow(row, true), ssa, stl));
    }

    private KDSRow setRow(int row, KDSRow r) {
        assert (RowsBuffer.isExist(r));
        this.rows.put(row, r);
        return r;
    }

    private void updateColumnStyle(int col, ShareStyleAttributes ssa) {
        if (ssa == null) {
            ssa = this.getColumn(col, false).getSSA();
        }
        Style stl = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssa, this.getSSA()});
        this.setColumn(col, ColumnsBuffer.getColumn(this.getColumn(col, true), ssa, stl));
    }

    private KDSColumn setColumn(int col, KDSColumn c) {
        assert (ColumnsBuffer.isExist(c));
        this.cols.put(col, c);
        return c;
    }

    public KDSSheetPrintSetup getPrintSetup() {
        return this.printSetup;
    }

    public void setPrintSetup(KDSSheetPrintSetup printSetup) {
        this.printSetup = printSetup;
    }

    public void setEmbedhLayer(byte[] layer, EmbedObjectRectangle bounds) {
        this.layer.add(layer);
        this.layer.add(bounds);
    }

    public void setEmbedhLayer(byte[] layer, Rectangle bounds) {
        this.layer.add(layer);
        this.layer.add(bounds);
    }

    public ArrayList getEmbedhLayer() {
        return this.layer;
    }

    public void setHeadRowCount(int headRowCount) {
        this.headRowCount = headRowCount;
    }

    public int getHeadRowCount() {
        return this.headRowCount;
    }

    public boolean isHeader(int row) {
        return row < this.headRowCount;
    }

    @Override
    public boolean equals(Object another) {
        boolean sret = super.equals(another);
        boolean ret = false;
        if (another instanceof KDSSheet) {
            ret = this.name != null ? this.name.equals(((KDSSheet)another).getName()) : this == another;
        }
        return sret && ret;
    }

    public void setRowSpans(List rowSpans) {
        this.rowSpans = rowSpans;
    }

    public List getRowSpans() {
        return this.rowSpans;
    }

    public void setColSpans(List colSpans) {
        this.colSpans = colSpans;
    }

    public List getColSpans() {
        return this.colSpans;
    }

    public boolean isLeftToOulineGroup() {
        return this.leftToOutlineGroup;
    }

    public void setLeftToOutlineGroup(boolean leftToOutlineGroup) {
        this.leftToOutlineGroup = leftToOutlineGroup;
    }

    public boolean isAboveOfOutlineGroup() {
        return this.aboveOfOutlineGroup;
    }

    public void setAboveOfOutlineGroup(boolean aboveOfOutlineGroup) {
        this.aboveOfOutlineGroup = aboveOfOutlineGroup;
    }

    class KDSMerges
    implements IMerges {
        private LinkedList merges = new LinkedList();
        boolean doCrossTest = true;

        @Override
        public KDSMergeBlock addMerge(int row, int col, int row2, int col2) {
            KDSMergeBlock merge;
            block9: {
                assert (KDSSheet.this.isValidRowCol(row, col));
                assert (KDSSheet.this.isValidRowCol(row2, col2));
                if (!this.doCrossTest) {
                    return this.addMergeWithoutCrossCheck(row, col, row2, col2);
                }
                merge = KDSMergeBlock.NULL_MERGE;
                if (row != row2 || col != col2) {
                    ArrayList<KDSMergeBlock> removes = new ArrayList<KDSMergeBlock>();
                    KDSMergeBlock mbNew = new KDSMergeBlock(row, col, row2, col2);
                    Iterator i = this.merges.iterator();
                    while (i.hasNext()) {
                        merge = (KDSMergeBlock)i.next();
                        if (!mbNew.cross(merge)) continue;
                        if (mbNew.equals(merge)) {
                            return merge;
                        }
                        if (mbNew.include(merge)) {
                            removes.add(merge);
                            i.remove();
                            continue;
                        }
                        this.merges.addAll(removes);
                        merge = KDSMergeBlock.NULL_MERGE;
                        break block9;
                    }
                    for (int i2 = 0; i2 < removes.size(); ++i2) {
                        merge = (KDSMergeBlock)removes.get(i2);
                        this.setCellsStateUnderMergeBlock(merge, KDSMergeBlock.NULL_MERGE);
                    }
                    merge = mbNew;
                    this.merges.add(merge);
                }
            }
            if (!merge.isNullMergeBlock()) {
                this.setCellsStateUnderMergeBlock(merge, merge);
            }
            return merge;
        }

        KDSMergeBlock addMergeWithoutCrossCheck(int row, int col, int row2, int col2) {
            KDSMergeBlock merge = new KDSMergeBlock(row, col, row2, col2);
            this.merges.add(merge);
            if (!merge.isNullMergeBlock()) {
                this.setCellsStateUnderMergeBlock(merge, merge);
            }
            return merge;
        }

        private void setCellsStateUnderMergeBlock(KDSMergeBlock mergeRange, KDSMergeBlock mergeValue) {
            boolean create;
            assert (mergeRange != null && mergeValue != null);
            if (mergeRange.isNullMergeBlock()) {
                return;
            }
            boolean bl = create = !mergeValue.isNullMergeBlock();
            if (mergeRange.isWholeRow()) {
                if (mergeRange.isWholeColumn()) {
                    KDSSheet.this.setMergeBlock(mergeValue);
                } else {
                    for (int i = mergeRange.row; i <= mergeRange.getRow2(); ++i) {
                        KDSSheet.this.setRow(i, RowsBuffer.getRow(KDSSheet.this.getRow(i, create), mergeValue));
                    }
                }
            } else if (mergeRange.isWholeColumn()) {
                for (int i = mergeRange.col; i <= mergeRange.getCol2(); ++i) {
                    KDSSheet.this.setColumn(i, ColumnsBuffer.getColumn(KDSSheet.this.getColumn(i, create), mergeValue));
                }
            } else {
                for (int i = mergeRange.row; i <= mergeRange.getRow2(); ++i) {
                    for (int j = mergeRange.col; j <= mergeRange.getCol2(); ++j) {
                        KDSSheet.this.setCell(i, j, CellsBuffer.getCell(KDSSheet.this.getCell(i, j, create), mergeValue), false);
                    }
                }
            }
        }

        @Override
        public boolean isCellMerged(int row, int col) {
            return !this.getMergeBlock(row, col).isNullMergeBlock();
        }

        @Override
        public KDSMergeBlock getMergeBlock(int row, int col) {
            KDSMergeBlock merge;
            block2: {
                block3: {
                    block1: {
                        assert (KDSSheet.this.isValidRowCol(row, col));
                        merge = KDSMergeBlock.NULL_MERGE;
                        KDSRow r = KDSSheet.this.getRow(row, false);
                        if (r == KDSSheet.this.defaultRow || !r.isMerged()) break block1;
                        merge = r.getMergeBlock();
                        break block2;
                    }
                    KDSColumn c = KDSSheet.this.getColumn(col, false);
                    if (c == KDSSheet.this.defaultColumn || !c.isMerged()) break block3;
                    merge = c.getMergeBlock();
                    break block2;
                }
                KDSCell cell = KDSSheet.this.getCell(row, col, false);
                if (cell == KDSSheet.this.defaultCell || !cell.isMerged()) break block2;
                merge = cell.getMergeBlock();
            }
            return merge;
        }

        @Override
        public KDSMergeBlock remove(int row, int col) {
            if (!this.isCellMerged(row, col)) {
                return KDSMergeBlock.NULL_MERGE;
            }
            KDSMergeBlock merge = KDSMergeBlock.NULL_MERGE;
            Iterator it = this.merges.iterator();
            while (it.hasNext()) {
                merge = (KDSMergeBlock)it.next();
                if (!merge.include(row, col)) continue;
                it.remove();
                break;
            }
            assert (!merge.isNullMergeBlock());
            this.setCellsStateUnderMergeBlock(merge, KDSMergeBlock.NULL_MERGE);
            return merge;
        }

        @Override
        public void removeAll() {
            for (KDSMergeBlock merge : this.merges) {
                this.setCellsStateUnderMergeBlock(merge, KDSMergeBlock.NULL_MERGE);
            }
            this.merges.clear();
        }

        @Override
        public Iterator iterator() {
            return this.merges.iterator();
        }
    }

    class ColumnStyleAttributesListener
    implements StyleAttributesChangeListener {
        protected ColumnStyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent evt) {
            if (evt.getSA().isEmpty()) {
                return;
            }
            if (!(evt.getOwner() instanceof Integer)) {
                throw new IllegalArgumentException("col");
            }
            int col = (Integer)evt.getOwner();
            if (!KDSSheet.this.isValidRowCol(0, col)) {
                throw new IllegalArgumentException("col");
            }
            ShareStyleAttributes ssaCol = Styles.getSSA((StyleAttributes)evt.getSA());
            KDSSheet.this.updateColumnStyle(col, ssaCol);
            ArrayList alCells = KDSSheet.this.getCellsWithinRowCol(col, false);
            for (int i = 0; i < alCells.size(); ++i) {
                Map.Entry e = (Map.Entry)alCells.get(i);
                long key = (Long)e.getKey();
                int row = (int)(key >> 32);
                KDSCell cell = (KDSCell)e.getValue();
                assert (cell != KDSSheet.this.defaultCell);
                ShareStyleAttributes ssaCell = cell.getSSA();
                Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssaCell, KDSSheet.this.getRow(row, false).getSSA(), ssaCol, KDSSheet.this.getSSA()});
                KDSSheet.this.setCell(row, col, CellsBuffer.getCell(cell, ssaCell, style), true);
            }
        }
    }

    class RowStyleAttributesListener
    implements StyleAttributesChangeListener {
        protected RowStyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent evt) {
            if (evt.getSA().isEmpty()) {
                return;
            }
            if (!(evt.getOwner() instanceof Integer)) {
                throw new IllegalArgumentException("row");
            }
            int row = (Integer)evt.getOwner();
            if (!KDSSheet.this.isValidRowCol(row, 0)) {
                throw new IllegalArgumentException("row");
            }
            ShareStyleAttributes ssaRow = Styles.getSSA((StyleAttributes)evt.getSA());
            KDSSheet.this.updateRowStyle(row, ssaRow);
            ArrayList alCells = KDSSheet.this.getCellsWithinRowCol(row, true);
            for (int i = 0; i < alCells.size(); ++i) {
                Map.Entry e = (Map.Entry)alCells.get(i);
                long key = (Long)e.getKey();
                int col = (int)(key & Integer.MAX_VALUE);
                KDSCell cell = (KDSCell)e.getValue();
                assert (cell != KDSSheet.this.defaultCell);
                ShareStyleAttributes ssaCell = cell.getSSA();
                Style style = Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{ssaCell, ssaRow, KDSSheet.this.getColumn(col, false).getSSA(), KDSSheet.this.getSSA()});
                KDSSheet.this.setCell(row, col, CellsBuffer.getCell(cell, ssaCell, style), true);
            }
        }
    }

    class CellStyleAttributesListener
    implements StyleAttributesChangeListener {
        protected CellStyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent evt) {
            int col;
            if (evt.getSA().isEmpty()) {
                return;
            }
            if (!(evt.getOwner() instanceof Long)) {
                throw new IllegalArgumentException("cell");
            }
            long rowcol = (Long)evt.getOwner();
            int row = (int)(rowcol >> 32);
            if (!KDSSheet.this.isValidRowCol(row, col = (int)(rowcol & Integer.MAX_VALUE))) {
                throw new IllegalArgumentException("cell");
            }
            KDSSheet.this.updateCellStyle(row, col, Styles.getSSA((StyleAttributes)evt.getSA()));
        }
    }

    class SheetStyleAttributesListener
    implements StyleAttributesChangeListener {
        protected SheetStyleAttributesListener() {
        }

        public void changeStyleAttributes(StyleAttributesChangeEvent evt) {
            if (evt.getSA().isEmpty()) {
                return;
            }
            assert (KDSSheet.this.name.equals(evt.getOwner()));
            KDSSheet.this.updateSheetStyle(Styles.getSSA((StyleAttributes)evt.getSA()));
        }
    }
}

