/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintInfoParsingException;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import java.awt.Dimension;
import java.lang.reflect.Field;
import javax.print.PrintService;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import org.apache.log4j.Logger;

public class PrintInfo
implements Cloneable {
    private static final Logger logger = LogUtil.getPackageLogger(PrintInfo.class);
    public static final PrintInfo DefaultPrintInfo = new PrintInfo();
    public static final String PORTRAIT = "PORTRAIT";
    public static final String LANDSCAPE = "LANDSCAPE";
    int leftMargin = 190;
    int rightMargin = 190;
    int topMargin = 250;
    int bottomMargin = 250;
    private IXmlElement xmlroot;
    private String namedPaperSize = "iso-a4";
    private String orientation = "portrait";
    int customizePaperWidth = 2100;
    int customizePaperHeight = -1;
    boolean isSnapShot = false;
    private boolean isCustomizedPaperSize = false;
    int headerMargin = 80;
    int footerMargin = 80;
    int headerPreferHeight = 80;
    int footerPreferHeight = 80;
    private int customizePageBottom = -1;
    private boolean isEconomizePaper;

    public PrintInfo() {
    }

    public static MediaSizeName String2MediaSizeName(String str) {
        Field[] f = MediaSizeName.class.getFields();
        try {
            for (int i = 0; i < f.length; ++i) {
                MediaSizeName msn;
                if (f[i].getDeclaringClass() != MediaSizeName.class || !(msn = (MediaSizeName)f[i].get(MediaSizeName.A)).toString().equals(str)) continue;
                return msn;
            }
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return null;
    }

    public PrintInfo(IXmlElement elt) throws PrintInfoParsingException {
        IXmlElement printersetup;
        IXmlElement snapshot;
        IXmlElement eOrient;
        IXmlElement efooter;
        IXmlElement custsize;
        this.xmlroot = elt;
        IXmlElement pagesetup = elt.getChild("PageSetup");
        if (pagesetup == null) {
            return;
        }
        IXmlElement margin = pagesetup.getChild("PageMargin");
        if (margin != null) {
            String left = margin.getAttribute("left");
            String right = margin.getAttribute("right");
            String top = margin.getAttribute("top");
            String bottom = margin.getAttribute("bottom");
            if (left != null) {
                this.leftMargin = Integer.parseInt(left);
            }
            if (right != null) {
                this.rightMargin = Integer.parseInt(right);
            }
            if (top != null) {
                this.topMargin = Integer.parseInt(top);
            }
            if (bottom != null) {
                this.bottomMargin = Integer.parseInt(bottom);
            }
            String strHeader = margin.getAttribute("header");
            String strFooter = margin.getAttribute("footer");
            if (strHeader != null) {
                this.headerPreferHeight = Integer.parseInt(strHeader);
            }
            if (strFooter != null) {
                this.footerPreferHeight = Integer.parseInt(strFooter);
            }
        }
        if ((custsize = pagesetup.getChild("CustomizePaperSize")) != null) {
            String cbottom;
            String cwidth = custsize.getAttribute("width");
            String cheight = custsize.getAttribute("height");
            if (cwidth != null) {
                this.customizePaperWidth = Integer.parseInt(cwidth);
            }
            if (cheight != null) {
                this.customizePaperHeight = Integer.parseInt(cheight);
            }
            this.customizePageBottom = (cbottom = custsize.getAttribute("bottom")) == null ? this.customizePaperHeight : Integer.parseInt(cbottom);
            this.isCustomizedPaperSize = true;
        } else {
            IXmlElement papersize = pagesetup.getChild("PaperSizeName");
            if (papersize != null) {
                this.namedPaperSize = papersize.getText();
            }
        }
        IXmlElement eheader = pagesetup.getChild("Header");
        if (eheader != null) {
            String hm = eheader.getAttribute("margin");
            this.headerMargin = Integer.parseInt(hm);
            String hh = eheader.getAttribute("height");
            this.headerPreferHeight = Integer.parseInt(hh);
        }
        if ((efooter = pagesetup.getChild("Footer")) != null) {
            String fm = efooter.getAttribute("margin");
            this.footerMargin = Integer.parseInt(fm);
            String fh = efooter.getAttribute("height");
            this.footerPreferHeight = Integer.parseInt(fh);
        }
        if ((eOrient = pagesetup.getChild("Orientation")) != null) {
            this.orientation = eOrient.getText();
        }
        if ((snapshot = elt.getChild("SnapShot")) != null) {
            this.isSnapShot = true;
        }
        if ((printersetup = elt.getChild("PrinterSetup")).getAttribute("economizePaper") != null) {
            this.setEconomizePaper(true);
        }
    }

    public IXmlElement store() {
        IXmlElement printroot = XmlUtil.createNode((String)"PrintInfo");
        IXmlElement pagesetup = XmlUtil.createNode((String)"PageSetup");
        IXmlElement printersetup = XmlUtil.createNode((String)"PrinterSetup");
        IXmlElement pageMargin = XmlUtil.createNode((String)"PageMargin");
        IXmlElement orientation = XmlUtil.createNode((String)"Orientation");
        pageMargin.setAttribute("left", Integer.toString(this.leftMargin));
        pageMargin.setAttribute("right", Integer.toString(this.rightMargin));
        pageMargin.setAttribute("top", Integer.toString(this.topMargin));
        pageMargin.setAttribute("bottom", Integer.toString(this.bottomMargin));
        pageMargin.setAttribute("header", Integer.toString(this.headerPreferHeight));
        pageMargin.setAttribute("footer", Integer.toString(this.footerPreferHeight));
        pagesetup.addChild(pageMargin);
        orientation.addCData(this.orientation);
        pagesetup.addChild(orientation);
        if (this.isCustomizedPaperSize) {
            IXmlElement customizePaperSize = XmlUtil.createNode((String)"CustomizePaperSize");
            customizePaperSize.setAttribute("width", Integer.toString(this.customizePaperWidth));
            customizePaperSize.setAttribute("height", Integer.toString(this.customizePaperHeight));
            customizePaperSize.setAttribute("bottom", Integer.toString(this.customizePageBottom));
            pagesetup.addChild(customizePaperSize);
        } else {
            IXmlElement namepsize = XmlUtil.createNode((String)"PaperSizeName");
            namepsize.addCData(this.namedPaperSize);
            pagesetup.addChild(namepsize);
        }
        IXmlElement header = XmlUtil.createNode((String)"Header");
        header.setAttribute("height", Integer.toString(this.headerPreferHeight));
        header.setAttribute("margin", Integer.toString(this.headerMargin));
        pagesetup.addChild(header);
        IXmlElement footer = XmlUtil.createNode((String)"Footer");
        footer.setAttribute("height", Integer.toString(this.footerPreferHeight));
        footer.setAttribute("margin", Integer.toString(this.footerMargin));
        pagesetup.addChild(footer);
        printroot.addChild(pagesetup);
        printroot.addChild(printersetup);
        if (this.isSnapShot) {
            IXmlElement isSnapshot = XmlUtil.createNode((String)"SnapShot");
            printroot.addChild(isSnapshot);
        }
        if (this.isEconomizePaper) {
            printersetup.setAttribute("economizePaper", "true");
        }
        return printroot;
    }

    public static void checkNull(Object pointer) throws PrintInfoParsingException {
        if (pointer == null) {
            throw new PrintInfoParsingException("null pointer");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" \n class PrintInfo: \n");
        buf.append("\t customize width ").append(this.customizePaperWidth);
        buf.append("\t customize heitht ").append(this.customizePaperHeight);
        buf.append('\n');
        buf.append("\t left ").append(this.leftMargin);
        buf.append("\t right ").append(this.rightMargin);
        buf.append("\t top ").append(this.topMargin);
        buf.append("\t bottom ").append(this.bottomMargin);
        buf.append('\n');
        buf.append("\t orient:").append(this.orientation);
        buf.append("\t namedpapersize:").append(this.namedPaperSize);
        return buf.toString();
    }

    public int getPaperWidth() {
        if (this.isCustomizedPaperSize) {
            return this.getCustomizePaperWidth();
        }
        MediaSizeName msn = PrintInfo.String2MediaSizeName(this.namedPaperSize);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        return (int)ms.getX(1000) * 10;
    }

    public Dimension getLogicPageDim() {
        Dimension dim;
        if (this.isCustomizedPaperSize) {
            int pw;
            int w = -1;
            int h = -1;
            int n = pw = PORTRAIT.equalsIgnoreCase(this.orientation) ? this.getPaperWidth() : this.getPaperHeight();
            if (pw > 0) {
                w = pw - this.leftMargin - this.rightMargin;
            }
            if (this.getCustomizePageBottom() > 0) {
                h = this.getCustomizePageBottom() - this.topMargin - this.bottomMargin;
            }
            dim = new Dimension(w, h);
        } else {
            dim = LANDSCAPE.equalsIgnoreCase(this.orientation) ? new Dimension(this.getPaperHeight() - this.leftMargin - this.rightMargin, this.getPaperWidth() - this.topMargin - this.bottomMargin) : new Dimension(this.getPaperWidth() - this.leftMargin - this.rightMargin, this.getPaperHeight() - this.topMargin - this.bottomMargin);
        }
        return dim;
    }

    public Dimension getPrintBodyArea() {
        Dimension dim;
        if (LANDSCAPE.equalsIgnoreCase(this.orientation)) {
            dim = new Dimension(this.getPaperHeight() - this.leftMargin - this.rightMargin, this.getPaperWidth() - this.topMargin - this.bottomMargin);
        } else {
            int w = -1;
            int h = -1;
            int paperWidth = this.getPaperWidth();
            int paperHeight = this.getPaperHeight();
            if (paperWidth > 0) {
                w = paperWidth - this.leftMargin - this.rightMargin;
            }
            if (paperHeight > 0) {
                h = paperHeight - this.topMargin - this.bottomMargin;
            }
            dim = new Dimension(w, h);
        }
        return dim;
    }

    public int getPaperHeight() {
        if (this.isCustomizedPaperSize) {
            return this.getCustomizePaperHeight();
        }
        MediaSizeName msn = PrintInfo.String2MediaSizeName(this.namedPaperSize);
        MediaSize ms = MediaSize.getMediaSizeForName(msn);
        return (int)ms.getY(1000) * 10;
    }

    public int getCustomizePaperWidth() {
        return this.customizePaperWidth;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setCustomizedPaperSize(boolean b) {
        this.isCustomizedPaperSize = b;
    }

    public void setCustomizePaperWidth(int i) {
        this.customizePaperWidth = i;
    }

    public void setCustomizePaperHeight(int i) {
        this.customizePaperHeight = i;
    }

    public void setNamedMediaSize(String namedMediaSize) {
        this.isCustomizedPaperSize = false;
        this.namedPaperSize = namedMediaSize;
    }

    public void setOrientation(String string) {
        this.orientation = string;
    }

    public int getBottomMargin() {
        return this.bottomMargin;
    }

    public int getLeftMargin() {
        return this.leftMargin;
    }

    public int getRightMargin() {
        return this.rightMargin;
    }

    public int getTopMargin() {
        return this.topMargin;
    }

    public int getHeaderMargin() {
        return this.headerMargin;
    }

    public void setHeaderMargin(int h) {
        this.headerMargin = h;
    }

    public void setFooterMargin(int f) {
        this.footerMargin = f;
    }

    public int getFooterMargin() {
        return this.footerMargin;
    }

    public void setBottomMargin(int i) {
        this.bottomMargin = i;
    }

    public void setLeftMargin(int i) {
        this.leftMargin = i;
    }

    public void setRightMargin(int i) {
        this.rightMargin = i;
    }

    public void setTopMargin(int i) {
        this.topMargin = i;
    }

    public int getCustomizePaperHeight() {
        return this.customizePaperHeight;
    }

    public String getNamedPaperSize() {
        if (this.isCustomizedPaperSize()) {
            return "customize";
        }
        return this.namedPaperSize;
    }

    public AttributeSet getAttrSet() {
        if (this.xmlroot == null) {
            return null;
        }
        IXmlElement printersetup = this.xmlroot.getChild("PrinterSetup");
        HashPrintRequestAttributeSet newAttrSet = null;
        newAttrSet = printersetup != null && printersetup.getChildren().size() > 0 ? (HashPrintRequestAttributeSet)Base64.decodeToObject((String)printersetup.getText()) : new HashPrintRequestAttributeSet();
        return newAttrSet;
    }

    public boolean isCustomizedPaperSize() {
        return this.isCustomizedPaperSize;
    }

    public MediaPrintableArea getMediaPrintableArea(PrintService serv) {
        int cpHeight = this.customizePaperHeight;
        int cpWidth = this.customizePaperWidth;
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)serv.getDefaultAttributeValue(Media.class));
        if (this.isCustomizedPaperSize) {
            if (cpHeight == -1) {
                cpHeight = (int)mediaSize.getY(1000) * 10;
            }
            if (cpWidth == -1) {
                cpWidth = (int)mediaSize.getX(1000) * 10;
            }
            return new MediaPrintableArea((float)((double)this.leftMargin * 0.1), (float)((double)this.topMargin * 0.1), (float)((double)(cpWidth - this.leftMargin - this.rightMargin) * 0.1), (float)((double)(cpHeight - this.topMargin - this.bottomMargin) * 0.1), 1000);
        }
        MediaSize ms = MediaSize.getMediaSizeForName(PrintInfo.String2MediaSizeName(this.namedPaperSize));
        return new MediaPrintableArea((float)((double)this.leftMargin * 0.1), (float)((double)this.topMargin * 0.1), (float)((double)ms.getX(1000) - (double)(this.leftMargin + this.rightMargin) * 0.1), (float)((double)ms.getY(1000) - (double)(this.topMargin + this.bottomMargin) * 0.1), 1000);
    }

    public Object clone() {
        PrintInfo newInfo = null;
        try {
            newInfo = (PrintInfo)super.clone();
            newInfo.xmlroot = this.xmlroot;
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return newInfo;
    }

    public boolean isSnapShot() {
        return this.isSnapShot;
    }

    public void setSnapShot(boolean b) {
        this.isSnapShot = b;
    }

    public int getFooterPreferHeight() {
        return this.footerPreferHeight;
    }

    public int getHeaderPreferHeight() {
        return this.headerPreferHeight;
    }

    public void setHeaderPreferHeight(int i) {
        this.headerPreferHeight = i;
    }

    public void setFooterPreferHeight(int i) {
        this.footerPreferHeight = i;
    }

    public int getCustomizePageBottom() {
        return this.customizePageBottom;
    }

    public void setCustomizePageBottom(int customizePageBottom) {
        this.customizePageBottom = customizePageBottom;
    }

    public boolean isEconomizePaper() {
        return this.isEconomizePaper;
    }

    public void setEconomizePaper(boolean isEconomize) {
        this.isEconomizePaper = isEconomize;
    }
}

