/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.conf;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.GlobalLocator;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.kdf.printprovider.conf.PrintProviderConfig;
import java.io.File;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class ConfManager {
    private static final Logger logger = LogUtil.getLogger(ConfManager.class);
    private String configfile;
    private PrintProviderConfig config = new PrintProviderConfig();
    private String toolbarName = null;
    private static ConfManager defaultManager;

    public PrintProviderConfig getConf() {
        return this.config;
    }

    public static ConfManager getDefaultInstance() {
        if (defaultManager == null) {
            defaultManager = new ConfManager();
            defaultManager.loadConfig("/client/PrintBase.xml");
        }
        return defaultManager;
    }

    public void loadConfig(String pathText) {
        String path;
        File f = GlobalLocator.getInstance().locateResourceFile(pathText);
        if (f == null) {
            return;
        }
        this.configfile = path = f.getPath();
        this.config.clear();
        XMLReader xmlReader = null;
        try {
            ConfSAXHandler handler = new ConfSAXHandler();
            xmlReader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xmlReader.setContentHandler(handler);
            xmlReader.setErrorHandler(handler);
            InputSource source = new InputSource(path);
            xmlReader.parse(source);
            InputStream inputStream = XmlUtil.inputSource2inputStream((InputSource)source);
            IXmlElement element = com.kingdee.bos.qing.common.xml.XmlUtil.loadRootElement((InputStream)inputStream);
            this.config.setSetupTreeNode(element.getChild("setuptree"));
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    public String getConfigfile() {
        return this.configfile;
    }

    private class ConfSAXHandler
    extends DefaultHandler
    implements ErrorHandler {
        boolean bParsing_StopRetriveAtClosing = false;

        private ConfSAXHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!"buttons".equals(qName)) {
                if ("button".equals(qName)) {
                    ConfManager.this.config.addEnableAction(attributes.getValue("classname"));
                } else if ("stopRetriveAtClosing".equals(qName)) {
                    this.bParsing_StopRetriveAtClosing = true;
                } else if ("formServer".equals(qName)) {
                    String serverMode = attributes.getValue("mode");
                    if (serverMode == null) {
                        logger.error((Object)("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1aformServer\u8282\u70b9\u6ca1\u6709mode\u5c5e\u6027" + ConfManager.this.configfile));
                    } else if (serverMode.equalsIgnoreCase("remote")) {
                        String tcpUrl = attributes.getValue("tcpurl");
                        if (tcpUrl == null) {
                            logger.error((Object)("\u914d\u7f6e\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff1aremote\u6a21\u5f0f\u6ca1\u6709tcpurl" + ConfManager.this.configfile));
                        } else {
                            ConfManager.this.config.setRemoteMode(true, tcpUrl);
                        }
                    }
                } else if (!"toolbars".equals(qName)) {
                    if ("toolbar".equals(qName)) {
                        ConfManager.this.toolbarName = attributes.getValue("name");
                    } else if ("tbbutton".equals(qName) && ConfManager.this.toolbarName != null) {
                        ConfManager.this.config.addToolbarButton(ConfManager.this.toolbarName, attributes.getValue("classname"));
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!"buttons".equals(qName)) {
                if ("stopRetriveAtClosing".equals(qName)) {
                    this.bParsing_StopRetriveAtClosing = false;
                } else if ("toolbar".equals(qName)) {
                    ConfManager.this.toolbarName = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            String strVal = new String(ch, start, length);
            if (this.bParsing_StopRetriveAtClosing) {
                if (strVal.equalsIgnoreCase("false")) {
                    ConfManager.this.config.setStopRetriveAtClose(false);
                } else if (strVal.equalsIgnoreCase("true")) {
                    ConfManager.this.config.setStopRetriveAtClose(true);
                }
            }
        }
    }
}

