/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IExSetup;
import com.kingdee.cosmic.ctrl.kdf.printprovider.IPrintCompositable;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrintCompContainer;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterAttrManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.PrinterNotFoundException;
import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.BasicPrintSetupPaneBuilder;
import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.ExSetupManager;
import com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.FixedLayout;
import com.kingdee.cosmic.ctrl.kdf.printprovider.resources.Resources;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.print.PrintService;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;

public class ExSetupDialog
extends KDDialog {
    private static final Logger logger = LogUtil.getLogger(ExSetupDialog.class);
    private static final long serialVersionUID = 4421536588552010871L;
    private static final int TREE_WIDTH = 148;
    private static final int GAP = 10;
    public static final int RIGHT_WIDTH = 425;
    public static final int RIGHT_HEIGHT = 350;
    KDPanel leftTree;
    KDPanel rightPane;
    JButton btnOk;
    JButton btnCancel;
    ExSetupManager setupMgr;
    PrintCompContainer container;
    boolean isClosed = true;
    String DEFAULT_BUILDER_CLASSNAME = "com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs.BasicPrintSetupPaneBuilder";

    public ExSetupDialog(Dialog dlg, String title, boolean modal, ExSetupManager mgr, PrintCompContainer container) throws Exception {
        super(dlg, title, modal);
        this.initDialog(mgr, container);
    }

    public ExSetupDialog(Frame frame, String title, boolean modal, ExSetupManager mgr, PrintCompContainer container) throws Exception {
        super(frame, title, modal);
        this.initDialog(mgr, container);
    }

    private void initDialog(ExSetupManager mgr, PrintCompContainer container) throws Exception {
        this.setupMgr = mgr;
        this.container = container;
        this.initComponent();
        this.setResizable(false);
        this.pack();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                if (ExSetupDialog.this.isClosed) {
                    Hashtable panes = ExSetupDialog.this.setupMgr.getUserPanes();
                    for (JPanel pane : panes.values()) {
                        if (!(pane instanceof IExSetup)) continue;
                        ((IExSetup)((Object)pane)).onShow();
                    }
                    ExSetupDialog.this.isClosed = false;
                }
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                ExSetupDialog.this.isClosed = true;
            }
        });
    }

    private void initComponent() throws Exception {
        JPanel cp = (JPanel)this.getContentPane();
        cp.setLayout(null);
        int w = 425;
        int h = 350;
        KDTree tree = this.createTree();
        KDTreeView view = new KDTreeView(tree);
        view.setShowControlPanel(false);
        view.setPreferredSize(new Dimension(148, h));
        this.leftTree = new KDPanel((LayoutManager)FixedLayout.ONE());
        this.leftTree.add((Component)view);
        this.rightPane = new KDPanel((LayoutManager)FixedLayout.ONE());
        KDPanel separater = new KDPanel((LayoutManager)FixedLayout.ONE());
        separater.setBorder(BorderFactory.createEtchedBorder());
        JPanel applyPane = this.createApplyPane();
        cp.add((Component)this.leftTree);
        cp.add((Component)this.rightPane);
        cp.add((Component)separater);
        cp.add(applyPane);
        int x = 10;
        int y = 10;
        this.leftTree.setBounds(x, y, 148, h);
        this.rightPane.setBounds(x + 148 + 10, y, w, h);
        w = x + 148 + 10 + w + 10;
        y = y + h + 10;
        separater.setBounds(-2, y, w + 4, 2);
        h = applyPane.getPreferredSize().height;
        applyPane.setBounds(0, y + 10, w - 10, h);
        h = y + 10 + h + 10;
        cp.setPreferredSize(new Dimension(w, h));
    }

    private KDTree createTree() {
        KDTree tree = this.setupMgr.getConfTree();
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                JPanel pane = ExSetupDialog.this.activeConfPane((TreeNode)e.getNewLeadSelectionPath().getLastPathComponent(), null);
                if (pane instanceof IExSetup) {
                    ((IExSetup)((Object)pane)).onShow();
                }
            }
        });
        MutableTreeNode root = (MutableTreeNode)tree.getModel().getRoot();
        Enumeration enum1 = this.setupMgr.getUserPanes().keys();
        while (enum1.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)enum1.nextElement();
            tree.addNodeInto((MutableTreeNode)node, root);
            this.setupMgr.getPanesCache().put(node, this.setupMgr.getUserPanes().get(node));
        }
        return tree;
    }

    private JPanel createApplyPane() throws Exception {
        BasicPrintSetupPaneBuilder builder = this.setupMgr.getPanebuilder();
        this.btnCancel = builder.getCancelButton();
        this.btnCancel.setText(Resources.LOCAL_STR("cancel", "cancel"));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExSetupDialog.this.setupMgr.setApproved(false);
                ExSetupDialog.this.setVisible(false);
            }
        });
        this.btnOk = builder.getOKButton();
        this.btnOk.setText(Resources.LOCAL_STR("approve", "OK"));
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExSetupDialog.this.setVisible(false);
                ExSetupDialog.this.setupMgr.onApprove();
                ExSetupDialog.this.setupMgr.setApproved(true);
            }
        });
        JPanel applyPane = new JPanel(new FlowLayout(2, 3, 0));
        applyPane.add(this.btnOk);
        applyPane.add(this.btnCancel);
        return applyPane;
    }

    private BasicPrintSetupPaneBuilder getPaneBuilder() {
        BasicPrintSetupPaneBuilder buider = null;
        try {
            buider = this.setupMgr.getPanebuilder();
        }
        catch (PrinterNotFoundException e1) {
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)Resources.LOCAL_STR("PrinterNotFound"));
            logger.error((Object)"Printer Not Found");
        }
        return buider;
    }

    private JPanel createPanelByName(String clsName, BasicPrintSetupPaneBuilder builder) {
        Object pane = null;
        if (clsName.equalsIgnoreCase(this.DEFAULT_BUILDER_CLASSNAME)) {
            pane = new KDPanel((LayoutManager)FixedLayout.ONE());
            pane.add((Component)builder.getConfigPane());
        } else {
            try {
                pane = (JPanel)Class.forName(clsName).newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)"err", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"err", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return pane;
    }

    private JPanel getPaneByNode(TreeNode node, BasicPrintSetupPaneBuilder builder) {
        JPanel pane;
        Object key = node;
        if (node instanceof DefaultKingdeeTreeNode) {
            key = ((DefaultKingdeeTreeNode)node).getText();
        }
        if ((pane = (JPanel)this.setupMgr.getPanesCache().get(key)) != null) {
            return pane;
        }
        String clsName = this.setupMgr.getClsNameOfNode(node);
        if (StringUtil.isEmptyString((String)clsName)) {
            return null;
        }
        pane = this.createPanelByName(clsName, builder);
        if (pane != null) {
            if (pane instanceof IExSetup) {
                this.setupMgr.addExsetup2((IExSetup)((Object)pane));
            }
            if (pane instanceof IPrintCompositable) {
                ((IPrintCompositable)((Object)pane)).setCompContainer(this.container);
            }
            this.setupMgr.getPanesCache().put(key, pane);
        }
        return pane;
    }

    private JPanel activeConfPane(TreeNode node, PrinterAttrManager attrMgr) {
        String clsName;
        BasicPrintSetupPaneBuilder builder = this.getPaneBuilder();
        if (builder == null) {
            return null;
        }
        JPanel pane = this.getPaneByNode(node, builder);
        this.rightPane.removeAll();
        if (pane != null) {
            pane.setPreferredSize(new Dimension(425, 350));
            this.rightPane.add((Component)pane);
            this.rightPane.validate();
        }
        if (this.DEFAULT_BUILDER_CLASSNAME.equalsIgnoreCase(clsName = this.setupMgr.getClsNameOfNode(node)) && attrMgr != null) {
            builder.getServDlg().setAttributes(attrMgr.getRequestAttrSet());
        }
        this.rightPane.repaint();
        return pane;
    }

    public PrintService printDialog(PrinterAttrManager attrMgr) {
        PrintService retServ = null;
        this.setupMgr.getConfTree().setSelectionRow(1);
        this.activeConfPane((TreeNode)this.setupMgr.getConfTree().getSelectionPath().getLastPathComponent(), attrMgr);
        this.setupMgr.udpate();
        this.setVisible(true);
        try {
            BasicPrintSetupPaneBuilder bb = this.setupMgr.getPanebuilder();
            if (this.setupMgr.isApproved()) {
                this.setupMgr.getAttrmgr().getRequestAttrSet().addAll(bb.getServDlg().getAttributes());
            }
            retServ = bb.getServDlg().getPrintService();
        }
        catch (PrinterNotFoundException e) {
            logger.error((Object)" Printer Not Found ", (Throwable)e);
            KDOptionPane.showMessageDialog((Component)((Object)this), (Object)Resources.LOCAL_STR("PrinterNotFound"));
        }
        return retServ;
    }
}

