/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.printprovider.dialogs;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.printprovider.ScaleFactor;
import com.kingdee.cosmic.ctrl.print.util.MediaUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FilePermission;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DecimalFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.NumberFormatter;
import sun.print.SunAlternateMedia;

public class PrintConfigDialog
extends KDDialog
implements ActionListener {
    private static final long serialVersionUID = 5689432009429913728L;
    private static final int PAGE_W = 423;
    private static final int GAP = 10;
    private static final int SPACE = 3;
    public static final int CONFIG_COMPONENT_HEIGHT = 350;
    public static final int CONFIG_COMPONENT_WIDTH = 425;
    public static final int WAITING = 0;
    public static final int APPROVE = 1;
    public static final int CANCEL = 2;
    private static final String strBundle = "sun.print.resources.serviceui";
    private static ResourceBundle messageRB;
    private KDTabbedPane tpTabs;
    private KDButton btnCancel;
    private KDButton btnApprove;
    private PrintService[] services;
    private int defaultServiceIndex;
    private PrintRequestAttributeSet asOriginal;
    private HashPrintRequestAttributeSet asCurrent;
    private PrintService psCurrent;
    private DocFlavor docFlavor;
    private int status;
    private GeneralPanel pnlGeneral;
    private PageSetupPanel pnlPageSetup;
    private AppearancePanel pnlAppearance;

    public PrintConfigDialog(Frame owner) {
        super(owner, true);
    }

    public PrintConfigDialog(Dialog owner) {
        super(owner, true);
    }

    public PrintConfigDialog(GraphicsConfiguration gc, int x, int y, PrintService[] services, int defaultServiceIndex, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        super(new Frame(gc), true);
        this.init(gc, x, y, services, defaultServiceIndex, flavor, attributes);
    }

    public PrintConfigDialog(GraphicsConfiguration gc, int x, int y, PrintService ps, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        super(new Frame(gc), true);
        this.init2(x, y, ps, flavor, attributes);
    }

    public void init(GraphicsConfiguration gc, int x, int y, PrintService[] services, int defaultServiceIndex, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        this.services = services;
        this.defaultServiceIndex = defaultServiceIndex;
        this.psCurrent = services[defaultServiceIndex];
        this.docFlavor = flavor;
        this.asOriginal = attributes;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.tpTabs = new KDTabbedPane();
        this.tpTabs.setBorder((Border)new EmptyBorder(5, 5, 5, 5));
        String gkey = PrintConfigDialog.getMsg("tab.general");
        int gmnemonic = PrintConfigDialog.getVKMnemonic("tab.general");
        this.pnlGeneral = new GeneralPanel();
        this.tpTabs.add(gkey, (Component)((Object)this.pnlGeneral));
        this.tpTabs.setMnemonicAt(0, gmnemonic);
        String pkey = PrintConfigDialog.getMsg("tab.pagesetup");
        int pmnemonic = PrintConfigDialog.getVKMnemonic("tab.pagesetup");
        this.pnlPageSetup = new PageSetupPanel();
        this.tpTabs.add(pkey, (Component)((Object)this.pnlPageSetup));
        this.tpTabs.setMnemonicAt(1, pmnemonic);
        String akey = PrintConfigDialog.getMsg("tab.appearance");
        int amnemonic = PrintConfigDialog.getVKMnemonic("tab.appearance");
        this.pnlAppearance = new AppearancePanel();
        this.tpTabs.add(akey, (Component)((Object)this.pnlAppearance));
        this.tpTabs.setMnemonicAt(2, amnemonic);
        int h = this.max(this.pnlGeneral.getPreferredSize().height, this.pnlPageSetup.getPreferredSize().height, this.pnlAppearance.getPreferredSize().height);
        h += 30;
        c.add((Component)this.tpTabs, "Center");
        this.updatePanels();
        KDPanel pnlSouth = new KDPanel((LayoutManager)new FlowLayout(4));
        this.btnApprove = PrintConfigDialog.createButton("button.print", this);
        pnlSouth.add((Component)this.btnApprove);
        this.btnCancel = PrintConfigDialog.createButton("button.cancel", this);
        pnlSouth.add((Component)this.btnCancel);
        c.add((Component)pnlSouth, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PrintConfigDialog.this.dispose(2);
            }
        });
        this.setTitle(PrintConfigDialog.getMsg("dialog.printtitle"));
        this.setResizable(false);
        this.setLocation(x, y);
        this.pack();
    }

    private void init2(int x, int y, PrintService ps, DocFlavor flavor, PrintRequestAttributeSet attributes) {
        this.psCurrent = ps;
        this.docFlavor = flavor;
        this.asOriginal = attributes;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        this.pnlPageSetup = new PageSetupPanel();
        c.add((Component)((Object)this.pnlPageSetup), "Center");
        this.pnlPageSetup.updateInfo();
        KDPanel pnlSouth = new KDPanel((LayoutManager)new FlowLayout(4));
        this.btnApprove = PrintConfigDialog.createButton("button.ok", this);
        pnlSouth.add((Component)this.btnApprove);
        this.btnCancel = PrintConfigDialog.createButton("button.cancel", this);
        pnlSouth.add((Component)this.btnCancel);
        c.add((Component)pnlSouth, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                PrintConfigDialog.this.dispose(2);
            }
        });
        this.setTitle(PrintConfigDialog.getMsg("dialog.pstitle"));
        this.setResizable(false);
        this.setLocation(x, y);
        this.pack();
    }

    public void setAttributes(PrintRequestAttributeSet attributes) {
        this.asOriginal = attributes;
        this.asCurrent = new HashPrintRequestAttributeSet(attributes);
        this.updateMarginPanel();
        this.updatePanels();
    }

    private void updateMarginPanel() {
        this.pnlPageSetup.updateMarginPanel();
    }

    public int getStatus() {
        return this.status;
    }

    public PrintRequestAttributeSet getAttributes() {
        if (this.status == 1) {
            return this.asCurrent;
        }
        return this.asOriginal;
    }

    public PrintService getPrintService() {
        if (this.status == 1) {
            return this.psCurrent;
        }
        return null;
    }

    public void dispose(int status) {
        this.status = status;
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        boolean approved = false;
        if (source == this.btnApprove) {
            approved = true;
            if (this.pnlGeneral != null) {
                if (this.pnlGeneral.isPrintToFileSelected()) {
                    approved = this.showFileChooser();
                } else {
                    this.asCurrent.remove(Destination.class);
                }
            }
        }
        this.dispose(approved ? 1 : 2);
    }

    private boolean showFileChooser() {
        File fileDest;
        Class<Destination> dstCategory = Destination.class;
        Destination dst = (Destination)this.asCurrent.get(dstCategory);
        if (dst == null && (dst = (Destination)this.psCurrent.getDefaultAttributeValue(dstCategory)) == null) {
            dst = new Destination(new File("out.prn").toURI());
        }
        try {
            fileDest = new File(dst.getURI());
        }
        catch (Exception e) {
            fileDest = new File("out.prn");
        }
        ValidatingFileChooser jfc = new ValidatingFileChooser();
        jfc.setApproveButtonText(PrintConfigDialog.getMsg("button.ok"));
        jfc.setApproveButtonMnemonic(PrintConfigDialog.getMnemonic("button.ok"));
        jfc.setDialogTitle(PrintConfigDialog.getMsg("dialog.printtofile"));
        jfc.setSelectedFile(fileDest);
        int returnVal = jfc.showDialog((Component)((Object)this), null);
        if (returnVal == 0) {
            fileDest = jfc.getSelectedFile();
            try {
                this.asCurrent.add(new Destination(fileDest.toURI()));
            }
            catch (Exception e) {
                this.asCurrent.remove(dstCategory);
            }
        } else {
            this.asCurrent.remove(dstCategory);
        }
        return returnVal == 0;
    }

    private void updatePanels() {
        this.pnlGeneral.updateInfo();
        this.pnlPageSetup.updateInfo();
        this.pnlAppearance.updateInfo();
    }

    private static void initResource() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    messageRB = ResourceBundle.getBundle(PrintConfigDialog.strBundle);
                    return null;
                }
                catch (MissingResourceException e) {
                    throw new Error("Fatal: Resource for ServiceUI is missing", e);
                }
            }
        });
    }

    private static String getMsg(String key) {
        try {
            return messageRB.getString(key);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + key + " key in resource", e);
        }
    }

    private static char getMnemonic(String key) {
        String str = PrintConfigDialog.getMsg(key + ".mnemonic");
        if (str != null && str.length() > 0) {
            return str.charAt(0);
        }
        return '\u0000';
    }

    private static int getVKMnemonic(String key) {
        String str = PrintConfigDialog.getMsg(key + ".vkMnemonic");
        if (str != null && str.length() > 0) {
            try {
                return Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    private static URL getImageResource(String key) {
        URL url = PrintConfigDialog.class.getResource("resources/" + key);
        if (url == null) {
            throw new Error("Fatal: Resource for ServiceUI is broken; there is no " + key + " key in resource");
        }
        return url;
    }

    private static KDButton createButton(String key, ActionListener al) {
        KDButton btn = new KDButton(PrintConfigDialog.getMsg(key));
        btn.setMnemonic(PrintConfigDialog.getMnemonic(key));
        btn.addActionListener(al);
        return btn;
    }

    private static KDCheckBox createCheckBox(String key, ActionListener al) {
        KDCheckBox cb = new KDCheckBox(PrintConfigDialog.getMsg(key));
        cb.setMnemonic(PrintConfigDialog.getMnemonic(key));
        cb.addActionListener(al);
        return cb;
    }

    private static KDRadioButton createRadioButton(String key, ActionListener al) {
        KDRadioButton rb = new KDRadioButton(PrintConfigDialog.getMsg(key));
        rb.setMnemonic(PrintConfigDialog.getMnemonic(key));
        rb.addActionListener(al);
        return rb;
    }

    public static void showNoPrintService(GraphicsConfiguration gc) {
        JOptionPane.showMessageDialog(new Frame(gc), PrintConfigDialog.getMsg("dialog.noprintermsg"));
    }

    private static void addToBG(AbstractButton button, Container cont, ButtonGroup bg) {
        bg.add(button);
        cont.add(button);
    }

    public KDTabbedPane getTabbedPane() {
        return this.tpTabs;
    }

    private int max(int i, int j, int k) {
        if (i > j) {
            return i > k ? i : k;
        }
        return j > k ? j : k;
    }

    private LinedLabel L(String t, JComponent c) {
        return new LinedLabel(t, c);
    }

    static {
        PrintConfigDialog.initResource();
    }

    private static class FixedPanel
    extends KDPanel {
        private static final long serialVersionUID = -60827111424001393L;

        public FixedPanel() {
            this.setOpaque(false);
            this.setLayout(new FlowLayout(0, 3, 0));
        }
    }

    protected static class LineLayout
    implements LayoutManager {
        private static final int INSET_ADJUST = 4;
        public static final LineLayout LIGHTWEIGHT = new LineLayout();

        protected LineLayout() {
        }

        @Override
        public void layoutContainer(Container p) {
            JComponent child;
            JComponent parent = (JComponent)p;
            Insets insets = parent.getInsets();
            int temp = 0;
            int count = parent.getComponentCount();
            int w = parent.getWidth() - 20 - insets.left - insets.right + 4;
            int h = parent.getHeight() - 20 - insets.top - insets.bottom + 4;
            int y = insets.top - 4 + 10;
            for (int i = 0; i < count; ++i) {
                child = (JComponent)parent.getComponent(i);
                temp += child.getPreferredSize().height;
            }
            int space = 0;
            if (count <= 0) {
                return;
            }
            if (count == 1) {
                space = h - temp;
                y += space / 2;
            } else {
                space = (h - temp) / (count - 1);
                if (space > 3) {
                    space = (h - temp) / count;
                    y += space / 2;
                }
            }
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    y += space;
                }
                child = (JComponent)parent.getComponent(i);
                temp = child.getPreferredSize().height;
                child.setBounds(10 + insets.left - 2, y, w, temp);
                y += temp;
            }
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int count = parent.getComponentCount();
            Insets insets = parent.getInsets();
            int h = insets.top + insets.bottom - 4;
            int w = 0;
            for (int i = 0; i < count; ++i) {
                if (i > 0) {
                    h += 3;
                }
                Dimension psize = parent.getComponent(i).getPreferredSize();
                h += psize.height;
                w = w < psize.width ? psize.width : w;
            }
            return new Dimension(w += 20, h += 20);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static class LinedLabel
    extends KDLabelContainer {
        private static final long serialVersionUID = 6544694141430229423L;

        private LinedLabel(String labelText, JComponent editor) {
            super(LinedLabel.Normalize(labelText, editor), editor);
            if (!(editor instanceof JLabel)) {
                this.setBoundLabelUnderline(true);
            }
        }

        private static String Normalize(String realtext, JComponent editor) {
            if (!(editor instanceof JLabel)) {
                return realtext.replace('\uff1a', ' ') + "  ";
            }
            return realtext.replace('\uff1a', ':') + "  ";
        }
    }

    private static class ValidatingFileChooser
    extends KDFileChooser {
        private static final long serialVersionUID = -946747932873320420L;

        private ValidatingFileChooser() {
        }

        public void approveSelection() {
            boolean exists;
            File selected = this.getSelectedFile();
            try {
                exists = selected.exists();
            }
            catch (SecurityException e) {
                exists = false;
            }
            if (exists) {
                int val = JOptionPane.showConfirmDialog(null, PrintConfigDialog.getMsg("dialog.overwrite"), PrintConfigDialog.getMsg("dialog.owtitle"), 0);
                if (val == 0) {
                    super.approveSelection();
                }
            } else {
                super.approveSelection();
            }
        }
    }

    private static class IconRadioButton
    extends JPanel {
        private static final long serialVersionUID = 6497386061206531964L;
        private KDRadioButton rb;
        private JLabel lbl;

        public IconRadioButton(String key, String img, boolean selected, ButtonGroup bg, ActionListener al) {
            super(new FlowLayout(3));
            this.setOpaque(false);
            ImageIcon icon = new ImageIcon(PrintConfigDialog.getImageResource(img));
            this.lbl = new JLabel(icon);
            this.add(this.lbl);
            this.rb = PrintConfigDialog.createRadioButton(key, al);
            this.rb.setSelected(selected);
            PrintConfigDialog.addToBG((AbstractButton)this.rb, this, bg);
        }

        public void addActionListener(ActionListener al) {
            this.rb.addActionListener(al);
        }

        public boolean isSameAs(Object source) {
            return this.rb == source;
        }

        @Override
        public void setEnabled(boolean enabled) {
            this.rb.setEnabled(enabled);
            this.lbl.setEnabled(enabled);
        }

        public boolean isSelected() {
            return this.rb.isSelected();
        }

        public void setSelected(boolean selected) {
            this.rb.setSelected(selected);
        }
    }

    private class JobAttributesPanel
    extends KDPanel
    implements ActionListener,
    ChangeListener,
    FocusListener {
        private static final long serialVersionUID = 7458019887582332821L;
        private JLabel lblPriority;
        private JLabel lblJobName;
        private JLabel lblUserName;
        private KDSpinner spinPriority;
        private SpinnerNumberModel snModel;
        private KDCheckBox cbJobSheets;
        private KDTextField tfJobName;
        private KDTextField tfUserName;

        public JobAttributesPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(PrintConfigDialog.getMsg("border.jobattributes")));
            this.cbJobSheets = PrintConfigDialog.createCheckBox("checkbox.jobsheets", this);
            this.snModel = new SpinnerNumberModel(1, 1, 100, 1);
            this.spinPriority = new KDSpinner((SpinnerModel)this.snModel);
            ((JSpinner.NumberEditor)this.spinPriority.getEditor()).getTextField().setColumns(3);
            this.spinPriority.addChangeListener((ChangeListener)this);
            String str = PrintConfigDialog.getMsg("label.priority");
            LinedLabel ll = PrintConfigDialog.this.L(str, (JComponent)this.spinPriority);
            this.lblPriority = ll.getBoundLabel();
            this.add((Component)((Object)ll));
            char jmnemonic = PrintConfigDialog.getMnemonic("label.jobname");
            this.tfJobName = new KDTextField();
            this.tfJobName.addFocusListener((FocusListener)this);
            this.tfJobName.setFocusAccelerator(jmnemonic);
            str = PrintConfigDialog.getMsg("label.jobname");
            ll = PrintConfigDialog.this.L(str, (JComponent)this.tfJobName);
            this.lblJobName = ll.getBoundLabel();
            this.add((Component)((Object)ll));
            char umnemonic = PrintConfigDialog.getMnemonic("label.username");
            this.tfUserName = new KDTextField();
            this.tfUserName.addFocusListener((FocusListener)this);
            this.tfUserName.setFocusAccelerator(umnemonic);
            str = PrintConfigDialog.getMsg("label.username");
            ll = PrintConfigDialog.this.L(str, (JComponent)this.tfUserName);
            this.lblUserName = ll.getBoundLabel();
            this.add((Component)((Object)ll));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.cbJobSheets.isSelected()) {
                PrintConfigDialog.this.asCurrent.add(JobSheets.STANDARD);
            } else {
                PrintConfigDialog.this.asCurrent.add(JobSheets.NONE);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            PrintConfigDialog.this.asCurrent.add(new JobPriority(this.snModel.getNumber().intValue()));
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.tfJobName) {
                PrintConfigDialog.this.asCurrent.add(new JobName(this.tfJobName.getText(), Locale.getDefault()));
            } else if (source == this.tfUserName) {
                PrintConfigDialog.this.asCurrent.add(new RequestingUserName(this.tfUserName.getText(), Locale.getDefault()));
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        public void updateInfo() {
            RequestingUserName un;
            JobName jn;
            int value;
            JobPriority jp;
            JobSheets js;
            Class<JobSheets> jsCategory = JobSheets.class;
            Class<JobPriority> jpCategory = JobPriority.class;
            Class<JobName> jnCategory = JobName.class;
            Class<RequestingUserName> unCategory = RequestingUserName.class;
            boolean jsSupported = false;
            boolean jpSupported = false;
            boolean jnSupported = false;
            boolean unSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(jsCategory)) {
                jsSupported = true;
            }
            if ((js = (JobSheets)PrintConfigDialog.this.asCurrent.get(jsCategory)) == null && (js = (JobSheets)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(jsCategory)) == null) {
                js = JobSheets.NONE;
            }
            this.cbJobSheets.setSelected(js != JobSheets.NONE);
            this.cbJobSheets.setEnabled(jsSupported);
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(jpCategory)) {
                jpSupported = true;
            }
            if ((jp = (JobPriority)PrintConfigDialog.this.asCurrent.get(jpCategory)) == null && (jp = (JobPriority)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(jpCategory)) == null) {
                jp = new JobPriority(1);
            }
            if ((value = jp.getValue()) < 1 || value > 100) {
                value = 1;
            }
            this.snModel.setValue(value);
            this.lblPriority.setEnabled(jpSupported);
            this.spinPriority.setEnabled(jpSupported);
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(jnCategory)) {
                jnSupported = true;
            }
            if ((jn = (JobName)PrintConfigDialog.this.asCurrent.get(jnCategory)) == null) {
                jn = new JobName("Kingdee EAS Printing", Locale.getDefault());
                PrintConfigDialog.this.asCurrent.add(jn);
            }
            this.tfJobName.setText(jn.getValue());
            this.tfJobName.setEnabled(jnSupported);
            this.lblJobName.setEnabled(jnSupported);
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(unCategory)) {
                unSupported = true;
            }
            if ((un = (RequestingUserName)PrintConfigDialog.this.asCurrent.get(unCategory)) == null && (un = (RequestingUserName)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(unCategory)) == null) {
                un = new RequestingUserName("", Locale.getDefault());
            }
            this.tfUserName.setText(un.getValue());
            this.tfUserName.setEnabled(unSupported);
            this.lblUserName.setEnabled(unSupported);
        }
    }

    private class SidesPanel
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = 3819053234835693889L;
        private IconRadioButton rbOneSide;
        private IconRadioButton rbTumble;
        private IconRadioButton rbDuplex;

        public SidesPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(PrintConfigDialog.getMsg("border.sides")));
            ButtonGroup bg = new ButtonGroup();
            this.rbOneSide = new IconRadioButton("radiobutton.oneside", "oneside.gif", true, bg, this);
            this.rbOneSide.addActionListener(this);
            this.add(this.rbOneSide);
            this.rbTumble = new IconRadioButton("radiobutton.tumble", "tumble.gif", false, bg, this);
            this.rbTumble.addActionListener(this);
            this.add(this.rbTumble);
            this.rbDuplex = new IconRadioButton("radiobutton.duplex", "duplex.gif", false, bg, this);
            this.rbDuplex.addActionListener(this);
            this.add(this.rbDuplex);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.rbOneSide.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(Sides.ONE_SIDED);
            } else if (this.rbTumble.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(Sides.TUMBLE);
            } else if (this.rbDuplex.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(Sides.DUPLEX);
            }
        }

        public void updateInfo() {
            Object values;
            Class<Sides> sdCategory = Sides.class;
            boolean osSupported = false;
            boolean tSupported = false;
            boolean dSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(sdCategory) && (values = PrintConfigDialog.this.psCurrent.getSupportedAttributeValues(sdCategory, PrintConfigDialog.this.docFlavor, PrintConfigDialog.this.asCurrent)) instanceof Sides[]) {
                Sides[] svalues = (Sides[])values;
                for (int i = 0; i < svalues.length; ++i) {
                    Sides value = svalues[i];
                    if (value == Sides.ONE_SIDED) {
                        osSupported = true;
                        continue;
                    }
                    if (value == Sides.TUMBLE) {
                        tSupported = true;
                        continue;
                    }
                    if (value != Sides.DUPLEX) continue;
                    dSupported = true;
                }
            }
            this.rbOneSide.setEnabled(osSupported);
            this.rbTumble.setEnabled(tSupported);
            this.rbDuplex.setEnabled(dSupported);
            Sides sd = (Sides)PrintConfigDialog.this.asCurrent.get(sdCategory);
            if (sd == null && (sd = (Sides)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(sdCategory)) == null) {
                sd = Sides.ONE_SIDED;
            }
            if (sd == Sides.ONE_SIDED) {
                this.rbOneSide.setSelected(true);
            } else if (sd == Sides.TUMBLE) {
                this.rbTumble.setSelected(true);
            } else {
                this.rbDuplex.setSelected(true);
            }
        }
    }

    private class QualityPanel
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = 8736658243992103866L;
        private KDRadioButton rbDraft;
        private KDRadioButton rbNormal;
        private KDRadioButton rbHigh;

        public QualityPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(PrintConfigDialog.getMsg("border.quality")));
            ButtonGroup bg = new ButtonGroup();
            this.rbDraft = PrintConfigDialog.createRadioButton("radiobutton.draftq", this);
            bg.add((AbstractButton)this.rbDraft);
            this.add((Component)this.rbDraft);
            this.rbNormal = PrintConfigDialog.createRadioButton("radiobutton.normalq", this);
            this.rbNormal.setSelected(true);
            bg.add((AbstractButton)this.rbNormal);
            this.add((Component)this.rbNormal);
            this.rbHigh = PrintConfigDialog.createRadioButton("radiobutton.highq", this);
            bg.add((AbstractButton)this.rbHigh);
            this.add((Component)this.rbHigh);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.rbDraft) {
                PrintConfigDialog.this.asCurrent.add(PrintQuality.DRAFT);
            } else if (source == this.rbNormal) {
                PrintConfigDialog.this.asCurrent.add(PrintQuality.NORMAL);
            } else if (source == this.rbHigh) {
                PrintConfigDialog.this.asCurrent.add(PrintQuality.HIGH);
            }
        }

        public void updateInfo() {
            Object values;
            Class<PrintQuality> pqCategory = PrintQuality.class;
            boolean draftSupported = false;
            boolean normalSupported = false;
            boolean highSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(pqCategory) && (values = PrintConfigDialog.this.psCurrent.getSupportedAttributeValues(pqCategory, PrintConfigDialog.this.docFlavor, PrintConfigDialog.this.asCurrent)) instanceof PrintQuality[]) {
                PrintQuality[] qvalues = (PrintQuality[])values;
                for (int i = 0; i < qvalues.length; ++i) {
                    PrintQuality value = qvalues[i];
                    if (value == PrintQuality.DRAFT) {
                        draftSupported = true;
                        continue;
                    }
                    if (value == PrintQuality.NORMAL) {
                        normalSupported = true;
                        continue;
                    }
                    if (value != PrintQuality.HIGH) continue;
                    highSupported = true;
                }
            }
            this.rbDraft.setEnabled(draftSupported);
            this.rbNormal.setEnabled(normalSupported);
            this.rbHigh.setEnabled(highSupported);
            PrintQuality pq = (PrintQuality)PrintConfigDialog.this.asCurrent.get(pqCategory);
            if (pq == null && (pq = (PrintQuality)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(pqCategory)) == null) {
                pq = PrintQuality.NORMAL;
            }
            if (pq == PrintQuality.DRAFT) {
                this.rbDraft.setSelected(true);
            } else if (pq == PrintQuality.NORMAL) {
                this.rbNormal.setSelected(true);
            } else {
                this.rbHigh.setSelected(true);
            }
        }
    }

    private class ChromaticityPanel
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = 5101746062830478093L;
        private KDRadioButton rbMonochrome;
        private KDRadioButton rbColor;

        public ChromaticityPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(PrintConfigDialog.getMsg("border.chromaticity")));
            ButtonGroup bg = new ButtonGroup();
            this.rbMonochrome = PrintConfigDialog.createRadioButton("radiobutton.monochrome", this);
            this.rbMonochrome.setSelected(true);
            bg.add((AbstractButton)this.rbMonochrome);
            this.add((Component)this.rbMonochrome);
            this.rbColor = PrintConfigDialog.createRadioButton("radiobutton.color", this);
            bg.add((AbstractButton)this.rbColor);
            this.add((Component)this.rbColor);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.rbMonochrome) {
                PrintConfigDialog.this.asCurrent.add(Chromaticity.MONOCHROME);
            } else if (source == this.rbColor) {
                PrintConfigDialog.this.asCurrent.add(Chromaticity.COLOR);
            }
        }

        public void updateInfo() {
            Object values;
            Class<Chromaticity> chCategory = Chromaticity.class;
            boolean monoSupported = false;
            boolean colorSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(chCategory) && (values = PrintConfigDialog.this.psCurrent.getSupportedAttributeValues(chCategory, PrintConfigDialog.this.docFlavor, PrintConfigDialog.this.asCurrent)) instanceof Chromaticity[]) {
                Chromaticity[] cvalues = (Chromaticity[])values;
                for (int i = 0; i < cvalues.length; ++i) {
                    Chromaticity value = cvalues[i];
                    if (value == Chromaticity.MONOCHROME) {
                        monoSupported = true;
                        continue;
                    }
                    if (value != Chromaticity.COLOR) continue;
                    colorSupported = true;
                }
            }
            this.rbMonochrome.setEnabled(monoSupported);
            this.rbColor.setEnabled(colorSupported);
            Chromaticity ch = (Chromaticity)PrintConfigDialog.this.asCurrent.get(chCategory);
            if (ch == null && (ch = (Chromaticity)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(chCategory)) == null) {
                ch = Chromaticity.MONOCHROME;
            }
            if (ch == Chromaticity.MONOCHROME) {
                this.rbMonochrome.setSelected(true);
            } else {
                this.rbColor.setSelected(true);
            }
        }
    }

    private class AppearancePanel
    extends KDPanel {
        private static final long serialVersionUID = 8345914709854873545L;
        private ChromaticityPanel pnlChromaticity;
        private QualityPanel pnlQuality;
        private JobAttributesPanel pnlJobAttributes;
        private SidesPanel pnlSides;

        public AppearancePanel() {
            this.setLayout(null);
            this.pnlChromaticity = new ChromaticityPanel();
            this.add((Component)((Object)this.pnlChromaticity));
            this.pnlQuality = new QualityPanel();
            this.add((Component)((Object)this.pnlQuality));
            this.pnlSides = new SidesPanel();
            this.add((Component)((Object)this.pnlSides));
            this.pnlJobAttributes = new JobAttributesPanel();
            this.add((Component)((Object)this.pnlJobAttributes));
            int x = 10;
            int y = 10;
            int w = 182;
            Dimension bound = this.pnlQuality.getPreferredSize();
            this.pnlChromaticity.setBounds(x, y, w, bound.height);
            this.pnlQuality.setBounds(x + w + 10, y, 423 - w - 30, bound.height);
            y = y + bound.height + 10;
            bound = this.pnlSides.getPreferredSize();
            this.pnlSides.setBounds(x, y, w, bound.height);
            this.pnlJobAttributes.setBounds(x + w + 10, y, 423 - w - 30, bound.height);
            int h = y + bound.height + 10;
            bound.setSize(423, h);
            this.setPreferredSize(bound);
        }

        public void updateInfo() {
            this.pnlChromaticity.updateInfo();
            this.pnlQuality.updateInfo();
            this.pnlSides.updateInfo();
            this.pnlJobAttributes.updateInfo();
        }
    }

    private class OrientationPanel
    extends KDPanel
    implements ActionListener {
        private static final long serialVersionUID = -7255224670769029643L;
        private IconRadioButton rbPortrait;
        private IconRadioButton rbLandscape;
        private IconRadioButton rbRevPortrait;
        private IconRadioButton rbRevLandscape;
        private MarginsPanel pnlMargins = null;

        public OrientationPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(PrintConfigDialog.getMsg("border.orientation")));
            ButtonGroup bg = new ButtonGroup();
            this.rbPortrait = new IconRadioButton("radiobutton.portrait", "orientPortrait.gif", true, bg, this);
            this.rbPortrait.addActionListener(this);
            this.add(this.rbPortrait);
            this.rbLandscape = new IconRadioButton("radiobutton.landscape", "orientLandscape.gif", false, bg, this);
            this.rbLandscape.addActionListener(this);
            this.add(this.rbLandscape);
            this.rbRevPortrait = new IconRadioButton("radiobutton.revportrait", "orientRevPortrait.gif", false, bg, this);
            this.rbRevPortrait.addActionListener(this);
            this.add(this.rbRevPortrait);
            this.rbRevLandscape = new IconRadioButton("radiobutton.revlandscape", "orientRevLandscape.gif", false, bg, this);
            this.rbRevLandscape.addActionListener(this);
            this.add(this.rbRevLandscape);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (this.rbPortrait.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(OrientationRequested.PORTRAIT);
            } else if (this.rbLandscape.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(OrientationRequested.LANDSCAPE);
            } else if (this.rbRevPortrait.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(OrientationRequested.REVERSE_PORTRAIT);
            } else if (this.rbRevLandscape.isSameAs(source)) {
                PrintConfigDialog.this.asCurrent.add(OrientationRequested.REVERSE_LANDSCAPE);
            }
            if (this.pnlMargins != null) {
                // empty if block
            }
        }

        void addOrientationListener(MarginsPanel pnl) {
            this.pnlMargins = pnl;
        }

        public void updateInfo() {
            Object values;
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            boolean pSupported = false;
            boolean lSupported = false;
            boolean rpSupported = false;
            boolean rlSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(orCategory) && (values = PrintConfigDialog.this.psCurrent.getSupportedAttributeValues(orCategory, PrintConfigDialog.this.docFlavor, PrintConfigDialog.this.asCurrent)) instanceof OrientationRequested[]) {
                OrientationRequested[] ovalues = (OrientationRequested[])values;
                for (int i = 0; i < ovalues.length; ++i) {
                    OrientationRequested value = ovalues[i];
                    if (value == OrientationRequested.PORTRAIT) {
                        pSupported = true;
                        continue;
                    }
                    if (value == OrientationRequested.LANDSCAPE) {
                        lSupported = true;
                        continue;
                    }
                    if (value == OrientationRequested.REVERSE_PORTRAIT) {
                        rpSupported = true;
                        continue;
                    }
                    if (value != OrientationRequested.REVERSE_LANDSCAPE) continue;
                    rlSupported = true;
                }
            }
            this.rbPortrait.setEnabled(pSupported);
            this.rbLandscape.setEnabled(lSupported);
            this.rbRevPortrait.setEnabled(rpSupported);
            this.rbRevLandscape.setEnabled(rlSupported);
            OrientationRequested or = (OrientationRequested)PrintConfigDialog.this.asCurrent.get(orCategory);
            if (or == null && (or = (OrientationRequested)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(orCategory)) == null) {
                or = OrientationRequested.PORTRAIT;
            }
            if (or == OrientationRequested.PORTRAIT) {
                this.rbPortrait.setSelected(true);
            } else if (or == OrientationRequested.LANDSCAPE) {
                this.rbLandscape.setSelected(true);
            } else if (or == OrientationRequested.REVERSE_PORTRAIT) {
                this.rbRevPortrait.setSelected(true);
            } else {
                this.rbRevLandscape.setSelected(true);
            }
        }
    }

    private class MediaPanel
    extends KDPanel
    implements ItemListener {
        private static final long serialVersionUID = -8230691748164811485L;
        private final String strTitle = PrintConfigDialog.access$200("border.media");
        private JLabel lblSize;
        private KDComboBox cbSize;
        private KDComboBox cbSource;
        private Vector sizes = new Vector();
        private Vector sources = new Vector();
        private MarginsPanel pnlMargins = null;

        public MediaPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            this.cbSize = new KDComboBox();
            this.cbSource = new KDComboBox();
            String str = PrintConfigDialog.getMsg("label.size");
            LinedLabel ll = PrintConfigDialog.this.L(str, (JComponent)this.cbSize);
            this.lblSize = ll.getBoundLabel();
            this.add((Component)((Object)ll));
            str = PrintConfigDialog.getMsg("label.source");
            ll = PrintConfigDialog.this.L(str, (JComponent)this.cbSource);
            this.add((Component)((Object)ll));
        }

        private String getMediaName(String key) {
            try {
                String newkey = key.replace(' ', '-');
                newkey = newkey.replace('#', 'n');
                return messageRB.getString(newkey);
            }
            catch (MissingResourceException e) {
                return key;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (e.getStateChange() == 1) {
                if (source == this.cbSize) {
                    int index = this.cbSize.getSelectedIndex();
                    if (index >= 0 && index < this.sizes.size()) {
                        if (this.cbSource.getItemCount() > 1 && this.cbSource.getSelectedIndex() >= 1) {
                            int src = this.cbSource.getSelectedIndex() - 1;
                            MediaTray mt = (MediaTray)this.sources.get(src);
                            PrintConfigDialog.this.asCurrent.add(new SunAlternateMedia(mt));
                        }
                        PrintConfigDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(index));
                    }
                } else if (source == this.cbSource) {
                    int index = this.cbSource.getSelectedIndex();
                    if (index >= 1 && index < this.sources.size() + 1) {
                        PrintConfigDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        MediaTray mt = (MediaTray)this.sources.get(index - 1);
                        PrintConfigDialog.this.asCurrent.add(new SunAlternateMedia(mt));
                    } else if (index == 0) {
                        PrintConfigDialog.this.asCurrent.remove(SunAlternateMedia.class);
                        if (this.cbSize.getItemCount() > 0) {
                            int size = this.cbSize.getSelectedIndex();
                            PrintConfigDialog.this.asCurrent.add((MediaSizeName)this.sizes.get(size));
                        }
                    }
                }
                if (this.pnlMargins != null) {
                    this.pnlMargins.updateInfo();
                }
            }
        }

        public void addMediaListener(MarginsPanel pnl) {
            this.pnlMargins = pnl;
        }

        public void updateInfo() {
            Class<Media> mdCategory = Media.class;
            Class<SunAlternateMedia> amCategory = SunAlternateMedia.class;
            boolean mediaSupported = false;
            this.cbSize.removeItemListener((ItemListener)this);
            this.cbSize.removeAllItems();
            this.cbSource.removeItemListener((ItemListener)this);
            this.cbSource.removeAllItems();
            this.cbSource.addItem((Object)this.getMediaName("auto-select"));
            this.sizes.clear();
            this.sources.clear();
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(mdCategory)) {
                mediaSupported = true;
                Object values = MediaUtil.getMediaByPrinter((PrintService)PrintConfigDialog.this.psCurrent, (DocFlavor)PrintConfigDialog.this.docFlavor, (HashPrintRequestAttributeSet)PrintConfigDialog.this.asCurrent);
                if (values instanceof Media[]) {
                    Media[] media = (Media[])values;
                    for (int i = 0; i < media.length; ++i) {
                        Media medium = media[i];
                        if (medium instanceof MediaSizeName) {
                            this.sizes.add(medium);
                            this.cbSize.addItem((Object)this.getMediaName(medium.toString()));
                            continue;
                        }
                        if (!(medium instanceof MediaTray)) continue;
                        this.sources.add(medium);
                        this.cbSource.addItem((Object)this.getMediaName(medium.toString()));
                    }
                }
            }
            boolean msSupported = mediaSupported && this.sizes.size() > 0;
            this.lblSize.setEnabled(msSupported);
            this.cbSize.setEnabled(msSupported);
            this.cbSource.setEnabled(mediaSupported);
            if (mediaSupported) {
                Media md;
                Media medium = (Media)PrintConfigDialog.this.asCurrent.get(mdCategory);
                if (medium == null && (medium = (Media)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(mdCategory)) == null && this.sizes.size() > 0) {
                    medium = (Media)this.sizes.get(0);
                }
                if (medium != null) {
                    if (medium instanceof MediaSizeName) {
                        MediaSizeName ms = (MediaSizeName)medium;
                        this.cbSize.setSelectedIndex(this.sizes.indexOf(ms));
                    } else if (medium instanceof MediaTray) {
                        MediaTray mt = (MediaTray)medium;
                        this.cbSource.setSelectedIndex(this.sources.indexOf(mt) + 1);
                    }
                } else {
                    this.cbSize.setSelectedIndex(this.sizes.size() > 0 ? 0 : -1);
                    this.cbSource.setSelectedIndex(0);
                }
                SunAlternateMedia alt = (SunAlternateMedia)PrintConfigDialog.this.asCurrent.get(amCategory);
                if (alt != null && (md = alt.getMedia()) instanceof MediaTray) {
                    MediaTray mt = (MediaTray)md;
                    this.cbSource.setSelectedIndex(this.sources.indexOf(mt) + 1);
                }
            }
            this.cbSize.addItemListener((ItemListener)this);
            this.cbSource.addItemListener((ItemListener)this);
        }
    }

    private class ScalePanel
    extends KDPanel
    implements ChangeListener {
        private static final long serialVersionUID = 3872980587943011884L;
        private KDSpinner spnScale;

        private final String getSrcTitle() {
            return CtrlKDFMessages.getMLS("zoom", "\u7f29\u653e");
        }

        public ScalePanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.getSrcTitle()));
            String str = CtrlKDFMessages.getMLS("zoomScale", "\u7f29\u653e\u6bd4\u4f8b(%)");
            Integer value = 100;
            Integer min = 10;
            Integer max = 400;
            Integer step = 5;
            SpinnerNumberModel model = new SpinnerNumberModel(value, min, max, step);
            this.spnScale = new KDSpinner((SpinnerModel)model);
            LinedLabel ll = PrintConfigDialog.this.L(str, (JComponent)this.spnScale);
            this.add((Component)((Object)ll));
            this.spnScale.addChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateScale();
        }

        public void updateScale() {
            Integer i = (Integer)this.spnScale.getValue();
            if (i != null) {
                float f = (float)i.intValue() / 100.0f;
                PrintConfigDialog.this.asCurrent.add(new ScaleFactor(f));
            }
        }

        public void updateInfo() {
            Integer newValue;
            Integer oldValue;
            Class<ScaleFactor> c = ScaleFactor.class;
            ScaleFactor factor = (ScaleFactor)PrintConfigDialog.this.asCurrent.get(c);
            float f = 1.0f;
            if (factor != null) {
                f = factor.getFactor();
            }
            if (!(oldValue = (Integer)this.spnScale.getValue()).equals(newValue = Integer.valueOf(Math.round(f * 100.0f)))) {
                this.spnScale.removeChangeListener((ChangeListener)this);
                this.spnScale.setValue((Object)newValue);
                this.spnScale.addChangeListener((ChangeListener)this);
            }
        }
    }

    private class MarginsPanel
    extends KDPanel
    implements ActionListener,
    FocusListener {
        private static final long serialVersionUID = 2718308088400507133L;
        private final String strTitle = PrintConfigDialog.access$200("border.margins");
        private KDFormattedTextField leftMargin;
        private KDFormattedTextField rightMargin;
        private KDFormattedTextField topMargin;
        private KDFormattedTextField bottomMargin;
        private int units = 1000;
        private float lmVal = -1.0f;
        private float rmVal = -1.0f;
        private float tmVal = -1.0f;
        private float bmVal = -1.0f;
        private Float lmObj;
        private Float rmObj;
        private Float tmObj;
        private Float bmObj;

        public void clearMargins() {
            this.lmVal = -1.0f;
            this.rmVal = -1.0f;
            this.tmVal = -1.0f;
            this.bmVal = -1.0f;
        }

        public MarginsPanel() {
            DecimalFormat format;
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            String unitsKey = "label.millimetres";
            String defaultCountry = Locale.getDefault().getCountry();
            if (defaultCountry != null && (defaultCountry.equals("") || defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
                unitsKey = "label.inches";
                this.units = 25400;
            }
            String unitsMsg = PrintConfigDialog.getMsg(unitsKey);
            if (this.units == 1000) {
                format = new DecimalFormat("###.##");
                format.setMaximumIntegerDigits(3);
            } else {
                format = new DecimalFormat("##.##");
                format.setMaximumIntegerDigits(2);
            }
            format.setMinimumFractionDigits(1);
            format.setMaximumFractionDigits(2);
            format.setMinimumIntegerDigits(1);
            format.setParseIntegerOnly(false);
            format.setDecimalSeparatorAlwaysShown(true);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(new Float(0.0f));
            nf.setMaximum(new Float(999.0f));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.leftMargin = new KDFormattedTextField();
            this.leftMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.leftMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.leftMargin.addFocusListener((FocusListener)this);
            this.leftMargin.addActionListener((ActionListener)this);
            this.rightMargin = new KDFormattedTextField();
            this.rightMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.rightMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.rightMargin.addFocusListener((FocusListener)this);
            this.rightMargin.addActionListener((ActionListener)this);
            this.topMargin = new KDFormattedTextField();
            this.topMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.topMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.topMargin.addFocusListener((FocusListener)this);
            this.topMargin.addActionListener((ActionListener)this);
            this.bottomMargin = new KDFormattedTextField();
            this.bottomMargin.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.bottomMargin.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.bottomMargin.addFocusListener((FocusListener)this);
            this.bottomMargin.addActionListener((ActionListener)this);
            String str = PrintConfigDialog.getMsg("label.leftmargin");
            str = this.addUnit(str, unitsMsg);
            LinedLabel ll = PrintConfigDialog.this.L(str, (JComponent)this.leftMargin);
            this.add((Component)((Object)ll));
            str = PrintConfigDialog.getMsg("label.rightmargin");
            str = this.addUnit(str, unitsMsg);
            ll = PrintConfigDialog.this.L(str, (JComponent)this.rightMargin);
            this.add((Component)((Object)ll));
            str = PrintConfigDialog.getMsg("label.topmargin");
            str = this.addUnit(str, unitsMsg);
            ll = PrintConfigDialog.this.L(str, (JComponent)this.topMargin);
            this.add((Component)((Object)ll));
            str = PrintConfigDialog.getMsg("label.bottommargin");
            str = this.addUnit(str, unitsMsg);
            ll = PrintConfigDialog.this.L(str, (JComponent)this.bottomMargin);
            this.add((Component)((Object)ll));
        }

        String addUnit(String str, String unitsMsg) {
            if (str != null) {
                str = str + unitsMsg;
            }
            return str;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            this.updateMargins(source);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        public void updateMargins(Object source) {
            MediaPrintableArea mpa;
            if (!(source instanceof KDFormattedTextField)) {
                return;
            }
            KDFormattedTextField tf = (KDFormattedTextField)source;
            Float val = (Float)tf.getValue(Float.class);
            if (val == null) {
                return;
            }
            if (tf == this.leftMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            if (tf == this.rightMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            if (tf == this.topMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            if (tf == this.bottomMargin && ArrayUtil.isEqual((Float)val, (Float)this.lmObj)) {
                return;
            }
            Float lmTmpObj = (Float)this.leftMargin.getValue(Float.class);
            Float rmTmpObj = (Float)this.rightMargin.getValue(Float.class);
            Float tmTmpObj = (Float)this.topMargin.getValue(Float.class);
            Float bmTmpObj = (Float)this.bottomMargin.getValue(Float.class);
            float lm = lmTmpObj.floatValue();
            float rm = rmTmpObj.floatValue();
            float tm = tmTmpObj.floatValue();
            float bm = bmTmpObj.floatValue();
            Class<OrientationRequested> orCategory = OrientationRequested.class;
            OrientationRequested or = (OrientationRequested)PrintConfigDialog.this.asCurrent.get(orCategory);
            if (or == null) {
                or = (OrientationRequested)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(orCategory);
            }
            if ((mpa = this.validateMargins(lm, rm, tm, bm)) != null) {
                PrintConfigDialog.this.asCurrent.add(mpa);
                this.lmVal = lm;
                this.rmVal = rm;
                this.tmVal = tm;
                this.bmVal = bm;
                this.lmObj = lmTmpObj;
                this.rmObj = rmTmpObj;
                this.tmObj = tmTmpObj;
                this.bmObj = bmTmpObj;
            } else {
                if (this.lmObj == null || this.bmObj == null || this.tmObj == null || this.rmObj == null) {
                    return;
                }
                this.leftMargin.setValue((Object)this.lmObj);
                this.rightMargin.setValue((Object)this.rmObj);
                this.topMargin.setValue((Object)this.tmObj);
                this.bottomMargin.setValue((Object)this.bmObj);
            }
        }

        private MediaPrintableArea validateMargins(float lm, float rm, float tm, float bm) {
            Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
            MediaPrintableArea mpaMax = null;
            MediaSize mediaSize = null;
            Media media = (Media)PrintConfigDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(PrintConfigDialog.this.asCurrent);
                tmpASet.add(media);
                Object values = PrintConfigDialog.this.psCurrent.getSupportedAttributeValues(mpaCategory, PrintConfigDialog.this.docFlavor, tmpASet);
                if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                    mpaMax = ((MediaPrintableArea[])values)[0];
                }
            }
            if (mpaMax == null) {
                mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float wid = mediaSize.getX(this.units);
            float hgt = mediaSize.getY(this.units);
            float pax = lm;
            float pay = tm;
            float paw = wid - lm - rm;
            float pah = hgt - tm - bm;
            float wMax = mpaMax.getWidth(this.units);
            wMax = Math.round(wMax);
            float hMax = mpaMax.getHeight(this.units);
            hMax = Math.round(hMax);
            if (paw <= 0.0f || pah <= 0.0f || pax < 0.0f || pay < 0.0f || paw > wMax || pah > hMax || Math.round(pax) < Math.round(mpaMax.getX(this.units)) || Math.round(pay) < Math.round(mpaMax.getY(this.units))) {
                return null;
            }
            return new MediaPrintableArea(lm, tm, paw, pah, this.units);
        }

        public void updateInfo() {
            Class<MediaPrintableArea> mpaCategory = MediaPrintableArea.class;
            MediaPrintableArea mpa = (MediaPrintableArea)PrintConfigDialog.this.asCurrent.get(mpaCategory);
            MediaPrintableArea mpaMax = null;
            MediaSize mediaSize = null;
            Media media = (Media)PrintConfigDialog.this.asCurrent.get(Media.class);
            if (media == null || !(media instanceof MediaSizeName)) {
                media = (Media)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(Media.class);
            }
            if (media instanceof MediaSizeName) {
                MediaSizeName msn = (MediaSizeName)media;
                mediaSize = MediaSize.getMediaSizeForName(msn);
            }
            if (mediaSize == null) {
                mediaSize = new MediaSize(8.5f, 11.0f, 25400);
            }
            if (media != null) {
                HashPrintRequestAttributeSet tmpASet = new HashPrintRequestAttributeSet(PrintConfigDialog.this.asCurrent);
                tmpASet.add(media);
                Object values = PrintConfigDialog.this.psCurrent.getSupportedAttributeValues(mpaCategory, PrintConfigDialog.this.docFlavor, tmpASet);
                if (values instanceof MediaPrintableArea[] && ((MediaPrintableArea[])values).length > 0) {
                    mpaMax = ((MediaPrintableArea[])values)[0];
                } else if (values instanceof MediaPrintableArea) {
                    mpaMax = (MediaPrintableArea)values;
                }
            }
            if (mpaMax == null) {
                mpaMax = new MediaPrintableArea(0.0f, 0.0f, mediaSize.getX(this.units), mediaSize.getY(this.units), this.units);
            }
            float wid = mediaSize.getX(25400);
            float hgt = mediaSize.getY(25400);
            float maxMarginRatio = 5.0f;
            float xMgn = wid > maxMarginRatio ? 1.0f : wid / maxMarginRatio;
            float yMgn = hgt > maxMarginRatio ? 1.0f : hgt / maxMarginRatio;
            if (mpa == null) {
                mpa = new MediaPrintableArea(xMgn, yMgn, wid - 2.0f * xMgn, hgt - 2.0f * yMgn, 25400);
                PrintConfigDialog.this.asCurrent.add(mpa);
            }
            float pax = mpa.getX(this.units);
            float pay = mpa.getY(this.units);
            float paw = mpa.getWidth(this.units);
            float pah = mpa.getHeight(this.units);
            wid = mediaSize.getX(this.units);
            hgt = mediaSize.getY(this.units);
            if (paw > pah) {
                paw = wid - (hgt - paw);
                pah = hgt - (wid - pah);
            }
            float paxMax = mpaMax.getX(this.units);
            float payMax = mpaMax.getY(this.units);
            float pawMax = mpaMax.getWidth(this.units);
            float pahMax = mpaMax.getHeight(this.units);
            boolean invalid = false;
            if (this.lmVal >= 0.0f) {
                invalid = true;
                if (this.lmVal + this.rmVal > wid) {
                    if (paw > pawMax) {
                        paw = pawMax;
                    }
                    pax = (wid - paw) / 2.0f;
                } else {
                    pax = this.lmVal >= paxMax ? this.lmVal : paxMax;
                    paw = wid - pax - this.rmVal;
                }
                if (this.tmVal + this.bmVal > hgt) {
                    if (pah > pahMax) {
                        pah = pahMax;
                    }
                    pay = (hgt - pah) / 2.0f;
                } else {
                    pay = this.tmVal >= payMax ? this.tmVal : payMax;
                    pah = hgt - pay - this.bmVal;
                }
            }
            if (pax < paxMax) {
                invalid = true;
                pax = paxMax;
            }
            if (pay < payMax) {
                invalid = true;
                pay = payMax;
            }
            if (paw > pawMax) {
                invalid = true;
                paw = pawMax;
            }
            if (pah > pahMax) {
                invalid = true;
                pah = pahMax;
            }
            if (pax + paw > paxMax + pawMax || paw <= 0.0f) {
                invalid = true;
                pax = paxMax;
                paw = pawMax;
            }
            if (pay + pah > payMax + pahMax || pah <= 0.0f) {
                invalid = true;
                pay = payMax;
                pah = pahMax;
            }
            if (invalid) {
                mpa = new MediaPrintableArea(pax, pay, paw, pah, this.units);
                PrintConfigDialog.this.asCurrent.add(mpa);
            }
            this.lmVal = pax;
            this.tmVal = pay;
            this.rmVal = mediaSize.getX(this.units) - pax - paw;
            float ssssHeight = mediaSize.getY(this.units);
            this.bmVal = ssssHeight - pay - pah;
            this.lmObj = new Float(this.lmVal);
            this.rmObj = new Float(this.rmVal);
            this.tmObj = new Float(this.tmVal);
            this.bmObj = new Float(this.bmVal);
            this.leftMargin.setValue((Object)this.lmObj);
            this.rightMargin.setValue((Object)this.rmObj);
            this.topMargin.setValue((Object)this.tmObj);
            this.bottomMargin.setValue((Object)this.bmObj);
        }
    }

    private class PageSetupPanel
    extends KDPanel {
        private static final long serialVersionUID = 5231887611741408503L;
        private MediaPanel pnlMedia;
        private OrientationPanel pnlOrientation;
        private MarginsPanel pnlMargins;
        private ScalePanel pnlScale;

        public void updateMarginPanel() {
            this.pnlMargins.clearMargins();
        }

        public PageSetupPanel() {
            this.setLayout(null);
            this.pnlMedia = new MediaPanel();
            this.add((Component)((Object)this.pnlMedia));
            this.pnlOrientation = new OrientationPanel();
            this.add((Component)((Object)this.pnlOrientation));
            this.pnlMargins = new MarginsPanel();
            this.pnlOrientation.addOrientationListener(this.pnlMargins);
            this.pnlMedia.addMediaListener(this.pnlMargins);
            this.add((Component)((Object)this.pnlMargins));
            this.pnlScale = new ScalePanel();
            this.add((Component)((Object)this.pnlScale));
            int x = 10;
            int y = 10;
            int w = 180;
            int h = this.pnlMargins.getPreferredSize().height;
            Dimension size = this.pnlMedia.getPreferredSize();
            this.pnlMedia.setBounds(x, y, 403, size.height);
            y = y + size.height + 10;
            this.pnlOrientation.setBounds(x, y, w, h);
            this.pnlMargins.setBounds(x + w + 10, y, 423 - w - 30, h);
            y = y + h + 10;
            h = this.pnlScale.getPreferredSize().height;
            this.pnlScale.setBounds(x, y, 403, h);
            h = y + h + 10;
            size.setSize(423, h);
            this.setPreferredSize(size);
        }

        public void updateInfo() {
            this.pnlMedia.updateInfo();
            this.pnlOrientation.updateInfo();
            this.pnlMargins.updateInfo();
            this.pnlScale.updateInfo();
        }
    }

    private class CopiesPanel
    extends KDPanel
    implements ActionListener,
    ChangeListener {
        private static final long serialVersionUID = -5930432421996966115L;
        private final String strTitle = PrintConfigDialog.access$200("border.copies");
        private SpinnerNumberModel snModel;
        private KDSpinner spinCopies;
        private JLabel lblCopies;
        private KDCheckBox cbCollate;
        private boolean scSupported;

        public CopiesPanel() {
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            this.snModel = new SpinnerNumberModel(1, 1, 999, 1);
            this.spinCopies = new KDSpinner((SpinnerModel)this.snModel);
            ((JSpinner.NumberEditor)this.spinCopies.getEditor()).getTextField().setColumns(3);
            this.spinCopies.addChangeListener((ChangeListener)this);
            String str = PrintConfigDialog.getMsg("label.numcopies");
            LinedLabel ll = PrintConfigDialog.this.L(str, (JComponent)this.spinCopies);
            this.lblCopies = ll.getBoundLabel();
            this.add((Component)((Object)ll));
            this.cbCollate = PrintConfigDialog.createCheckBox("checkbox.collate", this);
            this.cbCollate.setEnabled(false);
            this.add((Component)this.cbCollate);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.cbCollate.isSelected()) {
                PrintConfigDialog.this.asCurrent.add(SheetCollate.COLLATED);
            } else {
                PrintConfigDialog.this.asCurrent.add(SheetCollate.UNCOLLATED);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.updateCollateCB();
            PrintConfigDialog.this.asCurrent.add(new Copies(this.snModel.getNumber().intValue()));
        }

        private void updateCollateCB() {
            int num = this.snModel.getNumber().intValue();
            this.cbCollate.setEnabled(num > 1 && this.scSupported);
        }

        public void updateInfo() {
            SheetCollate sc;
            int max;
            int min;
            Copies cp;
            CopiesSupported cs;
            Class<Copies> cpCategory = Copies.class;
            Class<CopiesSupported> csCategory = CopiesSupported.class;
            Class<SheetCollate> scCategory = SheetCollate.class;
            boolean cpSupported = false;
            this.scSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(cpCategory)) {
                cpSupported = true;
            }
            if ((cs = (CopiesSupported)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(csCategory)) == null) {
                cs = new CopiesSupported(1, 999);
            }
            if ((cp = (Copies)PrintConfigDialog.this.asCurrent.get(cpCategory)) == null && (cp = (Copies)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(cpCategory)) == null) {
                cp = new Copies(1);
            }
            this.spinCopies.setEnabled(cpSupported);
            this.lblCopies.setEnabled(cpSupported);
            int[][] members = cs.getMembers();
            if (members.length > 0 && members[0].length > 0) {
                min = members[0][0];
                max = members[0][1];
            } else {
                min = 1;
                max = Integer.MAX_VALUE;
            }
            this.snModel.setMinimum(Integer.valueOf(min));
            this.snModel.setMaximum(Integer.valueOf(max));
            int value = cp.getValue();
            if (value < min || value > max) {
                value = min;
            }
            this.snModel.setValue(value);
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(scCategory)) {
                this.scSupported = true;
            }
            if ((sc = (SheetCollate)PrintConfigDialog.this.asCurrent.get(scCategory)) == null && (sc = (SheetCollate)PrintConfigDialog.this.psCurrent.getDefaultAttributeValue(scCategory)) == null) {
                sc = SheetCollate.UNCOLLATED;
            }
            this.cbCollate.setSelected(sc == SheetCollate.COLLATED);
            this.updateCollateCB();
        }
    }

    private class PrintRangePanel
    extends KDPanel
    implements ActionListener,
    FocusListener {
        private static final long serialVersionUID = 3543713748896314551L;
        private final String strTitle = PrintConfigDialog.access$200("border.printrange");
        private final PageRanges prAll = new PageRanges(1, Integer.MAX_VALUE);
        private KDRadioButton rbAll;
        private KDRadioButton rbPages;
        private KDFormattedTextField tfRangeFrom;
        private KDFormattedTextField tfRangeTo;
        private KDLabel lblRangeTo;
        private boolean prSupported;

        public PrintRangePanel() {
            NumberFormatter nfto;
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            ButtonGroup bg = new ButtonGroup();
            FixedPanel pnlTop = new FixedPanel();
            this.rbAll = PrintConfigDialog.createRadioButton("radiobutton.rangeall", this);
            this.rbAll.setSelected(true);
            bg.add((AbstractButton)this.rbAll);
            pnlTop.add((Component)this.rbAll);
            this.add((Component)((Object)pnlTop));
            FixedPanel pnlBottom = new FixedPanel();
            this.rbPages = PrintConfigDialog.createRadioButton("radiobutton.rangepages", this);
            bg.add((AbstractButton)this.rbPages);
            pnlBottom.add((Component)this.rbPages);
            DecimalFormat format = new DecimalFormat("####0");
            format.setMinimumFractionDigits(0);
            format.setMaximumFractionDigits(0);
            format.setMinimumIntegerDigits(0);
            format.setMaximumIntegerDigits(5);
            format.setParseIntegerOnly(true);
            format.setDecimalSeparatorAlwaysShown(false);
            NumberFormatter nf = new NumberFormatter(format);
            nf.setMinimum(Integer.valueOf(1));
            nf.setMaximum(Integer.valueOf(Integer.MAX_VALUE));
            nf.setAllowsInvalid(true);
            nf.setCommitsOnValidEdit(true);
            this.tfRangeFrom = new KDFormattedTextField();
            this.tfRangeFrom.setEditFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.tfRangeFrom.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nf);
            this.tfRangeFrom.setColumns(4);
            this.tfRangeFrom.setEnabled(false);
            this.tfRangeFrom.addActionListener((ActionListener)this);
            this.tfRangeFrom.addFocusListener((FocusListener)this);
            this.tfRangeFrom.setFocusLostBehavior(3);
            pnlBottom.add((Component)this.tfRangeFrom);
            this.lblRangeTo = new KDLabel(PrintConfigDialog.getMsg("label.rangeto"));
            this.lblRangeTo.setEnabled(false);
            pnlBottom.add((Component)this.lblRangeTo);
            try {
                nfto = (NumberFormatter)nf.clone();
            }
            catch (CloneNotSupportedException e) {
                nfto = new NumberFormatter();
            }
            this.tfRangeTo = new KDFormattedTextField();
            this.tfRangeTo.setEditFormatter((JFormattedTextField.AbstractFormatter)nfto);
            this.tfRangeTo.setDisplayFormatter((JFormattedTextField.AbstractFormatter)nfto);
            this.tfRangeTo.setColumns(4);
            this.tfRangeTo.setEnabled(false);
            this.tfRangeTo.addFocusListener((FocusListener)this);
            pnlBottom.add((Component)this.tfRangeTo);
            this.add((Component)((Object)pnlBottom));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            this.setupRangeWidgets();
            if (source == this.rbAll) {
                PrintConfigDialog.this.asCurrent.add(this.prAll);
            } else if (source == this.rbPages || source == this.tfRangeFrom || source == this.tfRangeTo) {
                this.updateRangeAttribute();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
            Object source = e.getSource();
            if (source == this.tfRangeFrom || source == this.tfRangeTo) {
                this.updateRangeAttribute();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        private void setupRangeWidgets() {
            boolean rangeEnabled = this.rbPages.isSelected() && this.prSupported;
            this.tfRangeFrom.setEnabled(rangeEnabled);
            this.tfRangeTo.setEnabled(rangeEnabled);
            this.lblRangeTo.setEnabled(rangeEnabled);
        }

        private void updateRangeAttribute() {
            int max;
            int min;
            String strFrom = this.tfRangeFrom.getText();
            String strTo = this.tfRangeTo.getText();
            try {
                min = Integer.parseInt(strFrom);
            }
            catch (NumberFormatException e) {
                min = 1;
            }
            try {
                max = Integer.parseInt(strTo);
            }
            catch (NumberFormatException e) {
                max = min;
            }
            if (min < 1) {
                min = 1;
                this.tfRangeFrom.setValue((Object)1);
            }
            if (max < min) {
                max = min;
                this.tfRangeTo.setValue((Object)min);
            }
            PageRanges pr = new PageRanges(min, max);
            PrintConfigDialog.this.asCurrent.add(pr);
        }

        public void updateInfo() {
            PageRanges pr;
            Class<PageRanges> prCategory = PageRanges.class;
            this.prSupported = false;
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(prCategory)) {
                this.prSupported = true;
            }
            if ((pr = (PageRanges)PrintConfigDialog.this.asCurrent.get(prCategory)) != null) {
                if (pr.equals(this.prAll)) {
                    this.rbAll.setSelected(true);
                } else {
                    this.rbPages.setSelected(true);
                    int[][] members = pr.getMembers();
                    int min = 1;
                    int max = 1;
                    if (members.length > 0 && members[0].length > 1) {
                        min = members[0][0];
                        max = members[0][1];
                    }
                    this.tfRangeFrom.setValue((Object)min);
                    this.tfRangeTo.setValue((Object)max);
                }
            } else {
                this.rbAll.setSelected(true);
                this.tfRangeFrom.setValue((Object)1);
                this.tfRangeTo.setValue((Object)1);
            }
            this.rbAll.setEnabled(this.prSupported);
            this.rbPages.setEnabled(this.prSupported);
            this.setupRangeWidgets();
        }
    }

    private class PrintServicePanel
    extends KDPanel
    implements ActionListener,
    ItemListener,
    PopupMenuListener {
        private static final long serialVersionUID = 4371325421260811416L;
        private final String strTitle = PrintConfigDialog.access$200("border.printservice");
        private FilePermission printToFilePermission;
        private KDButton btnProperties;
        private KDCheckBox cbPrintToFile;
        private KDComboBox cbName;
        private KDLabel lblType;
        private KDLabel lblStatus;
        private KDLabel lblInfo;
        private ServiceUIFactory uiFactory;
        private boolean changedService = false;

        public PrintServicePanel() {
            this.uiFactory = PrintConfigDialog.this.psCurrent.getServiceUIFactory();
            this.setOpaque(false);
            this.setLayout(LineLayout.LIGHTWEIGHT);
            this.setBorder(BorderFactory.createTitledBorder(this.strTitle));
            Object[] psnames = new String[PrintConfigDialog.this.services.length];
            for (int i = 0; i < psnames.length; ++i) {
                psnames[i] = PrintConfigDialog.this.services[i].getName();
            }
            this.cbName = new KDComboBox(psnames);
            this.cbName.setSelectedIndex(PrintConfigDialog.this.defaultServiceIndex);
            this.cbName.addItemListener((ItemListener)this);
            this.cbName.addPopupMenuListener((PopupMenuListener)this);
            String str = PrintConfigDialog.getMsg("label.psname");
            this.add((Component)((Object)PrintConfigDialog.this.L(str, (JComponent)this.cbName)));
            this.btnProperties = PrintConfigDialog.createButton("button.properties", this);
            str = PrintConfigDialog.getMsg("label.status");
            this.lblStatus = new KDLabel();
            this.add((Component)((Object)PrintConfigDialog.this.L(str, (JComponent)this.lblStatus)));
            str = PrintConfigDialog.getMsg("label.pstype");
            this.lblType = new KDLabel();
            this.add((Component)((Object)PrintConfigDialog.this.L(str, (JComponent)this.lblType)));
            str = PrintConfigDialog.getMsg("label.info");
            this.lblInfo = new KDLabel();
            this.add((Component)((Object)PrintConfigDialog.this.L(str, (JComponent)this.lblInfo)));
            this.cbPrintToFile = PrintConfigDialog.createCheckBox("checkbox.printtofile", this);
        }

        public boolean isPrintToFileSelected() {
            return this.cbPrintToFile.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (source == this.btnProperties && this.uiFactory != null) {
                JDialog dialog = (JDialog)this.uiFactory.getUI(3, "javax.swing.JDialog");
                if (dialog != null) {
                    dialog.show();
                } else {
                    this.btnProperties.setEnabled(false);
                }
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int index;
            if (e.getStateChange() == 1 && (index = this.cbName.getSelectedIndex()) >= 0 && index < PrintConfigDialog.this.services.length && !PrintConfigDialog.this.services[index].equals(PrintConfigDialog.this.psCurrent)) {
                PrintConfigDialog.this.psCurrent = PrintConfigDialog.this.services[index];
                this.uiFactory = PrintConfigDialog.this.psCurrent.getServiceUIFactory();
                this.changedService = true;
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.changedService = false;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (this.changedService) {
                this.changedService = false;
                PrintConfigDialog.this.updatePanels();
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private boolean allowedToPrintToFile() {
            try {
                this.throwPrintToFile();
                return true;
            }
            catch (SecurityException e) {
                return false;
            }
        }

        private void throwPrintToFile() {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                if (this.printToFilePermission == null) {
                    this.printToFilePermission = new FilePermission("<<ALL FILES>>", "read,write");
                }
                security.checkPermission(this.printToFilePermission);
            }
        }

        public void updateInfo() {
            PrinterInfo info;
            PrinterIsAcceptingJobs status;
            Destination dst;
            Class<Destination> dstCategory = Destination.class;
            boolean dstSupported = false;
            boolean dstSelected = false;
            boolean dstAllowed = this.allowedToPrintToFile();
            if (PrintConfigDialog.this.psCurrent.isAttributeCategorySupported(dstCategory)) {
                dstSupported = true;
            }
            if ((dst = (Destination)PrintConfigDialog.this.asCurrent.get(dstCategory)) != null) {
                dstSelected = true;
            }
            this.cbPrintToFile.setEnabled(dstSupported && dstAllowed);
            this.cbPrintToFile.setSelected(dstSelected && dstAllowed);
            PrinterMakeAndModel type = PrintConfigDialog.this.psCurrent.getAttribute(PrinterMakeAndModel.class);
            if (type != null) {
                this.lblType.setText(((Object)type).toString());
            }
            if ((status = PrintConfigDialog.this.psCurrent.getAttribute(PrinterIsAcceptingJobs.class)) != null) {
                this.lblStatus.setText(PrintConfigDialog.getMsg(((Object)status).toString()));
            }
            if ((info = PrintConfigDialog.this.psCurrent.getAttribute(PrinterInfo.class)) != null) {
                this.lblInfo.setText(((Object)info).toString());
            }
            this.btnProperties.setEnabled(this.uiFactory != null);
        }
    }

    private class GeneralPanel
    extends KDPanel {
        private static final long serialVersionUID = -8963381832795583876L;
        private PrintServicePanel pnlPrintService;
        private PrintRangePanel pnlPrintRange;
        private CopiesPanel pnlCopies;

        public GeneralPanel() {
            this.setLayout(null);
            this.pnlPrintService = new PrintServicePanel();
            this.pnlPrintRange = new PrintRangePanel();
            this.pnlCopies = new CopiesPanel();
            this.add((Component)((Object)this.pnlPrintService));
            this.add((Component)((Object)this.pnlPrintRange));
            this.add((Component)((Object)this.pnlCopies));
            int x = 10;
            int y = 10;
            int h = this.pnlPrintService.getPreferredSize().height;
            int w = 403;
            this.pnlPrintService.setBounds(x, y, w, h);
            y = y + h + 10;
            this.pnlPrintRange.setBounds(x, y, 222, 86);
            this.pnlCopies.setBounds(x + 222 + 10, y, w - 222 - 10, 86);
        }

        public boolean isPrintToFileSelected() {
            return this.pnlPrintService.isPrintToFileSelected();
        }

        public void updateInfo() {
            this.pnlPrintService.updateInfo();
            this.pnlPrintRange.updateInfo();
            this.pnlCopies.updateInfo();
        }
    }
}

