/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.proxy;

import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

public class JavaDataInput
extends DataInputStream {
    private byte[] n_abBuf = new byte[4096];

    public JavaDataInput(InputStream in) {
        super(in);
    }

    public Date readDate() throws IOException {
        Calendar calendar = Calendar.getInstance();
        calendar.set(super.readShort(), super.readByte() - 1, super.readByte(), super.readByte(), super.readByte(), super.readByte());
        return calendar.getTime();
    }

    public BigDecimal readDecimal() throws IOException {
        return new BigDecimal(this.readString());
    }

    public String readString() throws IOException {
        int iLength = super.readInt() * 2;
        byte[] abData = iLength < 4096 ? this.n_abBuf : new byte[iLength];
        for (int i = 0; i < iLength; i += super.read(abData, i, iLength - i)) {
        }
        return new String(abData, 0, iLength, "UTF-16");
    }

    public byte[] readArray() throws IOException {
        super.readInt();
        int iLen = super.readInt();
        byte[] ab = new byte[iLen];
        for (int i = 0; i < iLen; i += super.read(ab, i, iLen - i)) {
        }
        return ab;
    }

    public Variant readVariant() throws IOException {
        short eVarType = super.readShort();
        Variant var = new Variant();
        switch (eVarType) {
            case 3: {
                var.setInt(this.readInt());
                break;
            }
            case 2: {
                var.setShort(this.readShort());
                break;
            }
            case 5: {
                var.setFloat(this.readFloat());
                break;
            }
            case 6: {
                var.setDouble(this.readDouble());
                break;
            }
            case 8: {
                var.setBoolean(this.readBoolean());
                break;
            }
            case 10: {
                var.setObject((Object)this.readDecimal(), 10);
                break;
            }
            case 12: {
                var.setObject((Object)this.readDate());
                break;
            }
            case 11: {
                var.setObject((Object)this.readString());
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                var.setByte(this.readByte());
                break;
            }
            case 4: {
                var.setLong(this.readLong());
                break;
            }
            default: {
                if (0 == (eVarType & 0x200)) break;
                var.setObject((Object)this.readArray(), (int)eVarType);
            }
        }
        return var;
    }
}

