/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import java.util.Hashtable;

public class LazyValueMap
extends Hashtable {
    private static final long serialVersionUID = -4977807494625328530L;
    public static Object NULL_OBJECT = new Object();

    @Override
    public synchronized Object get(Object key) {
        Object obj = super.get(key);
        if (obj == NULL_OBJECT) {
            obj = null;
        } else if (obj instanceof LazyValue) {
            if ((obj = this.createLazyValue((LazyValue)obj)) == null) {
                this.put(key, NULL_OBJECT);
            } else {
                this.put(key, obj);
            }
        }
        return obj;
    }

    protected Object createLazyValue(LazyValue lazyValue) {
        ClassLoader cl;
        String className = lazyValue.getClassName();
        Object value = null;
        if (!StringUtil.isEmptyString((String)className) && (cl = this.getClass().getClassLoader()) != null) {
            try {
                value = cl.loadClass(className).newInstance();
            }
            catch (InstantiationException e) {
                value = null;
            }
            catch (IllegalAccessException e) {
                value = null;
            }
            catch (ClassNotFoundException e) {
                value = null;
            }
        }
        return value;
    }

    public static class LazyValue {
        private String className;

        public LazyValue(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }
    }
}

