/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.JDBCDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.query.KDSourceQuery;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryColumn;
import com.kingdee.cosmic.ctrl.kdf.data.query.QueryDir;
import com.kingdee.cosmic.ctrl.kdf.form.Area;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.Panel;
import com.kingdee.cosmic.ctrl.kdf.form.Property;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.cosmic.ctrl.kdf.util.AbstractK3File2KDFObj;
import com.kingdee.cosmic.ctrl.kdf.util.Base64;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class NDFFile2KDFObj
extends AbstractK3File2KDFObj {
    private static final Logger logger = LogUtil.getPackageLogger(NDFFile2KDFObj.class);
    private String _NDFFile = "";
    private KDF _kdf;
    private Form _form;
    private Page _page;
    private DataSource source;
    private String _strErr;
    private long lByteHasBeenRead = 0L;
    private long index = 0L;
    private static final String _csReserver = "Margin";
    static final byte btEnd = 26;
    private static final byte KN_CLSID_RECT = 1;
    private static final byte KN_CLSID_TEXT = 2;
    private static final byte KN_CLSID_UNIT = 3;
    private static final byte KN_CLSID_BODY = 4;
    static final byte KN_CLSID_TABLE = 5;
    private static final byte KN_CLSID_IMAGE = 6;
    private static final long KN_FLAG_FILL = 1L;
    private static final long KN_FLAG_LINE = 2L;
    private static final byte LF_FLAG_ITALIC = 1;
    private static final byte LF_FLAG_UNDERLINE = 2;
    private static final byte LF_FLAG_STRIKEOUT = 4;
    private static final byte LF_FLAG_BOLD = 8;
    private static final int FW_NORMAL = 400;
    private static final int FW_BOLD = 700;
    private static final int KN_TF_TOP = 1;
    private static final int KN_TF_LEFT = 2;
    private static final int KN_TF_CENTER = 4;
    private static final int KN_TF_RIGHT = 8;
    private static final int KN_TF_VCENTER = 16;
    private static final int KN_TF_BOTTOM = 32;
    static final int KN_TF_EXTEND = 64;
    static final int KN_TF_DEFAULT = 20;
    private Vector vecFld = null;
    private boolean DEBUG = false;
    private boolean saveAKDF = false;
    private int queryColumnIDSeed = 0;
    private Object[] metaTables;
    private Panel outPanel;

    private static final String getKNFileHead() {
        return CtrlKDFMessages.getMLS("kpControlKit", "KINGDEE\u5957\u6253\u63a7\u4ef6");
    }

    private String getString(DataInputStream ndfDataStream) throws IOException {
        long llen = this.getStringLen(ndfDataStream);
        byte[] b = new byte[(int)llen];
        this.lByteHasBeenRead += llen;
        String s = new String(b, StandardCharsets.UTF_8);
        return s;
    }

    private long getStringLen(DataInputStream ndfDataStream) throws IOException {
        long llen = 0L;
        byte b1 = this.readbyte(ndfDataStream);
        if (b1 != -1) {
            llen = b1;
        } else {
            b1 = this.readbyte(ndfDataStream);
            byte b2 = this.readbyte(ndfDataStream);
            if (b1 != -1 || b2 != -2) {
                if (b1 == -1 && b2 == -1) {
                    b1 = this.readbyte(ndfDataStream);
                    b2 = this.readbyte(ndfDataStream);
                    byte b3 = this.readbyte(ndfDataStream);
                    byte b4 = this.readbyte(ndfDataStream);
                    llen = this.convertByte2UINT(b1, b2, b3, b4);
                } else {
                    llen = this.convertByte2UINT(b1, b2);
                }
            }
        }
        return llen;
    }

    private long convertByte2UINT(byte b1, byte b2) {
        long l = 0L;
        l += this.convertNegativeByte2UINT(b2) << 8;
        return l += this.convertNegativeByte2UINT(b1);
    }

    private long convertNegativeByte2UINT(byte b1) {
        if (b1 < 0) {
            return 256 + b1;
        }
        return b1;
    }

    private long convertByte2long(byte b1, byte b2, byte b3, byte b4) {
        long l = 0L;
        l |= (long)(b4 << 24);
        l |= (long)(b3 << 16);
        l |= (long)(b2 << 8);
        return l |= (long)b1;
    }

    private long convertByte2UINT(byte b1, byte b2, byte b3, byte b4) {
        long l = 0L;
        l += this.convertNegativeByte2UINT(b4) << 24;
        l += this.convertNegativeByte2UINT(b3) << 16;
        l += this.convertNegativeByte2UINT(b2) << 8;
        return l += this.convertNegativeByte2UINT(b1);
    }

    private double convertByte2double(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7, byte b8) {
        long l = 0L;
        l += this.convertNegativeByte2UINT(b8) << 56;
        l += this.convertNegativeByte2UINT(b7) << 48;
        l += this.convertNegativeByte2UINT(b6) << 40;
        l += this.convertNegativeByte2UINT(b5) << 32;
        l += this.convertNegativeByte2UINT(b4) << 24;
        l += this.convertNegativeByte2UINT(b3) << 16;
        l += this.convertNegativeByte2UINT(b2) << 8;
        double d = Double.longBitsToDouble(l += this.convertNegativeByte2UINT(b1));
        d = (double)Math.round(d * 100.0) / 100.0;
        return d;
    }

    private void cout(String title, byte value, int inset) {
        if (this.DEBUG) {
            String strInset = "\t";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inset; ++i) {
                sb.append(strInset);
            }
        }
    }

    private void cout(String title, double value, int inset) {
        if (this.DEBUG) {
            String strInset = "\t";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inset; ++i) {
                sb.append(strInset);
            }
        }
    }

    private void cout(String title, String value, int inset) {
        if (this.DEBUG) {
            String strInset = "\t";
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < inset; ++i) {
                sb.append(strInset);
            }
        }
    }

    private byte readbyte(DataInputStream ndfDataStream) throws IOException {
        byte b = ndfDataStream.readByte();
        ++this.lByteHasBeenRead;
        return b;
    }

    public boolean translate() {
        try {
            return this.translate(new FileInputStream(FilenameUtils.normalize((String)this._NDFFile)));
        }
        catch (FileNotFoundException e) {
            logger.error((Object)"err", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean translate(InputStream input) {
        this.index = 0L;
        boolean ok = true;
        DataInputStream ndfDataStream = null;
        int inset = 0;
        this.cout("", "===============in translate(begin)", inset);
        try {
            long m_iNoteType;
            ndfDataStream = new DataInputStream(input);
            this.getKdf().setAuthors(new String[]{this._NDFFile});
            this.getKdf().setVersion("3.1");
            byte b1 = this.readbyte(ndfDataStream);
            byte b2 = this.readbyte(ndfDataStream);
            this.cout(CtrlKDFMessages.getMLS("fileHeader1", "\u6587\u4ef6\u59341="), b1, inset);
            this.cout(CtrlKDFMessages.getMLS("fileHeader2", "\u6587\u4ef6\u59342="), b2, inset);
            String szFileHead = this.getString(ndfDataStream);
            this.cout("KN_FILE_HEAD=", szFileHead, inset);
            if (!szFileHead.trim().equals(NDFFile2KDFObj.getKNFileHead())) {
                throw new Exception(CtrlKDFMessages.getMLS("fileTypeUnrecognized", "\u6587\u4ef6\u7c7b\u578b\u4e0d\u53ef\u8bc6\u522b!"));
            }
            this.cout(CtrlKDFMessages.getMLS("trailingBytes", "\u7ed3\u5c3e\u5b57\u8282="), this.readbyte(ndfDataStream), inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            byte b3 = this.readbyte(ndfDataStream);
            byte b4 = this.readbyte(ndfDataStream);
            byte b5 = this.readbyte(ndfDataStream);
            byte b6 = this.readbyte(ndfDataStream);
            byte b7 = this.readbyte(ndfDataStream);
            byte b8 = this.readbyte(ndfDataStream);
            double dfVersion = this.convertByte2double(b1, b2, b3, b4, b5, b6, b7, b8);
            this.cout(CtrlKDFMessages.getMLS("fileVersion", "\u6587\u4ef6\u7248\u672c="), dfVersion, inset);
            String csReserver = this.getString(ndfDataStream);
            this.cout(CtrlKDFMessages.getMLS("reservedBytes", "\u4fdd\u7559\u5b57\u8282="), csReserver, inset);
            if (dfVersion >= 2.1) {
                long llen;
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                this.cout(CtrlKDFMessages.getMLS("printInfoLength", "\u6253\u5370\u4fe1\u606f\u957f\u5ea6="), llen, inset);
                this.lByteHasBeenRead += llen;
                for (llen = this.convertByte2UINT(b1, b2, b3, b4); llen > Integer.MAX_VALUE; llen -= Integer.MAX_VALUE) {
                    ndfDataStream.skipBytes(Integer.MAX_VALUE);
                }
                ndfDataStream.skipBytes((int)llen);
            }
            String m_szNoteName = this.getString(ndfDataStream);
            this.cout(CtrlKDFMessages.getMLS("templateName", "\u5957\u6253\u540d\u79f0="), m_szNoteName, inset);
            if (dfVersion < 2.31) {
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                m_iNoteType = this.convertByte2UINT(b1, b2);
            } else {
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                m_iNoteType = this.convertByte2UINT(b1, b2, b3, b4);
            }
            this.cout(CtrlKDFMessages.getMLS("templateVersion", "\u5957\u6253\u7248\u672c="), m_iNoteType, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            long m_bDashTextBorder = this.convertByte2UINT(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("showDashedTextBox", "\u663e\u793a\u865a\u7ebf\u6587\u672c\u6846="), m_bDashTextBorder, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            long m_bForceQuery = this.convertByte2UINT(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("forceData", "\u5f3a\u5236\u53d6\u6570="), m_bForceQuery, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            long sizeX = this.convertByte2UINT(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("pageSizeX", "\u9875\u9762\u5927\u5c0f_X="), sizeX, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            long sizeY = this.convertByte2UINT(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("pageSizeY", "\u9875\u9762\u5927\u5c0f_Y="), sizeY, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            long pointX = this.convertByte2UINT(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("printStartPointX", "\u6253\u5370\u65f6\u8d77\u59cb\u70b9_X="), pointX, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            long pointY = this.convertByte2UINT(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("printStartPointY", "\u6253\u5370\u65f6\u8d77\u59cb\u70b9_Y="), pointY, inset);
            LinkedList lnkLayer = new LinkedList();
            this.translate_Layer(ndfDataStream, lnkLayer, inset + 1);
            this.translate_HeadFoot(ndfDataStream, dfVersion, inset + 1);
            this.translate_Table(ndfDataStream, inset + 1);
            this.makeDesignedPageNode(this.getPage(), false, sizeX, sizeY);
            if (csReserver.equals(_csReserver)) {
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                long m_left = this.convertByte2UINT(b1, b2, b3, b4);
                this.cout(CtrlKDFMessages.getMLS("rectLeft", "\u77e9\u5f62\u7684left="), m_left, inset);
                this.getKdf().getPrintInfo().setLeftMargin((int)m_left);
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                long m_top = this.convertByte2UINT(b1, b2, b3, b4);
                this.cout(CtrlKDFMessages.getMLS("rectTop", "\u77e9\u5f62\u7684top="), m_top, inset);
                this.getKdf().getPrintInfo().setTopMargin((int)m_top);
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                long m_right = this.convertByte2UINT(b1, b2, b3, b4);
                this.cout(CtrlKDFMessages.getMLS("rectRight", "\u77e9\u5f62\u7684right="), m_right, inset);
                this.getKdf().getPrintInfo().setRightMargin((int)m_right);
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                long m_bottom = this.convertByte2UINT(b1, b2, b3, b4);
                this.cout(CtrlKDFMessages.getMLS("rectBottom", "\u77e9\u5f62\u7684bottom="), m_bottom, inset);
                this.getKdf().getPrintInfo().setBottomMargin((int)m_bottom);
                this.getKdf().getPrintInfo().setCustomizePaperWidth((int)sizeX + (int)m_left + (int)m_right);
                this.getKdf().getPrintInfo().setCustomizePaperHeight((int)sizeY + (int)m_bottom + (int)m_top);
                this.getKdf().getPrintInfo().setCustomizedPaperSize(true);
            } else {
                this.getKdf().getPrintInfo().setLeftMargin(0);
                this.getKdf().getPrintInfo().setTopMargin(0);
                this.getKdf().getPrintInfo().setRightMargin(0);
                this.getKdf().getPrintInfo().setBottomMargin(0);
                this.getKdf().getPrintInfo().setCustomizePaperWidth((int)sizeX);
                this.getKdf().getPrintInfo().setCustomizePaperHeight((int)sizeY);
                this.getKdf().getPrintInfo().setCustomizedPaperSize(true);
            }
            this.cout("", "===============in translate(end)", inset);
            if (this.DEBUG) {
                StringBuilder sb = new StringBuilder();
                sb.append("Select ");
                for (int i = 0; i < this.getVecFld().size(); ++i) {
                    sb.append("[").append(String.valueOf(this.getVecFld().get(i))).append("],");
                    if (i % 5 != 0 || i == this.getVecFld().size() - 1) continue;
                    sb.append('\n');
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(" From test ");
                ((JDBCDataSource)this.getSource()).setSource(sb.toString());
            } else {
                ArrayList<String> noMetaField = new ArrayList<String>();
                if (this.getMetaTables().length != 0) {
                    BOSQueryDataSource ds = (BOSQueryDataSource)this.getSource();
                    IXmlElement designedDSNode = XmlUtil.createNode((String)"DesignedDataSource");
                    designedDSNode.setAttribute("id", ds.getID());
                    designedDSNode.setAttribute("name", ds.getName());
                    designedDSNode.setAttribute("queryType", String.valueOf(0));
                    designedDSNode.setAttribute("objectClass", "KDQuery");
                    designedDSNode.setAttribute("isLinked", String.valueOf(ds.isLinked()));
                    designedDSNode.setAttribute("isSelfDefine", "false");
                    IXmlElement columnsNode = XmlUtil.createNode((String)"Columns");
                    for (int i = 0; i < this.getVecFld().size(); ++i) {
                        IXmlElement colNode = this.biuldDSFieldDesignedNode(String.valueOf(this.getVecFld().get(i)));
                        if (colNode != null) {
                            columnsNode.addChild(colNode);
                            continue;
                        }
                        noMetaField.add(String.valueOf(this.getVecFld().get(i)));
                    }
                    IXmlElement subQuerysNode = XmlUtil.createNode((String)"SubQuerys");
                    for (int i = 0; i < this.getMetaTables().length; ++i) {
                        KDSourceQuery sq = (KDSourceQuery)this.getMetaTables()[i];
                        IXmlElement tableNode = XmlUtil.createNode((String)"SubQuery");
                        tableNode.setAttribute("id", "queryTable" + i);
                        tableNode.setAttribute("name", sq.getName());
                        tableNode.setAttribute("subQueryID", sq.getID());
                        subQuerysNode.addChild(tableNode);
                    }
                    designedDSNode.addChild(columnsNode);
                    designedDSNode.addChild(subQuerysNode);
                    ((BOSQueryDataSource)this.getSource()).setUserObject(designedDSNode);
                }
                this.fireNoMeta(this.dataManager == null, this.getMetaTables().length == 0, noMetaField.size() != 0, noMetaField.toArray());
            }
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
            ok = false;
            this._strErr = "Error: " + this.getNDFFile() + "\n" + ex + "\n";
        }
        try {
            if (ndfDataStream != null) {
                ndfDataStream.close();
            }
            input.close();
            if (this.isSaveAKDF()) {
                this._kdf.saveToFile(this._NDFFile + ".kdf");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
            this._strErr = ex.toString();
        }
        return ok;
    }

    private IXmlElement biuldDSFieldDesignedNode(String activeTextName) {
        if (this.getMetaTables().length == 0) {
            return null;
        }
        Object[] objs = this.getMetaField(activeTextName);
        if (objs == null) {
            return null;
        }
        KDSourceQuery table = (KDSourceQuery)objs[0];
        QueryColumn col = (QueryColumn)objs[1];
        IXmlElement node = XmlUtil.createNode((String)"Column");
        node.setAttribute("id", "queryColumn" + this.queryColumnIDSeed++);
        node.setAttribute("name", col.getName());
        node.setAttribute("fieldID", col.getProgramID());
        node.setAttribute("type", col.getType().toString());
        IXmlElement formulaNode = XmlUtil.createNode((String)"Formula");
        formulaNode.addCData("[" + table.getName() + "].[" + col.getName() + "]");
        IXmlElement formula4SqlNode = XmlUtil.createNode((String)"Formula4Sql");
        formula4SqlNode.addCData("[" + table.getName() + "].[" + col.getFormula() + "]");
        node.addChild(formulaNode);
        node.addChild(formula4SqlNode);
        return node;
    }

    private Object[] getMetaField(String fieldName) {
        Object[] objs = new Object[2];
        for (int i = 0; i < this.getMetaTables().length; ++i) {
            KDSourceQuery sourceQry = (KDSourceQuery)this.getMetaTables()[i];
            QueryColumn col = sourceQry.getColumnByName(fieldName);
            if (col == null) continue;
            objs[0] = sourceQry;
            objs[1] = col;
            return objs;
        }
        return null;
    }

    private Object[] getMetaTables() {
        if (this.dataManager == null) {
            return new Object[0];
        }
        if (this.metaTables == null) {
            ArrayList listQrys = new ArrayList();
            Iterator itKey = this.dataManager.getDbImport().keySet().iterator();
            if (itKey.hasNext()) {
                QueryDir qryDir = (QueryDir)this.dataManager.getDbImport().get(itKey.next());
                listQrys = this.getSourceQrys(qryDir);
            }
            this.metaTables = listQrys.toArray();
        }
        return this.metaTables;
    }

    private ArrayList getSourceQrys(QueryDir qd) {
        ArrayList listQrys = new ArrayList();
        Iterator it = qd.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            if (temp instanceof QueryDir) {
                listQrys.addAll(this.getSourceQrys((QueryDir)temp));
                continue;
            }
            if (!(temp instanceof KDSourceQuery)) continue;
            listQrys.add(temp);
        }
        return listQrys;
    }

    private void makeDesignedPageNode(Page page, boolean isHeadFooter, long width, long height) {
        if (page == null) {
            return;
        }
        IXmlElement node = XmlUtil.createNode((String)"DesignedPage");
        node.setAttribute("objHeight", String.valueOf(height));
        if (!isHeadFooter) {
            node.setAttribute("paperSize", "Custom");
            node.setAttribute("objWidth", String.valueOf(width));
            node.setAttribute("widthLimitless", "false");
            node.setAttribute("heightLimitless", "false");
        }
        page.setUserObject(node);
    }

    private void translate_Table(DataInputStream ndfDataStream, int inset) throws IOException {
        this.cout("", "=============translate_Table(begin)", inset);
        Area outArea = new Area();
        outArea.setId("area" + this.index++);
        outArea.setUserAlias(outArea.getId());
        outArea.setNext(outArea);
        this.getPage().addChild(outArea);
        outArea.getLeft().setOriginString("[" + this.getPage().getId() + ".left]");
        outArea.getTop().setOriginString("[" + this.getPage().getId() + ".top]");
        outArea.getRight().setOriginString("[" + this.getPage().getId() + ".right]");
        outArea.getBottom().setOriginString("[" + this.getPage().getId() + ".bottom]");
        outArea.setUserObject(this.translateDesignedNode((IXmlElement)outArea.getUserObject(), outArea, this.getPage().getId(), "0", "0", "0", "0", false));
        this.outPanel = new Panel();
        this.outPanel.setId("panel" + this.index++);
        this.outPanel.setUserAlias(this.outPanel.getId());
        this.outPanel.group().setDataSource(this.getSource().getID());
        outArea.addChild(this.outPanel);
        this.outPanel.getLeft().setOriginString("[" + outArea.getId() + ".left]");
        this.outPanel.getTop().setOriginString("[" + outArea.getId() + ".top]");
        this.outPanel.getRight().setOriginString("[" + outArea.getId() + ".right]");
        this.outPanel.getBottom().setOriginString("[" + outArea.getId() + ".bottom]");
        this.outPanel.setUserObject(this.translateDesignedNode((IXmlElement)this.outPanel.getUserObject(), this.outPanel, outArea.getId(), "0", "0", "0", "0", false));
        this.translate_Unit(ndfDataStream, inset + 1, this.outPanel, null);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        long nUnits = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("unitCount", "\u5355\u5143\u4e2a\u6570"), nUnits, inset);
        int i = 0;
        while ((long)i < nUnits) {
            byte btClsID = this.readbyte(ndfDataStream);
            switch (btClsID) {
                case 3: {
                    Panel panel2 = new Panel();
                    panel2.setId("panel" + this.index++);
                    panel2.setUserAlias(panel2.getId());
                    this.outPanel.addChild(panel2);
                    panel2.group().setDataSource(this.getSource().getID());
                    this.translate_Unit(ndfDataStream, inset + 1, panel2, this.outPanel);
                    break;
                }
                case 4: {
                    this.translate_Body(ndfDataStream, inset + 1, this.outPanel);
                    break;
                }
                default: {
                    throw new IOException(CtrlKDFMessages.getMLS("fileConversionError", "\u6587\u4ef6\u8f6c\u6362\u9519\u8bef(translate_Table)!"));
                }
            }
            ++i;
        }
        this.cout("", "=============translate_Table(end)", inset);
    }

    private void translate_Body(DataInputStream ndfDataStream, int inset, Panel parent) throws IOException {
        this.cout("", "=============translate_Body(begin)", inset);
        Area area = new Area();
        area.setId("area" + this.index++);
        area.setUserAlias(area.getId());
        area.setNext(area);
        parent.addChild(area);
        Panel panel = new Panel();
        panel.setId("panel" + this.index++);
        panel.setUserAlias(panel.getId());
        panel.group().setDataSource(this.getSource().getID());
        Vector vcCell = this.translate_Unit(ndfDataStream, inset + 1, area, parent);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        long m_nVisLines = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("displayedRecordLineCount", "\u663e\u793a\u7684\u7eaa\u5f55\u7ebf\u6570\u76ee="), m_nVisLines, inset);
        int i = 0;
        while ((long)i < m_nVisLines) {
            byte btClsID = this.readbyte(ndfDataStream);
            switch (btClsID) {
                case 1: {
                    if (i == 0) {
                        this.translate_Rect(ndfDataStream, inset + 1, panel, area);
                        break;
                    }
                    this.translate_Rect(ndfDataStream, inset + 1, null, area);
                    break;
                }
                default: {
                    throw new IOException(CtrlKDFMessages.getMLS("fileConversionError2", "\u6587\u4ef6\u8f6c\u6362\u9519\u8bef(translate_Body)!"));
                }
            }
            ++i;
        }
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_nDsnEntrys = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("designRecordCount", "\u8bbe\u8ba1\u65f6\u7684\u7eaa\u5f55\u6570="), m_nDsnEntrys, inset);
        area.setMaxLoopCount((int)m_nDsnEntrys);
        area.setMinLoopCount((int)m_nDsnEntrys);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_nPrnEntrys = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("printRecordCount", "\u6253\u5370\u65f6\u7684\u7eaa\u5f55\u6570="), m_nPrnEntrys, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_nDsnHeight = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("designRecordHeight", "\u8bbe\u8ba1\u65f6\u7eaa\u5f55\u9ad8\u5ea6="), m_nDsnHeight, inset);
        GDI_Rect rectArea = new GDI_Rect(area);
        if (m_nVisLines <= 0L) {
            this.getRelativePos(panel, area.getId(), "0", "0", String.valueOf(rectArea.width), String.valueOf(rectArea.height));
        } else {
            this.getRelativePos(panel, area.getId(), "0", "0", String.valueOf(rectArea.width), String.valueOf(m_nDsnHeight));
        }
        this.addCell2Panel(panel, vcCell, rectArea);
        area.addChild(panel);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_nPrnHeight = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("printRecordHeightAndPreserve", "\u6253\u5370\u65f6\u7eaa\u5f55\u9ad8\u5ea6, \u4fdd\u7559="), m_nPrnHeight, inset);
        this.cout("", "=============translate_Body(end)", inset);
    }

    private void addCell2Panel(Panel panel, Vector vcCell, GDI_Rect rectArea) {
        for (int i = 0; i < vcCell.size(); ++i) {
            Cell cell = (Cell)vcCell.get(i);
            GDI_Rect rectCell = new GDI_Rect(cell);
            this.getRelativePos(cell, panel.getId(), String.valueOf(rectCell.left - rectArea.left), String.valueOf(rectCell.top - rectArea.top), String.valueOf(rectCell.width), String.valueOf(rectCell.height));
            panel.addChild(cell);
        }
    }

    private void getRelativePos(Container container, String relativeID, String sLeft, String sTop, String sWidth, String sHeight) {
        container.getLeft().setOriginString("[" + relativeID + ".left]+" + sLeft);
        container.getTop().setOriginString("[" + relativeID + ".top]+" + sTop);
        container.getRight().setOriginString("[" + container.getId() + ".left]+" + sWidth);
        container.getBottom().setOriginString("[" + container.getId() + ".top]+" + sHeight);
        container.setUserObject(this.translateDesignedNode((IXmlElement)container.getUserObject(), container, relativeID, sLeft, sWidth, sTop, sHeight, true));
    }

    private Vector translate_Unit(DataInputStream ndfDataStream, int inset, Object obj, Container parent) throws IOException {
        this.cout("", "=============translate_Unit(begin)", inset);
        this.translate_Rect(ndfDataStream, inset + 1, obj, parent);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        long nItems = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("unitCount2", "\u5355\u5143\u4e2a\u6570="), nItems, inset);
        Vector<Cell> vcCell = new Vector<Cell>(0);
        int i = 0;
        while ((long)i < nItems) {
            byte btClsID = this.readbyte(ndfDataStream);
            Cell cell = new Cell();
            cell.setId("cell" + this.index++);
            cell.setUserAlias(cell.getId());
            switch (btClsID) {
                case 1: {
                    this.translate_Rect(ndfDataStream, inset + 1, cell, (Container)obj);
                    break;
                }
                case 2: {
                    this.translate_Text(ndfDataStream, inset + 1, cell, (Container)obj);
                    break;
                }
                case 6: {
                    this.translate_Image(ndfDataStream, inset + 1, cell, (Container)obj);
                    break;
                }
            }
            if (obj instanceof Area) {
                vcCell.add(cell);
            } else {
                this.addSonObj(obj, cell);
            }
            ++i;
        }
        this.cout("", "=============translate_Unit(end)", inset);
        return vcCell;
    }

    private void addSonObj(Object objParent, Cell cell) {
        if (!(objParent instanceof Area)) {
            if (objParent instanceof Panel) {
                ((Panel)objParent).addChild(cell);
            } else if (objParent instanceof Page) {
                ((Page)objParent).addChild(cell);
            }
        }
    }

    private void translate_Image(DataInputStream ndfDataStream, int inset, Object obj, Container parent) throws IOException {
        File f;
        long len;
        this.cout("", "=============translate_Image(begin)", inset);
        this.translate_Rect(ndfDataStream, inset + 1, obj, parent);
        String m_szImageFile = this.getString(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("imagePath", "\u56fe\u50cf\u6587\u4ef6\u8def\u5f84="), m_szImageFile, inset);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        Color m_crMask = this.convertByte2Color(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("mosaicColor", "\u884d\u6a21\u989c\u8272="), m_crMask.toString(), inset);
        if (obj instanceof Cell && (len = (f = new File(FilenameUtils.normalize((String)m_szImageFile))).length()) > 0L) {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(FilenameUtils.normalize((String)m_szImageFile)));){
                byte[] buf = new byte[(int)len];
                bis.read(buf);
                Data data = new Data();
                data.setFormat(Base64.encodeBytes((byte[])buf));
                ((Cell)obj).setType("constant");
                ((Cell)obj).addProperty(new Property("contentType", null, "embeddedImage"));
                ((Cell)obj).setData(data);
            }
        }
        this.cout("", "=============translate_Image(end)", inset);
    }

    private void translate_Text(DataInputStream ndfDataStream, int inset, Object obj, Container parent) throws IOException {
        this.cout("", "=============translate_Text(begin)", inset);
        this.translate_Rect(ndfDataStream, inset + 1, obj, parent);
        String m_szText = this.getString(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("textOrDisplayKeyword(requireData)", CtrlKDFMessages.getMLS("textOrDisplayKeyword(requireData)", CtrlKDFMessages.getMLS("textOrDisplayKeyword(requireData)", CtrlKDFMessages.getMLS("textOrDisplayKeyword(requireData)", "\u6587\u5b57\u6216\u663e\u793a\u7684\u5173\u952e\u5b57\uff08\u9700\u8981\u53d6\u6570\u636e\uff09=")))), m_szText, inset);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        Color m_crText = this.convertByte2Color(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("textColor", "\u6587\u5b57\u989c\u8272="), m_crText.toString(), inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_uAlignFlag = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("textAlignmentFormat", "\u6587\u672c\u5bf9\u9f50\u683c\u5f0f="), m_uAlignFlag, inset);
        String m_szDataFormat = this.getString(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("dataFormat", "\u6570\u636e\u683c\u5f0f="), m_szDataFormat, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        long m_iCharSpace = this.convertByte2UINT(b1, b2);
        this.cout(CtrlKDFMessages.getMLS("characterInterval0.1mm", "\u6bcf\u4e2a\u5b57\u7b26\u7684\u95f4\u96940.1mm="), m_iCharSpace, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        long m_iCharDist = this.convertByte2UINT(b1, b2);
        this.cout(CtrlKDFMessages.getMLS("charInterval0.01mm", "\u6bcf\u4e2a\u5b57\u96940.01mm="), m_iCharDist, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_nRowSpace = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("lineHeight0.1Multiple", "0.1\u884c\u9ad8\u500d\u6570="), m_nRowSpace, inset);
        String m_szQuery = this.getString(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("keywordForQuery", "\u7528\u4e8e\u67e5\u8be2\u7684\u5173\u952e\u5b57="), m_szQuery, inset);
        MiniFont miniFont = this.translate_MiniFont(ndfDataStream, inset + 1);
        if (obj instanceof Cell) {
            StyleAttributes styleAtt = this.getFontStyle(miniFont, m_crText);
            if ((m_uAlignFlag & 1L) == 1L) {
                styleAtt.setVerticalAlign(Styles.VerticalAlignment.TOP);
            }
            if ((m_uAlignFlag & 0x20L) == 32L) {
                styleAtt.setVerticalAlign(Styles.VerticalAlignment.BOTTOM);
            }
            if ((m_uAlignFlag & 2L) == 2L) {
                styleAtt.setHorizontalAlign(Styles.HorizontalAlignment.LEFT);
            }
            if ((m_uAlignFlag & 8L) == 8L) {
                styleAtt.setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            }
            ShareStyleAttributes sharestyle = ((Cell)obj).getStyles();
            ShareStyleAttributes[] aSharestyle = new ShareStyleAttributes[]{Styles.getSSA((StyleAttributes)styleAtt), sharestyle};
            ((Cell)obj).setStyles(Styles.mergeSSA((ShareStyleAttributes[])aSharestyle));
            Data data = new Data();
            ((Cell)obj).setData(data);
            if (m_szQuery.trim().length() > 0) {
                ((Cell)obj).setType("field");
                this.getVecFld().add(m_szQuery);
                QueryColumn col = null;
                Object[] objs = this.getMetaField(m_szQuery);
                if (objs != null) {
                    col = (QueryColumn)objs[1];
                }
                if (col == null) {
                    ((Cell)obj).getData().setFormat(m_szQuery);
                } else {
                    ((Cell)obj).getData().setFormat(col.getProgramID());
                }
                ((IXmlElement)((Cell)obj).getUserObject()).setAttribute("text", m_szQuery);
            } else {
                ((Cell)obj).setType("constant");
                ((Cell)obj).getData().setFormat(m_szText);
            }
        }
        this.cout("", "=============translate_Text(end)", inset);
    }

    private StyleAttributes getFontStyle(MiniFont miniFont, Color m_crText) {
        StyleAttributes styleAtt = Styles.getEmptySA();
        int size = (int)((double)Math.abs(miniFont.miHeight) * 72.0 / 254.0 + 0.5);
        styleAtt.setFontName(miniFont.miFaceName);
        styleAtt.setFontSize(size);
        styleAtt.setFontColor(m_crText);
        if ((miniFont.miFlags & 1) == 1) {
            styleAtt.setItalic(true);
        }
        if ((miniFont.miFlags & 2) == 2) {
            styleAtt.setUnderline(true);
        }
        if ((miniFont.miFlags & 4) == 4) {
            styleAtt.setStrikeThrough(true);
        }
        if ((miniFont.miFlags & 8) == 8) {
            styleAtt.setBold(true);
            styleAtt.setWeight(700.0f);
        } else {
            styleAtt.setWeight(400.0f);
        }
        return styleAtt;
    }

    private MiniFont translate_MiniFont(DataInputStream ndfDataStream, int inset) throws IOException {
        this.cout("", "=============translate_MiniFont(begin)", inset);
        MiniFont miniFont = new MiniFont();
        miniFont.miFlags = this.readbyte(ndfDataStream);
        this.cout("miFlags=", miniFont.miFlags, inset);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        miniFont.iFaceLen = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout("iFaceLen=", miniFont.iFaceLen, inset);
        byte[] b = new byte[(int)miniFont.iFaceLen];
        this.lByteHasBeenRead += (long)b.length;
        miniFont.miFaceName = new String(b, StandardCharsets.UTF_8);
        this.cout("miFaceName=", miniFont.miFaceName, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        miniFont.miHeight = this.convertByte2long(b1, b2, b3, b4);
        this.cout("miHeight=", miniFont.miHeight, inset);
        miniFont.miCharSet = this.convertByte2UINT(ndfDataStream.readByte(), (byte)0);
        ++this.lByteHasBeenRead;
        this.cout("miCharSet=", miniFont.miCharSet, inset);
        this.cout("", "=============translate_MiniFont(end)", inset);
        return miniFont;
    }

    private void translate_Rect(DataInputStream ndfDataStream, int inset, Object obj, Container parent) throws IOException {
        this.cout("", "=============translate_Rect(begin)", inset);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        long m_left = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("rectLeft", "\u77e9\u5f62\u7684left="), m_left, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_top = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("rectTop", "\u77e9\u5f62\u7684top="), m_top, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_right = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("rectRight", "\u77e9\u5f62\u7684right="), m_right, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_bottom = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("rectBottom", "\u77e9\u5f62\u7684bottom="), m_bottom, inset);
        byte m_btType = this.readbyte(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("objectType", "\u7269\u4f53\u7c7b\u578b="), m_btType, inset);
        byte m_btPosBase = this.readbyte(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("positionReferenceType", "\u4f4d\u7f6e\u57fa\u51c6\u7684\u7c7b\u578b="), m_btPosBase, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long m_uFlags = b1;
        this.cout(CtrlKDFMessages.getMLS("borderOrFillFlag", "\u672b\u5c3e\u4e24\u4f4d\u8868\u793a\u662f\u5426\u6709\u8fb9\u6846\u6216\u586b\u51450000 0011="), m_uFlags, inset);
        this.cout(CtrlKDFMessages.getMLS("borderOrFillFlag", "\u672b\u5c3e\u4e24\u4f4d\u8868\u793a\u662f\u5426\u6709\u8fb9\u6846\u6216\u586b\u51450000 0011="), Integer.toBinaryString(b1), inset);
        byte m_btLayerIndex = this.readbyte(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("layerOfObject", "\u7269\u4f53\u6240\u5728\u7684\u5c42="), m_btLayerIndex, inset);
        if (obj instanceof Container) {
            ((Container)obj).getLeft().setOriginString(String.valueOf(m_left));
            ((Container)obj).getTop().setOriginString(String.valueOf(m_top));
            ((Container)obj).getRight().setOriginString(String.valueOf(m_right));
            ((Container)obj).getBottom().setOriginString(String.valueOf(m_bottom));
            ((Container)obj).setLayer(String.valueOf(m_btLayerIndex + 1));
        }
        byte m_btListID = this.readbyte(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("linkedListID", "\u6240\u5c5e\u94fe\u8868\u7684ID="), m_btListID, inset);
        String m_szNameID = this.getString(ndfDataStream);
        this.cout(CtrlKDFMessages.getMLS("objectName(mustBeUnique)", CtrlKDFMessages.getMLS("objectName(mustBeUnique)", CtrlKDFMessages.getMLS("objectName(mustBeUnique)", CtrlKDFMessages.getMLS("objectName(mustBeUnique)", "\u7269\u4f53\u540d\u5b57(\u5fc5\u987b\u552f\u4e00)=")))), m_szNameID, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        Color crFill = this.convertByte2Color(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("rectColor", "\u77e9\u5f62\u989c\u8272="), crFill.toString(), inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long lopnStyle = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout("LOGPEN.lopnStyle=", lopnStyle, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long pointX = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout("LOGPEN.POINT.X=", pointX, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long pointY = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout("LOGPEN.POINT.Y=", pointY, inset);
        int lineWidth = (int)((double)pointX / 2.5);
        lineWidth = lineWidth == 0 ? 1 : lineWidth;
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        Color lopnColor = this.convertByte2Color(b1, b2, b3, b4);
        this.cout("LOGPEN.lopnColor=", lopnColor.toString(), inset);
        if (obj != null && parent != null) {
            StyleAttributes styleAtt = Styles.getEmptySA();
            if ((m_uFlags & 1L) == 1L) {
                styleAtt.setBackground(crFill);
            }
            if ((m_uFlags & 2L) == 2L) {
                LineStyle ls = lineWidth == 1 ? LineStyle.SINGLE_LINE : LineStyle.DOUBLE_LINE_B;
                styleAtt.setBorderColor(Styles.Position.LEFT, lopnColor);
                styleAtt.setBorderLineStyle(Styles.Position.LEFT, ls);
                styleAtt.setBorderColor(Styles.Position.TOP, lopnColor);
                styleAtt.setBorderLineStyle(Styles.Position.TOP, ls);
                styleAtt.setBorderColor(Styles.Position.RIGHT, lopnColor);
                styleAtt.setBorderLineStyle(Styles.Position.RIGHT, ls);
                styleAtt.setBorderColor(Styles.Position.BOTTOM, lopnColor);
                styleAtt.setBorderLineStyle(Styles.Position.BOTTOM, ls);
                switch ((int)lopnStyle) {
                    case 0: {
                        styleAtt.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_SOLID);
                        styleAtt.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_SOLID);
                        styleAtt.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_SOLID);
                        styleAtt.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_SOLID);
                        break;
                    }
                    case 1: {
                        styleAtt.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_DOT);
                        styleAtt.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_DOT);
                        styleAtt.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_DOT);
                        styleAtt.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_DOT);
                        break;
                    }
                    case 2: {
                        styleAtt.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_CONTINUOUS);
                        styleAtt.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_CONTINUOUS);
                        styleAtt.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_CONTINUOUS);
                        styleAtt.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_CONTINUOUS);
                        break;
                    }
                    case 3: {
                        styleAtt.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_DASHDOTDOT);
                        styleAtt.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_DASHDOTDOT);
                        styleAtt.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_DASHDOTDOT);
                        styleAtt.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_DASHDOTDOT);
                        break;
                    }
                    case 4: {
                        styleAtt.setBorderPenStyle(Styles.Position.LEFT, PenStyle.PS_DASHDOT);
                        styleAtt.setBorderPenStyle(Styles.Position.TOP, PenStyle.PS_DASHDOT);
                        styleAtt.setBorderPenStyle(Styles.Position.RIGHT, PenStyle.PS_DASHDOT);
                        styleAtt.setBorderPenStyle(Styles.Position.BOTTOM, PenStyle.PS_DASHDOT);
                        break;
                    }
                    case 5: {
                        styleAtt.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
                        break;
                    }
                    case 6: {
                        styleAtt.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
                        break;
                    }
                    default: {
                        styleAtt.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                        styleAtt.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
                        break;
                    }
                }
            } else {
                styleAtt.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                styleAtt.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                styleAtt.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                styleAtt.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
            }
            ((Container)obj).setStyles(Styles.getSSA((StyleAttributes)styleAtt));
            String left = String.valueOf(m_left);
            String width = String.valueOf(m_right - m_left);
            String top = String.valueOf(m_top);
            String height = String.valueOf(m_bottom - m_top);
            GDI_Rect parentPanel = new GDI_Rect(parent);
            if (parent != this.outPanel) {
                left = String.valueOf(m_left - (long)parentPanel.left);
                top = String.valueOf(m_top - (long)parentPanel.top);
            }
            ((Container)obj).setUserObject(this.translateDesignedNode((IXmlElement)((Container)obj).getUserObject(), obj, parent.getId(), left, width, top, height, true));
        }
        this.cout("", "=============translate_Rect(end)", inset);
    }

    private IXmlElement translateDesignedNode(IXmlElement designedNode, Object obj, String parentId, String left, String right, String top, String bottom, boolean isAbsolute) {
        String tagName = "DesignedCell";
        if (obj instanceof Area) {
            tagName = "DesignedArea";
        } else if (obj instanceof Panel) {
            tagName = "DesignedPanel";
        }
        IXmlElement node = designedNode == null ? XmlUtil.createNode((String)tagName) : designedNode;
        node.setAttribute("locked", "false");
        node.setAttribute("leftLocationType", "relative");
        node.setAttribute("leftRelativeObjID", parentId);
        node.setAttribute("leftRelativeBorder", "left");
        node.setAttribute("leftRelativeOffset", left);
        node.setAttribute("rightLocationType", "relative");
        if (isAbsolute) {
            node.setAttribute("rightRelativeObjID", ((Container)obj).getId());
            node.setAttribute("rightRelativeBorder", "left");
        } else {
            node.setAttribute("rightRelativeObjID", parentId);
            node.setAttribute("rightRelativeBorder", "right");
        }
        node.setAttribute("rightRelativeOffset", right);
        node.setAttribute("topLocationType", "relative");
        node.setAttribute("topRelativeObjID", parentId);
        node.setAttribute("topRelativeBorder", "top");
        node.setAttribute("topRelativeOffset", top);
        node.setAttribute("bottomLocationType", "relative");
        if (isAbsolute) {
            node.setAttribute("bottomRelativeObjID", ((Container)obj).getId());
            node.setAttribute("bottomRelativeBorder", "top");
        } else {
            node.setAttribute("bottomRelativeObjID", parentId);
            node.setAttribute("bottomRelativeBorder", "bottom");
        }
        node.setAttribute("bottomRelativeOffset", bottom);
        return node;
    }

    private void translate_HeadFoot(DataInputStream ndfDataStream, double dfVersion, int inset) throws IOException {
        this.cout("", "=============translate_HeadFoot(begin)", inset);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        long m_bInMargin = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("withinLeftAndRightMargins", "\u662f\u5426\u5728\u5de6\u53f3\u9875\u8fb9\u8ddd\u8303\u56f4\u5185="), m_bInMargin, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long bHead = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("hasPageHeader", "\u662f\u5426\u6709\u9875\u5934="), bHead, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        b3 = this.readbyte(ndfDataStream);
        b4 = this.readbyte(ndfDataStream);
        long bFoot = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("hasPageFooter", "\u662f\u5426\u6709\u9875\u811a="), bFoot, inset);
        if (bHead == 1L) {
            String m_szHead = this.getString(ndfDataStream);
            this.cout(CtrlKDFMessages.getMLS("headerText", "\u9875\u7709\u6587\u672c="), m_szHead, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            Color m_clrHead = this.convertByte2Color(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("fontColor", "\u5b57\u4f53\u989c\u8272="), m_clrHead.toString(), inset);
            MiniFont miniFontHead = this.translate_MiniFont(ndfDataStream, inset);
            if (dfVersion >= 2.3) {
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                long m_nMarginHead = this.convertByte2UINT(b1, b2, b3, b4);
                this.cout(CtrlKDFMessages.getMLS("marginDistance", "\u8ddd\u8fb9\u754c="), m_nMarginHead, inset);
            }
            this.getKdf().getPrintInfo().setHeaderMargin(80);
            Page hPage = this.getHeadOrFoot(m_szHead, this.getFontStyle(miniFontHead, m_clrHead));
            this.getKdf().addHeader(hPage);
            this.getForm().setHeaderID(hPage.getId());
        }
        if (bFoot == 1L) {
            String m_szFoot = this.getString(ndfDataStream);
            this.cout(CtrlKDFMessages.getMLS("footerText", "\u9875\u811a\u6587\u672c="), m_szFoot, inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            Color m_clrFoot = this.convertByte2Color(b1, b2, b3, b4);
            this.cout(CtrlKDFMessages.getMLS("fontColor", "\u5b57\u4f53\u989c\u8272="), m_clrFoot.toString(), inset);
            MiniFont miniFontFoot = this.translate_MiniFont(ndfDataStream, inset);
            if (dfVersion >= 2.3) {
                b1 = this.readbyte(ndfDataStream);
                b2 = this.readbyte(ndfDataStream);
                b3 = this.readbyte(ndfDataStream);
                b4 = this.readbyte(ndfDataStream);
                long m_nMarginFoot = this.convertByte2UINT(b1, b2, b3, b4);
                this.cout(CtrlKDFMessages.getMLS("marginDistance", "\u8ddd\u8fb9\u754c="), m_nMarginFoot, inset);
            }
            this.getKdf().getPrintInfo().setFooterMargin(80);
            Page fPage = this.getHeadOrFoot(m_szFoot, this.getFontStyle(miniFontFoot, m_clrFoot));
            this.getKdf().addFooter(fPage);
            this.getForm().setFooterID(fPage.getId());
        }
        this.cout("", "=============translate_HeadFoot(end)", inset);
    }

    private String translateSpecailChar(String strIn) {
        strIn = strIn.replaceAll("&P", "&[Page]");
        strIn = strIn.replaceAll("&p", "&[Page]");
        strIn = strIn.replaceAll("&S", "&[PageCount]");
        strIn = strIn.replaceAll("&s", "&[PageCount]");
        strIn = strIn.replaceAll("&D", "&[Date]");
        strIn = strIn.replaceAll("&d", "&[Date]");
        strIn = strIn.replaceAll("&T", "&[Time]");
        strIn = strIn.replaceAll("&t", "&[Time]");
        return strIn;
    }

    private Page getHeadOrFoot(String strFormat, StyleAttributes styleAtt) {
        HeadFootModel model = new HeadFootModel();
        model.addRow(this.translateSpecailChar(strFormat));
        return HeadFootParser.parseModel2HeadFootPage(model);
    }

    private long translate_Layer(DataInputStream ndfDataStream, LinkedList lnkLayer, int inset) throws IOException {
        long listCount;
        this.cout("", "=============translate_Layer(begin)", inset);
        byte b1 = this.readbyte(ndfDataStream);
        byte b2 = this.readbyte(ndfDataStream);
        byte b3 = this.readbyte(ndfDataStream);
        byte b4 = this.readbyte(ndfDataStream);
        long m_nCurIndex = this.convertByte2UINT(b1, b2, b3, b4);
        this.cout(CtrlKDFMessages.getMLS("layerNumber", "\u5c42\u53f7="), m_nCurIndex, inset);
        b1 = this.readbyte(ndfDataStream);
        b2 = this.readbyte(ndfDataStream);
        if (b1 != -1 && b2 != -1) {
            listCount = this.convertByte2UINT(b1, b2);
        } else {
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            listCount = this.convertByte2UINT(b1, b2, b3, b4);
        }
        this.cout(CtrlKDFMessages.getMLS("linkedListCount", "\u94fe\u8868\u4e2a\u6570="), listCount, inset);
        int i = 0;
        while ((long)i < listCount) {
            LayerInfo Li = new LayerInfo();
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            Li.setM_uLayerFlag(this.convertByte2UINT(b1, b2, b3, b4));
            this.cout(CtrlKDFMessages.getMLS("layerFlag", "\u5c42\u7684\u6807\u5fd7="), Li.getM_uLayerFlag(), inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            Li.setM_crText(this.convertByte2Color(b1, b2, b3, b4));
            this.cout(CtrlKDFMessages.getMLS("textColor2", "\u6587\u672c\u989c\u8272="), Li.getM_crText().toString(), inset);
            b1 = this.readbyte(ndfDataStream);
            b2 = this.readbyte(ndfDataStream);
            b3 = this.readbyte(ndfDataStream);
            b4 = this.readbyte(ndfDataStream);
            Li.setM_crLine(this.convertByte2Color(b1, b2, b3, b4));
            this.cout(CtrlKDFMessages.getMLS("lineColor", "\u7ebf\u989c\u8272="), Li.getM_crLine().toString(), inset);
            lnkLayer.add(Li);
            ++i;
        }
        this.cout("", "=============translate_Layer(end)", inset);
        return listCount;
    }

    private Color convertByte2Color(byte b1, byte b2, byte b3, byte b4) {
        return new Color((int)this.convertNegativeByte2UINT(b1), (int)this.convertNegativeByte2UINT(b2), (int)this.convertNegativeByte2UINT(b3));
    }

    public NDFFile2KDFObj() {
    }

    public NDFFile2KDFObj(String NDFFile) {
        this._NDFFile = NDFFile;
    }

    @Override
    public KDF getKdf() {
        if (this._kdf == null) {
            this._kdf = new KDF();
            this._kdf.addForm(this.getForm());
        }
        return this._kdf;
    }

    public void setKdf(KDF kdf) {
        this._kdf = kdf;
    }

    public String getNDFFile() {
        return this._NDFFile;
    }

    public void setNDFFile(String file) {
        this._NDFFile = file;
    }

    public String getStrErr() {
        return this._strErr;
    }

    public boolean isDEBUG() {
        return this.DEBUG;
    }

    public void setDEBUG(boolean debug) {
        this.DEBUG = debug;
    }

    public Form getForm() {
        if (this._form == null) {
            this._form = new Form();
            this._form.setId("form" + this.index++);
            String alias = this._form.getId();
            if (!StringUtil.isEmptyString((String)this.getNDFFile())) {
                int fileName = this.getNDFFile().lastIndexOf(92) + 1;
                if (fileName == 0) {
                    fileName = this.getNDFFile().lastIndexOf(47) + 1;
                }
                int extName = this.getNDFFile().indexOf(".ndf");
                if (fileName != 0 && extName > fileName) {
                    alias = this.getNDFFile().substring(fileName, extName);
                }
            }
            this._form.setUserAlias(alias);
            this._form.getPages().add(this.getPage());
        }
        return this._form;
    }

    public void setForm(Form _form) {
        this._form = _form;
    }

    public Page getPage() {
        if (this._page == null) {
            this._page = new Page();
            this._page.setId("page" + this.index++);
            this._page.setUserAlias(this._page.getId());
            this._page.setRepeat(-1);
        }
        return this._page;
    }

    public void setPage(Page _page) {
        this._page = _page;
    }

    public DataSource getSource() {
        if (this.source == null) {
            this.source = this.isDEBUG() ? new JDBCDataSource("KDNoteDataSource", "") : new BOSQueryDataSource("KDNoteDataSource", "pk", "BOSQuery");
            this.getKdf().addDataSource(this.source);
        }
        return this.source;
    }

    public void setSource(DataSource source) {
        this.source = source;
    }

    public Vector getVecFld() {
        if (this.vecFld == null) {
            this.vecFld = new Vector(0);
        }
        return this.vecFld;
    }

    public void setVecFld(Vector vecFld) {
        this.vecFld = vecFld;
    }

    public boolean isSaveAKDF() {
        return this.saveAKDF;
    }

    public void setSaveAKDF(boolean saveAKDF) {
        this.saveAKDF = saveAKDF;
    }

    private static class MiniFont {
        byte miFlags;
        long iFaceLen;
        String miFaceName;
        long miHeight;
        long miCharSet;

        private MiniFont() {
        }
    }

    private static class GDI_Rect {
        int left = 0;
        int top = 0;
        int width = 0;
        int height = 0;
        String sLeft = "0";
        String sTop = "0";
        String sRight = "0";
        String sBottom = "0";

        GDI_Rect(Container container) {
            this.sLeft = container.getLeft().getOriginString();
            this.sTop = container.getTop().getOriginString();
            this.sRight = container.getRight().getOriginString();
            this.sBottom = container.getBottom().getOriginString();
            this.left = Integer.parseInt(this.sLeft);
            this.top = Integer.parseInt(this.sTop);
            this.width = Integer.parseInt(this.sRight) - this.left;
            this.height = Integer.parseInt(this.sBottom) - this.top;
        }
    }

    private static class LayerInfo {
        long m_uLayerFlag;
        Color m_crText;
        Color m_crLine;

        private LayerInfo() {
        }

        public Color getM_crLine() {
            return this.m_crLine;
        }

        public void setM_crLine(Color line) {
            this.m_crLine = line;
        }

        public Color getM_crText() {
            return this.m_crText;
        }

        public void setM_crText(Color text) {
            this.m_crText = text;
        }

        public long getM_uLayerFlag() {
            return this.m_uLayerFlag;
        }

        public void setM_uLayerFlag(long layerFlag) {
            this.m_uLayerFlag = layerFlag;
        }
    }
}

