/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.form.Cell;
import com.kingdee.cosmic.ctrl.kdf.form.Container;
import com.kingdee.cosmic.ctrl.kdf.form.Data;
import com.kingdee.cosmic.ctrl.kdf.form.Form;
import com.kingdee.cosmic.ctrl.kdf.form.Page;
import com.kingdee.cosmic.ctrl.kdf.form.PageCollection;
import com.kingdee.cosmic.ctrl.kdf.formbrowser2.util.CellImageCreator;
import com.kingdee.cosmic.ctrl.kdf.kds.ICells;
import com.kingdee.cosmic.ctrl.kdf.kds.IColumns;
import com.kingdee.cosmic.ctrl.kdf.kds.IMerges;
import com.kingdee.cosmic.ctrl.kdf.kds.IRows;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.util.Rect;
import com.kingdee.cosmic.ctrl.kdf.util.SingleChildContainer;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public final class TransForm {
    private static final Logger logger = LogUtil.getPackageLogger(TransForm.class);
    private static final int LOWESTPRECISION = 1;
    private int prec = 1;
    private int halfprec = this.prec / 2;
    private static TransForm tf = new TransForm();

    protected TransForm() {
    }

    protected TransForm(int precision) {
        this.setPrecision(precision);
    }

    private void addCuts(List xCuts, List yCuts, Object o) {
        this.addCuts(xCuts, yCuts, o, 0, 0);
    }

    private void addCuts(List xCuts, List yCuts, Object o, int px, int py) {
        Container element = (Container)o;
        Rect rc = new Rect();
        Integer cut = null;
        rc.x1 = this.snap(element.getLeft().getInteger() + px);
        rc.y1 = this.snap(element.getTop().getInteger() + py);
        rc.x2 = this.snap(element.getRight().getInteger() + px);
        rc.y2 = this.snap(element.getBottom().getInteger() + py);
        cut = rc.x1;
        if (!xCuts.contains(cut)) {
            xCuts.add(cut);
        }
        if (!xCuts.contains(cut = Integer.valueOf(rc.x2))) {
            xCuts.add(cut);
        }
        if (!yCuts.contains(cut = Integer.valueOf(rc.y1))) {
            yCuts.add(cut);
        }
        if (!yCuts.contains(cut = Integer.valueOf(rc.y2))) {
            yCuts.add(cut);
        }
        Iterator it = element.iterator();
        while (it.hasNext()) {
            this.addCuts(xCuts, yCuts, it.next(), px, py);
        }
    }

    private boolean hasChildren(Container elems) {
        return elems.iterator().hasNext();
    }

    private void setParentsStyle(ICells cells, KDSCell defaultCell, Rect rc, ShareStyleAttributes ssa, Style style) {
        int yi = 0;
        int xi = 0;
        KDSCell cell = null;
        StyleAttributes sa = null;
        for (yi = rc.y1; yi <= rc.y2; ++yi) {
            for (xi = rc.x1; xi <= rc.x2; ++xi) {
                cell = cells.getCell(yi, xi, false);
                if (cell != defaultCell) continue;
                sa = Styles.getSA((ShareStyleAttributes)ssa);
                sa.append((ShareStyleAttributes)style, false);
                if (xi != rc.x1) {
                    sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                }
                if (xi != rc.x2) {
                    sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                }
                if (yi != rc.y1) {
                    sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                }
                if (yi != rc.y2) {
                    sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
                }
                cells.setCell(yi, xi, null, Styles.getSSA((StyleAttributes)sa));
            }
        }
    }

    private void setChildStyle(ICells cells, Rect rc, ShareStyleAttributes ssa, Style style) {
        int yi = 0;
        int xi = 0;
        StyleAttributes sa = null;
        for (yi = rc.y1; yi <= rc.y2; ++yi) {
            for (xi = rc.x1; xi <= rc.x2; ++xi) {
                sa = Styles.getSA((ShareStyleAttributes)ssa);
                sa.append((ShareStyleAttributes)style, false);
                if (xi != rc.x1) {
                    sa.setBorderLineStyle(Styles.Position.LEFT, LineStyle.NULL_LINE);
                }
                if (xi != rc.x2) {
                    sa.setBorderLineStyle(Styles.Position.RIGHT, LineStyle.NULL_LINE);
                }
                if (yi != rc.y1) {
                    sa.setBorderLineStyle(Styles.Position.TOP, LineStyle.NULL_LINE);
                }
                if (yi != rc.y2) {
                    sa.setBorderLineStyle(Styles.Position.BOTTOM, LineStyle.NULL_LINE);
                }
                cells.setCell(yi, xi, null, Styles.getSSA((StyleAttributes)sa));
            }
        }
    }

    private boolean getUnoverlap(ICells cells, Rect rc) {
        int yi = 0;
        int xi = 0;
        int x2max = rc.x2;
        int y2max = rc.y2;
        boolean xext = false;
        boolean yext = false;
        boolean done = false;
        block0: for (yi = rc.y1; yi <= rc.y2; ++yi) {
            for (xi = rc.x1; xi <= rc.x2; ++xi) {
                if (cells.getCell(yi, xi, false).isMerged()) continue;
                xext = true;
                yext = true;
                done = true;
                break block0;
            }
        }
        rc.x1 = xi;
        rc.y1 = yi;
        rc.x2 = rc.x1;
        rc.y2 = rc.y1;
        while (xext || yext) {
            if (xext) {
                if (rc.x2 < x2max) {
                    xi = rc.x2 + 1;
                    for (yi = rc.y1; yi <= rc.y2; ++yi) {
                        if (!cells.getCell(yi, xi, false).isMerged()) continue;
                        xext = false;
                    }
                    if (xext) {
                        ++rc.x2;
                    }
                } else {
                    xext = false;
                }
            }
            if (!yext) continue;
            if (rc.y2 < y2max) {
                yi = rc.y2 + 1;
                for (xi = rc.x1; xi <= rc.x2; ++xi) {
                    if (!cells.getCell(yi, xi, false).isMerged()) continue;
                    yext = false;
                }
                if (!yext) continue;
                ++rc.y2;
                continue;
            }
            yext = false;
        }
        return done;
    }

    private Object getElementData(Container element) {
        Data cellData;
        Cell cell;
        Object ret = null;
        if (element instanceof Cell && (ret = CellImageCreator.getImageOf(cell = (Cell)element)) == null && (cellData = cell.getData()) != null) {
            ret = cellData.getFormat();
        }
        return ret;
    }

    private void mergeOverlap(ICells cells, IMerges merges, Container element, Rect rc, Object data, ShareStyleAttributes ssa, Style style) {
        if (rc.x1 == rc.x2 && rc.y1 == rc.y2) {
            cells.setCell(rc.y1, rc.x1, data, ssa);
        } else if (rc.x2 < rc.x1 || rc.y2 < rc.y1) {
            if (rc.x2 + 1 >= rc.x1 && rc.y2 + 1 < rc.y1) {
                // empty if block
            }
        } else if (KDSMergeBlock.NULL_MERGE != merges.addMerge(rc.y1, rc.x1, rc.y2, rc.x2)) {
            this.setChildStyle(cells, rc, ssa, style);
            cells.setCellValue(rc.y1, rc.x1, data);
        }
    }

    private ShareStyleAttributes getElementSSA(Container e) {
        ArrayList<ShareStyleAttributes> lssa = new ArrayList<ShareStyleAttributes>();
        do {
            lssa.add(e.getCustomStyles().getStyleAttributes());
            lssa.add(e.getStyles());
        } while ((e = e.getParent()) != null);
        ShareStyleAttributes[] assa = new ShareStyleAttributes[lssa.size()];
        lssa.toArray(assa);
        return Styles.mergeSSA((ShareStyleAttributes[])assa);
    }

    private Rect getElementRect(List xCuts, List yCuts, Container element, int px, int py) {
        Rect rc = new Rect();
        rc.x1 = this.snap(element.getLeft().getInteger() + px);
        rc.y1 = this.snap(element.getTop().getInteger() + py);
        rc.x2 = this.snap(element.getRight().getInteger() + px);
        rc.y2 = this.snap(element.getBottom().getInteger() + py);
        rc.Normalize();
        rc.x1 = xCuts.indexOf(rc.x1);
        rc.y1 = yCuts.indexOf(rc.y1);
        rc.x2 = -1 + xCuts.indexOf(rc.x2);
        rc.y2 = -1 + yCuts.indexOf(rc.y2);
        return rc;
    }

    private void layoutChildren(List xCuts, List yCuts, ICells cells, IMerges merges, KDSCell defaultCell, Container elems, int px, int py) {
        Container element = null;
        Rect rc = null;
        ShareStyleAttributes ssa = null;
        Style style = null;
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            element = (Container)it.next();
            rc = this.getElementRect(xCuts, yCuts, element, px, py);
            ssa = this.getElementSSA(element);
            style = Styles.getStyle((ShareStyleAttributes)ssa);
            if (this.hasChildren(element)) {
                this.layoutChildren(xCuts, yCuts, cells, merges, defaultCell, element, px, py);
                this.setParentsStyle(cells, defaultCell, rc, ssa, style);
                continue;
            }
            KDSCell cell = cells.getCell(rc.y1, rc.x1, false);
            Object data = this.getElementData(element);
            if (rc.x1 == rc.x2 && rc.y1 == rc.y2) {
                if (cell != defaultCell) {
                    // empty if block
                }
                cells.setCell(rc.y1, rc.x1, data, ssa);
                continue;
            }
            if (rc.x2 < rc.x1 || rc.y2 < rc.y1) {
                if (rc.x2 + 1 < rc.x1 || rc.y2 + 1 >= rc.y1) continue;
                continue;
            }
            if (KDSMergeBlock.NULL_MERGE == merges.addMerge(rc.y1, rc.x1, rc.y2, rc.x2)) {
                if (!this.getUnoverlap(cells, rc)) continue;
                this.mergeOverlap(cells, merges, element, rc, data, ssa, style);
                continue;
            }
            this.setChildStyle(cells, rc, ssa, style);
            cells.setCellValue(rc.y1, rc.x1, data);
        }
    }

    public static KDSSheet toSheet(Form form) {
        return TransForm.toSheet(form, 1);
    }

    protected KDSSheet pageToSheet(Page page) {
        KDSSheet sheet = new KDSSheet(null, page.getId() + "(" + page.getIndex() + ")");
        KDSCell defaultCell = sheet.getDefaultCell();
        ICells cells = sheet.getCells();
        IMerges merges = sheet.getMerges();
        ArrayList xCuts = new ArrayList();
        ArrayList yCuts = new ArrayList();
        this.addCuts(xCuts, yCuts, page);
        Collections.sort(xCuts);
        Collections.sort(yCuts);
        float old = 0.0f;
        float now = 0.0f;
        int xCellCount = xCuts.size() - 1;
        int yCellCount = yCuts.size() - 1;
        IColumns cols = sheet.getColumns();
        now = ((Integer)xCuts.get(0)).intValue();
        for (int i = 0; i < xCellCount; ++i) {
            old = now;
            now = ((Integer)xCuts.get(i + 1)).intValue();
            cols.setColumnWidth(i, (now - old) / 10.0f);
        }
        IRows rows = sheet.getRows();
        now = ((Integer)yCuts.get(0)).intValue();
        for (int i = 0; i < yCellCount; ++i) {
            old = now;
            now = ((Integer)yCuts.get(i + 1)).intValue();
            rows.setRowHeight(i, (now - old) / 10.0f);
        }
        this.layoutChildren(xCuts, yCuts, cells, merges, defaultCell, new SingleChildContainer(page));
        return sheet;
    }

    protected KDSSheet formToSheet(Form form, int pageSpace) {
        PageCollection coll = form.getOutputPages();
        if (coll == null) {
            return null;
        }
        KDSSheet sheet = new KDSSheet(null, form.getId());
        KDSCell defaultCell = sheet.getDefaultCell();
        ICells cells = sheet.getCells();
        IMerges merges = sheet.getMerges();
        ArrayList xCuts = new ArrayList();
        ArrayList yCuts = new ArrayList();
        Page page2 = null;
        int py = 0;
        for (Page page2 : coll) {
            this.addCuts(xCuts, yCuts, page2, 0, py);
            py += page2.getBottom().getInteger();
            py += pageSpace;
        }
        Collections.sort(xCuts);
        Collections.sort(yCuts);
        float old = 0.0f;
        float now = 0.0f;
        int xCellCount = xCuts.size() - 1;
        int yCellCount = yCuts.size() - 1;
        IColumns cols = sheet.getColumns();
        now = ((Integer)xCuts.get(0)).intValue();
        for (int i = 0; i < xCellCount; ++i) {
            old = now;
            now = ((Integer)xCuts.get(i + 1)).intValue();
            cols.setColumnWidth(i, (now - old) / 10.0f);
        }
        IRows rows = sheet.getRows();
        now = ((Integer)yCuts.get(0)).intValue();
        for (int i = 0; i < yCellCount; ++i) {
            old = now;
            now = ((Integer)yCuts.get(i + 1)).intValue();
            rows.setRowHeight(i, (now - old) / 10.0f);
        }
        py = 0;
        for (Page page2 : coll) {
            this.layoutChildren(xCuts, yCuts, cells, merges, defaultCell, new SingleChildContainer(page2), 0, py);
            py += page2.getBottom().getInteger();
            py += pageSpace;
        }
        return sheet;
    }

    protected KDSSheet pageCollectionToSheet(PageCollection coll, int pageSpace) {
        if (coll == null) {
            return null;
        }
        KDSSheet sheet = new KDSSheet(null, "fromPageCollection");
        KDSCell defaultCell = sheet.getDefaultCell();
        ICells cells = sheet.getCells();
        IMerges merges = sheet.getMerges();
        ArrayList xCuts = new ArrayList();
        ArrayList yCuts = new ArrayList();
        Page page2 = null;
        int py = 0;
        for (Page page2 : coll) {
            this.addCuts(xCuts, yCuts, page2, 0, py);
            py += page2.getBottom().getInteger();
            py += pageSpace;
        }
        Collections.sort(xCuts);
        Collections.sort(yCuts);
        float old = 0.0f;
        float now = 0.0f;
        int xCellCount = xCuts.size() - 1;
        int yCellCount = yCuts.size() - 1;
        IColumns cols = sheet.getColumns();
        now = ((Integer)xCuts.get(0)).intValue();
        for (int i = 0; i < xCellCount; ++i) {
            old = now;
            now = ((Integer)xCuts.get(i + 1)).intValue();
            cols.setColumnWidth(i, (now - old) / 10.0f);
        }
        IRows rows = sheet.getRows();
        now = ((Integer)yCuts.get(0)).intValue();
        for (int i = 0; i < yCellCount; ++i) {
            old = now;
            now = ((Integer)yCuts.get(i + 1)).intValue();
            rows.setRowHeight(i, (now - old) / 10.0f);
        }
        py = 0;
        for (Page page2 : coll) {
            this.layoutChildren(xCuts, yCuts, cells, merges, defaultCell, new SingleChildContainer(page2), 0, py);
            py += page2.getBottom().getInteger();
            py += pageSpace;
        }
        return sheet;
    }

    protected KDSSheet containerToSheet(Container container) {
        if (container instanceof SingleChildContainer) {
            container = ((SingleChildContainer)container).getChild();
        }
        if (container == null) {
            return null;
        }
        KDSSheet sheet = new KDSSheet(null, container.getAliasName());
        KDSCell defaultCell = sheet.getDefaultCell();
        ICells cells = sheet.getCells();
        IMerges merges = sheet.getMerges();
        ArrayList xCuts = new ArrayList();
        ArrayList yCuts = new ArrayList();
        this.addCuts(xCuts, yCuts, container);
        Collections.sort(xCuts);
        Collections.sort(yCuts);
        float old = 0.0f;
        float now = 0.0f;
        int xCellCount = xCuts.size() - 1;
        int yCellCount = yCuts.size() - 1;
        IColumns cols = sheet.getColumns();
        now = ((Integer)xCuts.get(0)).intValue();
        for (int i = 0; i < xCellCount; ++i) {
            old = now;
            now = ((Integer)xCuts.get(i + 1)).intValue();
            cols.setColumnWidth(i, (now - old) / 10.0f);
        }
        IRows rows = sheet.getRows();
        now = ((Integer)yCuts.get(0)).intValue();
        for (int i = 0; i < yCellCount; ++i) {
            old = now;
            now = ((Integer)yCuts.get(i + 1)).intValue();
            rows.setRowHeight(i, (now - old) / 10.0f);
        }
        this.layoutChildren(xCuts, yCuts, cells, merges, defaultCell, new SingleChildContainer(container));
        return sheet;
    }

    public static KDSSheet toSheet(Page page) {
        return TransForm.toSheet(page, 1);
    }

    public static KDSSheet toSheet(Page page, int precision) {
        tf.setPrecision(precision);
        return tf.pageToSheet(page);
    }

    protected void setPrecision(int precision) {
        this.prec = precision < 1 ? 1 : precision;
        this.halfprec = this.prec / 2;
    }

    private int snap(int pos) {
        if (this.prec > 1) {
            int x = pos % this.prec;
            if (x > this.halfprec) {
                x -= this.prec;
            }
            pos -= x;
        }
        return pos;
    }

    public static KDSSheet toSheet(Container container) {
        return TransForm.toSheet(container, 1);
    }

    public static KDSSheet toSheet(Container container, int precision) {
        tf.setPrecision(precision);
        return tf.containerToSheet(container);
    }

    public static KDSBook toBook(Form form, int precision) {
        PageCollection coll = form.getOutputPages();
        if (coll == null) {
            return null;
        }
        KDSBook book = new KDSBook(form.getId());
        Page page2 = null;
        for (Page page2 : coll) {
            try {
                book.addSheet(null, TransForm.toSheet(page2, precision));
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return book;
    }

    public static KDSSheet toSheet(Form form, int precision) {
        int pageSpace = 20;
        tf.setPrecision(precision);
        return tf.formToSheet(form, pageSpace);
    }

    public static KDSSheet toSheet(PageCollection coll) {
        return TransForm.toSheet(coll, 1);
    }

    public static KDSSheet toSheet(PageCollection coll, int precision) {
        int pageSpace = 20;
        tf.setPrecision(precision);
        return tf.pageCollectionToSheet(coll, pageSpace);
    }

    public static KDSBook toBook(Form form) {
        return TransForm.toBook(form, 1);
    }

    public static KDSBook toBook(PageCollection coll, int precision) {
        if (coll == null) {
            return null;
        }
        KDSBook book = new KDSBook("fromPageCollection");
        Page page2 = null;
        for (Page page2 : coll) {
            try {
                book.addSheet(null, TransForm.toSheet(page2, precision));
            }
            catch (Exception e) {
                logger.error((Object)"err", (Throwable)e);
            }
        }
        return book;
    }

    private void layoutChildren(List xCuts, List yCuts, ICells cells, IMerges merges, KDSCell defaultCell, Container elems) {
        this.layoutChildren(xCuts, yCuts, cells, merges, defaultCell, elems, 0, 0);
    }

    public static KDSBook toBook(PageCollection coll) {
        return TransForm.toBook(coll, 1);
    }
}

