/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.file;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFException;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlException;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class KDFXmlWriter
extends KDFXmlReader {
    private static final Logger logger = LogUtil.getPackageLogger(KDFXmlWriter.class);
    private Writer writer;
    private File file;
    public static final String XML_ENCODING = "UTF-8";

    public KDFXmlWriter() {
    }

    public KDFXmlWriter(String fileName) throws KDFXmlException {
        super(fileName);
    }

    public KDFXmlWriter(Reader reader) {
        super(reader);
    }

    public KDFXmlWriter(InputStream stream) {
        super(stream);
    }

    public KDFXmlWriter(KDFXmlReader reader) throws KDFException {
        this.doc = reader.getDoc();
        this.root = reader.getRoot();
        this.styleNodeBuf = reader.getStyleNodeBuf();
    }

    public void addStyleNode(IXmlElement styleNode) {
        IXmlElement nodeStyles = this.getStylesNode();
        nodeStyles.addChild(styleNode);
        this.styleNodeBuf.put(styleNode.getAttribute("id"), styleNode);
    }

    public void addDataSourceNode(IXmlElement datasourceNode) {
        this.getDataSourcesNode().addChild(datasourceNode);
    }

    public void addDBConnectionNode(IXmlElement dbconnNode) {
        this.getDBConnectionsNode().addChild(dbconnNode);
    }

    public void addParamNode(IXmlElement paramNode) {
        this.getParamsNode().addChild(paramNode);
    }

    public void addHeaderNode(IXmlElement headerNode) {
        this.getHeadersNode().addChild(headerNode);
    }

    public void addFooterNode(IXmlElement footerNode) {
        this.getFootersNode().addChild(footerNode);
    }

    public void addFormNode(IXmlElement formNode) {
        this.getRoot().addChild(formNode);
    }

    public void addTableNode(IXmlElement tableNode) {
        this.getRoot().addChild(tableNode);
    }

    public void addTablePrintSetNode(IXmlElement tableNode) {
        this.getRoot().addChild(tableNode);
    }

    public void addAuthor(String author) {
        IXmlElement nodeDocInfo = this.getDocInfoNode();
        IXmlElement nodeAuthor = XmlUtil.createNode((String)"Author");
        nodeAuthor.addCData(author);
        nodeDocInfo.addChild(nodeAuthor);
    }

    public void addAuthors(String[] authors) {
        for (int i = 0; i < authors.length; ++i) {
            this.addAuthor(authors[i]);
        }
    }

    public void setAuthors(String[] authors) {
        this.getDocInfoNode().removeChild(this.getDocInfoNode().getChild("Author"));
        this.addAuthors(authors);
    }

    public void setCompany(String company) {
        IXmlElement nodeDocInfo;
        IXmlElement nodeCT;
        if (company == null) {
            company = "";
        }
        if (null == (nodeCT = (nodeDocInfo = this.getDocInfoNode()).getChild("Company"))) {
            nodeCT = XmlUtil.createNode((String)"Company");
            nodeDocInfo.addChild(nodeCT);
        }
        nodeCT.addCData(company.trim());
    }

    public void setVersion(String version) {
        this.getRoot().setAttribute("version", version);
    }

    public void setCreatedTime(Date time) {
        this.setCreateTime(time.toString());
    }

    public void setCreateTime(String strTime) {
        IXmlElement nodeDocInfo = this.getDocInfoNode();
        IXmlElement nodeCT = nodeDocInfo.getChild("Created");
        if (null == nodeCT) {
            nodeCT = XmlUtil.createNode((String)"Created");
            nodeDocInfo.addChild(nodeCT);
        }
        nodeCT.addCData(strTime);
    }

    public void setLastModified(String strTime) {
        IXmlElement nodeDocInfo = this.getDocInfoNode();
        IXmlElement nodeCT = nodeDocInfo.getChild("LastModified");
        if (null == nodeCT) {
            nodeCT = XmlUtil.createNode((String)"LastModified");
            nodeDocInfo.addChild(nodeCT);
        }
        nodeCT.addCData(strTime);
    }

    public void setPrintInfo(IXmlElement printInfoNode) {
        this.getRoot().removeChild(this.getRoot().getChild("PrintInfo"));
        this.getRoot().addChild(printInfoNode);
    }

    public void removeAllFormNodes() {
        this.getRoot().removeChild(this.getRoot().getChild("Form"));
    }

    public void removeAllTableNodes() {
        this.getRoot().removeChild(this.getRoot().getChild("Table"));
    }

    public void removeAllTableSet() {
        this.getRoot().removeChild(this.getRoot().getChild("TablePrintSets"));
    }

    public void removeAllStyleNodes() {
        this.getStylesNode().removeChild(this.getStylesNode().getChild("Style"));
    }

    public void removeAllDataSourceNodes() {
        this.getDataSourcesNode().removeChild(this.getStylesNode().getChild("DataSource"));
    }

    public void removeAllDBConnectionNodes() {
        this.getDBConnectionsNode().removeChild(this.getStylesNode().getChild("DBConnection"));
    }

    public void removeAllParamNodes() {
        this.getParamsNode().removeChild(this.getStylesNode().getChild("Param"));
    }

    public void removeAllHeaderNodes() {
        this.getHeadersNode().removeChild(this.getStylesNode().getChild("Header"));
    }

    public void removeAllFooterNodes() {
        this.getFootersNode().removeChild(this.getStylesNode().getChild("Footer"));
    }

    public void save(String fileName) throws KDFException {
        try {
            try {
                this.file = new File(FilenameUtils.normalize((String)fileName));
                if (!this.file.exists() && !this.file.createNewFile()) {
                    logger.warn((Object)(this.file.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
                }
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                XmlUtil.save((IXmlElement)this.getDoc(), (OutputStream)outputStream);
            }
            catch (IOException err) {
                throw new KDFException("Failed writing data to file: " + err.getMessage(), err);
            }
            catch (Exception err) {
                logger.error((Object)"err", (Throwable)err);
            }
            finally {
                if (this.writer != null) {
                    this.getWriter().close();
                }
            }
        }
        catch (IOException e) {
            throw new KDFException("Failed writing data to file: " + e.getMessage(), e);
        }
    }

    public void save(OutputStream os) {
        try {
            XmlUtil.save((IXmlElement)this.getDoc(), (OutputStream)os);
            os.close();
        }
        catch (IOException err) {
            throw new RuntimeException("Write stream error: " + err.getMessage(), err);
        }
        catch (Exception err) {
            logger.error((Object)"err", (Throwable)err);
        }
    }

    public void save(Writer writer) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            XmlUtil.save((IXmlElement)this.getDoc(), (OutputStream)outputStream);
            String content = outputStream.toString(XML_ENCODING);
            writer.write(content, 0, content.length());
        }
        catch (IOException err) {
            throw new RuntimeException("Write file error: " + err.getMessage(), err);
        }
        catch (Exception err) {
            logger.error((Object)"err", (Throwable)err);
        }
    }

    public Writer getWriter() {
        if (this.writer != null) {
            return this.writer;
        }
        try {
            this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), XML_ENCODING);
        }
        catch (IOException err) {
            throw new RuntimeException("Write file [" + this.getFileName() + "] error, can not create FileWriter", err);
        }
        return this.writer;
    }

    public String getFileName() {
        if (this.file != null) {
            return this.file.getName();
        }
        return null;
    }

    public void setUserObjects(IXmlElement userObjectsNode) {
        this.getRoot().removeChild(this.getRoot().getChild("UserObjects"));
        this.getRoot().addChild(userObjectsNode);
    }

    public void addDataObjectNode(IXmlElement dataObjNode) {
        this.getDataObjectsNode().addChild(dataObjNode);
    }

    public void removeAllDataObjectNodes() {
        this.getDataObjectsNode().getChildren().clear();
    }

    public void addElement(IXmlElement e) {
        if (e == null) {
            return;
        }
        this.getRoot().removeChild(this.getRoot().getChild(e.getName()));
        this.getRoot().addChild(e);
    }
}

