/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.printout;

import com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.cosmic.ctrl.kdf.kds.IColumns;
import com.kingdee.cosmic.ctrl.kdf.kds.IRows;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheetPrintSetup;
import com.kingdee.cosmic.ctrl.kdf.util.printout.AbstractPagination;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IndexedPage;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleUtil;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.print.attribute.standard.OrientationRequested;

public final class CommonPagination
extends AbstractPagination {
    public CommonPagination(KDSBook book, double pageWidth, double pageHeight) {
        super(book, pageWidth, pageHeight);
    }

    @Override
    public ArrayList getPages(PrintPage printPage) {
        ArrayList alPages = new ArrayList();
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            alPages.addAll(this.sheetPaginationWrapper(this.book.getSheets().getSheet(i), this.pageWidth, this.pageHeight, printPage));
        }
        return alPages;
    }

    @Override
    public ArrayList getIndexedPages() {
        ArrayList alPages = new ArrayList();
        for (int i = 0; i < this.book.getSheetCount(); ++i) {
            alPages.addAll(this.sheetPagination(this.book.getSheets().getSheet(i), this.pageWidth, this.pageHeight));
        }
        return alPages;
    }

    private ArrayList sheetPaginationWrapper(KDSSheet sheet, double pageWidth, double pageHeight, PrintPage printPage) {
        KDSSheetPrintSetup printSetup = sheet.getPrintSetup();
        if (printSetup == null) {
            printSetup = new KDSSheetPrintSetup();
            sheet.setPrintSetup(printSetup);
        }
        double contentWidth = 0.0;
        double contentHeight = 0.0;
        double right = StyleUtil.inchToMM((double)printSetup.getRight());
        double left = StyleUtil.inchToMM((double)printSetup.getLeft());
        double top = StyleUtil.inchToMM((double)printSetup.getTop());
        double bottom = StyleUtil.inchToMM((double)printSetup.getBottom());
        boolean autoFit = printSetup.isAutoFit();
        if (autoFit) {
            short widthFit = printSetup.getWidthFit();
            short heightFit = printSetup.getHeightFit();
        } else {
            short s = printSetup.getScale();
        }
        boolean landScape = printSetup.isLandScape();
        if (landScape) {
            contentWidth = pageHeight - left - right;
            contentHeight = pageWidth - top - bottom;
            printPage.setOrientation(OrientationRequested.LANDSCAPE);
            return this.sheetPagination(sheet, contentWidth, contentHeight);
        }
        contentWidth = pageWidth - left - right;
        contentHeight = pageHeight - top - bottom;
        printPage.setOrientation(OrientationRequested.PORTRAIT);
        return this.sheetPagination(sheet, contentWidth, contentHeight);
    }

    private ArrayList sheetPagination(KDSSheet sheet, double pageWidth, double pageHeight) {
        ArrayList<IndexedPage> alPages = new ArrayList<IndexedPage>();
        int[] alColDiv = this.getColDiv(sheet, pageWidth);
        int[] alRowDiv = this.getRowDiv(sheet, pageHeight);
        for (int i = 0; i < alRowDiv.length - 1; ++i) {
            for (int j = 0; j < alColDiv.length - 1; ++j) {
                IndexedPage ip = new IndexedPage(sheet, alRowDiv[i], alRowDiv[i + 1], alColDiv[j], alColDiv[j + 1]);
                alPages.add(ip);
            }
        }
        return alPages;
    }

    private int[] getColDiv(KDSSheet sheet, double pageWidth) {
        short scale = sheet.getPrintSetup().getScale();
        int expandedCol = sheet.getSheet().getExpandedColumns();
        ArrayList layer = sheet.getEmbedhLayer();
        int s = layer.size();
        for (int i = 0; i < s; i += 2) {
            Rectangle bounds = (Rectangle)layer.get(i + 1);
            expandedCol = Math.max(expandedCol, bounds.height);
        }
        IColumns colsNow = sheet.getSheet().getColumns();
        ArrayList<Integer> alColDiv = new ArrayList<Integer>();
        double fWidth = 0.0;
        alColDiv.add(0);
        int iLast = 0;
        for (int i = 0; i < expandedCol; ++i) {
            if (!((fWidth += (double)colsNow.getColumnWidth(i)) * (double)scale / 100.0 + 1.0 >= pageWidth + 0.1)) continue;
            if (i == iLast) {
                // empty if block
            }
            iLast = ++i;
            alColDiv.add(i);
            fWidth = colsNow.getColumnWidth(i);
        }
        alColDiv.add(expandedCol + 1);
        Object[] objs = alColDiv.toArray();
        int[] indexes = new int[objs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)objs[i];
        }
        return indexes;
    }

    private int[] getRowDiv(KDSSheet sheet, double pageHeight) {
        short scale = sheet.getPrintSetup().getScale();
        int expandedRow = sheet.getSheet().getExpandedRows();
        ArrayList layer = sheet.getEmbedhLayer();
        int s = layer.size();
        for (int i = 0; i < s; i += 2) {
            Rectangle bounds = (Rectangle)layer.get(i + 1);
            expandedRow = Math.max(expandedRow, bounds.width);
        }
        IRows rowsNow = sheet.getSheet().getRows();
        ArrayList<Integer> alRowDiv = new ArrayList<Integer>();
        alRowDiv.add(0);
        double fHeight = 0.0;
        int iLast = 0;
        for (int i = 0; i < expandedRow; ++i) {
            if (!((fHeight += (double)rowsNow.getRowHeight(i)) * (double)scale / 100.0 >= pageHeight + 0.1)) continue;
            if (i == iLast) {
                // empty if block
            }
            iLast = ++i;
            alRowDiv.add(i);
            fHeight = rowsNow.getRowHeight(i);
        }
        alRowDiv.add(expandedRow + 1);
        Object[] objs = alRowDiv.toArray();
        int[] indexes = new int[objs.length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = (Integer)objs[i];
        }
        return indexes;
    }
}

