/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.printout;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.kds.IColumns;
import com.kingdee.cosmic.ctrl.kdf.kds.IMerges;
import com.kingdee.cosmic.ctrl.kdf.kds.IRows;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSCell;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IndexedPage;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellImageRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.TextRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Border;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public final class PageRender {
    private IndexedPage page;
    private TextRender render;
    private CellImageRender ImageRender;

    public TextRender getRender() {
        if (null == this.render) {
            this.render = new TextRender();
        }
        return this.render;
    }

    public CellImageRender getImageRender() {
        if (null == this.ImageRender) {
            this.ImageRender = new CellImageRender();
        }
        return this.ImageRender;
    }

    public PageRender(IndexedPage page) {
        this.page = page;
    }

    private boolean firstCellOfMergeInPage(KDSMergeBlock theMerges, IndexedPage.PageBlock pb, int row, int col) {
        if (!theMerges.include(row, col)) {
            return false;
        }
        return !(col != pb.getBeginCol() && col != theMerges.col || row != pb.getBeginRow() && row != theMerges.row);
    }

    private boolean isMergeRightSide(IndexedPage.PageBlock pb, int row, int col) {
        IMerges merges = pb.getSheet().getMerges();
        KDSMergeBlock block = merges.getMergeBlock(row, col);
        if (null == block) {
            return false;
        }
        return col == block.getCol2();
    }

    private boolean isMergeBottomSide(IndexedPage.PageBlock pb, int row, int col) {
        IMerges merges = pb.getSheet().getMerges();
        KDSMergeBlock block = merges.getMergeBlock(row, col);
        if (null == block) {
            return false;
        }
        return row == block.getRow2();
    }

    private Border getLeftBorder(IndexedPage.PageBlock pb, int row, int col) {
        IMerges merges = pb.getSheet().getMerges();
        if (merges.isCellMerged(row, col)) {
            return null;
        }
        if (this.isLeftSide(pb, col)) {
            Border border = pb.getSheet().getCells().getCell(row, col, false).getStyle().getBorder(Styles.Position.LEFT);
            return border.isNull() ? null : border;
        }
        return this.getRightBorder(pb, row, col - 1);
    }

    private Border getRightBorder(IndexedPage.PageBlock pb, int row, int col) {
        KDSSheet sheet = pb.getSheet();
        KDSCell cell = sheet.getCells().getCell(row, col, true);
        IMerges merges = sheet.getMerges();
        Border border = null;
        if (merges.isCellMerged(row, col)) {
            if (this.isMergeRightSide(pb, row, col)) {
                border = sheet.getCells().getCell(row, col + 1, true).getStyle().getBorder(Styles.Position.LEFT);
                if (border.isNull()) {
                    border = null;
                }
                if (null == border || this.isRightSide(pb, col)) {
                    KDSMergeBlock block = merges.getMergeBlock(row, col);
                    border = pb.getSheet().getCell(block.row, block.col, true).getStyle().getBorder(Styles.Position.RIGHT);
                    if (border.isNull()) {
                        border = null;
                    }
                    if (null == border && (border = cell.getStyle().getBorder(Styles.Position.RIGHT)).isNull()) {
                        border = null;
                    }
                }
            }
        } else {
            border = cell.getStyle().getBorder(Styles.Position.RIGHT);
            if (border.isNull() && !this.isRightSide(pb, col)) {
                if (!merges.isCellMerged(row, col + 1)) {
                    border = sheet.getCells().getCell(row, col + 1, true).getStyle().getBorder(Styles.Position.LEFT);
                    if (border.isNull()) {
                        border = null;
                    }
                } else {
                    KDSMergeBlock block = merges.getMergeBlock(row, col + 1);
                    border = sheet.getCells().getCell(block.row, block.col, false).getStyle().getBorder(Styles.Position.LEFT);
                    if (border.isNull()) {
                        border = null;
                    }
                }
            }
        }
        return border;
    }

    private Border getTopBorder(IndexedPage.PageBlock pb, int row, int col) {
        KDSSheet sheet = pb.getSheet();
        KDSCell cell = sheet.getCells().getCell(row, col, true);
        IMerges merges = sheet.getMerges();
        if (merges.isCellMerged(row, col)) {
            return null;
        }
        if (this.isTopSide(pb, row)) {
            Border border = cell.getStyle().getBorder(Styles.Position.TOP);
            if (border.isNull()) {
                border = null;
            }
            return border;
        }
        return this.getBottomBorder(pb, row - 1, col);
    }

    private Border getBottomBorder(IndexedPage.PageBlock pb, int row, int col) {
        KDSSheet sheet = pb.getSheet();
        KDSCell cell = sheet.getCells().getCell(row, col, true);
        IMerges merges = sheet.getMerges();
        Border border = null;
        if (merges.isCellMerged(row, col)) {
            if (this.isMergeBottomSide(pb, row, col)) {
                border = sheet.getCells().getCell(row + 1, col, true).getStyle().getBorder(Styles.Position.TOP);
                if (border.isNull()) {
                    border = null;
                }
                if (null == border || this.isBottomSide(pb, row)) {
                    KDSMergeBlock block = merges.getMergeBlock(row, col);
                    border = pb.getSheet().getCell(block.row, block.col, true).getStyle().getBorder(Styles.Position.BOTTOM);
                    if (border.isNull()) {
                        border = null;
                    }
                    if (null == border && (border = cell.getStyle().getBorder(Styles.Position.BOTTOM)).isNull()) {
                        border = null;
                    }
                }
            }
        } else {
            border = cell.getStyle().getBorder(Styles.Position.BOTTOM);
            if (border.isNull() && !this.isBottomSide(pb, row)) {
                if (!merges.isCellMerged(row + 1, col)) {
                    border = sheet.getCells().getCell(row + 1, col, true).getStyle().getBorder(Styles.Position.TOP);
                    if (border.isNull()) {
                        border = null;
                    }
                } else {
                    KDSMergeBlock block = merges.getMergeBlock(row + 1, col);
                    border = sheet.getCells().getCell(block.row, block.col, false).getStyle().getBorder(Styles.Position.TOP);
                    if (border.isNull()) {
                        border = null;
                    }
                }
            }
        }
        return border;
    }

    private void paintBorders(Graphics2D g2d, double[] xes, double[] yes, IndexedPage.PageBlock pb) {
        for (int i = pb.getBeginRow(); i < pb.getEndRow(); ++i) {
            for (int j = pb.getBeginCol(); j < pb.getEndCol(); ++j) {
                double pxCellWidth = xes[j - pb.getBeginCol() + 1] - xes[j - pb.getBeginCol()];
                double pxCellHeight = yes[i - pb.getBeginRow() + 1] - yes[i - pb.getBeginRow()];
                Rectangle2D.Double rectCell = new Rectangle2D.Double(xes[j - pb.getBeginCol()], yes[i - pb.getBeginRow()], pxCellWidth, pxCellHeight);
                this.paintCellBorder(g2d, rectCell, pb, i, j);
            }
        }
    }

    private boolean isNotEmptyBorder(Border border) {
        return null != border && !border.isNull();
    }

    private void paintCellBorder(Graphics2D g2d, Rectangle2D rectCell, IndexedPage.PageBlock pb, int row, int col) {
        double endY;
        double endX;
        double startY;
        double startX;
        double ny = rectCell.getMinY();
        Line2D.Double line = new Line2D.Double();
        Border border = this.getRightBorder(pb, row, col);
        if (this.isNotEmptyBorder(border)) {
            g2d.setColor(border.getColor());
            g2d.setStroke(border.getStroke());
            startX = rectCell.getMaxX() - 1.0;
            startY = ny;
            endX = startX;
            endY = rectCell.getMaxY() - 1.0;
            line.setLine(startX, startY, endX, endY);
            g2d.draw(line);
        }
        border = null;
        border = this.getBottomBorder(pb, row, col);
        if (this.isNotEmptyBorder(border)) {
            g2d.setColor(border.getColor());
            g2d.setStroke(border.getStroke());
            startX = rectCell.getMinX();
            startY = rectCell.getMaxY() - 1.0;
            endX = rectCell.getMaxX() - 1.0;
            endY = startY;
            line.setLine(startX, startY, endX, endY);
            g2d.draw(line);
        }
        if (this.isTopSide(pb, row)) {
            border = this.getTopBorder(pb, row, col);
            if (null == border) {
                border = this.getBottomBorder(pb, row - 1, col);
            }
            if (this.isNotEmptyBorder(border)) {
                g2d.setColor(border.getColor());
                g2d.setStroke(border.getStroke());
                startX = rectCell.getMinX();
                startY = rectCell.getMinY();
                endX = rectCell.getMaxX();
                endY = startY;
                line.setLine(startX, startY, endX, endY);
                g2d.draw(line);
            }
        }
        if (this.isLeftSide(pb, col)) {
            border = this.getLeftBorder(pb, row, col);
            if (null == border) {
                border = this.getRightBorder(pb, row, col - 1);
            }
            if (this.isNotEmptyBorder(border)) {
                g2d.setColor(border.getColor());
                g2d.setStroke(border.getStroke());
                startX = rectCell.getMinX();
                startY = rectCell.getMinY();
                endX = startX;
                endY = rectCell.getMaxY();
                line.setLine(startX, startY, endX, endY);
                g2d.draw(line);
            }
        }
    }

    private void paintText(Graphics2D g2d, KDSCell cell, Rectangle2D clip) {
        String text = cell.getText();
        if (StringUtil.isEmptyString((String)text)) {
            return;
        }
        this.getRender().setFlagSimple(false);
        this.getRender().draw((Graphics)g2d, (Shape)clip, text, cell.getStyle());
    }

    private void paintImage(Graphics2D g2d, KDSCell cell, Rectangle2D clip, Image image) {
        this.getImageRender().draw((Graphics)g2d, (Shape)clip, (Object)image, cell.getStyle());
    }

    private void paintMerge(Graphics2D g2d, IndexedPage.PageBlock pb, int row, int col, double[] xes, double[] yes) {
        KDSSheet sheet = pb.getSheet();
        KDSMergeBlock merge = sheet.getMerges().getMergeBlock(row, col);
        KDSCell cell = sheet.getCells().getCell(merge.row, merge.col, false);
        double mergeWidth = this.getMergeWidthPx(pb, merge);
        double mergeHeight = this.getMergeHeightPx(pb, merge);
        double ny = 0.0;
        double nx = 0.0;
        if (this.firstCellOfMergeInPage(merge, pb, row, col) && this.page.contains(sheet, merge.row, merge.col)) {
            nx = xes[col - pb.getBeginCol()];
            ny = yes[row - pb.getBeginRow()];
            this.paintMergeContent(g2d, new Rectangle2D.Double(nx, ny, mergeWidth, mergeHeight), cell);
        } else if (this.firstCellOfMergeInPage(merge, pb, row, col) && !this.page.contains(sheet, merge.row, merge.col) && this.firstCellOfMergeInPage(merge, pb, row, col)) {
            if (pb.contains(sheet, merge.row, merge.getCol2())) {
                nx = xes[merge.getCol2() - pb.getBeginCol() + 1];
                ny = yes[merge.row - pb.getBeginRow()];
                nx -= mergeWidth;
            } else if (pb.contains(sheet, merge.getRow2(), merge.col)) {
                nx = xes[merge.col - pb.getBeginCol()];
                ny = yes[merge.getRow2() - pb.getBeginRow() + 1];
                ny -= mergeHeight;
            } else if (pb.contains(sheet, merge.getRow2(), merge.getCol2())) {
                nx = xes[merge.getCol2() - pb.getBeginCol() + 1];
                ny = yes[merge.getRow2() - pb.getBeginRow() + 1];
                nx -= mergeWidth;
                ny -= mergeHeight;
            } else {
                nx = xes[col - pb.getBeginCol()];
                ny = yes[row - pb.getBeginRow()];
                double xOffset = this.getColsWidthPx(pb, merge.col, col);
                double yOffset = this.getRowsHeightPx(pb, merge.row, row);
                nx -= xOffset;
                ny -= yOffset;
            }
            this.paintMergeContentText(g2d, new Rectangle2D.Double(nx, ny, mergeWidth, mergeHeight), cell);
        }
    }

    private void paintMergeBack(Graphics2D g2d, IndexedPage.PageBlock pb, int row, int col, double[] xes, double[] yes) {
        KDSSheet sheet = pb.getSheet();
        KDSMergeBlock merge = sheet.getMerges().getMergeBlock(row, col);
        KDSCell cell = sheet.getCells().getCell(merge.row, merge.col, false);
        double mergeWidth = this.getMergeWidthPx(pb, merge);
        double mergeHeight = this.getMergeHeightPx(pb, merge);
        double ny = 0.0;
        double nx = 0.0;
        if (this.firstCellOfMergeInPage(merge, pb, row, col) && this.page.contains(sheet, merge.row, merge.col)) {
            nx = xes[col - pb.getBeginCol()];
            ny = yes[row - pb.getBeginRow()];
            this.paintMergeContentBack(g2d, new Rectangle2D.Double(nx, ny, mergeWidth, mergeHeight), cell);
        } else if (this.firstCellOfMergeInPage(merge, pb, row, col) && !this.page.contains(sheet, merge.row, merge.col) && this.firstCellOfMergeInPage(merge, pb, row, col)) {
            if (pb.contains(sheet, merge.row, merge.getCol2())) {
                nx = xes[merge.getCol2() - pb.getBeginCol() + 1];
                ny = yes[merge.row - pb.getBeginRow()];
                nx -= mergeWidth;
            } else if (pb.contains(sheet, merge.getRow2(), merge.col)) {
                nx = xes[merge.col - pb.getBeginCol()];
                ny = yes[merge.getRow2() - pb.getBeginRow() + 1];
                ny -= mergeHeight;
            } else if (pb.contains(sheet, merge.getRow2(), merge.getCol2())) {
                nx = xes[merge.getCol2() - pb.getBeginCol() + 1];
                ny = yes[merge.getRow2() - pb.getBeginRow() + 1];
                nx -= mergeWidth;
                ny -= mergeHeight;
            } else {
                nx = xes[col - pb.getBeginCol()];
                ny = yes[row - pb.getBeginRow()];
                double xOffset = this.getColsWidthPx(pb, merge.col, col);
                double yOffset = this.getRowsHeightPx(pb, merge.row, row);
                nx -= xOffset;
                ny -= yOffset;
            }
            this.paintMergeContentBack(g2d, new Rectangle2D.Double(nx, ny, mergeWidth, mergeHeight), cell);
        }
    }

    private void paintMergeContentText(Graphics2D g2d, Rectangle2D rectMerge, KDSCell cell) {
        double nx = rectMerge.getMinX();
        double ny = rectMerge.getMinY();
        double mergeWidth = rectMerge.getWidth();
        double mergeHeight = rectMerge.getHeight();
        Rectangle2D.Double rectText = new Rectangle2D.Double(nx + 3.0, ny + 3.0, mergeWidth - 6.0, mergeHeight - 6.0);
        this.paintText(g2d, cell, rectText);
    }

    private void paintMergeContentImage(Graphics2D g2d, Rectangle2D rectMerge, KDSCell cell, Image image) {
        double nx = rectMerge.getMinX();
        double ny = rectMerge.getMinY();
        double mergeWidth = rectMerge.getWidth();
        double mergeHeight = rectMerge.getHeight();
        Rectangle2D.Double rectImage = new Rectangle2D.Double(nx + 3.0, ny + 3.0, mergeWidth - 6.0, mergeHeight - 6.0);
        this.paintImage(g2d, cell, rectImage, image);
    }

    private void paintMergeContent(Graphics2D g2d, Rectangle2D rectMerge, KDSCell cell) {
        Object objectValue = cell.getValue();
        if (objectValue instanceof Image) {
            this.paintMergeContentImage(g2d, rectMerge, cell, (Image)objectValue);
        } else {
            this.paintMergeContentText(g2d, rectMerge, cell);
        }
    }

    private void paintMergeContentBack(Graphics2D g2d, Rectangle2D rectMerge, KDSCell cell) {
        double nx = rectMerge.getMinX();
        double ny = rectMerge.getMinY();
        double mergeWidth = rectMerge.getWidth();
        double mergeHeight = rectMerge.getHeight();
        Rectangle2D.Double rectBg = new Rectangle2D.Double(nx, ny, mergeWidth, mergeHeight);
        this.fillInteriorRect(g2d, cell, rectBg);
    }

    private double getMergeWidthPx(IndexedPage.PageBlock pb, KDSMergeBlock merge) {
        double width = 0.0;
        IColumns cols = pb.getSheet().getColumns();
        for (int col = merge.col; col <= merge.getCol2(); ++col) {
            width += Math.floor(this.mmToPx(cols.getColumnWidth(col))) * 96.0 / 72.0;
        }
        return width;
    }

    private double getMergeHeightPx(IndexedPage.PageBlock pb, KDSMergeBlock merge) {
        double height = 0.0;
        IRows rows = pb.getSheet().getRows();
        for (int row = merge.row; row <= merge.getRow2(); ++row) {
            height += Math.floor(this.mmToPx(rows.getRowHeight(row))) * 96.0 / 72.0;
        }
        return height;
    }

    private double getColsWidthPx(IndexedPage.PageBlock pb, int beginCol, int endCol) {
        double width = 0.0;
        IColumns cols = pb.getSheet().getColumns();
        for (int col = beginCol; col < endCol; ++col) {
            width += Math.floor(this.mmToPx(cols.getColumnWidth(col)));
        }
        return width;
    }

    private double getRowsHeightPx(IndexedPage.PageBlock pb, int beginRow, int endRow) {
        double height = 0.0;
        IRows rows = pb.getSheet().getRows();
        for (int row = beginRow; row < endRow; ++row) {
            height += Math.floor(this.mmToPx(rows.getRowHeight(row)));
        }
        return height;
    }

    private void fillInteriorRect(Graphics2D g2d, KDSCell cell, Rectangle2D.Double rect) {
        Paint paintSave = g2d.getPaint();
        g2d.setPaint(cell.getStyle().getFillPaint());
        g2d.fill(rect);
        g2d.setPaint(paintSave);
    }

    private boolean isLeftSide(IndexedPage.PageBlock pb, int col) {
        return pb.getBeginCol() == col;
    }

    private boolean isRightSide(IndexedPage.PageBlock pb, int col) {
        return pb.getEndCol() == col;
    }

    private boolean isTopSide(IndexedPage.PageBlock pb, int row) {
        return pb.getBeginRow() == row;
    }

    private boolean isBottomSide(IndexedPage.PageBlock pb, int row) {
        return pb.getEndRow() == row;
    }

    private double mmToPx(double mmValue) {
        return mmValue * 72.0 / 25.4;
    }

    private void paintCell(Graphics2D g2d, Rectangle2D rectCell, IndexedPage.PageBlock pb, int row, int col) {
        KDSCell cell = pb.getSheet().getCells().getCell(row, col, true);
        double nx = rectCell.getMinX();
        double ny = rectCell.getMinY();
        double pxCellWidth = rectCell.getWidth();
        double pxCellHeight = rectCell.getHeight();
        Rectangle2D.Double rectClip = new Rectangle2D.Double(nx, ny, pxCellWidth, pxCellHeight);
        Object objectValue = cell.getValue();
        if (objectValue instanceof Image) {
            this.paintImage(g2d, cell, rectClip, (Image)objectValue);
        } else {
            this.paintText(g2d, cell, rectClip);
        }
    }

    private void paintCellBack(Graphics2D g2d, Rectangle2D rectCell, IndexedPage.PageBlock pb, int row, int col) {
        KDSCell cell = pb.getSheet().getCells().getCell(row, col, true);
        double nx = rectCell.getMinX();
        double ny = rectCell.getMinY();
        double pxCellWidth = rectCell.getWidth();
        double pxCellHeight = rectCell.getHeight();
        Rectangle2D.Double rectFill = new Rectangle2D.Double(nx, ny, pxCellWidth, pxCellHeight);
        this.fillInteriorRect(g2d, cell, rectFill);
    }

    public Graphics2D draw(IndexedPage page, Graphics2D g2d, Shape area) {
        this.setPage(page);
        return this.draw(g2d, area);
    }

    public Graphics2D draw(Graphics2D g2d, Shape area) {
        if (!(area instanceof Rectangle2D)) {
            throw new IllegalArgumentException(CtrlKDFMessages.getMLS("unsupportedShapeExceptRect", "\u6682\u672a\u652f\u6301\u9664\u77e9\u5f62\u4e4b\u5916\u7684\u53ef\u7ed8\u5236\u533a\u57df"));
        }
        double ox = Math.ceil(area.getBounds2D().getMinX());
        double oy = Math.ceil(area.getBounds2D().getMinY());
        double nx = ox;
        double ny = oy;
        int listSize = this.page.getListBlocks().size();
        for (int b = 0; b < listSize; ++b) {
            Rectangle2D.Double rectCell;
            double pxCellHeight;
            double pxCellWidth;
            int j;
            int i;
            IndexedPage.PageBlock pb = (IndexedPage.PageBlock)this.page.getListBlocks().get(b);
            int endCol = pb.getEndCol();
            int beginCol = pb.getBeginCol();
            double[] xes = new double[endCol - beginCol + 1];
            int endRow = pb.getEndRow();
            int beginRow = pb.getBeginRow();
            double[] yes = new double[endRow - beginRow + 1];
            xes[0] = nx;
            yes[0] = ny;
            double xPos = ox;
            double yPos = oy;
            for (int j2 = beginCol; j2 < endCol; ++j2) {
                xes[j2 - beginCol + 1] = xPos += Math.floor(this.mmToPx(pb.getSheet().getColumnWidth(j2))) * 96.0 / 72.0;
            }
            for (i = beginRow; i < endRow; ++i) {
                yes[i - beginRow + 1] = yPos += Math.floor(this.mmToPx(pb.getSheet().getRowHeight(i))) * 96.0 / 72.0;
            }
            for (i = beginRow; i < endRow; ++i) {
                for (j = beginCol; j < endCol; ++j) {
                    if (pb.getSheet().getMerges().isCellMerged(i, j)) {
                        this.paintMergeBack(g2d, pb, i, j, xes, yes);
                        continue;
                    }
                    pxCellWidth = xes[j - beginCol + 1] - xes[j - beginCol];
                    pxCellHeight = yes[i - beginRow + 1] - yes[i - beginRow];
                    rectCell = new Rectangle2D.Double(xes[j - beginCol], yes[i - beginRow], pxCellWidth, pxCellHeight);
                    this.paintCellBack(g2d, rectCell, pb, i, j);
                }
            }
            for (i = beginRow; i < endRow; ++i) {
                for (j = beginCol; j < endCol; ++j) {
                    if (pb.getSheet().getMerges().isCellMerged(i, j)) {
                        this.paintMerge(g2d, pb, i, j, xes, yes);
                        continue;
                    }
                    pxCellWidth = xes[j - beginCol + 1] - xes[j - beginCol];
                    pxCellHeight = yes[i - beginRow + 1] - yes[i - beginRow];
                    rectCell = new Rectangle2D.Double(xes[j - beginCol], yes[i - beginRow], pxCellWidth, pxCellHeight);
                    this.paintCell(g2d, rectCell, pb, i, j);
                }
            }
            ny = yes[yes.length - 1];
            this.paintBorders(g2d, xes, yes, pb);
        }
        return g2d;
    }

    public IndexedPage getPage() {
        return this.page;
    }

    public void setPage(IndexedPage page) {
        this.page = page;
    }
}

