/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.util.printout;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDFMessages;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintable;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintableAdapter;
import com.kingdee.cosmic.ctrl.kdf.kdprint.KDPrintbase;
import com.kingdee.cosmic.ctrl.kdf.kdprint.PrintPage;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.util.printout.AbstractPagination;
import com.kingdee.cosmic.ctrl.kdf.util.printout.CommonPagination;
import com.kingdee.cosmic.ctrl.kdf.util.printout.HoldMergePagination;
import com.kingdee.cosmic.ctrl.kdf.util.printout.IndexedPage;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PageRender;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.print.PrinterException;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public final class PrintableBook
extends KDPrintableAdapter
implements ImageObserver {
    private static final Logger logger = LogUtil.getPackageLogger(PrintableBook.class);
    private KDSBook book;
    private ArrayList pages;
    private KDPrintbase printBase;
    private PageRender pageRender;
    private short printMode;
    public static final short MODE_COMMON = 0;
    public static final short MODE_SAVEPAPER = 1;
    public static final short MODE_HOLDMERGE = 2;

    public PrintableBook(KDSBook book) {
        if (book.getSheetCount() < 1 && book.getImages() == null) {
            throw new IllegalArgumentException(CtrlKDFMessages.getMLS("KDSBookObjectDoesNotContainKDSSheet", "\u4f20\u5165\u7684KDSBook\u5bf9\u8c61\u4e0d\u5305\u542b#1\u6ca1\u6709\u8fdb\u884c\u6253\u5370\u548c\u76f8\u5173\u64cd\u4f5c\u7684\u610f\u4e49").replace("#1", "KDSSheet\uff0c"));
        }
        this.book = book;
        this.pages = new ArrayList();
        this.printMode = 0;
    }

    public PrintableBook(KDSBook book, KDPrintbase printBase) {
        this(book);
        this.printBase = printBase;
    }

    public PrintableBook(KDSBook book, short modeCode) {
        this(book);
        this.setPrintMode(modeCode);
    }

    public PrintableBook(KDSBook book, KDPrintbase printBase, short modeCode) {
        this(book, printBase);
        this.setPrintMode(modeCode);
    }

    private void buildPrintbase() {
        try {
            if (this.printBase == null) {
                this.printBase = new KDPrintbase(this, null);
            }
            this.printBase.addRePaginationListener(this);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    @Override
    public int print(Graphics graphics, KDPrintable.AreaInfo areaInfo, int pageIndex) throws PrinterException {
        if (pageIndex >= this.pages.size()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)graphics;
        IndexedPage page = (IndexedPage)this.getIndexedPages().get(pageIndex);
        g2d.setClip(areaInfo.area);
        this.getPageRender(page).draw(g2d, areaInfo.area);
        return 0;
    }

    public ArrayList getIndexedPages() {
        if (null == this.pages || this.pages.size() < 1) {
            this.pagination();
        }
        return this.pages;
    }

    public ArrayList getIndexedPagesNoSavePaper() {
        if (0 == this.getPrintMode()) {
            return this.getIndexedPages();
        }
        double pageWidth = this.getPrintBase().getPrintPage().getPrintableAreaW();
        double pageHeight = this.getPrintBase().getPrintPage().getPrintableAreaH();
        CommonPagination pager = new CommonPagination(this.getBook(), pageWidth, pageHeight);
        return pager.getIndexedPages();
    }

    private int pagination() {
        double pageWidth = 0.0;
        double pageHeight = 0.0;
        PrintPage printPage = null;
        try {
            printPage = this.getPrintBase().getPrintPage();
            pageWidth = printPage.getPrintPageW();
            pageHeight = printPage.getPrintPageH();
        }
        catch (Throwable th) {
            pageWidth = 172.0;
            pageHeight = 247.0;
        }
        AbstractPagination pager = null;
        pager = 2 == this.getPrintMode() ? new HoldMergePagination(this.getBook(), pageWidth, pageHeight) : (1 == this.getPrintMode() ? new CommonPagination(this.getBook(), pageWidth, pageHeight) : new CommonPagination(this.getBook(), pageWidth, pageHeight));
        this.pages = pager.getPages(printPage);
        return this.pages.size();
    }

    @Override
    public int bodyHeightChanged(int hOld, int hNew) {
        return this.pagination();
    }

    @Override
    public int footerHeightChanged(int hOld, int hNew) {
        return this.pagination();
    }

    @Override
    public int headerHeightChanged(int hOld, int hNew) {
        return this.pagination();
    }

    @Override
    public int PrintPageUpdated(PrintPage page) {
        return this.pagination();
    }

    @Override
    public int widthChanged(int wOld, int wNew) {
        return this.pagination();
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        return false;
    }

    public KDPrintbase getPrintBase() {
        if (null == this.printBase) {
            this.buildPrintbase();
        }
        return this.printBase;
    }

    public KDSBook getBook() {
        return this.book;
    }

    public float[] getMargin() {
        return this.getPrintBase().getPrintPage().getEdges();
    }

    public float[] getPaperSize() {
        return new float[]{this.getPrintBase().getPrintPage().getPrintPageW(), this.getPrintBase().getPrintPage().getPrintPageH()};
    }

    public PageRender getPageRender(IndexedPage page) {
        if (null == this.pageRender) {
            this.pageRender = new PageRender(page);
        } else {
            this.pageRender.setPage(page);
        }
        return this.pageRender;
    }

    public void setPrintMode(short modeCode) {
        boolean needRePagination = false;
        if (modeCode == 0 || modeCode == 2 || modeCode == 1) {
            if (this.printMode != modeCode) {
                needRePagination = true;
            }
        } else {
            throw new IllegalArgumentException("Unsupported print mode code detected:" + modeCode + ",the legal value may be PrintableBook.MODE_COMMON,PrintableBook.MODE_SAVEPAPER or PrintableBook.MODE_HOLDMERGE.");
        }
        this.printMode = modeCode;
        if (needRePagination) {
            this.pagination();
        }
    }

    public short getPrintMode() {
        return this.printMode;
    }
}

