/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.export.nio;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.excel.AbstractDataWrapper;
import com.kingdee.cosmic.ctrl.kdf.export.IExportObject;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableHelper;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.Collections;
import org.apache.log4j.Logger;

public class KDTableDataWrapper
extends AbstractDataWrapper {
    private KDTable _table;
    private int headRowCount = 0;
    private int[] hideColMarks;
    private int _colCount;
    private boolean _exportFootRow = true;
    private boolean _exportHeadRow = true;
    private int colEnd;
    private int rowEnd;
    private int colStart;
    private int rowStart;
    private int blockRowEnd;
    private int blockRowStart;
    private Logger logger = Logger.getLogger(KDTableDataWrapper.class);

    public KDTableDataWrapper(KDTable table) {
        super(1);
        this._table = table;
        this.headRowCount = table.getHeadRowCount();
        this._colCount = this.colCount();
        if (!this._exportHideCols) {
            this.hideColMarks = new int[this._colCount];
            for (int i = 0; i < this._colCount; ++i) {
                if (!this.isHideCol(i)) continue;
                this.hideColMarks[i] = 1;
            }
        }
    }

    private IRow getRow(int rowNum) {
        int bodySize = this._table.getBody().size();
        if (rowNum < this.headRowCount) {
            return this._table.getHeadRow(rowNum);
        }
        if (rowNum - this.headRowCount < bodySize) {
            return this._table.getRow(rowNum - this.headRowCount);
        }
        return this._table.getFootRow(rowNum - this.headRowCount - bodySize);
    }

    public boolean isRowEnd(int rowPosition) {
        boolean ret;
        if (this._exportSelect) {
            return rowPosition - this.headRowCount > this.rowEnd;
        }
        if (rowPosition < this.headRowCount) {
            return this._table.getHeadRow(rowPosition) == null;
        }
        boolean bl = ret = this._table.getRow(rowPosition - this.headRowCount) == null;
        if (ret && this._exportFootRow && this._table.isHasFoot()) {
            int size = this._table.getBody().size();
            ret = this._table.getFootRow(rowPosition - size - this.headRowCount) == null;
        }
        return ret;
    }

    public boolean isColEnd(int colPosition) {
        if (this._exportSelect) {
            return colPosition > this.colEnd;
        }
        return colPosition >= this._colCount;
    }

    public AbstractDataWrapper.MergeBlock getMergeBlock(int rowNum, int colNum) {
        AbstractDataWrapper.MergeBlock mb;
        int i;
        boolean head = false;
        if (rowNum < this.headRowCount) {
            head = true;
        }
        if (!this._exportMergeBlocks && !head) {
            return null;
        }
        ICell cell = this.getFirstVisibleCell(rowNum, colNum);
        if (cell == null) {
            return null;
        }
        KDTMergeBlock block = cell.getMergeBlock();
        if (block == null) {
            return null;
        }
        int top = block.getTop();
        int bottom = block.getBottom();
        if (this._exportSelect && this.blockRowStart > top && !head) {
            top = this.blockRowStart;
        }
        if (this._exportSelect && this.blockRowEnd < bottom && !head) {
            bottom = this.blockRowEnd;
        }
        int left = block.getLeft();
        int right = block.getRight();
        if (top == bottom && left == right) {
            return null;
        }
        int hideRowCount = 0;
        int hideColCount = 0;
        if (!this._exportHideRows) {
            for (i = top; i <= bottom; ++i) {
                if (head) {
                    if (!this._table.getHeadRow(rowNum).getStyleAttributes().isHided()) continue;
                    ++hideRowCount;
                    continue;
                }
                if (this._table.getRow(rowNum) == null || !this._table.getRow(rowNum).getStyleAttributes().isHided()) continue;
                ++hideRowCount;
            }
        }
        if (!this._exportHideCols) {
            for (i = left; i <= right; ++i) {
                if (this.hideColMarks[i] != 1) continue;
                ++hideColCount;
            }
        }
        AbstractDataWrapper.MergeBlock mergeBlock = mb = head ? KDTableDataWrapper.getMergeBlock((int)rowNum, (int)colNum, (int)(bottom - top + rowNum - hideRowCount), (int)(right - left + colNum - hideColCount)) : KDTableDataWrapper.getMergeBlock((int)(top + this.headRowCount), (int)colNum, (int)(bottom - hideRowCount + this.headRowCount), (int)(right - left + colNum - hideColCount));
        if (this._exportSelect && !head) {
            int newRow = mb.getRow();
            int newCol = mb.getCol();
            int newRow2 = mb.getRow2();
            int newCol2 = mb.getCol2();
            if (newRow < this.rowStart) {
                newRow = this.rowStart;
            }
            if (newCol < this.colStart) {
                newCol = this.colStart;
            }
            if (newRow2 > this.rowEnd + 1 + this.headRowCount) {
                newRow2 = this.rowEnd + 1 + this.headRowCount;
            }
            if (newCol2 > this.colEnd + 1) {
                newCol2 = this.colEnd + 1;
            }
            mb = KDTableDataWrapper.getMergeBlock((int)(newRow + this.headRowCount), (int)newCol, (int)(newRow2 - hideRowCount + this.headRowCount), (int)(newCol2 - hideColCount));
        }
        mb.setGroup(null == cell.getKDTCell().getValue() ? "" : cell.getKDTCell().getValue().toString());
        if (mb.getRow2() == mb.getRow() && mb.getCol() == mb.getCol2()) {
            mb = null;
        }
        return mb;
    }

    public ShareStyleAttributes SSAAt(int rowNum, int colNum) {
        StyleAttributes sa;
        IRow row;
        int bodySize = this._table.getBody().size();
        ICell cell = null;
        if (rowNum < this.headRowCount) {
            row = this._table.getHeadRow(rowNum);
            cell = row.getCell(colNum);
        } else if (rowNum - this.headRowCount < bodySize) {
            row = this._table.getRow(rowNum - this.headRowCount);
            if (row != null) {
                cell = row.getCell(colNum);
            }
        } else {
            rowNum -= this.headRowCount;
            row = this._table.getFootRow(rowNum -= bodySize);
            cell = this.getFirstVisibleMergeCell_Foot(rowNum, colNum);
        }
        if (cell == null) {
            return Styles.getEmptySSA();
        }
        ShareStyleAttributes[] ssas = new ShareStyleAttributes[4];
        ssas[0] = cell.getStyleAttributes();
        Object ret = cell.getValue();
        if (ret instanceof Variant) {
            ret = ((Variant)ret).getValue();
        }
        if (ret instanceof IExportObject) {
            IExportObject eo = (IExportObject)ret;
            sa = Styles.getSA((ShareStyleAttributes)ssas[0]);
            sa.setNumberFormat(eo.getFormatString());
            ssas[0] = Styles.getSSA((StyleAttributes)sa);
        }
        ssas[1] = row.getStyleAttributes();
        IColumn col = this._table.getColumn(colNum);
        ssas[2] = col.getStyleAttributes();
        ssas[3] = this._table.getSSA();
        ShareStyleAttributes ret2 = Styles.mergeSSA((ShareStyleAttributes[])ssas);
        if (this.isKDTableFormatStr(ret2.getNumberFormat())) {
            sa = Styles.getSA((ShareStyleAttributes)ret2);
            sa.setNumberFormat(null);
            ret2 = Styles.getSSA((StyleAttributes)sa);
        }
        return ret2;
    }

    private boolean isKDTableFormatStr(String str) {
        if (StringUtil.isEmptyString((String)str)) {
            return false;
        }
        if (str.startsWith("%")) {
            return true;
        }
        if (str.startsWith("$L") || str.startsWith("$U") || str.startsWith("$P")) {
            return true;
        }
        if (str.startsWith("@") && str.length() > 1) {
            return true;
        }
        return this.getCharCount(str, ';') > 3;
    }

    private int getCharCount(String str, char c) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public void dataSourceMemeryCallback(int row, int col) {
        KDTDataRequestManager manager = this._table.getDataRequestManager();
        manager.doMemoryCallback(row / manager.getPageRowCount());
    }

    public Object valueAt(int rowNum, int colNum) {
        ICell cell = this.getFirstVisibleCell(rowNum, colNum);
        if (cell == null) {
            return null;
        }
        Object ret = cell.getValue();
        if (rowNum >= this.headRowCount && rowNum - this.headRowCount < this._table.getBody().size()) {
            String nf = cell.getStyleAttributes().getNumberFormat();
            ret = nf != null && nf.startsWith("@") && nf.length() > 1 ? this._table.getCellDisplayValue(cell.getKDTCell(), cell.getRowIndex(), cell.getColumnIndex()) : KDTableHelper.getCellDisplayValue2(this._table, cell.getRowIndex(), cell.getColumnIndex());
            if (ret instanceof Variant) {
                ret = ((Variant)ret).getValue();
            }
            if (ret instanceof IExportObject) {
                IExportObject eo = (IExportObject)ret;
                ret = eo.getContent();
            }
        } else if (rowNum >= this.headRowCount) {
            rowNum -= this.headRowCount;
            cell = this.getFirstVisibleMergeCell_Foot(rowNum -= this._table.getBody().size(), colNum);
            ret = cell != null ? cell.getValue() : null;
        }
        return ret;
    }

    private ICell getFirstVisibleMergeCell_Body(int rowNum, int colNum) {
        int i;
        KDTMergeBlock merge = null;
        if (this._table.getCell(rowNum, colNum) != null) {
            merge = this._table.getCell(rowNum, colNum).getMergeBlock();
        }
        if (merge == null) {
            return this._table.getCell(rowNum, colNum);
        }
        int row = merge.getTop();
        int row2 = merge.getBottom();
        int col = merge.getLeft();
        int col2 = merge.getRight();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && !this._table.getRow(rowNum).getStyleAttributes().isHided()) {
            for (i = row; i <= row2 && this._table.getRow(row) != null && this._table.getRow(row).getStyleAttributes() != null && this._table.getRow(row).getStyleAttributes().isHided(); ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this._table.getCell(merge.getTop(), merge.getLeft());
        }
        if (!this._exportMergeBlocks) {
            return this._table.getCell(merge.getTop(), merge.getLeft());
        }
        if (this._exportSelect && rowNum == this.blockRowStart) {
            return this._table.getCell(merge.getTop(), merge.getLeft());
        }
        return null;
    }

    private ICell getFirstVisibleMergeCell_Head(int rowNum, int colNum) {
        int i;
        KDTMergeBlock merge = null;
        if (this._table.getHeadRow(rowNum).getCell(colNum) != null) {
            merge = this._table.getHeadRow(rowNum).getCell(colNum).getMergeBlock();
        }
        if (merge == null) {
            return this._table.getHeadRow(rowNum).getCell(colNum);
        }
        int row = merge.getTop();
        int row2 = merge.getBottom();
        int col = merge.getLeft();
        int col2 = merge.getRight();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && !this._table.getHeadRow(rowNum).getStyleAttributes().isHided()) {
            for (i = row; i <= row2 && this._table.getHeadRow(row).getStyleAttributes().isHided(); ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this._table.getHeadRow(merge.getTop()).getCell(merge.getLeft());
        }
        return null;
    }

    private ICell getFirstVisibleMergeCell_Foot(int rowNum, int colNum) {
        int i;
        KDTMergeBlock merge = null;
        merge = this._table.getFootManager().getMergeManager().getMergeBlockOfCell(rowNum, colNum);
        if (merge == null) {
            return this._table.getFootRow(rowNum).getCell(colNum);
        }
        int row = merge.getTop();
        int row2 = merge.getBottom();
        int col = merge.getLeft();
        int col2 = merge.getRight();
        if (!this._exportHideCols && this.hideColMarks[colNum] != 1) {
            for (i = col; i <= col2 && this.hideColMarks[i] == 1; ++i) {
                ++col;
            }
        }
        if (!this._exportHideRows && !this._table.getFootRow(rowNum).getStyleAttributes().isHided()) {
            for (i = row; i <= row2 && this._table.getFootRow(row).getStyleAttributes().isHided(); ++i) {
                ++row;
            }
        }
        if (rowNum == row && colNum == col) {
            return this._table.getFootRow(merge.getTop()).getCell(colNum);
        }
        if (!this._exportMergeBlocks) {
            return this._table.getFootRow(merge.getTop()).getCell(colNum);
        }
        return null;
    }

    private ICell getFirstVisibleCell(int rowNum, int colNum) {
        int bodySize = this._table.getBody().size();
        ICell cell = null;
        if (rowNum < this.headRowCount) {
            cell = this.getFirstVisibleMergeCell_Head(rowNum, colNum);
        } else if (rowNum - this.headRowCount < bodySize) {
            cell = this.getFirstVisibleMergeCell_Body(rowNum -= this.headRowCount, colNum);
        } else {
            rowNum = rowNum - this.headRowCount - bodySize;
            cell = this.getFirstVisibleMergeCell_Foot(rowNum, colNum);
        }
        return cell;
    }

    public short valueTypeAt(int rowNum, int colNum) {
        ICell cell = this.getFirstVisibleCell(rowNum, colNum);
        if (cell == null) {
            return 3;
        }
        return KDTableDataWrapper.getValueType((Object)cell.getValue());
    }

    public int sheetCount() {
        return 1;
    }

    public String sheetName(int index) {
        return "Sheet1";
    }

    public boolean isFirstMergeCell(int row, int col) {
        KDTMergeBlock block;
        boolean head = false;
        if (row < this.headRowCount) {
            block = this._table.getHeadRow(row).getCell(col).getMergeBlock();
            head = true;
        } else {
            block = this._table.getCell(row - this.headRowCount, col).getMergeBlock();
        }
        if (block == null) {
            return true;
        }
        return head ? block.getTop() == row && block.getLeft() == col : block.getTop() == row - this.headRowCount && block.getLeft() == col;
    }

    public boolean isBookProtected() {
        return false;
    }

    public boolean isCurrentSheetProtected() {
        return false;
    }

    protected String getFormula(int row, int col) {
        return null;
    }

    public String formulaAt(int row, int col) {
        return null;
    }

    public boolean isHideRow(int rowNum) {
        if (rowNum < this.headRowCount) {
            return false;
        }
        if (this._exportSelect) {
            return !this.isSelectRow(rowNum);
        }
        if (this._exportHideRows) {
            return false;
        }
        IRow row = this.getRow(rowNum);
        if (row == null) {
            return true;
        }
        return row.getStyleAttributes().isHided();
    }

    private boolean isSelectRow(int rowNum) {
        KDTRange range = this._table.getSelectManager().toRange().getSequenceRange();
        for (IBlock block : range) {
            if (rowNum - this.headRowCount < block.getTop() || rowNum - this.headRowCount > block.getBottom()) continue;
            this.blockRowStart = block.getTop();
            this.blockRowEnd = block.getBottom();
            if (this._exportHideRows) {
                return true;
            }
            IRow row = this.getRow(rowNum);
            if (row == null) {
                return false;
            }
            return !row.getStyleAttributes().isHided();
        }
        return false;
    }

    public boolean isHideCol(int col) {
        if (col < this.colStart) {
            return true;
        }
        if (this._exportHideCols) {
            return false;
        }
        IColumn column = this._table.getColumn(col);
        if (column == null) {
            return true;
        }
        return column.getStyleAttributes().isHided();
    }

    public int colCount() {
        return this._table.getColumnCount();
    }

    public void configSourceRepaint(boolean isOpen) {
        if (this._table.getDataRequestManager().getDataRequestMode() == 0 || this.isExportSelect()) {
            return;
        }
        this._table.enableRepaint(false);
        this._table.setRefresh(false);
        KDTDataRequestManager manager = this._table.getDataRequestManager();
        manager.setMemoryCallback(!isOpen);
        manager.setExporting(!isOpen);
        if (isOpen && manager.isRequestDataByQuery()) {
            this._table.removeRows();
        }
        this._table.enableRepaint(isOpen);
        this._table.setRefresh(isOpen);
        this._table.reLayoutAndPaint();
    }

    public AbstractDataWrapper.EmbedObject getEmbedObject(int index) {
        return null;
    }

    public int getEmbedObjectsCount() {
        return 0;
    }

    public int rowCount() {
        return this._table.getRowCount();
    }

    public int rowHeightAt(int rowNum) {
        if (rowNum < this.headRowCount) {
            return this._table.getHeadRow(rowNum).getHeight();
        }
        if (rowNum < this._table.getBody().size() + this.headRowCount) {
            return this._table.getRow(rowNum - this.headRowCount).getHeight();
        }
        return this._table.getFootRow(rowNum - this._table.getBody().size() - this.headRowCount).getHeight();
    }

    public int colWidthAt(int colNum) {
        return this._table.getColumn(colNum).getWidth();
    }

    public final void setExportFootRow(boolean exportFootRow) {
        this._exportFootRow = exportFootRow;
    }

    public final boolean isExportFootRow() {
        return this._exportFootRow;
    }

    public final void setExportHeadRow(boolean exportHeadRow) {
        this._exportHeadRow = exportHeadRow;
        if (!exportHeadRow) {
            this.headRowCount = 0;
        }
    }

    public final boolean isExportHeadRow() {
        return this._exportHeadRow;
    }

    public void setCurrentSheetIndex(int currentSheetIndex) {
        if (this._exportSelect) {
            KDTRange range = this._table.getSelectManager().toRange();
            Collections.sort(range);
            IBlock block = (IBlock)range.get(0);
            IBlock blockLast = (IBlock)range.get(range.size() - 1);
            this.rowStart = block.getTop();
            this.rowEnd = blockLast.getBottom();
            this.colStart = block.getLeft();
            this.colEnd = blockLast.getRight();
            int selectMode = this._table.getSelectManager().getSelectMode();
            if (selectMode == 2 || selectMode == 10) {
                this.colStart = 0;
                this.colEnd = this._table.getColumnCount();
            } else if (selectMode == 4 || selectMode == 12) {
                this.rowStart = 0;
                this.rowEnd = this._table.getRowCount3();
            }
        }
    }

    public int getExportPageRowCount() {
        return this._table.getDataRequestManager().getExportPageRowCount();
    }

    public int getTopGroupColIndex() {
        int gp = -1;
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            if (!this._table.getColumns().getColumn(i).isGroup()) continue;
            ++gp;
            break;
        }
        return gp;
    }

    public String getCellValue(int row, int col) {
        String value = "";
        KDTCell cell = this._table.getBody().getCell(row, col);
        if (null != cell && null != cell.getValue()) {
            value = cell.getValue().toString();
        }
        return value;
    }

    public int getLastGroupColIndex() {
        int gp = -1;
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            if (!this._table.getColumns().getColumn(i).isGroup()) continue;
            ++gp;
        }
        return gp;
    }

    public boolean isGroupCol(int col) {
        return this._table.getColumn(col).isGroup();
    }

    public boolean isMergeCol(int col) {
        return this._table.getColumn(col).isMergeable();
    }

    public boolean isExportHeadRow(int rowNum) {
        return rowNum < this._table.getHeadRowCount();
    }

    public int getHeadNumber() {
        return this._table.getHeadRowCount();
    }
}

