/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.AbstractTableTravelPolicy;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;

public final class CellFocusTravelByRow
extends AbstractTableTravelPolicy {
    public CellFocusTravelByRow(KDTable table) {
        super(table);
    }

    @Override
    public KDTCellIndex nextCellIndex(int rowIndex, int colIndex) {
        KDTCellIndex cellIndex = new KDTCellIndex();
        cellIndex.setRowIndex(rowIndex);
        cellIndex.setColIndex(colIndex);
        KDTSelectManager sman = this.table.getSelectManager();
        int blockIndex = sman.getSelectBlockIndexOfCell(rowIndex, colIndex);
        if (blockIndex > -1) {
            if (this.isSingleSelectedCell()) {
                cellIndex.setColIndex(sman.nextColIndex(rowIndex, colIndex, true));
                int colCount = this.table.getColumnCount();
                if (cellIndex.getColIndex() > colCount - 1) {
                    int rowHeight;
                    int nextCol;
                    for (int nextC = nextCol = 0; nextC < colCount - 1 && sman.isJumpCol(rowIndex, nextC, true); ++nextC) {
                        ++nextCol;
                    }
                    cellIndex.setColIndex(nextCol);
                    int nextRow = cellIndex.getRowIndex() + 1;
                    int rowCount = this.table.getRowCount();
                    for (int nextR = nextRow; nextR < rowCount - 1 && (rowHeight = this.table.getRow(nextR).getHeight()) <= 0; ++nextR) {
                        ++nextRow;
                    }
                    cellIndex.setRowIndex(nextRow % this.table.getRowCount());
                }
            } else {
                KDTSelectBlock block = (KDTSelectBlock)sman.getBlocks().get(blockIndex);
                cellIndex.setColIndex(sman.nextColIndex(rowIndex, colIndex));
                if (cellIndex.getColIndex() > block.getRight()) {
                    if (block.getBottom() == rowIndex) {
                        block = (KDTSelectBlock)sman.getBlocks().get((blockIndex + 1) % sman.getBlocks().size());
                        cellIndex.setRowIndex(block.getTop());
                    } else {
                        cellIndex.setRowIndex(rowIndex + 1);
                    }
                    cellIndex.setColIndex(block.getLeft());
                }
            }
        } else if (sman.getBlocks().size() != 0) {
            KDTSelectBlock lastBlock = (KDTSelectBlock)sman.getBlocks().get(sman.getBlocks().size() - 1);
            if (null != lastBlock) {
                cellIndex.setColIndex(lastBlock.getLeft());
                cellIndex.setRowIndex(lastBlock.getTop());
            } else {
                cellIndex.setRowIndex(rowIndex);
                cellIndex.setColIndex(colIndex);
            }
        } else {
            sman.add(0, 0, 0, 0);
            cellIndex.setColIndex(0);
            cellIndex.setRowIndex(0);
        }
        return cellIndex;
    }

    @Override
    public KDTCellIndex previousCellIndex(int rowIndex, int colIndex) {
        KDTCellIndex cellIndex = new KDTCellIndex();
        cellIndex.setRowIndex(rowIndex);
        cellIndex.setColIndex(colIndex);
        KDTSelectManager sman = this.table.getSelectManager();
        int blockIndex = sman.getSelectBlockIndexOfCell(rowIndex, colIndex);
        if (blockIndex > -1) {
            if (this.isSingleSelectedCell()) {
                int preColIndex = sman.previousColIndex(rowIndex, colIndex, true);
                if (preColIndex < 0) {
                    int nextCol;
                    int colCount = this.table.getColumnCount();
                    for (int nextC = nextCol = colCount - 1; nextC >= 0 && sman.isJumpCol(rowIndex, nextC, true); --nextC) {
                        --nextCol;
                    }
                    cellIndex.setColIndex(nextCol);
                    int rowCount = this.table.getRowCount();
                    cellIndex.setRowIndex((cellIndex.getRowIndex() - 1 + rowCount) % rowCount);
                } else {
                    cellIndex.setColIndex(preColIndex);
                }
            } else {
                KDTSelectBlock block = (KDTSelectBlock)sman.getBlocks().get(blockIndex);
                cellIndex.setColIndex(sman.previousColIndex(rowIndex, colIndex));
                if (cellIndex.getColIndex() < block.getLeft()) {
                    if (block.getTop() == rowIndex) {
                        int blockSize = sman.getBlocks().size();
                        block = (KDTSelectBlock)sman.getBlocks().get((blockIndex - 1 + blockSize) % blockSize);
                        cellIndex.setRowIndex(block.getBottom());
                    } else {
                        cellIndex.setRowIndex(rowIndex - 1);
                    }
                    cellIndex.setColIndex(block.getRight());
                }
            }
        } else if (sman.getBlocks().size() != 0) {
            KDTSelectBlock lastBlock = (KDTSelectBlock)sman.getBlocks().get(sman.getBlocks().size() - 1);
            if (null != lastBlock) {
                cellIndex.setColIndex(lastBlock.getRight());
                cellIndex.setRowIndex(lastBlock.getBottom());
            } else {
                cellIndex.setRowIndex(rowIndex);
                cellIndex.setColIndex(colIndex);
            }
        } else {
            sman.add(0, 0, 0, 0);
            cellIndex.setColIndex(0);
            cellIndex.setRowIndex(0);
        }
        return cellIndex;
    }

    private boolean isSingleSelectedCell() {
        if (this.table.getSelectManager().getBlocks().size() == 1) {
            KDTSelectBlock block = (KDTSelectBlock)this.table.getSelectManager().getBlocks().get(0);
            return block.getBeginCol() == block.getEndCol() && block.getBeginRow() == block.getEndRow();
        }
        return false;
    }
}

