/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.ObjectUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IDataConvert;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTEditHelper;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellValueParse;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFXmlReader;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class DataTable {
    private static final Logger logger = LogUtil.getPackageLogger(DataTable.class);
    private List cols;
    private List rows;
    private int rangeMode;
    private KDFXmlReader reader;
    private int mark;
    private IDataConvert<Object, Object> loadCellConvert;
    private IDataConvert<Object, Object> saveCellConvert;
    private int defaultRowHeight;
    private int defaultColumnWidth;
    private ShareStyleAttributes bodySSA;
    private Style bodyStyle;
    private int cellDisplayMode;
    List mergeBlockList;

    public DataTable() {
        this(15);
    }

    public DataTable(int mark) {
        this(0, 0, mark);
    }

    public DataTable(int rowCount, int colCount, int mark) {
        this.mark = mark;
        this.cols = new ArrayList(rowCount);
        this.rows = new ArrayList(colCount);
    }

    public KDTRow addRow() {
        return this.addRow(new KDTRow());
    }

    public KDTRow addRow(int rowIndex) {
        return this.addRow(rowIndex, new KDTRow());
    }

    public KDTRow addRow(KDTRow row) {
        return this.addRow(this.getRowCount(), row);
    }

    public KDTRow addRow(int rowIndex, KDTRow row) {
        this.rows.add(rowIndex, row);
        return row;
    }

    public KDTColumn addCol() {
        return this.addCol(new KDTColumn());
    }

    public KDTColumn addCol(int colIndex) {
        return this.addCol(colIndex, new KDTColumn());
    }

    public KDTColumn addCol(KDTColumn col) {
        return this.addCol(this.getColCount(), col);
    }

    public KDTColumn addCol(int colIndex, KDTColumn col) {
        this.cols.add(colIndex, col);
        return col;
    }

    public KDTRow getRow(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return (KDTRow)this.rows.get(rowIndex);
        }
        return null;
    }

    public KDTColumn getCol(int colIndex) {
        if (colIndex >= 0 && colIndex < this.getColCount()) {
            return (KDTColumn)this.cols.get(colIndex);
        }
        return null;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColCount() {
        return this.cols.size();
    }

    public ShareStyleAttributes getBodySSA() {
        return this.bodySSA;
    }

    public void setBodySSA(ShareStyleAttributes bodySSA) {
        this.bodySSA = bodySSA;
    }

    public int getCellDisplayMode() {
        return this.cellDisplayMode;
    }

    public void setCellDisplayMode(int cellDisplayMode) {
        this.cellDisplayMode = cellDisplayMode;
    }

    public int getDefaultColumnWidth() {
        return this.defaultColumnWidth;
    }

    public void setDefaultColumnWidth(int defaultColumnWidth) {
        this.defaultColumnWidth = defaultColumnWidth;
    }

    public Style getBodyStyle() {
        return this.bodyStyle;
    }

    public void setBodyStyle(Style bodyStyle) {
        this.bodyStyle = bodyStyle;
    }

    public int getDefaultRowHeight() {
        return this.defaultRowHeight;
    }

    public void setDefaultRowHeight(int defaultRowHeight) {
        this.defaultRowHeight = defaultRowHeight;
    }

    public void load(Reader charStream) {
        KDFXmlReader reader = new KDFXmlReader(charStream);
        this.readDefaultTableFromFile(reader);
    }

    List getMergeBlockList() {
        if (this.mergeBlockList == null) {
            this.mergeBlockList = new ArrayList();
        }
        return this.mergeBlockList;
    }

    public void addMergeBlock(IBlock block) {
        this.getMergeBlockList().add(block);
    }

    public IBlock getMergeBlock(int index) {
        return (IBlock)this.getMergeBlockList().get(index);
    }

    private boolean copyIgnoreHideCol(KDTable table, int index) {
        return table.getColumn(index) != null && table.getColumn(index).getStyleAttributes().isHided();
    }

    private boolean copyIgnoreHideRow(KDTable table, int index) {
        return table.getRow2(index) != null && table.getRow2(index).getStyleAttributes().isHided();
    }

    private boolean isFID(KDTable table, int colIndex) {
        IColumn col = table.getColumn(colIndex);
        if ("ID".equalsIgnoreCase(col.getFieldName()) || "FID".equalsIgnoreCase(col.getFieldName())) {
            return true;
        }
        List names = table.getCopyColNames();
        int l = names.size();
        for (int i = 0; i < l; ++i) {
            String name = (String)names.get(i);
            if (StringUtil.isEmptyString((String)name) || !name.equals(col.getFieldName())) continue;
            return true;
        }
        return false;
    }

    public boolean load(KDTable table, KDTRange range) {
        if ((range = range.getSequenceRange()) == null) {
            return false;
        }
        int direct = -2;
        for (IBlock block : range) {
            this.rangeMode = block.getMode();
            switch (this.rangeMode) {
                case 1: {
                    if (direct == -2) {
                        direct = range.getRangeDirect();
                    }
                    if (direct == 0) {
                        this.loadCellBlockRowDirect(table, block);
                        break;
                    }
                    this.loadCellBlockColDirect(table, block);
                    break;
                }
                case 2: {
                    this.loadRowBlock(table, block);
                    break;
                }
                case 4: {
                    this.loadColBlock(table, block);
                    break;
                }
                case 8: {
                    this.loadTableBlock(table, block);
                    break;
                }
            }
        }
        return true;
    }

    public boolean save(KDTable table, KDTRange range) {
        if (!range.isSingleRange()) {
            return false;
        }
        IBlock block = (IBlock)range.get(0);
        switch (this.rangeMode) {
            case 1: {
                this.saveCellBlock(table, block);
                break;
            }
            case 2: {
                this.saveRowBlock(table, block);
                break;
            }
            case 4: {
                this.saveColBlock(table, block);
                break;
            }
            case 8: {
                this.saveTableBlock(table, block);
                break;
            }
        }
        this.saveMergeBlock(table, block);
        return true;
    }

    private void saveMergeBlock(KDTable table, IBlock block) {
        int top = block.getTop();
        int left = block.getLeft();
        for (KDTMergeBlock mb : this.getMergeBlockList()) {
            KDTMergeBlock newb = (KDTMergeBlock)mb.clone();
            newb.setTop(mb.getTop() + top);
            newb.setBottom(mb.getBottom() + top);
            newb.setLeft(mb.getLeft() + left);
            newb.setRight(mb.getRight() + left);
            table.getMergeManager().mergeBlock(newb);
        }
    }

    private void loadTableBlock(KDTable table, IBlock block) {
        int i;
        int top = 0;
        int left = 0;
        int bottom = table.getRowCount3() - 1;
        int right = table.getColumnCount() - 1;
        this.setDefaultColumnWidth(table.getDefaultColumnWidth());
        this.setDefaultRowHeight(table.getDefaultRowHeight());
        this.setCellDisplayMode(table.getCellDisplayMode());
        this.setBodySSA(table.getSSA());
        KDTBody rows = table.getBody();
        KDTColumns cols = table.getColumns();
        ShareStyleAttributes tableSSA = table.getSSA();
        for (i = left; i <= right; ++i) {
            if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, i) : !this.isFID(table, i)) continue;
            KDTColumn kdtCol = cols.getColumn(i);
            if (kdtCol == null) {
                right = i - 1;
                break;
            }
            KDTColumn col = (KDTColumn)kdtCol.clone();
            this.addCol(col);
            col.setSSA(kdtCol.getSSA());
            ShareStyleAttributes shareStyleAttributes = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{col.getSSA(), tableSSA});
        }
        for (i = top; i <= bottom; ++i) {
            ShareStyleAttributes ssa;
            if (this.copyIgnoreHideRow(table, i)) continue;
            KDTRow kdtRow = rows.getRow(i);
            if (kdtRow == null) break;
            ShareStyleAttributes rowSSA = kdtRow.getSSA();
            KDTRow row = this.addRow();
            for (int j = left; j <= right; ++j) {
                if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, j) : !this.isFID(table, j)) continue;
                KDTCell cell = kdtRow.getCell(j);
                if (cell != null) {
                    cell = (KDTCell)cell.clone();
                    ShareStyleAttributes colSSA = cols.getColumn(j).getSSA();
                    ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), rowSSA, colSSA, tableSSA});
                    cell.setSSA(ssa);
                    if (KDTEditHelper.isDisplayValue(this.mark)) {
                        cell.setValue(this.getCellDisplayValue(table, i, j));
                    }
                }
                row.addCell(this.convertLoadCell(cell, i, j));
            }
            ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{rowSSA, tableSSA});
            row.setSSA(ssa);
        }
        this.mergeBlockList = table.getMergeManager().getMergeBlockList();
    }

    private void loadRowBlock(KDTable table, IBlock block) {
        int top = block.getTop();
        int left = 0;
        int bottom = block.getBottom();
        int right = table.getColumnCount() - 1;
        KDTBody rows = table.getBody();
        KDTColumns cols = table.getColumns();
        int offsetCol = 0;
        int offsetRow = this.getRowCount();
        if (this.getColCount() <= 0) {
            for (int i = left; i <= right; ++i) {
                if (table.isCopyFID() ? !this.isFID(table, i) : this.copyIgnoreHideCol(table, i)) continue;
                this.addCol();
            }
        }
        ShareStyleAttributes tableSSA = table.getSSA();
        for (int i = top; i <= bottom; ++i) {
            ShareStyleAttributes ssa;
            if (this.copyIgnoreHideRow(table, i)) continue;
            KDTRow oldRow = rows.getRow(i);
            ShareStyleAttributes rowSSA = oldRow.getSSA();
            KDTRow row = this.addRow();
            for (int j = 0; j <= right; ++j) {
                if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, j) : !this.isFID(table, j)) continue;
                KDTCell cell = oldRow.getCell(j);
                if (cell != null) {
                    cell = (KDTCell)cell.clone();
                    ShareStyleAttributes colSSA = cols.getColumn(j + left).getSSA();
                    ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), rowSSA, colSSA, tableSSA});
                    cell.setSSA(ssa);
                    KDTMergeBlock mb = cell.getMergeBlock();
                    if (mb != null && mb.getTop() == i - offsetRow + top && mb.getLeft() == j - offsetCol + left) {
                        int newTop = mb.getTop() - top + offsetRow;
                        int newBottom = mb.getBottom() - top + offsetRow;
                        int newLeft = mb.getLeft() - left + offsetCol;
                        int newRight = mb.getRight() - left + offsetCol;
                        mb = new KDTMergeBlock();
                        mb.setTop(newTop);
                        mb.setBottom(newBottom);
                        mb.setLeft(newLeft);
                        mb.setRight(newRight);
                        this.getMergeBlockList().add(mb);
                    }
                    if (KDTEditHelper.isDisplayValue(this.mark)) {
                        cell.setValue(this.getCellDisplayValue(table, i, j));
                    }
                }
                row.addCell(this.convertLoadCell(cell, i, j));
            }
            ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{rowSSA, tableSSA});
            row.setSSA(ssa);
        }
    }

    private void loadColBlock(KDTable table, IBlock block) {
        ShareStyleAttributes ssa;
        ShareStyleAttributes colSSA;
        int i;
        int top = 0;
        int left = block.getLeft();
        int bottom = table.getRowCount3() - 1;
        int right = block.getRight();
        KDTBody rows = table.getBody();
        KDTColumns cols = table.getColumns();
        ShareStyleAttributes tableSSA = table.getSSA();
        int offsetCol = this.getColCount();
        int offsetRow = 0;
        for (i = left; i <= right; ++i) {
            if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, i) : !this.isFID(table, i)) continue;
            KDTColumn kdtCol = cols.getColumn(i);
            if (kdtCol == null) {
                right = i;
                break;
            }
            KDTColumn col = (KDTColumn)kdtCol.clone();
            this.addCol(col);
            colSSA = col.getSSA();
            ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{colSSA, tableSSA});
            col.setSSA(ssa);
        }
        if (this.getRowCount() <= 0) {
            for (i = top; i <= bottom; ++i) {
                if (this.copyIgnoreHideRow(table, i)) continue;
                this.addRow();
            }
        }
        for (i = top; i <= bottom; ++i) {
            KDTRow row;
            if (this.copyIgnoreHideRow(table, i) || (row = this.getRow(i)) == null) continue;
            KDTRow kdtRow = rows.getRow(i);
            ShareStyleAttributes rowSSA = kdtRow.getSSA();
            for (int j = left; j <= right; ++j) {
                if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, j) : !this.isFID(table, j)) continue;
                KDTCell cell = kdtRow.getCell(j);
                if (cell != null) {
                    cell = (KDTCell)cell.clone();
                    colSSA = cols.getColumn(j).getSSA();
                    ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), rowSSA, colSSA, tableSSA});
                    cell.setSSA(ssa);
                    KDTMergeBlock mb = cell.getMergeBlock();
                    if (mb != null && mb.getTop() == i && mb.getLeft() == j) {
                        int newTop = mb.getTop() - top + offsetRow;
                        int newBottom = mb.getBottom() - top + offsetRow;
                        int newLeft = mb.getLeft() - left + offsetCol;
                        int newRight = mb.getRight() - left + offsetCol;
                        mb = new KDTMergeBlock();
                        mb.setTop(newTop);
                        mb.setBottom(newBottom);
                        mb.setLeft(newLeft);
                        mb.setRight(newRight);
                        this.getMergeBlockList().add(mb);
                    }
                    if (KDTEditHelper.isDisplayValue(this.mark)) {
                        cell.setValue(this.getCellDisplayValue(table, i, j));
                    }
                }
                row.addCell(this.convertLoadCell(cell, i, j));
            }
        }
    }

    private void loadCellBlockColDirect(KDTable table, IBlock block) {
        int i;
        boolean isCompleteMegerBlock = false;
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        KDTBody rows = table.getBody();
        ShareStyleAttributes tableSSA = table.getSSA();
        int offsetCol = 0;
        int offsetRow = this.getRowCount();
        if (this.getCol(0) == null) {
            for (i = left; i <= right; ++i) {
                if (table.isCopyFID() ? !this.isFID(table, i) : this.copyIgnoreHideCol(table, i)) continue;
                this.addCol();
            }
        }
        for (i = top; i <= bottom; ++i) {
            if (this.copyIgnoreHideRow(table, i)) continue;
            KDTRow oldRow = rows.getRow(i);
            ShareStyleAttributes rowSSA = oldRow.getSSA();
            KDTRow row = this.addRow();
            for (int j = left; j <= right; ++j) {
                if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, j) : !this.isFID(table, j)) continue;
                KDTCell cell = oldRow.getCell(j);
                if (cell != null) {
                    cell = (KDTCell)cell.clone();
                    ShareStyleAttributes colSSA = table.getColumns().getColumn(j).getSSA();
                    ShareStyleAttributes ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), rowSSA, colSSA, tableSSA});
                    cell.setSSA(ssa);
                    KDTMergeBlock mb = cell.getMergeBlock();
                    if (mb != null && mb.getTop() == i && mb.getLeft() == j) {
                        int newTop = mb.getTop() - top + offsetRow;
                        int newBottom = mb.getBottom() - top + offsetRow;
                        int newLeft = mb.getLeft() - left + offsetCol;
                        int newRight = mb.getRight() - left + offsetCol;
                        mb.setTop(newTop);
                        mb.setBottom(newBottom);
                        mb.setLeft(newLeft);
                        mb.setRight(newRight);
                        this.getMergeBlockList().add(mb);
                        isCompleteMegerBlock = true;
                    } else if (table.getSelectManager().isForSingleCell() && mb != null && isCompleteMegerBlock) {
                        cell.setValue("");
                        row.addCell(cell);
                        continue;
                    }
                    if (KDTEditHelper.isDisplayValue(this.mark)) {
                        cell.setValue(this.getCellDisplayValue(table, i, j));
                    }
                }
                row.addCell(this.convertLoadCell(cell, i, j));
            }
        }
    }

    private Object getCellDisplayValue(KDTable table, int rowIndex, int colIndex) {
        ICell cell = table.getCell(rowIndex, colIndex);
        return table.getCellDisplayText(cell);
    }

    private void loadCellBlockRowDirect(KDTable table, IBlock block) {
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        KDTBody rows = table.getBody();
        ShareStyleAttributes tableSSA = table.getSSA();
        int offsetCol = this.getColCount();
        int offsetRow = 0;
        for (int i = left; i <= right; ++i) {
            if (table.isCopyFID() ? !this.isFID(table, i) : this.copyIgnoreHideCol(table, i)) continue;
            this.addCol();
        }
        KDTRow firstRow = this.getRow(0);
        for (int i = top; i <= bottom; ++i) {
            if (this.copyIgnoreHideRow(table, i)) continue;
            KDTRow oldRow = rows.getRow(i);
            ShareStyleAttributes rowSSA = oldRow.getSSA();
            KDTRow row = firstRow == null ? this.addRow() : this.getRow(i - top);
            for (int j = left; j <= right; ++j) {
                if (!table.isCopyFID() ? this.copyIgnoreHideCol(table, j) : !this.isFID(table, j)) continue;
                KDTCell cell = oldRow.getCell(j);
                if (cell != null) {
                    cell = (KDTCell)cell.clone();
                    ShareStyleAttributes colSSA = table.getColumns().getColumn(j).getSSA();
                    ShareStyleAttributes ssa = Styles.mergeSSA((ShareStyleAttributes[])new ShareStyleAttributes[]{cell.getSSA(), rowSSA, colSSA, tableSSA});
                    cell.setSSA(ssa);
                    KDTMergeBlock mb = cell.getMergeBlock();
                    if (mb != null && mb.getTop() == i && mb.getLeft() == j) {
                        int newTop = mb.getTop() - top + offsetRow;
                        int newBottom = mb.getBottom() - top + offsetRow;
                        int newLeft = mb.getLeft() - left + offsetCol;
                        int newRight = mb.getRight() - left + offsetCol;
                        mb.setTop(newTop);
                        mb.setBottom(newBottom);
                        mb.setLeft(newLeft);
                        mb.setRight(newRight);
                        this.getMergeBlockList().add(mb);
                    }
                    if (KDTEditHelper.isDisplayValue(this.mark)) {
                        cell.setValue(this.getCellDisplayValue(table, i, j));
                    }
                }
                row.addCell(this.convertLoadCell(cell, i, j));
            }
        }
    }

    private void saveCellBlock(KDTable table, IBlock block) {
        int top = block.getTop();
        int left = block.getLeft();
        int rowCount = top + this.rows.size() <= table.getRowCount3() ? this.rows.size() : table.getRowCount3() - top;
        int colCount = left + this.cols.size() <= table.getColumnCount() ? this.cols.size() : table.getColumnCount() - left;
        KDTBody rows = table.getBody();
        CellCopy cellCopy = new CellCopy(table);
        for (int i = 0; i < rowCount; ++i) {
            int destRowIndex = top + i;
            KDTRow row = (KDTRow)this.rows.get(i);
            KDTRow kdtRow = rows.getRow(destRowIndex);
            if (kdtRow == null) break;
            for (int j = 0; j < colCount; ++j) {
                int destColIndex = left + j;
                KDTCell cell = row.getCell(j);
                cellCopy.setDest(kdtRow.getCell(destColIndex));
                cellCopy.setDestRowIndex(destRowIndex);
                cellCopy.setDestColIndex(destColIndex);
                cellCopy.setSrc(this.convertSaveCell(cell, destRowIndex, destColIndex));
                cellCopy.copy();
            }
        }
    }

    private void saveRowBlock(KDTable table, IBlock block) {
        int top = block.getTop();
        int left = 0;
        int rowCount = this.getRowCount() < table.getRowCount3() ? this.getRowCount() : table.getRowCount3();
        int hideCount = 0;
        if (table.getColumn(0).getStyleAttributes().isHided()) {
            ++hideCount;
            ++left;
        }
        KDTBody rows = table.getBody();
        RowCopy rowCopy = new RowCopy(table);
        CellCopy cellCopy = new CellCopy(table);
        for (int i = 0; i < rowCount; ++i) {
            int destRowIndex = top + i;
            KDTRow row = this.getRow(i);
            KDTRow kdtRow = rows.getRow(destRowIndex);
            if (kdtRow == null) break;
            if (hideCount == 1) {
                rows.removeRow(destRowIndex);
                KDTable.XRow xRow = (KDTable.XRow)table.addRow(destRowIndex);
                KDTCell xCell = xRow.createBlankCell(0);
                kdtRow = xRow.getKDTRow();
                kdtRow.setCell(0, xCell);
            }
            rowCopy.setDest(kdtRow);
            rowCopy.setSrc(row);
            rowCopy.setDestRowIndex(destRowIndex);
            rowCopy.copy();
            int cellCount = row.cells.size();
            int colCount = table.getColumnCount();
            if (cellCount > colCount) {
                cellCount = colCount;
            }
            for (int j = 0; j < cellCount; ++j) {
                int destColIndex = left + j;
                KDTCell cell = row.getCell(j);
                cellCopy.setDest(kdtRow.getCell(destColIndex));
                cellCopy.setDestRowIndex(destRowIndex);
                cellCopy.setDestColIndex(destColIndex);
                cellCopy.setSrc(this.convertSaveCell(cell, destRowIndex, destColIndex));
                cellCopy.copy();
            }
        }
    }

    private void saveTableBlock(KDTable table, IBlock block) {
        KDTColumn kdtcol;
        int i;
        TableCopy tableCopy = new TableCopy(table);
        ColumnCopy colCopy = new ColumnCopy(table);
        RowCopy rowCopy = new RowCopy(table);
        CellCopy cellCopy = new CellCopy(table);
        tableCopy.copy();
        int rowCount = this.getRowCount();
        int colCount = this.getColCount() < table.getColumnCount() ? this.getColCount() : table.getColumnCount();
        KDTBody rows = table.getBody();
        KDTColumns cols = table.getColumns();
        for (i = 0; i < colCount && (kdtcol = cols.getColumn(i)) != null; ++i) {
            colCopy.setDest(kdtcol);
            colCopy.setDestColIndex(i);
            colCopy.setSrc(this.getCol(i));
            colCopy.copy();
        }
        for (i = 0; i < rowCount; ++i) {
            KDTRow row = this.getRow(i);
            KDTRow kdtRow = rows.getRow(i);
            if (kdtRow == null) break;
            rowCopy.setDest(kdtRow);
            rowCopy.setSrc(row);
            rowCopy.setDestRowIndex(i);
            rowCopy.copy();
            int cellCount = row.cells.size();
            for (int j = 0; j < cellCount; ++j) {
                KDTCell cell = row.getCell(j);
                cellCopy.setDest(kdtRow.getCell(j));
                cellCopy.setDestRowIndex(i);
                cellCopy.setDestColIndex(j);
                cellCopy.setSrc(this.convertSaveCell(cell, i, j));
                cellCopy.copy();
            }
        }
    }

    private void saveColBlock(KDTable table, IBlock block) {
        int i;
        int top = 0;
        int left = block.getLeft();
        int rowCount = this.getRowCount();
        int colCount = left + this.getColCount() <= table.getColumnCount() ? this.getColCount() : table.getColumnCount();
        KDTBody rows = table.getBody();
        KDTColumns cols = table.getColumns();
        ColumnCopy colCopy = new ColumnCopy(table);
        CellCopy cellCopy = new CellCopy(table);
        for (i = 0; i < colCount; ++i) {
            int destColIndex = left + i;
            KDTColumn col = this.getCol(i);
            KDTColumn kdtcol = cols.getColumn(destColIndex);
            if (kdtcol == null) break;
            colCopy.setDest(kdtcol);
            colCopy.setDestColIndex(destColIndex);
            colCopy.setSrc(col);
            colCopy.copy();
        }
        for (i = top; i < rowCount; ++i) {
            KDTRow row = this.getRow(i);
            KDTRow kdtrow = rows.getRow(i);
            if (kdtrow == null) break;
            for (int j = 0; j < colCount; ++j) {
                int destColIndex = left + j;
                KDTCell cell = row.getCell(j);
                cellCopy.setDest(kdtrow.getCell(destColIndex));
                cellCopy.setDestRowIndex(i);
                cellCopy.setDestColIndex(destColIndex);
                cellCopy.setSrc(this.convertSaveCell(cell, i, destColIndex));
                cellCopy.copy();
            }
        }
    }

    void cellChanged(KDTable table, KDTCell cell, int rowIndex, int colIndex) {
        if (table.scriptManager != null) {
            if (cell == null || StringUtil.isEmptyString((String)cell.getExpressions())) {
                table.scriptManager.cellPropertyChanged(rowIndex, colIndex);
            } else {
                table.scriptManager.cellFormulaChanged(rowIndex, colIndex);
            }
        }
    }

    IXmlElement out(KDF kdf) {
        if (null == kdf) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("KDTableSerializationMethodRequiresNonNullParam", "KDTable\u5e8f\u5217\u5316\u65b9\u6cd5\u9700\u8981\u975e\u7a7a\u7684\u53c2\u6570\uff1akdf"));
        }
        IXmlElement nodeKDTable = XmlUtil.createNode((String)"Table");
        this.setNodeAttribute(nodeKDTable, "id", "clipboard");
        this.setNodeAttribute(nodeKDTable, "clipboardMode", String.valueOf(this.rangeMode));
        this.setNodeAttribute(nodeKDTable, "clipboardContent", String.valueOf(this.mark));
        IXmlElement nodeSheet = XmlUtil.createNode((String)"Sheet");
        nodeKDTable.addChild(nodeSheet);
        this.buildSheet(kdf, nodeSheet);
        return nodeKDTable;
    }

    private void buildSheet(KDF kdf, IXmlElement nodeSheet) {
        nodeSheet.setAttribute("name", "NotSupportedInThisVersion");
        IXmlElement nodeTable = XmlUtil.createNode((String)"Table");
        this.buildTable(kdf, nodeTable);
        nodeSheet.addChild(nodeTable);
        IXmlElement nodeOptions = XmlUtil.createNode((String)"SheetOptions");
        this.buildSheetOptions(nodeOptions);
        nodeSheet.addChild(nodeOptions);
    }

    private void buildSheetOptions(IXmlElement nodeOptions) {
        IXmlElement nodeMergeBlocks = XmlUtil.createNode((String)"MergeBlocks");
        this.buildMergeBlocks(nodeMergeBlocks, this.mergeBlockList);
        nodeOptions.addChild(nodeMergeBlocks);
    }

    private void buildTable(KDF kdf, IXmlElement nodeTable) {
        if (this.rangeMode == 8) {
            this.setTableAttributes(kdf, nodeTable);
        }
        IXmlElement nodeColGroup = XmlUtil.createNode((String)"ColumnGroup");
        this.buildNodeColGroup(kdf, nodeColGroup);
        nodeTable.addChild(nodeColGroup);
        IXmlElement nodeBody = XmlUtil.createNode((String)"Body");
        this.buildNodeBody(kdf, nodeBody);
        nodeTable.addChild(nodeBody);
    }

    private void buildNodeColGroup(KDF kdf, IXmlElement nodeColGroup) {
        int colCount = this.getColCount();
        for (int i = 0; i < colCount; ++i) {
            KDTColumn col = this.getCol(i);
            IXmlElement nodeCol = XmlUtil.createNode((String)"Column");
            this.buildColumn(kdf, nodeCol, col);
            nodeColGroup.addChild(nodeCol);
        }
    }

    private void buildColumn(KDF kdf, IXmlElement nodeCol, KDTColumn col) {
        if (this.rangeMode == 4 || this.rangeMode == 8) {
            String str;
            this.setNodeAttribute(nodeCol, "width", String.valueOf(col.getWidth()));
            this.setNodeAttribute(nodeCol, "key", col.getKey());
            this.setNodeAttribute(nodeCol, "mergeable", String.valueOf(col.isMergeable()));
            this.setNodeAttribute(nodeCol, "group", String.valueOf(col.isGroup()));
            this.setNodeAttribute(nodeCol, "resizeable", String.valueOf(col.isResizeable()));
            this.setNodeAttribute(nodeCol, "moveable", String.valueOf(col.isMoveable()));
            this.setNodeAttribute(nodeCol, "styleID", kdf.addSSA(col.getSSA()));
            Object obj = col.getUserObject();
            if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
                IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
                nodeUO.addCData(str);
                nodeCol.addChild(nodeUO);
            }
        }
    }

    private void buildNodeBody(KDF kdf, IXmlElement nodeBody) {
        this.buildRowsNode(kdf, nodeBody, this.rows);
    }

    private void buildRowsNode(KDF kdf, IXmlElement nodeRows, List rows) {
        int rowCount = rows.size();
        for (int i = 0; i < rowCount; ++i) {
            IXmlElement nodeRow = XmlUtil.createNode((String)"Row");
            this.buildRow(kdf, nodeRow, (KDTRow)rows.get(i));
            nodeRows.addChild(nodeRow);
        }
    }

    private void buildRow(KDF kdf, IXmlElement nodeRow, KDTRow row) {
        if (this.rangeMode == 2 || this.rangeMode == 8) {
            String str;
            this.setNodeAttribute(nodeRow, "mergeable", String.valueOf(row.isMergeable()));
            this.setNodeAttribute(nodeRow, "resizeable", String.valueOf(row.isResizeable()));
            this.setNodeAttribute(nodeRow, "height", String.valueOf(row.getHeight()));
            this.setNodeAttribute(nodeRow, "styleID", kdf.addSSA(row.getSSA()));
            Object obj = row.getUserObject();
            if (obj != null && (str = ObjectUtil.objectToString((Object)obj)) != null) {
                IXmlElement nodeUO = XmlUtil.createNode((String)"UserObject");
                nodeUO.addCData(str);
                nodeRow.addChild(nodeUO);
            }
        }
        int size = row.getCells().size();
        boolean hasNullBefore = false;
        for (int i = 0; i < size; ++i) {
            KDTCell cell = row.getCell(i);
            if (cell == null) {
                hasNullBefore = true;
                continue;
            }
            IXmlElement nodeCell = XmlUtil.createNode((String)"Cell");
            if (hasNullBefore) {
                this.setNodeAttribute(nodeCell, "index", String.valueOf(i));
                hasNullBefore = false;
            }
            this.buildCell(kdf, nodeCell, row.getCell(i));
            nodeRow.addChild(nodeCell);
        }
    }

    private void buildCell(KDF kdf, IXmlElement nodeCell, KDTCell cell) {
        ShareStyleAttributes ssa;
        String value;
        IXmlElement node;
        if (null == cell) {
            return;
        }
        Object obj = cell.getValue();
        if (obj instanceof String) {
            node = XmlUtil.createNode((String)"Value");
            node.setAttribute("type", "string");
            node.addCData((String)obj);
            nodeCell.addChild(node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = XmlUtil.createNode((String)"Value");
                node.addCData(value);
                nodeCell.addChild(node);
            }
        }
        obj = cell.getFormattedValue();
        if (obj instanceof String) {
            node = XmlUtil.createNode((String)"FormattedValue");
            node.setAttribute("type", "string");
            node.addCData((String)obj);
            nodeCell.addChild(node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = XmlUtil.createNode((String)"FormattedValue");
                node.addCData(value);
                nodeCell.addChild(node);
            }
        }
        obj = cell.getUserObject();
        if (obj instanceof String) {
            node = XmlUtil.createNode((String)"UserObject");
            node.setAttribute("type", "string");
            node.addCData((String)obj);
            nodeCell.addChild(node);
        } else {
            value = ObjectUtil.objectToString((Object)obj);
            if (value != null) {
                node = XmlUtil.createNode((String)"UserObject");
                node.addCData(value);
                nodeCell.addChild(node);
            }
        }
        value = cell.getExpressions();
        if (!this.isEmptyString(value)) {
            node = XmlUtil.createNode((String)"Expression");
            node.addCData(value);
            nodeCell.addChild(node);
        }
        if ((ssa = cell.getSSA()) != null) {
            this.setNodeAttribute(nodeCell, "styleID", kdf.addSSA(ssa));
        }
        if ((ssa = cell.getFormattedSSA()) != null) {
            this.setNodeAttribute(nodeCell, "formattedStyleID", kdf.addSSA(ssa));
        }
    }

    private void setTableAttributes(KDF kdf, IXmlElement nodeTable) {
        this.setNodeAttribute(nodeTable, "styleID", kdf.addSSA(this.getBodySSA()));
        this.setNodeAttribute(nodeTable, "rowHeight", String.valueOf(this.getDefaultRowHeight()));
        this.setNodeAttribute(nodeTable, "columnWidth", String.valueOf(this.getDefaultColumnWidth()));
        this.setNodeAttribute(nodeTable, "cellDisplayMode", String.valueOf(this.getCellDisplayMode()));
    }

    private void setNodeAttribute(IXmlElement node, String attrName, String value) {
        if (StringUtil.isEmptyString((String)attrName) || null == value) {
            return;
        }
        node.setAttribute(attrName, value);
    }

    private boolean isEmptyString(String value) {
        return null == value || value.trim().equals("");
    }

    private void readDefaultTableFromFile(KDFXmlReader reader) {
        this.reader = reader;
        this.parse((IXmlElement)reader.getTableNodes().get(0));
    }

    void parse(IXmlElement nodeKDTable) {
        String attVal = nodeKDTable.getAttribute("clipboardMode");
        if (!this.isEmptyString(attVal)) {
            this.rangeMode = Integer.parseInt(attVal);
        }
        if (!this.isEmptyString(attVal = nodeKDTable.getAttribute("clipboardContent"))) {
            this.mark &= Integer.parseInt(attVal);
        }
        IXmlElement nodeTable = null;
        try {
            nodeTable = nodeKDTable.getChild("Sheet").getChild("Table");
        }
        catch (Exception e) {
            return;
        }
        if (nodeTable == null) {
            return;
        }
        this.fillTable(nodeTable);
        IXmlElement nodeSheetOptions = nodeKDTable.getChild("Sheet").getChild("SheetOptions");
        if (null != nodeSheetOptions) {
            this.fillSheetOptions(nodeSheetOptions);
        }
    }

    private void fillSheetOptions(IXmlElement nodeSheetOptions) {
        IXmlElement nodeMerges = nodeSheetOptions.getChild("MergeBlocks");
        this.parseMergeBlocks(nodeMerges);
    }

    private void parseMergeBlocks(IXmlElement nodeMerges) {
        if (null == nodeMerges) {
            return;
        }
        IXmlElement nodeBody = nodeMerges.getChild("Body");
        if (nodeBody != null) {
            this.parseMergePart(nodeBody);
        }
    }

    private void parseMergePart(IXmlElement blocksNode) {
        List nodeBlockList = blocksNode.getChildren();
        Iterator iter = nodeBlockList.iterator();
        while (iter.hasNext()) {
            KDTMergeBlock block = this.parseMergeBlock((IXmlElement)iter.next());
            if (null == block) continue;
            this.addMergeBlock(block);
        }
    }

    private KDTMergeBlock parseMergeBlock(IXmlElement nodeBlock) {
        if (null == nodeBlock) {
            return null;
        }
        KDTMergeBlock block = new KDTMergeBlock();
        try {
            String top = nodeBlock.getAttribute("top");
            String right = nodeBlock.getAttribute("right");
            String left = nodeBlock.getAttribute("left");
            String bottom = nodeBlock.getAttribute("bottom");
            if (this.isEmptyString(top) || this.isEmptyString(right) || this.isEmptyString(left) || this.isEmptyString(bottom)) {
                throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("selectionBlockParamIncomplete", "\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574"));
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            return block;
        }
        catch (Exception err) {
            logger.error((Object)"err", (Throwable)err);
            return null;
        }
    }

    private void fillTable(IXmlElement nodeTable) {
        this.fillTableAttributes(nodeTable);
        IXmlElement e = nodeTable.getChild("ColumnGroup");
        if (e != null) {
            this.fillColumns(e);
        }
        if ((e = nodeTable.getChild("Body")) != null) {
            this.fillBody(e);
        }
    }

    private void fillColumns(IXmlElement e) {
        List list1 = e.searchChildren("Column");
        for (int i = 0; i < list1.size(); ++i) {
            KDTColumn col = this.addCol(i);
            IXmlElement colNode = (IXmlElement)list1.get(i);
            this.fillColAttributes(col, colNode);
        }
    }

    private void fillBody(IXmlElement e) {
        List list1 = e.getChildren();
        for (int i = 0; i < list1.size(); ++i) {
            int cellIndex = 0;
            KDTRow row = this.addRow(i);
            IXmlElement rowNode = (IXmlElement)list1.get(i);
            this.fillRowAttributes(row, rowNode);
            List list2 = rowNode.searchChildren("Cell");
            for (int j = 0; j < list2.size(); ++j) {
                IXmlElement cellNode = (IXmlElement)list2.get(j);
                String attVal = cellNode.getAttribute("index");
                if (attVal != null) {
                    cellIndex = Integer.parseInt(attVal);
                }
                KDTCell cell = row.addCell(cellIndex);
                this.fillCellAttributes(cell, cellNode);
                ++cellIndex;
            }
        }
    }

    private void fillTableAttributes(IXmlElement objXml) {
        String attVal = objXml.getAttribute("columnWidth");
        if (!this.isEmptyString(attVal)) {
            this.setDefaultColumnWidth(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("rowHeight"))) {
            this.setDefaultRowHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("cellDisplayMode"))) {
            this.setCellDisplayMode(Integer.parseInt(attVal));
        }
        if (KDTEditHelper.isStyle(this.mark) && !this.isEmptyString(attVal = objXml.getAttribute("styleID"))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            this.setBodySSA(ssa);
            this.setBodyStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
    }

    private void fillColAttributes(KDTColumn objTable, IXmlElement objXml) {
        Object uo;
        IXmlElement e;
        String attVal = objXml.getAttribute("width");
        if (attVal != null && !attVal.equals("")) {
            objTable.setWidth(Integer.parseInt(attVal));
        }
        if ((attVal = objXml.getAttribute("key")) != null && !attVal.equals("")) {
            objTable.setKey(attVal);
        }
        if ((attVal = objXml.getAttribute("mergeable")) != null && !attVal.equals("")) {
            objTable.setMergeable(!attVal.equals("0"));
        }
        if ((attVal = objXml.getAttribute("resizeable")) != null && !attVal.equals("")) {
            objTable.setResizeable(!attVal.equals("0"));
        }
        if ((attVal = objXml.getAttribute("moveable")) != null && !attVal.equals("")) {
            objTable.setMoveable(!attVal.equals("0"));
        }
        if ((attVal = objXml.getAttribute("group")) != null && !attVal.equals("")) {
            objTable.setGroup(!attVal.equals("0"));
        }
        if (KDTEditHelper.isStyle(this.mark) && !this.isEmptyString(attVal = objXml.getAttribute("styleID"))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            objTable.setSSA(ssa);
            objTable.setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
        if (KDTEditHelper.isUserObject(this.mark) && (e = objXml.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            objTable.setUserObject(uo);
        }
    }

    private ShareStyleAttributes getStyleAttributes(String id) {
        IXmlElement styleNode;
        if (this.reader != null && null != (styleNode = this.reader.getStyleNodeByID(id))) {
            return StyleParser.parseSA((IXmlElement)styleNode);
        }
        return Styles.getEmptySSA();
    }

    private void fillRowAttributes(KDTRow objTable, IXmlElement objXml) {
        Object uo;
        IXmlElement e;
        String attVal = objXml.getAttribute("height");
        if (!this.isEmptyString(attVal)) {
            objTable.setHeight(Integer.parseInt(attVal));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("mergeable"))) {
            objTable.setMergeable(!attVal.equals("0"));
        }
        if (!this.isEmptyString(attVal = objXml.getAttribute("resizeable"))) {
            objTable.setResizeable(!attVal.equals("0"));
        }
        if (KDTEditHelper.isStyle(this.mark) && !this.isEmptyString(attVal = objXml.getAttribute("styleID"))) {
            ShareStyleAttributes ssa = this.getStyleAttributes(attVal.trim());
            objTable.setSSA(ssa);
            objTable.setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
        if (KDTEditHelper.isUserObject(this.mark) && (e = objXml.getChild("UserObject")) != null && (uo = ObjectUtil.stringToObject((String)e.getText())) != null) {
            objTable.setUserObject(uo);
        }
    }

    private void fillCellAttributes(KDTCell objCell, IXmlElement objXml) {
        Object obj;
        String type;
        IXmlElement node;
        String attVal;
        if (KDTEditHelper.isStyle(this.mark)) {
            ShareStyleAttributes ssa = null;
            ShareStyleAttributes fssa = null;
            attVal = objXml.getAttribute("styleID");
            if (!this.isEmptyString(attVal)) {
                ssa = this.getStyleAttributes(attVal.trim());
                objCell.setSSA(ssa);
            }
            if (!this.isEmptyString(attVal = objXml.getAttribute("formattedStyleID"))) {
                fssa = this.getStyleAttributes(attVal.trim());
                objCell.setFormattedSSA(ssa);
            }
            if (ssa != null) {
                if (fssa == null) {
                    objCell.setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
                } else {
                    objCell.setStyle(Styles.getStyle((ShareStyleAttributes[])new ShareStyleAttributes[]{fssa, ssa}));
                }
            }
        }
        if (KDTEditHelper.isValue(this.mark) && objXml.getChildren().size() == 0) {
            attVal = objXml.getText();
            if (!StringUtil.isEmptyString((String)attVal)) {
                objCell.setValue(attVal);
            }
            return;
        }
        if (KDTEditHelper.isUserObject(this.mark) && (node = objXml.getChild("UserObject")) != null) {
            attVal = node.getText();
            type = node.getAttribute("type");
            if ("string".equalsIgnoreCase(type)) {
                if (attVal != null) {
                    objCell.setUserObject(attVal);
                }
            } else {
                obj = ObjectUtil.stringToObject((String)attVal);
                if (obj != null) {
                    objCell.setUserObject(obj);
                }
            }
        }
        if (KDTEditHelper.isFormula(this.mark) && (node = objXml.getChild("Expression")) != null && !this.isEmptyString(attVal = node.getText())) {
            objCell.setExpressions(attVal);
        }
        if (KDTEditHelper.isValue(this.mark)) {
            node = objXml.getChild("FormattedValue");
            if (node != null) {
                attVal = node.getText();
                type = node.getAttribute("type");
                if ("string".equalsIgnoreCase(type)) {
                    if (attVal != null) {
                        objCell.setFormattedValue(attVal);
                    }
                } else {
                    obj = ObjectUtil.stringToObject((String)attVal);
                    if (obj != null) {
                        objCell.setFormattedValue(obj);
                    }
                }
            }
            if ((node = objXml.getChild("Value")) != null) {
                attVal = node.getText();
                type = node.getAttribute("type");
                if ("string".equalsIgnoreCase(type)) {
                    if (StringUtil.isEmptyString((String)attVal)) {
                        objCell.setValue(null);
                    } else {
                        objCell.setValue(attVal);
                    }
                } else {
                    obj = ObjectUtil.stringToObject((String)attVal);
                    if (obj != null) {
                        objCell.setValue(obj);
                    } else if (attVal != null) {
                        if (StringUtil.isEmptyString((String)attVal)) {
                            objCell.setValue(null);
                        } else {
                            objCell.setValue(attVal);
                        }
                    }
                }
            }
        }
    }

    private void buildMergeBlocks(IXmlElement nodeBlocks, List blocks) {
        if (blocks == null) {
            return;
        }
        KDTMergeBlock block2 = null;
        IXmlElement nodeBody = XmlUtil.createNode((String)"Body");
        IXmlElement nodeBlock = null;
        for (KDTMergeBlock block2 : blocks) {
            nodeBlock = XmlUtil.createNode((String)"Block");
            this.setNodeAttribute(nodeBlock, "top", String.valueOf(block2.getTop()));
            this.setNodeAttribute(nodeBlock, "left", String.valueOf(block2.getLeft()));
            this.setNodeAttribute(nodeBlock, "right", String.valueOf(block2.getRight()));
            this.setNodeAttribute(nodeBlock, "bottom", String.valueOf(block2.getBottom()));
            nodeBody.addChild(nodeBlock);
        }
        nodeBlocks.addChild(nodeBody);
    }

    ShareStyleAttributes getDefaultSSA() {
        return Styles.getEmptySSA();
    }

    Style getDefaultStyle() {
        return Styles.getDefaultStyle();
    }

    public KDTSelectBlock preSave(KDTable table, KDTRange range) {
        int top = 0;
        int left = 0;
        int rowCount = 0;
        int colCount = 0;
        if (!range.isSingleRange()) {
            return null;
        }
        IBlock block = (IBlock)range.get(0);
        switch (this.rangeMode) {
            case 1: {
                top = block.getTop();
                left = block.getLeft();
                rowCount = top + this.rows.size() <= table.getRowCount3() ? this.rows.size() : table.getRowCount3() - top;
                colCount = left + this.cols.size() <= table.getColumnCount() ? this.cols.size() : table.getColumnCount() - left;
                break;
            }
            case 2: {
                top = block.getTop();
                left = 0;
                rowCount = this.getRowCount() < table.getRowCount3() ? this.getRowCount() : table.getRowCount3();
                colCount = table.getColumnCount();
                break;
            }
            case 4: {
                top = 0;
                left = block.getLeft();
                rowCount = this.getRowCount();
                colCount = left + this.getColCount() <= table.getColumnCount() ? this.getColCount() : table.getColumnCount();
                break;
            }
            case 8: {
                top = 0;
                left = 0;
                rowCount = this.getRowCount();
                colCount = this.getColCount() < table.getColumnCount() ? this.getColCount() : table.getColumnCount();
                break;
            }
        }
        KDTSelectBlock pblock = new KDTSelectBlock(top, left, top + rowCount - 1, left + colCount - 1);
        return pblock;
    }

    public void clear() {
        this.cols.clear();
        this.rows.clear();
        if (this.mergeBlockList != null) {
            this.mergeBlockList.clear();
        }
    }

    public KDTCell convertLoadCell(KDTCell cell, int row, int col) {
        if (null != this.loadCellConvert && null != cell) {
            cell.setValue(this.loadCellConvert.convert(cell.getValue(), row, col));
        }
        return cell;
    }

    public KDTCell convertSaveCell(KDTCell cell, int row, int col) {
        if (null != this.saveCellConvert && null != cell) {
            cell.setValue(this.saveCellConvert.convert(cell.getValue(), row, col));
        }
        return cell;
    }

    public void setSaveConverter(IDataConvert<Object, Object> converter) {
        this.saveCellConvert = converter;
    }

    public void setLoadConverter(IDataConvert<Object, Object> converter) {
        this.loadCellConvert = converter;
    }

    class TableCopy {
        KDTable dest;

        public TableCopy(KDTable dest) {
            this.dest = dest;
        }

        public void copy() {
            if (this.dest != null && this.dest.getStyle().isLocked()) {
                return;
            }
            if (KDTEditHelper.isValue(DataTable.this.mark)) {
                int cellDisplayMode = this.getCellDisplayMode();
                this.setCellDisplayMode(cellDisplayMode);
            }
            if (KDTEditHelper.isStyle(DataTable.this.mark)) {
                int defaultColumnWidth = this.getDefaultColumnWidth();
                this.setDefaultColumnWidth(defaultColumnWidth);
                int defaultRowHeight = this.getDefaultRowHeight();
                this.setDefaultRowHeight(defaultRowHeight);
                ShareStyleAttributes ssa = this.getSSA();
                this.setSSA(ssa);
                Style style = this.getStyle();
                this.setStyle(style);
            }
            if (KDTEditHelper.isAll(DataTable.this.mark) && this.dest != null) {
                this.dest.removeRows();
                this.dest.getRow(0);
            }
        }

        public int getDefaultColumnWidth() {
            return DataTable.this.getDefaultColumnWidth();
        }

        public int getDefaultRowHeight() {
            return DataTable.this.getDefaultRowHeight();
        }

        public int getCellDisplayMode() {
            return DataTable.this.getCellDisplayMode();
        }

        public ShareStyleAttributes getSSA() {
            return DataTable.this.getBodySSA();
        }

        public Style getStyle() {
            return DataTable.this.getBodyStyle();
        }

        public Object getUserObject() {
            return null;
        }

        public void setDefaultColumnWidth(int width) {
            if (this.dest != null && width != -1) {
                this.dest.setDefaultColumnWidth(width);
            }
        }

        public void setDefaultRowHeight(int height) {
            if (this.dest != null && height != -1) {
                this.dest.setDefaultRowHeight(height);
            }
        }

        public void setCellDisplayMode(int mode) {
            if (this.dest != null && mode != -1) {
                this.dest.setCellDisplayMode(mode);
            }
        }

        public void setSSA(ShareStyleAttributes ssa) {
            if (this.dest != null && ssa != null) {
                this.dest.setSSA(ssa);
            }
        }

        public void setStyle(Style style) {
            if (this.dest != null && style != null) {
                this.dest.setStyle(style);
            }
        }

        void setUserObject(Object value) {
            if (this.dest != null) {
                this.dest.setUserObject(value);
            }
        }
    }

    class RowCopy {
        int destRowIndex;
        KDTRow dest;
        KDTRow src;

        public RowCopy(KDTable table) {
        }

        public void copy() {
            if (this.dest != null && this.dest.getStyle().isLocked()) {
                return;
            }
            if (KDTEditHelper.isFormula(DataTable.this.mark)) {
                String formula = this.getFormula();
                this.setFormula(formula);
            }
            if (KDTEditHelper.isUserObject(DataTable.this.mark)) {
                Object userObject = this.getUserObject();
                this.setUserObject(userObject);
            }
            if (KDTEditHelper.isStyle(DataTable.this.mark)) {
                int height = this.getHeight();
                this.setHeight(height);
                int mark = this.getMark();
                this.setMark(mark);
                ShareStyleAttributes ssa = this.getSSA();
                this.setSSA(ssa);
                Style style = this.getStyle();
                this.setStyle(style);
            }
        }

        KDTRow getDestRow() {
            return this.dest;
        }

        String getFormula() {
            if (this.src == null) {
                return null;
            }
            return this.src.getExpressions();
        }

        Object getUserObject() {
            if (this.src == null) {
                return null;
            }
            return this.src.getUserObject();
        }

        ShareStyleAttributes getSSA() {
            if (this.src == null) {
                return null;
            }
            return this.src.getSSA();
        }

        Style getStyle() {
            if (this.src == null) {
                return null;
            }
            return this.src.getStyle();
        }

        int getHeight() {
            if (this.src == null) {
                return -1;
            }
            return this.src.getHeight();
        }

        int getMark() {
            if (this.src == null) {
                return -1;
            }
            return this.src.mark;
        }

        void setFormula(String value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDest().setExpressions(value);
        }

        void setUserObject(Object value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDest().setUserObject(value);
        }

        void setSSA(ShareStyleAttributes value) {
            if (this.dest == null && value == null) {
                return;
            }
            if (value == null) {
                value = DataTable.this.getDefaultSSA();
            }
            this.getDestRow().setSSA(value);
        }

        void setStyle(Style value) {
            if (this.dest == null && value == null) {
                return;
            }
            if (value == null) {
                value = DataTable.this.getDefaultStyle();
            }
            this.getDestRow().setStyle(value);
        }

        void setHeight(int height) {
            if (this.dest != null) {
                this.dest.setHeight(height);
            }
        }

        void setMark(int mark) {
            if (this.dest != null && mark != -1) {
                this.dest.mark = mark;
            }
        }

        public KDTRow getDest() {
            return this.dest;
        }

        public void setDest(KDTRow dest) {
            this.dest = dest;
        }

        public KDTRow getSrc() {
            return this.src;
        }

        public void setSrc(KDTRow src) {
            this.src = src;
        }

        public int getDestRowIndex() {
            return this.destRowIndex;
        }

        public void setDestRowIndex(int destRowIndex) {
            this.destRowIndex = destRowIndex;
        }
    }

    class ColumnCopy {
        int destColIndex;
        KDTColumn dest;
        KDTColumn src;

        public ColumnCopy(KDTable table) {
        }

        public void copy() {
            if (this.dest != null && this.dest.getStyle().isLocked()) {
                return;
            }
            if (KDTEditHelper.isFormula(DataTable.this.mark)) {
                String formula = this.getFormula();
                this.setFormula(formula);
            }
            if (KDTEditHelper.isUserObject(DataTable.this.mark)) {
                Object userObject = this.getUserObject();
                this.setUserObject(userObject);
            }
            if (KDTEditHelper.isStyle(DataTable.this.mark)) {
                int mark = this.getMark();
                this.setMark(mark);
                int width = this.getWidth();
                this.setWidth(width);
                ShareStyleAttributes ssa = this.getSSA();
                this.setSSA(ssa);
                Style style = this.getStyle();
                this.setStyle(style);
            }
        }

        KDTColumn getDestColumn() {
            return this.dest;
        }

        String getFormula() {
            if (this.src == null) {
                return null;
            }
            return this.src.getExpressions();
        }

        Object getUserObject() {
            if (this.src == null) {
                return null;
            }
            return this.src.getUserObject();
        }

        ShareStyleAttributes getSSA() {
            if (this.src == null) {
                return null;
            }
            return this.src.getSSA();
        }

        Style getStyle() {
            if (this.src == null) {
                return null;
            }
            return this.src.getStyle();
        }

        int getWidth() {
            if (this.src == null) {
                return -1;
            }
            return this.src.getWidth();
        }

        int getMark() {
            if (this.src == null) {
                return -1;
            }
            return this.src.mark;
        }

        void setFormula(String value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDest().setExpressions(value);
        }

        void setUserObject(Object value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDest().setUserObject(value);
        }

        void setSSA(ShareStyleAttributes value) {
            if (this.dest == null && value == null) {
                return;
            }
            if (value == null) {
                value = DataTable.this.getDefaultSSA();
            }
            this.getDestColumn().setSSA(value);
        }

        void setStyle(Style value) {
            if (this.dest == null && value == null) {
                return;
            }
            if (value == null) {
                value = DataTable.this.getDefaultStyle();
            }
            this.getDestColumn().setStyle(value);
        }

        void setWidth(int width) {
            if (this.dest != null) {
                this.dest.setWidth(width);
            }
        }

        void setMark(int mark) {
            if (this.dest != null && mark != -1) {
                this.dest.mark = mark;
            }
        }

        public KDTColumn getDest() {
            return this.dest;
        }

        public void setDest(KDTColumn dest) {
            this.dest = dest;
        }

        public KDTColumn getSrc() {
            return this.src;
        }

        public void setSrc(KDTColumn src) {
            this.src = src;
        }

        public int getDestColIndex() {
            return this.destColIndex;
        }

        public void setDestColIndex(int destColIndex) {
            this.destColIndex = destColIndex;
        }
    }

    class CellCopy {
        KDTable table;
        int destRowIndex;
        int destColIndex;
        KDTCell dest;
        KDTCell src;

        public CellCopy(KDTable table) {
            this.table = table;
        }

        public void copy() {
            if (this.dest != null && this.dest.getStyle().isLocked()) {
                return;
            }
            if (KDTEditHelper.isValue(DataTable.this.mark)) {
                Object value = this.getValue();
                this.setValue(value);
                Object formattedValue = this.getFormattedValue();
                this.setFormattedValue(formattedValue);
            }
            if (KDTEditHelper.isFormula(DataTable.this.mark)) {
                String formula = this.getFormula();
                this.setFormula(formula);
            }
            if (KDTEditHelper.isUserObject(DataTable.this.mark)) {
                Object userObject = this.getUserObject();
                this.setUserObject(userObject);
            }
            if (KDTEditHelper.isStyle(DataTable.this.mark)) {
                ShareStyleAttributes formattedSSA = this.getFormattedSSA();
                this.setFormattedSSA(formattedSSA);
                ShareStyleAttributes ssa = this.getSSA();
                this.setSSA(ssa);
                Style style = this.getStyle();
                this.setStyle(style);
            }
            DataTable.this.cellChanged(this.table, this.src, this.destRowIndex, this.destColIndex);
        }

        KDTCell getDestCell() {
            if (this.dest == null) {
                this.dest = this.table.createBlankCell(this.destRowIndex, this.destColIndex);
            }
            return this.dest;
        }

        Object getValue() {
            if (this.src == null) {
                return null;
            }
            return this.src.getValue();
        }

        String getFormula() {
            if (this.src == null) {
                return null;
            }
            return this.src.getExpressions();
        }

        Object getFormattedValue() {
            if (this.src == null) {
                return null;
            }
            return this.src.getFormattedValue();
        }

        Object getUserObject() {
            if (this.src == null) {
                return null;
            }
            return this.src.getUserObject();
        }

        ShareStyleAttributes getFormattedSSA() {
            if (this.src == null) {
                return null;
            }
            return this.src.getFormattedSSA();
        }

        ShareStyleAttributes getSSA() {
            if (this.src == null) {
                return null;
            }
            return this.src.getSSA();
        }

        Style getStyle() {
            if (this.src == null) {
                return null;
            }
            return this.src.getStyle();
        }

        void setValue(Object value) {
            KDTCellIndex index = new KDTCellIndex();
            index.setType(1);
            index.setRowIndex(this.getDestRowIndex());
            index.setColIndex(this.getDestColIndex());
            ICellEditor editor = this.table.getCellEditor(this.getDestRowIndex(), this.getDestColIndex());
            Object newValue = null;
            if (editor instanceof ICellValueParse) {
                Object result = ((ICellValueParse)((Object)editor)).parseValue(value);
                if (result == ICellValueParse.ParseError) {
                    return;
                }
                newValue = result;
            } else {
                newValue = value;
            }
            Object old = this.getDestCell().getValue();
            this.getDestCell().setValue(newValue);
            this.table.fireCellPropertyChange("cellValue", old, newValue, index);
        }

        void setFormattedValue(Object value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDestCell().setFormattedValue(value);
        }

        void setFormula(String value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDestCell().setExpressions(value);
        }

        void setUserObject(Object value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDestCell().setUserObject(value);
        }

        void setFormattedSSA(ShareStyleAttributes value) {
            if (this.dest == null && value == null) {
                return;
            }
            this.getDestCell().setFormattedSSA(value);
        }

        void setSSA(ShareStyleAttributes value) {
            if (this.dest == null && value == null) {
                return;
            }
            if (value == null) {
                value = DataTable.this.getDefaultSSA();
            }
            this.getDestCell().setSSA(value);
        }

        void setStyle(Style value) {
            if (this.dest == null && value == null) {
                return;
            }
            if (value == null) {
                value = DataTable.this.getDefaultStyle();
            }
            this.getDestCell().setStyle(value);
        }

        public KDTCell getDest() {
            return this.dest;
        }

        public void setDest(KDTCell dest) {
            this.dest = dest;
        }

        public KDTCell getSrc() {
            return this.src;
        }

        public void setSrc(KDTCell src) {
            this.src = src;
        }

        public int getDestColIndex() {
            return this.destColIndex;
        }

        public void setDestColIndex(int destColIndex) {
            this.destColIndex = destColIndex;
        }

        public int getDestRowIndex() {
            return this.destRowIndex;
        }

        public void setDestRowIndex(int destRowIndex) {
            this.destRowIndex = destRowIndex;
        }
    }
}

