/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.CollectionUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTGetRowEvent;
import java.util.ArrayList;
import java.util.List;

public class KDTBody
implements IRows {
    private KDTable table;
    private ArrayList dataRows;
    private ArrayList rows;

    public KDTBody(KDTable table) {
        this.table = table;
        this.rows = new ArrayList();
        this.dataRows = this.rows;
    }

    @Override
    public int size() {
        return this.rows.size();
    }

    @Override
    public int virtualSize() {
        if (this.table.getDataRequestManager().getDataRequestMode() == 0) {
            return this.rows.size();
        }
        if (this.table.getRowCount2() >= 0) {
            return this.table.getRowCount2();
        }
        return this.rows.size() + 1;
    }

    @Override
    public void addRow(int rowIndex, KDTRow row) {
        if (rowIndex < 0) {
            return;
        }
        if (rowIndex > this.size()) {
            CollectionUtil.resizeList((List)this.rows, (int)rowIndex);
        }
        this.rows.add(rowIndex, row);
    }

    @Override
    public void setRow(int rowIndex, KDTRow row) {
        if (rowIndex < 0 || rowIndex >= this.size()) {
            this.addRow(rowIndex, row);
        } else {
            this.rows.set(rowIndex, row);
        }
    }

    @Override
    public void addColumn(int colIndex, KDTCell cell) {
        for (int i = 0; i < this.rows.size(); ++i) {
            KDTRow row = this.getRow2(i);
            if (row == null) continue;
            row.addCell(colIndex, cell);
        }
    }

    @Override
    public KDTRow removeRow(int rowIndex) {
        return (KDTRow)this.rows.remove(rowIndex);
    }

    public void removeRows() {
        this.rows.clear();
        this.dataRows.clear();
    }

    void setRowNull(int r1, int r2) {
        for (int i = r1; i <= r2; ++i) {
            if (i >= this.rows.size()) {
                return;
            }
            this.rows.set(i, null);
        }
    }

    @Override
    public KDTRow getRow(int rowIndex) {
        KDTRow row = this.getRow2(rowIndex);
        if (row == null && this.table.getDataRequestManager().doDataRequest(rowIndex) > 0) {
            row = this.getRow2(rowIndex);
        }
        if (this.table.getGetRowListener() != null) {
            this.table.getGetRowListener().getRow(new KDTGetRowEvent(this.table, rowIndex));
        }
        return row;
    }

    @Override
    public KDTRow getRow2(int rowIndex) {
        return rowIndex < 0 || rowIndex >= this.size() ? null : (KDTRow)this.rows.get(rowIndex);
    }

    @Override
    public int getRowHeight(int rowIndex) {
        KDTRow row = this.getRow(rowIndex);
        if (row != null) {
            if (row.getStyle().isHided()) {
                return 0;
            }
            int height = row.getHeight();
            if (height == -1) {
                height = this.table.getDefaultRowHeight();
            }
            return height;
        }
        return -1;
    }

    @Override
    public void setRowHeight(int rowIndex, int height) {
        KDTRow row = this.getRow(rowIndex);
        if (row != null) {
            row.setHeight(height);
        }
    }

    @Override
    public int getHeight(int top, int bottom) {
        if (top < 0) {
            top = 0;
        }
        int height = 0;
        for (int i = top; i <= bottom; ++i) {
            height += this.getRowHeight(i);
        }
        return height;
    }

    @Override
    public int getHeight() {
        int height = 0;
        for (int i = 0; i < this.size(); ++i) {
            height += this.getRowHeight(i);
        }
        return height;
    }

    @Override
    public boolean isCellEquals(KDTCell cell1, KDTCell cell2) {
        Object value1 = null;
        Object value2 = null;
        if (cell1 != null) {
            value1 = cell1.getValue();
        }
        if (cell2 != null) {
            value2 = cell2.getValue();
        }
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null || value2 == null) {
            return false;
        }
        return value1.equals(value2);
    }

    void backupRows() {
        int size = this.rows.size();
        this.dataRows = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.dataRows.add(this.rows.get(i));
        }
    }

    void resumeRows() {
        if (this.rows != this.dataRows) {
            this.rows.clear();
            this.rows = this.dataRows;
        }
    }

    KDTRow getDataRow(int rowIndex) {
        if (this.dataRows != null && rowIndex >= 0 && rowIndex < this.size()) {
            return (KDTRow)this.dataRows.get(rowIndex);
        }
        return null;
    }

    @Override
    public int getType() {
        return 1;
    }

    public List getRows() {
        return this.rows;
    }

    public KDTCell getCell(int rowIndex, int colIndex) {
        KDTRow row = this.getRow(rowIndex);
        if (row != null) {
            return row.getCell(colIndex);
        }
        return null;
    }

    public void exchangeColumn(int from, int to) {
        for (int i = 0; i < this.rows.size(); ++i) {
            KDTRow row = (KDTRow)this.rows.get(i);
            if (row == null) continue;
            row.exchangeColumn(from, to);
        }
    }

    public void moveColumn(int from, int to) {
        for (int i = 0; i < this.rows.size(); ++i) {
            KDTRow row = (KDTRow)this.rows.get(i);
            if (row == null) continue;
            row.moveColumn(from, to);
        }
    }

    public void moveRow(int from, int to) {
        Object fromCell = this.rows.get(from);
        this.rows.remove(from);
        this.rows.add(to, fromCell);
    }

    public void exchangeRow(int from, int to) {
        Object fromCell = this.rows.get(from);
        Object toCell = this.rows.get(to);
        this.rows.set(from, toCell);
        this.rows.set(to, fromCell);
    }
}

