/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.data.DataSetWrapper;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.DataSource;
import com.kingdee.cosmic.ctrl.kdf.data.datasource.ObjectDataSource;
import com.kingdee.cosmic.ctrl.kdf.data.impl.DataSetWrapperFactory;
import com.kingdee.cosmic.ctrl.kdf.table.BindInfo;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTLayoutInfo;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTDataRequestListener;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class KDTDataRequestManager {
    private static final Logger log = LogUtil.getPackageLogger(KDTDataRequestManager.class);
    public static final int REAL_MODE = 0;
    public static final int VIRTUAL_MODE_PAGE = 1;
    public static final int VIRTUAL_MODE_GROUP = 2;
    public static int defaultPageRow;
    private KDTable table;
    private DataSetWrapperFactory dataSetFactory;
    private DataSourceProxyList dsProxyList;
    private int dataRequestMode = 0;
    private volatile int pageRowCount = defaultPageRow;
    private boolean memoryCallback = false;
    private Object parameterEx;
    private boolean _isExporting;
    private boolean exportMemoryCallback = false;
    private int exportPageRowCount = defaultPageRow;
    private int queryPageRowCount = defaultPageRow;
    private Map<Integer, Boolean> page = new HashMap<Integer, Boolean>();

    public KDTDataRequestManager(KDTable table) {
        this.table = table;
    }

    public DataSetWrapperFactory getDataSetFactory() {
        if (this.dataSetFactory == null) {
            this.dataSetFactory = new DataSetWrapperFactory();
        }
        return this.dataSetFactory;
    }

    DataSourceProxyList getDsProxyList() {
        if (this.dsProxyList == null) {
            this.dsProxyList = new DataSourceProxyList();
        }
        return this.dsProxyList;
    }

    public void putBindContents(String key, String objectName, String fieldName) {
        int index = this.table.getColumnIndex(key);
        this.putBindContents(index, objectName, fieldName);
    }

    public void putBindContents(int index, String objectName, String fieldName) {
        if (StringUtil.isEmptyString((String)objectName) || StringUtil.isEmptyString((String)fieldName)) {
            return;
        }
        BindInfo bindInfo = new BindInfo();
        bindInfo.setDataSourceName(objectName);
        bindInfo.setFieldName(fieldName);
        DataSetWrapper ds = this.getDsProxyList().addDataSource(objectName);
        bindInfo.setDataSet(ds);
        this.table.getColumns().getColumn(index).setBindInfo(bindInfo);
    }

    void removeBindContents() {
        this.getDsProxyList().clear();
        int colCount = this.table.getColumnCount();
        for (int i = 0; i < colCount; ++i) {
            KDTColumn column = this.table.getColumns().getColumn(i);
            column.setBindInfo(null);
        }
    }

    public int getDataRequestMode() {
        return this.dataRequestMode;
    }

    public void setDataRequestMode(int dataRequestMode) {
        this.dataRequestMode = dataRequestMode;
    }

    public int getPageRowCount() {
        return this.pageRowCount;
    }

    public void setPageRowCount(int pageRowCount) {
        int maxRequestCount = 500;
        if (pageRowCount < maxRequestCount) {
            this.pageRowCount = pageRowCount;
            this.queryPageRowCount = pageRowCount;
        } else {
            this.pageRowCount = maxRequestCount;
            this.queryPageRowCount = maxRequestCount;
        }
    }

    public void setExportPageRowCount(int pageRowCount) {
        int maxRequestCount = 500;
        this.exportPageRowCount = pageRowCount < maxRequestCount ? pageRowCount : maxRequestCount;
    }

    public int getExportPageRowCount() {
        return this.exportPageRowCount;
    }

    public Object getParameterEx() {
        return this.parameterEx;
    }

    public void setParameterEx(Object parameterEx) {
        this.parameterEx = parameterEx;
    }

    public synchronized int doDataRequest(int rowIndex) {
        if (rowIndex < 0) {
            return 0;
        }
        if (this.table.getBody().getRow2(rowIndex) != null) {
            return 1;
        }
        long databegin = System.currentTimeMillis();
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        int ret = this.doDataRequest2(rowIndex);
        this.table.setRefresh(refresh ? refresh : this.table.isRefresh());
        KDTable.printDebugInfo("---doDataRequest consuming " + (System.currentTimeMillis() - databegin));
        return ret;
    }

    int doDataRequest2(int rowIndex) {
        int returnValue = 0;
        int r1 = 0;
        int r2 = -1;
        int rowCount = this.table.getRowCount2();
        if (this.dataRequestMode == 0) {
            if (this.table.getBody().size() > 0) {
                return 0;
            }
            if (rowCount < 0) {
                r2 = 0x7FFFFFFE;
            } else {
                if (rowCount == 0) {
                    return 0;
                }
                r2 = rowCount - 1;
            }
            this.doDataRequestReal(r1, r2);
            returnValue = this.table.getBody().size();
            r2 = returnValue - 1;
            this.table.setRowCount(returnValue);
        } else if (this.dataRequestMode == 1) {
            if (rowCount >= 0 && rowIndex >= rowCount) {
                return 0;
            }
            int pageIndex = rowIndex / this.pageRowCount;
            r1 = this._isExporting ? rowIndex : pageIndex * this.pageRowCount;
            r2 = r1 + this.pageRowCount - 1;
            if (rowCount >= 0 && r2 >= rowCount) {
                r2 = rowCount - 1;
            }
            int oldBodySize = this.table.getBody().size();
            long databegin = System.currentTimeMillis();
            this.doDataRequestPage(r1, r2);
            KDTable.printDebugInfo("---doDataRequestPage consuming " + (System.currentTimeMillis() - databegin));
            returnValue = r2 < oldBodySize ? this.pageRowCount : this.table.getBody().size() - oldBodySize;
            if (rowCount == -1 && returnValue != this.pageRowCount) {
                r2 = r1 + returnValue - 1;
                if (r2 + 1 < oldBodySize) {
                    this.table.setRowCount(oldBodySize);
                } else {
                    this.table.setRowCount(r2 + 1);
                }
            }
            this.doMemoryCallback(pageIndex, r1, r2);
        } else {
            this.doDataRequestGroup(rowIndex);
        }
        int colCount = this.table.getColumnCount();
        if (returnValue > 0) {
            this.table.autoMerge = false;
            this.table.getHeadMergeManager().mergeFreeEx(0, 0, this.table.getHeadRowCount() - 1, this.table.getColumnCount() - 1);
            if (this.table.getGroupManager().isGroup()) {
                this.table.getGroupManager().group(r1, r2);
            } else {
                this.table.getMergeManager().mergeFreeEx(r1, 0, r2, colCount - 1);
            }
            this.table.getLayoutManager().invalidateHorizonLast();
            this.table.getLayoutManager().invalidateVerticalLast();
        } else if (returnValue == 0) {
            r2 = r1 - 1;
        }
        this.fireTableDataFill(r1, 0, r2, colCount - 1);
        return returnValue;
    }

    private void doDataRequestReal(int r1, int r2) {
        if (this.getDsProxyList().size() > 0) {
            this.requestData(r1, r2, null);
        } else {
            this.fireTableDataRequest(r1, r2, 0, this.table.getColumnCount() - 1);
        }
    }

    private void doDataRequestPage(int r1, int r2) {
        if (this.getDsProxyList().size() > 0) {
            this.requestData(r1, r2, null);
        } else {
            this.fireTableDataRequest(r1, r2, 0, this.table.getColumnCount() - 1);
        }
    }

    public boolean isRequestDataByQuery() {
        return this.getDsProxyList().size() > 0;
    }

    private void doDataRequestGroup(int rowIndex) {
    }

    private void fireTableDataRequest(int r1, int r2, int c1, int c2) {
        KDTDataRequestEvent e = new KDTDataRequestEvent(this.table);
        e.setDataRequestMode(this.dataRequestMode);
        e.setFirstRow(r1);
        e.setLastRow(r2);
        e.setFirstCol(c1);
        e.setLastCol(c2);
        e.setParameterEx(this.parameterEx);
        this.fireTableDataRequest(e);
    }

    private void fireTableDataFill(int r1, int c1, int r2, int c2) {
        KDTDataRequestEvent e = new KDTDataRequestEvent(this.table);
        e.setDataRequestMode(this.dataRequestMode);
        e.setFirstRow(r1);
        e.setLastRow(r2);
        e.setFirstCol(c1);
        e.setLastCol(c2);
        e.setParameterEx(this.parameterEx);
        this.fireTableDataFill(e);
    }

    private void requestData(int r1, int r2, String[] fields) {
        for (DataSourceProxy proxy : this.getDsProxyList()) {
            this.getDataSetFactory().requestData(proxy.getDsName(), proxy.getDsName(), fields, 0, (Object)r1, (Object)r2);
        }
        long fillBegin = System.currentTimeMillis();
        this.fillTableWithDS(r1, r2);
        KDTable.printDebugInfo("---fillTableWithDS consuming " + (System.currentTimeMillis() - fillBegin));
    }

    private void fillTableWithDS(int r1, int r2) {
        int colCount = this.table.getColumnCount();
        KDTColumns columns = this.table.getColumns();
        boolean[] ends = new boolean[colCount];
        int i = r1;
        while (i <= r2) {
            DataSetWrapper dataSet;
            int j;
            for (j = 0; j < colCount; ++j) {
                BindInfo bindInfo = columns.getColumn(j).getBindInfo();
                dataSet = bindInfo != null ? bindInfo.getDataSet() : null;
                if (ends[j] || dataSet != null && dataSet.hasNext()) continue;
                ends[j] = true;
            }
            if (this.isAllTrue(ends)) break;
            for (DataSourceProxy proxy : this.getDsProxyList()) {
                proxy.getDsWrapper().next();
            }
            IRow row = this.table.setRow(i++);
            for (j = 0; j < colCount; ++j) {
                String field;
                if (ends[j]) continue;
                BindInfo bindInfo = columns.getColumn(j).getBindInfo();
                if (bindInfo != null) {
                    dataSet = bindInfo.getDataSet();
                    field = bindInfo.getFieldName();
                } else {
                    dataSet = null;
                    field = null;
                }
                if (dataSet != null && field != null) {
                    row.getCell(j).setValue(dataSet.getField(field).getValue());
                    continue;
                }
                ends[j] = true;
            }
        }
    }

    private boolean isAllTrue(boolean[] ends) {
        for (int i = 0; i < ends.length; ++i) {
            if (ends[i]) continue;
            return false;
        }
        return true;
    }

    public void addDataRequestListener(KDTDataRequestListener l) {
        this.table.getListenerList().add(KDTDataRequestListener.class, l);
    }

    public void removeDataRequestListener(KDTDataRequestListener l) {
        this.table.getListenerList().remove(KDTDataRequestListener.class, l);
    }

    public void addDataFillListener(KDTDataFillListener l) {
        this.table.getListenerList().add(KDTDataFillListener.class, l);
    }

    public void removeDataFillListener(KDTDataFillListener l) {
        this.table.getListenerList().remove(KDTDataFillListener.class, l);
    }

    void fireTableDataRequest(KDTDataRequestEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTDataRequestListener.class) continue;
            ((KDTDataRequestListener)listeners[i + 1]).tableDataRequest(e);
        }
    }

    void fireTableDataFill(KDTDataRequestEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTDataFillListener.class) continue;
            ((KDTDataFillListener)listeners[i + 1]).afterDataFill(e);
        }
    }

    public boolean isNeedMemoryCallBack(int currPage) {
        if (currPage <= 1) {
            return false;
        }
        if (!this._isExporting) {
            return this.isMemoryCallback();
        }
        if (this._isExporting) {
            return this.isMemoryCallback() || this.isExportMemoryCallback();
        }
        return false;
    }

    public void doMemoryCallback(int currPage) {
        this.doMemoryCallback(currPage, -1, -1);
    }

    public void doMemoryCallback(int currPage, int r1, int r2) {
        if (!this.isNeedMemoryCallBack(currPage)) {
            return;
        }
        if (currPage <= 1) {
            this.page.clear();
        }
        int pageTotal = (this.table.getBody().size() - 1) / this.pageRowCount + 1;
        if (!this._isExporting && pageTotal <= 2) {
            return;
        }
        boolean[] pageKeep = new boolean[pageTotal];
        this.setPageKeep(pageKeep, 0);
        if (currPage - 1 > 0) {
            this.setPageKeep(pageKeep, currPage - 1);
        }
        this.setPageKeep(pageKeep, currPage);
        int vCount = this.table.getVerticalCount();
        if (this._isExporting) {
            if (vCount == 2) {
                int row2;
                int page2;
                KDTVertical info = this.table.getLayoutManager().getVertical(1);
                int row1 = info.getFirst();
                int page1 = row1 / this.pageRowCount;
                if (page1 == (page2 = (row2 = ((KDTLayoutInfo)info).getLast()) / this.pageRowCount)) {
                    if ((row1 %= this.pageRowCount) > (row2 = this.pageRowCount - row2 % this.pageRowCount)) {
                        ++page2;
                    } else {
                        --page1;
                    }
                }
                this.setPageKeep(pageKeep, page1);
                this.setPageKeep(pageKeep, page2);
            } else {
                for (int i = 1; i < vCount; ++i) {
                    KDTVertical info = this.table.getLayoutManager().getVertical(i);
                    int row1 = info.getFirst();
                    int row2 = ((KDTLayoutInfo)info).getLast();
                    int page1 = row1 / this.pageRowCount;
                    int page2 = row2 / this.pageRowCount;
                    this.setPageKeep(pageKeep, page1);
                    this.setPageKeep(pageKeep, page2);
                }
            }
        }
        this.keepCoalescedPages(pageKeep, r1, r2);
        int colCount = this.table.getColumnCount();
        for (int j = 0; j < colCount; ++j) {
            this.table.getColumn(j).getKDTColumn().getGroupBlockList().clear();
        }
        for (int i = 0; i < pageKeep.length; ++i) {
            if (pageKeep[i] || this.page.get(i) == null || !Boolean.TRUE.equals(this.page.get(i))) continue;
            this.page.remove(i);
            this.removePage(i);
        }
    }

    private void keepCoalescedPages(boolean[] pageKeep, int r1, int r2) {
        for (KDTMergeBlock block : this.table.getMergeManager().getMergeBlockSet()) {
            int page1 = block.getTop() / this.pageRowCount;
            int page2 = block.getBottom() / this.pageRowCount;
            if (page1 > r2 || page2 < r1 || page1 == page2) continue;
            for (int i = page1; i <= page2; ++i) {
                this.setPageKeep(pageKeep, i);
            }
        }
    }

    void setPageKeep(boolean[] pageKeep, int pageIndex) {
        if (pageIndex >= 0 && pageIndex < pageKeep.length) {
            pageKeep[pageIndex] = true;
            this.page.put(pageIndex, true);
        }
    }

    void removePage(int index) {
        int r1 = index * this.pageRowCount;
        int r2 = r1 + this.pageRowCount - 1;
        KDTBody body = this.table.getBody();
        if (r2 >= body.size()) {
            r2 -= body.size() - 1;
        }
        for (int row = r1; row <= r2; ++row) {
            boolean remove = true;
            int colCount = this.table.getColumnCount();
            for (int j = 0; j < colCount && remove; ++j) {
                KDTRow k = body.getRow2(r1);
                if (k == null) continue;
                KDTMergeBlock cellMergeBlock = null;
                if (k.getCell(j) != null) {
                    cellMergeBlock = k.getCell(j).getMergeBlock();
                }
                if (cellMergeBlock == null || cellMergeBlock.getTop() == cellMergeBlock.getBottom() || cellMergeBlock.getLeft() == cellMergeBlock.getRight() || cellMergeBlock.getTop() != r1) continue;
                remove = false;
            }
            if (!remove) continue;
            body.setRowNull(row, row);
        }
        Set set = this.table.getMergeManager().getMergeBlockSet();
        ArrayList<KDTMergeBlock> tobeRemoved = new ArrayList<KDTMergeBlock>();
        for (KDTMergeBlock block : set) {
            if (!this.isPageContainsBlock(r1, r2, block)) continue;
            tobeRemoved.add(block);
        }
        set.removeAll(tobeRemoved);
    }

    private boolean isPageContainsBlock(int pageTopIndex, int pageBottomIndex, KDTMergeBlock block) {
        return pageTopIndex <= block.getTop() && pageBottomIndex >= block.getBottom();
    }

    public boolean isMemoryCallback() {
        return this.memoryCallback;
    }

    public void setMemoryCallback(boolean memoryCallback) {
        this.memoryCallback = memoryCallback;
    }

    public boolean isExportMemoryCallback() {
        return this.exportMemoryCallback;
    }

    public void setExportMemoryCallback(boolean memoryCallback) {
        this.exportMemoryCallback = memoryCallback;
    }

    public void setExporting(boolean isExporting) {
        this._isExporting = isExporting;
        this.pageRowCount = this._isExporting ? this.exportPageRowCount : this.queryPageRowCount;
    }

    public boolean isExporting() {
        return this._isExporting;
    }

    static {
        Dimension d = KDToolkit.getScreenSize();
        int h = 768;
        if (d != null) {
            h = d.height;
        }
        defaultPageRow = h <= 768 ? 30 : 50;
    }

    public static class DataSourceProxy {
        private String dsName;
        private DataSetWrapper dsWrapper;
        private int counter;

        public int getCounter() {
            return this.counter;
        }

        public void addCounter() {
            ++this.counter;
        }

        public void removeCounter() {
            --this.counter;
        }

        public String getDsName() {
            return this.dsName;
        }

        public void setDsName(String dsName) {
            this.dsName = dsName;
        }

        public DataSetWrapper getDsWrapper() {
            return this.dsWrapper;
        }

        public void setDsWrapper(DataSetWrapper dsWrapper) {
            this.dsWrapper = dsWrapper;
        }
    }

    public class DataSourceProxyList
    extends ArrayList {
        private static final long serialVersionUID = 1062852723540739805L;

        DataSourceProxy getDataSourceProxy(String dsName) {
            for (DataSourceProxy proxy : this) {
                if (!proxy.getDsName().equals(dsName)) continue;
                return proxy;
            }
            return null;
        }

        public DataSetWrapper getDataSource(int index) {
            DataSourceProxy proxy = (DataSourceProxy)this.get(index);
            if (proxy != null) {
                return proxy.getDsWrapper();
            }
            return null;
        }

        public DataSetWrapper getDataSource(String dsName) {
            DataSourceProxy proxy = this.getDataSourceProxy(dsName);
            if (proxy != null) {
                return proxy.getDsWrapper();
            }
            return null;
        }

        public DataSetWrapper addDataSource(String dsName) {
            if (!StringUtil.isEmptyString((String)dsName)) {
                DataSourceProxy proxy = this.getDataSourceProxy(dsName);
                if (proxy == null) {
                    KDTDataRequestManager.this.getDataSetFactory().addDataSource((DataSource)new ObjectDataSource(dsName, dsName));
                    proxy = new DataSourceProxy();
                    proxy.setDsName(dsName);
                    proxy.setDsWrapper(KDTDataRequestManager.this.getDataSetFactory().getDataSetWrapper(dsName));
                    proxy.addCounter();
                    this.add(proxy);
                } else {
                    proxy.addCounter();
                }
                return proxy.getDsWrapper();
            }
            return null;
        }

        public DataSetWrapper removeDataSource(String dsName) {
            DataSourceProxy proxy;
            if (!StringUtil.isEmptyString((String)dsName) && (proxy = this.getDataSourceProxy(dsName)) != null) {
                proxy.removeCounter();
                if (proxy.counter <= 0) {
                    this.remove(proxy);
                }
                return proxy.getDsWrapper();
            }
            return null;
        }
    }
}

