/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.kdf.table.DataTable;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTFindParameter;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTReplaceParameter;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTransferAction;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTransferHandle;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.StringTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.DataActionEvent;
import com.kingdee.cosmic.ctrl.kdf.util.file.IDObject;
import com.kingdee.cosmic.ctrl.kdf.util.file.IXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Point;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class KDTEditHelper {
    private KDTable table;
    private KDTTransferHandle th;
    public static final int ALL = 15;
    public static final int STYLE = 1;
    public static final int VALUE = 2;
    public static final int FORMULA = 4;
    public static final int USEROBJECT = 8;
    public static final int FID = 22;
    public static final int DISPLAYVALUE = 50;
    public static final int DELETE_ALL = 15;
    public static final int DELETE_CONTENT = 14;
    public static final int DELETE_STYLE = 1;
    public static final int DELETE_VALUE = 2;
    public static final int DELETE_FORMULA = 4;
    public static final int DELETE_USEROBJECT = 8;

    public KDTEditHelper(KDTable table) {
        this.table = table;
    }

    public Point find(KDTFindParameter para) {
        return null;
    }

    public Point[] findAll(KDTFindParameter para) {
        ArrayList result = new ArrayList();
        this.findInRange(para, result, false);
        int length = result.size();
        Point[] ps = new Point[length];
        result.toArray(ps);
        return ps;
    }

    public Point[] replaceAll(KDTReplaceParameter para) {
        ArrayList result = new ArrayList();
        this.findInRange(para, result, true);
        int length = result.size();
        Point[] ps = new Point[length];
        result.toArray(ps);
        return ps;
    }

    private void findInRange(KDTFindParameter para, List result, boolean replace) {
        KDTRange range = para.getRange();
        if (range == null) {
            range = new KDTRange();
            KDTBlock block = new KDTBlock();
            block.setMode(8);
            range.add(block);
        }
        int blockCount = range.size();
        for (int i = 0; i < blockCount; ++i) {
            IBlock block = (IBlock)range.get(i);
            this.findInBlock(para, block, result, replace);
        }
    }

    private void findInBlock(KDTFindParameter para, IBlock block, List result, boolean replace) {
        KDTRow row;
        switch (block.getMode()) {
            case 8: {
                block.setTop(0);
                block.setLeft(0);
                block.setBottom(this.table.getRowCount3() - 1);
                block.setRight(this.table.getColumnCount() - 1);
                break;
            }
            case 4: {
                block.setTop(0);
                block.setBottom(this.table.getRowCount3() - 1);
                break;
            }
            case 2: {
                block.setLeft(0);
                block.setRight(this.table.getColumnCount() - 1);
                break;
            }
        }
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        KDTBody rows = this.table.getBody();
        if (!(para instanceof KDTReplaceParameter)) {
            replace = false;
        }
        for (int i = top; i <= bottom && (row = rows.getRow(i)) != null; ++i) {
            for (int j = left; j <= right; ++j) {
                KDTCell cell = row.getCell(j);
                if (!this.checkCell(cell, para)) continue;
                result.add(new Point(j, i));
                if (!replace) continue;
                KDTReplaceParameter rPara = (KDTReplaceParameter)para;
                this.setCellContent(cell, rPara.getItem(), rPara.getNewContent());
            }
        }
    }

    private boolean checkCell(KDTCell cell, KDTFindParameter para) {
        if (cell == null) {
            return false;
        }
        Object value = this.getCellContent(cell, para.getItem());
        if (value == null) {
            return false;
        }
        return value.equals(para.getContent());
    }

    private Object getCellContent(KDTCell cell, int item) {
        Object value = null;
        if ((item & 1) == 1) {
            value = cell.getValue();
        } else if ((item & 2) == 2) {
            value = cell.getExpressions();
        } else if ((item & 4) == 4) {
            value = cell.getUserObject();
        }
        return value;
    }

    private void setCellContent(KDTCell cell, int item, Object content) {
        if ((item & 1) == 1) {
            cell.setValue(content);
        } else if ((item & 2) == 2) {
            cell.setExpressions(content.toString());
        } else if ((item & 4) == 4) {
            cell.setUserObject(content);
        }
    }

    KDTTransferHandle getTransferHandle() {
        if (this.th == null) {
            this.th = new KDTTransferHandle(this.table);
        }
        return this.th;
    }

    public void copy() {
        this.copy(15);
    }

    public void copy(int mark) {
        if (!this.table.excuteBeforeAction(4, mark)) {
            return;
        }
        KDTTransferHandle th = this.getTransferHandle();
        if (mark == 22) {
            th.setMark(15);
            this.table.setCopyFID(true);
        } else if (mark == 50) {
            th.setMark(50);
            this.table.setCopyFID(false);
        } else {
            th.setMark(mark);
            this.table.setCopyFID(false);
        }
        th.exportToClipboard();
        this.table.excuteAfterAction(4, mark);
    }

    public void paste() {
        this.paste(15);
    }

    public void paste(int mark) {
        if (!this.table.excuteBeforeAction(5, mark)) {
            return;
        }
        KDTTransferHandle th = this.getTransferHandle();
        th.setMark(mark);
        th.importFromClipboard();
        this.table.excuteAfterAction(5, mark);
    }

    public KDTSelectBlock prePaste() {
        KDTTransferHandle th = this.getTransferHandle();
        th.setMark(15);
        return th.preImportFromClipboard();
    }

    public boolean isPastable() {
        return this.getTransferHandle().isClipboardDataAvailable();
    }

    public void cut() {
        this.cut(15);
    }

    public void cut(int mark) {
        if (!this.table.excuteBeforeAction(6, mark)) {
            return;
        }
        this.copy(mark);
        KDTRange range = this.table.getSelectManager().toRange();
        this.delete(range.getSequenceRange(), mark);
        this.table.excuteAfterAction(6, mark);
    }

    String getXmlForClipboard(DataTable datTable) {
        HashMap<String, Object> xmlParamMap = new HashMap<String, Object>();
        xmlParamMap.put("destination", "clipboard");
        xmlParamMap.put("type", "xml");
        xmlParamMap.put("dataTable", datTable);
        this.table.fireExportEvent(new DataActionEvent(this, 0, xmlParamMap));
        KDF kdf = new KDF();
        StringWriter writer = new StringWriter();
        kdf.setTableTrans((IXmlTrans)new ClipboardXmlTranse(datTable));
        kdf.addTable((IDObject)this.table);
        kdf.save((Writer)writer);
        this.table.fireExportEvent(new DataActionEvent(this, 1, xmlParamMap));
        return ((Object)writer).toString();
    }

    String getStringForClipboard(DataTable datTable) {
        StringTable st = new StringTable();
        HashMap<String, Object> strParamMap = new HashMap<String, Object>();
        strParamMap.put("destination", "clipboard");
        strParamMap.put("type", "string");
        strParamMap.put("stringTable", st);
        this.table.fireExportEvent(new DataActionEvent(this, 0, strParamMap));
        st.load(datTable, this.table.getCellDisplayMode());
        StringWriter writer = new StringWriter();
        st.save(writer);
        this.table.fireExportEvent(new DataActionEvent(this, 1, strParamMap));
        return ((Object)writer).toString();
    }

    void parseXmlFromClipboard(String xml, int mark) {
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        DataTable dt = new DataTable(mark);
        HashMap<String, Object> xmlParamMap = new HashMap<String, Object>();
        xmlParamMap.put("destination", "clipboard");
        xmlParamMap.put("type", "xml");
        xmlParamMap.put("dataTable", dt);
        this.table.fireImportEvent(new DataActionEvent(this, 0, xmlParamMap));
        dt.load(new StringReader(xml));
        dt.save(this.table, this.table.getSelectManager().toRange());
        this.table.fireImportEvent(new DataActionEvent(this, 1, xmlParamMap));
        this.table.setRefresh(refresh);
        this.table.repaint();
    }

    public void parseStringFromClipboard(String str) {
        boolean refresh = this.table.isRefresh();
        this.table.setRefresh(false);
        StringTable st = new StringTable();
        HashMap<String, Object> strParamMap = new HashMap<String, Object>();
        strParamMap.put("destination", "clipboard");
        strParamMap.put("type", "string");
        strParamMap.put("stringTable", st);
        this.table.fireImportEvent(new DataActionEvent(this, 0, strParamMap));
        st.load(str);
        KDTSelectManager sm = this.table.getSelectManager();
        KDTSelectBlock block = sm.get();
        if (block != null) {
            st.save(this.table, block.getTop(), block.getLeft());
        }
        this.table.fireImportEvent(new DataActionEvent(this, 1, strParamMap));
        this.table.setRefresh(refresh);
        this.table.repaint();
    }

    public KDTSelectBlock preParseStringFromClipboard(String str) {
        StringTable st = new StringTable();
        st.load(str);
        KDTSelectManager sm = this.table.getSelectManager();
        return st.preSave(this.table, sm.getActiveRowIndex(), sm.getActiveColumnIndex());
    }

    public static boolean isAll(int mark) {
        return mark == 15;
    }

    public static boolean isDisplayValue(int mark) {
        return mark == 50;
    }

    public static boolean isStyle(int mark) {
        return (mark & 1) == 1;
    }

    public static boolean isValue(int mark) {
        return (mark & 2) == 2;
    }

    public static boolean isFormula(int mark) {
        return (mark & 4) == 4;
    }

    public static boolean isUserObject(int mark) {
        return (mark & 8) == 8;
    }

    public int delete() {
        return this.delete(this.table.getSelectManager().toRange());
    }

    public int delete(int mark) {
        return this.delete(this.table.getSelectManager().toRange(), mark);
    }

    public int delete(KDTRange range) {
        return this.delete(range, 14);
    }

    public int delete(KDTRange range, int mark) {
        if (!this.table.excuteBeforeAction(7, mark)) {
            return 0;
        }
        if (range == null) {
            return 0;
        }
        int size = range.size();
        if (size <= 0) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < size; ++i) {
            IBlock block = (IBlock)range.get(i);
            int top = 0;
            int left = 0;
            int bottom = 0;
            int right = 0;
            switch (block.getMode()) {
                case 8: {
                    top = 0;
                    left = 0;
                    bottom = this.table.getRowCount3() - 1;
                    right = this.table.getColumnCount() - 1;
                    break;
                }
                case 4: {
                    top = 0;
                    left = block.getLeft();
                    bottom = this.table.getRowCount3() - 1;
                    right = block.getRight();
                    break;
                }
                case 2: {
                    top = block.getTop();
                    left = 0;
                    bottom = block.getBottom();
                    right = this.table.getColumnCount() - 1;
                    break;
                }
                case 1: {
                    top = block.getTop();
                    left = block.getLeft();
                    bottom = block.getBottom();
                    right = block.getRight();
                    break;
                }
                default: {
                    return 0;
                }
            }
            for (int j = top; j <= bottom; ++j) {
                for (int k = left; k <= right; ++k) {
                    if (!this.deleteCell2(j, k, mark)) continue;
                    ++count;
                }
            }
        }
        if (count > 0) {
            this.table.repaint();
        }
        this.table.excuteAfterAction(7, mark);
        return count;
    }

    public ICell deleteCell(int rowIndex, int colIndex) {
        return this.deleteCell(rowIndex, colIndex, 14);
    }

    public ICell deleteCell(int rowIndex, int colIndex, int mark) {
        if (colIndex >= this.table.getColumnCount()) {
            return null;
        }
        ICell cell = this.table.getRow(rowIndex).getCell(colIndex);
        this.deleteCell2(rowIndex, colIndex, mark);
        this.table.repaint();
        return cell;
    }

    boolean deleteCell2(int rowIndex, int colIndex, int mark) {
        KDTRow row = this.table.getBody().getRow(rowIndex);
        if (row != null) {
            KDTCell cell = row.getCell(colIndex);
            if (cell == null) {
                return false;
            }
            if (cell.getStyle().isLocked()) {
                return false;
            }
            if (KDTEditHelper.isAll(mark)) {
                this.splitMergeBlock(cell);
                Object oldValue = cell.getValue();
                row.setCell(colIndex, null);
                if (oldValue != null) {
                    KDTCellIndex index = new KDTCellIndex();
                    index.setRowIndex(rowIndex);
                    index.setColIndex(colIndex);
                    index.setType(1);
                    this.table.fireCellPropertyChange("cellValue", oldValue, null, index);
                }
            } else {
                if (KDTEditHelper.isValue(mark)) {
                    Object oldValue = cell.getValue();
                    if (oldValue != null) {
                        KDTCellIndex index = new KDTCellIndex();
                        index.setRowIndex(rowIndex);
                        index.setColIndex(colIndex);
                        index.setType(1);
                        this.table.fireCellPropertyChange("cellValue", oldValue, null, index);
                    }
                    cell.setValue(null);
                }
                if (KDTEditHelper.isStyle(mark)) {
                    this.splitMergeBlock(cell);
                    ShareStyleAttributes ssaRow = row.getSSA();
                    ShareStyleAttributes ssaCol = this.table.getColumns().getColumn(colIndex).getSSA();
                    ShareStyleAttributes ssa = Styles.getEmptySSA();
                    Style style = this.table.getBlankCellStyle(ssaRow, ssaCol);
                    cell.setSSA(ssa);
                    cell.setStyle(style);
                }
                if (KDTEditHelper.isFormula(mark)) {
                    cell.setExpressions(null);
                }
                if (KDTEditHelper.isUserObject(mark)) {
                    cell.setUserObject(null);
                }
            }
            if (this.table.scriptManager != null) {
                this.table.scriptManager.cellPropertyChanged(rowIndex, colIndex);
            }
            return true;
        }
        return false;
    }

    void splitMergeBlock(KDTCell cell) {
        KDTMergeBlock block = cell.getMergeBlock();
        if (block != null) {
            this.table.getMergeManager().splitBlock(block.getTop(), block.getLeft(), block.getBottom(), block.getRight());
        }
    }

    public KDTSelectBlock preParseXmlFromClipboard(String xml, int mark) {
        DataTable dt = new DataTable(mark);
        dt.load(new StringReader(xml));
        return dt.preSave(this.table, this.table.getSelectManager().toRange());
    }

    public void setCoypMode(int mode) {
        if (mode == 15 || mode == 1 || mode == 2 || mode == 4 || mode == 8) {
            KDTTransferAction copyAction = (KDTTransferAction)this.table.getActionMap().get("Copy");
            copyAction.setCopyMode(mode);
        }
    }

    public int getCopyMode() {
        return ((KDTTransferAction)this.table.getActionMap().get("Copy")).getCopyMode();
    }

    static class ClipboardXmlTranse
    implements IXmlTrans {
        private DataTable datTable;

        public ClipboardXmlTranse(DataTable datTable) {
            this.datTable = datTable;
        }

        public Object readFromNode(IXmlElement ele, KDF kdf) {
            return null;
        }

        public IXmlElement writeToNode(Object obj, KDF kdf) {
            if (!(obj instanceof KDTable)) {
                throw new IllegalArgumentException("support KDTable only");
            }
            KDTable table = (KDTable)obj;
            this.datTable.load(table, table.getSelectManager().toRange());
            return this.datTable.out(kdf);
        }
    }
}

