/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.ITravelPolicy;
import com.kingdee.cosmic.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import java.awt.event.ActionEvent;
import javax.swing.Action;

public class KDTFocusChangeAction
extends KDTAbstractAction {
    private static final long serialVersionUID = 905591797930305192L;
    public static final short DIR_ROW = 0;
    public static final short DIR_COLUMN = 1;
    protected boolean reverse;
    protected boolean isAddRow;
    protected short dirCode;
    protected ITravelPolicy travelPolicy;
    protected Action actionAfterAddRow;

    public KDTFocusChangeAction(KDTable table, short dirCode, boolean isReverse) {
        this(table, dirCode, isReverse, false);
    }

    public KDTFocusChangeAction(KDTable table, short dirCode, boolean isReverse, boolean isAddRow) {
        this(table, dirCode, isReverse, isAddRow, null);
    }

    public KDTFocusChangeAction(KDTable table, short dirCode, boolean isReverse, boolean isAddRow, Action actionAfterAddRow) {
        super(table);
        this.reverse = isReverse;
        this.dirCode = dirCode;
        this.isAddRow = isAddRow;
        this.actionAfterAddRow = actionAfterAddRow;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.table.getBody().size() <= 0) {
            return;
        }
        this.travelPolicy = this.dirCode == 0 ? this.table.getKeyControlManager().getRowFocusTravelPolicy() : this.table.getKeyControlManager().getColumnFocusTravelPolicy();
        if (this.table.getEditManager().stopEditing() != 0) {
            return;
        }
        KDTSelectManager sman = this.table.getSelectManager();
        int rowIndex = sman.getActiveRowIndex();
        int colIndex = sman.getActiveColumnIndex();
        KDTCellIndex cellIndex = new KDTCellIndex();
        if (!this.reverse) {
            if (this.isAddRow && colIndex >= KDTableUtil.getLastVisibleColumnIndex(this.table)) {
                if (this.table.getSelectManager().getEnterTravelAction() != null) {
                    this.table.getSelectManager().getEnterTravelAction().enterAction(rowIndex);
                    this.table.getViewManager().updateBounds();
                    cellIndex = this.travelPolicy.nextCellIndex(rowIndex, KDTableUtil.getLastVisibleColumnIndex(this.table));
                } else if (rowIndex >= KDTableUtil.getLastVisibleRowIndex(this.table)) {
                    this.addRow();
                    this.table.getViewManager().updateBounds();
                    cellIndex = this.travelPolicy.nextCellIndex(rowIndex, KDTableUtil.getLastVisibleColumnIndex(this.table));
                    if (this.actionAfterAddRow != null) {
                        ActionEvent evt = new ActionEvent(this.table, 0, "");
                        this.actionAfterAddRow.actionPerformed(evt);
                    }
                } else {
                    cellIndex = this.travelPolicy.nextCellIndex(rowIndex, colIndex);
                }
            } else {
                cellIndex = this.travelPolicy.nextCellIndex(rowIndex, colIndex);
            }
        } else if (this.isAddRow && rowIndex == 0 && colIndex == 0) {
            cellIndex.setColIndex(0);
            cellIndex.setRowIndex(0);
        } else {
            cellIndex = this.travelPolicy.previousCellIndex(rowIndex, colIndex);
        }
        rowIndex = cellIndex.getRowIndex();
        colIndex = cellIndex.getColIndex();
        if (sman.getSelectBlockIndexOfCell(rowIndex, colIndex) == -1) {
            sman.select(rowIndex, colIndex, rowIndex, colIndex);
        } else {
            sman.setActiveCell(rowIndex, colIndex);
        }
        int verticalIndex = this.table.getViewManager().getVerticalIndex(sman.getActiveViewIndex());
        int horizonIndex = this.table.getViewManager().getHorizonIndex(sman.getActiveViewIndex());
        this.table.getLayoutManager().getVertical(verticalIndex).scrollToShowRow(rowIndex);
        this.table.getLayoutManager().getHorizon(horizonIndex).scrollToShowCol(colIndex);
        this.table.repaint();
    }

    protected void addRow() {
        this.table.addRow();
    }
}

