/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.export.ExportManager;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.export.POIExportException;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSSheet;
import com.kingdee.cosmic.ctrl.kdf.read.POIXlsReader;
import com.kingdee.cosmic.ctrl.kdf.table.IExceptionHandler;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableXmlTrans;
import com.kingdee.cosmic.ctrl.kdf.table.Kds2Kdt;
import com.kingdee.cosmic.ctrl.kdf.table.Kdt2Kds;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDF;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFException;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class KDTIOManager {
    private static final Logger logger = LogUtil.getPackageLogger(KDTIOManager.class);
    public static final int ALL = 15;
    public static final int STYLE = 1;
    public static final int VALUE = 2;
    public static final int FORMULA = 4;
    public static final int USEROBJECT = 8;
    private KDTable table;
    private boolean expandedOnly;
    protected String tempFileDirection;
    protected IExceptionHandler exceptionHandler;
    private boolean mergeExportable = true;
    private boolean memoryCallbackWhenExport;
    private int exportSize = 1999;

    static boolean isAll(int mark) {
        return mark == 15;
    }

    static boolean isStyle(int mark) {
        return (mark & 1) == 1;
    }

    static boolean isValue(int mark) {
        return (mark & 2) == 2;
    }

    static boolean isFormula(int mark) {
        return (mark & 4) == 4;
    }

    static boolean isUserObject(int mark) {
        return (mark & 8) == 8;
    }

    public KDTIOManager(KDTable table) {
        this.table = table;
    }

    public boolean isMergeExportable() {
        return this.mergeExportable;
    }

    public void setMergeExportable(boolean mergeExportable) {
        this.mergeExportable = mergeExportable;
    }

    public void load(InputStream byteStream) {
        KDF kdf = null;
        try {
            kdf = new KDF(byteStream);
        }
        catch (KDFException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (kdf != null) {
            this.parseDefaultTable(kdf);
        }
    }

    public void load(Reader charStream) {
        KDF kdf = null;
        try {
            kdf = new KDF(charStream);
        }
        catch (KDFException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (kdf != null) {
            this.parseDefaultTable(kdf);
        }
    }

    public void load(String fileName) {
        KDF kdf = null;
        try {
            kdf = new KDF(fileName);
        }
        catch (KDFException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (kdf != null) {
            this.parseDefaultTable(kdf);
        }
    }

    public void parseFromKDS(KDSSheet sheet, int headRowCount) {
        this.parseFromKDS(sheet, headRowCount, true);
    }

    public void parseFromKDS(KDSSheet sheet, int headRowCount, boolean overwrite) {
        this.parseFromKDS(sheet, headRowCount, overwrite, 15);
    }

    public void parseFromKDS(KDSSheet sheet, int headRowCount, boolean overwrite, int mark) {
        Kds2Kdt transer = new Kds2Kdt();
        transer.parse(this.table, sheet, headRowCount, overwrite, mark);
    }

    public void parseFromKDSWithExcelHead(KDSSheet sheet) {
        this.parseFromKDSWithExcelHead(sheet, true);
    }

    public void parseFromKDSWithExcelHead(KDSSheet sheet, boolean overwrite) {
        this.parseFromKDSWithExcelHead(sheet, overwrite, 15);
    }

    public void parseFromKDSWithExcelHead(KDSSheet sheet, boolean overwrite, int mark) {
        this.parseFromKDS(sheet, 0, overwrite, mark);
        this.table.setHeadDisplayMode(1);
    }

    void loadFromExcel(String fileName, int headRowCount) {
        KDSBook book = POIXlsReader.parse((String)fileName);
        this.parseFromKDS(book.getSheet((Object)0), headRowCount);
    }

    void loadFromExcel(String fileName, int headRowCount, String sheetName) {
        KDSBook book = POIXlsReader.parse((String)fileName);
        this.parseFromKDS(book.getSheet((Object)sheetName), headRowCount);
    }

    void loadFromExcel(InputStream in, int headRowCount) {
        KDSBook book = POIXlsReader.parse((InputStream)in);
        this.parseFromKDS(book.getSheet((Object)0), headRowCount);
    }

    void loadFromExcel(InputStream in, int headRowCount, String sheetName) {
        KDSBook book = POIXlsReader.parse((InputStream)in);
        this.parseFromKDS(book.getSheet((Object)sheetName), headRowCount);
    }

    public KDSSheet saveToKDSSheet(KDSBook book, boolean withHead, boolean withIndex, String sheetName) {
        return this.saveToKDSSheet(book, withHead, withIndex, true, sheetName);
    }

    public KDSSheet saveToKDSSheet(KDSBook book, boolean withHead, boolean withIndex, boolean withHiddenCol, String sheetName) {
        return this.saveToKDSSheet(book, withHead, withIndex, withHiddenCol, sheetName, null);
    }

    public KDSSheet saveToKDSSheet(KDSBook book, boolean withHead, boolean withIndex, boolean withHiddenCol, String sheetName, KDTRange range) {
        Kdt2Kds trans = new Kdt2Kds(this.table, book);
        trans.setWithHead(withHead);
        trans.setWithIndexColumn(withIndex);
        trans.setWithHiddenCol(withHiddenCol);
        trans.setRange(range);
        return trans.transform(sheetName);
    }

    boolean isFormatOnly() {
        Object obj = this.table.getClientProperty("formatOnly");
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public void setFormatXml(String formatXml) {
        if (StringUtil.isEmptyString((String)formatXml)) {
            return;
        }
        Object obj = this.table.getClientProperty("formatOnly");
        this.table.putClientProperty("formatOnly", Boolean.TRUE);
        this.load(new StringReader(formatXml));
        this.table.putClientProperty("formatOnly", obj);
    }

    public boolean isExpandedOnly() {
        return this.expandedOnly;
    }

    public void setExpandedOnly(boolean expandedOnly) {
        this.expandedOnly = expandedOnly;
    }

    public int getTableRowCount() {
        if (this.isExpandedOnly()) {
            return this.table.getExpandedRowCount();
        }
        return this.table.getRowCount1();
    }

    public int getTableColumnCount() {
        if (this.isExpandedOnly()) {
            return this.table.getExpandedColumnCount();
        }
        return this.table.getColumnCount();
    }

    private boolean exportColumnConfirm(KDTable table, boolean isSelect, KDTRange range) {
        if (this.getBlockColumnCount(isSelect, range) > 256) {
            String msg2 = CtrlKDTableMessages.getMLS("export2Excel.maxColumnLimit", "");
            KDOptionPane.showMessageDialog((Component)table, (Object)msg2);
            return false;
        }
        return true;
    }

    private int getBlockColumnCount(boolean isSelect, KDTRange range) {
        if (range == null) {
            int tableColumnCount;
            int cnt = tableColumnCount = this.table.getColumnCount();
            for (int i = 0; i < tableColumnCount; ++i) {
                if (!this.table.getColumn(i).getStyleAttributes().isHided()) continue;
                --cnt;
            }
            return cnt;
        }
        KDTBlock block = (KDTBlock)range.get(0);
        if (!isSelect || block.getMode() == 8 || block.getMode() == 2) {
            return this.table.getColumnCount();
        }
        return block.getRight() - block.getLeft() + 1;
    }

    public void parseDefaultTable(KDF kdf) {
        boolean formatOnly = this.isFormatOnly();
        if (!formatOnly) {
            this.table.removeColumns();
            this.table.setRowCount(-1);
        }
        KDTableXmlTrans trans = new KDTableXmlTrans();
        trans.readDefaultTableFromFile(this.table, kdf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportExcelToFile(boolean isSelect, File file) {
        block15: {
            boolean isRefresh = this.table.isRefresh();
            boolean enablePaint = this.table.enableRepaint;
            this.table.setRefresh(false);
            this.table.enableRepaint(false);
            try {
                File tempFile;
                KDTRange range = null;
                if (isSelect) {
                    range = this.table.getSelectManager().toRange();
                    if ((range = range.getSequenceRange()) == null) {
                        String msg = CtrlKDTableMessages.getMLS("export2Excel.error", "");
                        KDOptionPane.showMessageDialog((Component)this.table, (Object)msg);
                        String string = null;
                        return string;
                    }
                }
                File file2 = tempFile = file != null ? file : KDTMenuManager.createTempFile(this.getTempFileDirection());
                if (tempFile == null) break block15;
                String tempFileName = tempFile.getAbsolutePath();
                KDSSheet sheet = null;
                ExportManager man = new ExportManager();
                if (!this.mergeExportable) {
                    man.setExporterParmeter(ExporterParameter.EXPORT_MERGE_BLOCKS, (Object)"FALSE");
                }
                KDSBook book = null;
                book = new KDSBook("kdtable export");
                if (!this.exportColumnConfirm(this.table, isSelect, range)) {
                    String string = null;
                    return string;
                }
                KDTDataRequestManager dataRequester = this.table.getDataRequestManager();
                boolean originSettings = dataRequester.isExportMemoryCallback();
                dataRequester.setExporting(true);
                dataRequester.setExportMemoryCallback(false);
                sheet = this.getKDSSheet(book, isSelect);
                dataRequester.setExportMemoryCallback(originSettings);
                try {
                    book.addSheet(null, sheet);
                }
                catch (Exception e1) {
                    if (this.getExceptionHandler() != null) {
                        this.getExceptionHandler().handle(e1);
                    }
                    String string = null;
                    this.table.setRefresh(isRefresh);
                    this.table.enableRepaint(enablePaint);
                    this.table.getDataRequestManager().setExporting(false);
                    return string;
                }
                try {
                    man.exportToExcel(book, tempFileName);
                }
                catch (POIExportException pee) {
                    logger.error((Object)"err", (Throwable)pee);
                }
                String string = tempFileName;
                return string;
            }
            finally {
                this.table.setRefresh(isRefresh);
                this.table.enableRepaint(enablePaint);
                this.table.getDataRequestManager().setExporting(false);
            }
        }
        return null;
    }

    private void openFile(String tempFileName) {
        block6: {
            try {
                KDTMenuManager.openFileInExcel(tempFileName);
            }
            catch (IOException e2) {
                KDFileChooser fileChooser = this.getFileChooser();
                int result = fileChooser.showSaveDialog((Component)this.table);
                if (result != 0) break block6;
                File dest = this.getSelectedFile(fileChooser);
                try {
                    File src = new File(FilenameUtils.normalize((String)tempFileName));
                    if (dest.exists() && !dest.delete()) {
                        logger.warn((Object)(dest.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
                    }
                    if (!src.renameTo(dest)) {
                        logger.warn((Object)(src.getName() + "\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25"));
                    }
                }
                catch (Exception e3) {
                    if (this.getExceptionHandler() == null) break block6;
                    this.getExceptionHandler().handle(e3);
                }
            }
        }
    }

    private boolean exportColumnConfirmFor2007(KDTable table, boolean isSelect, KDTRange range) {
        if (this.getBlockColumnCount(isSelect, range) > 16384) {
            KDOptionPane.showMessageDialog((Component)table, (Object)CtrlKDTableMessages.getMLS("cannotExportTableWithMoreThan16384Columns", "\u4e0d\u80fd\u5bfc\u51fa\u8d85\u8fc716384\u5217\u7684\u8868\u683c\uff0c\u56e0\u4e3aExcel 2007\u6700\u591a\u53ea\u80fd\u63a5\u53d716384\u5217\u3002"));
            return false;
        }
        return true;
    }

    File getSelectedFile(KDFileChooser fileChooser) {
        File file = fileChooser.getSelectedFile();
        if (file != null) {
            String path = file.getAbsolutePath();
            FileFilter ext = fileChooser.getFileFilter();
            if (ext != null && !ext.accept(file)) {
                if (ext instanceof ExcelFileFilter) {
                    path = path + ".xls";
                }
                file = new File(FilenameUtils.normalize((String)path));
            }
        }
        return file;
    }

    protected KDSSheet getKDSSheet(KDSBook book, boolean isSelect) {
        if (!isSelect) {
            return this.saveToKDSSheet(book, true, false, false, "sheet1");
        }
        return this.saveToKDSSheet(book, true, false, false, "sheet1", this.table.getSelectManager().toRange());
    }

    protected KDSSheet getKDSSheet(KDSBook book, int rowCount) {
        KDTRange range = new KDTRange();
        range.add(new KDTSelectBlock(0, 0, rowCount - 1, this.table.getColumnCount() - 1));
        return this.saveToKDSSheet(book, true, false, false, "sheet1", range);
    }

    public IExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(IExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    KDFileChooser getFileChooser() {
        String title = CtrlKDTableMessages.getMLS("FileChooserTitle", "Save As...");
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.setDialogTitle(title);
        fileChooser.setFileFilter((FileFilter)new ExcelFileFilter());
        return fileChooser;
    }

    public String getTempFileDirection() {
        return this.tempFileDirection;
    }

    public void setTempFileDirection(String tempFileDirection) {
        this.tempFileDirection = tempFileDirection;
    }

    public boolean isMemoryCallbackWhenExport() {
        return this.memoryCallbackWhenExport;
    }

    public void setMemoryCallbackWhenExport(boolean callback) {
        this.memoryCallbackWhenExport = callback;
    }

    public void exportExcelToTempFile(boolean isSelect) {
        String fileName = this.exportExcelToFile(isSelect, null);
        if (fileName != null) {
            this.openFile(fileName);
        }
    }

    void doMemeryCallBack(KDTDataRequestManager manager, int start, int end, boolean keepMergeBlock) {
        try {
            if (!this.isMemoryCallbackWhenExport()) {
                return;
            }
            long max = Runtime.getRuntime().maxMemory();
            long free = Runtime.getRuntime().freeMemory();
            System.out.println("\u5f53\u524d\u6700\u5927\u53ef\u7528\u5185\u5b58:" + max / 1024L / 1024L + "M");
            System.out.println("\u5f53\u524d\u7a7a\u95f2\u5185\u5b58:" + free / 1024L / 1024L + "M");
            long temp = max - free;
            System.out.println("\u5f53\u524d\u5360\u7528\u5185\u5b58:" + (max - free) / 1024L / 1024L + "M");
            Set set = this.table.getMergeManager().getMergeBlockSet();
            HashSet hash = null;
            if (keepMergeBlock) {
                hash = new HashSet(set);
            }
            set.clear();
            int size = this.table.columns.size();
            for (int i = 0; i < size; ++i) {
                this.table.columns.getColumn(i).getGroupBlockList().clear();
            }
            manager.setExportMemoryCallback(true);
            manager.doMemoryCallback(end / this.table.getDataRequestManager().getPageRowCount());
            manager.setExportMemoryCallback(false);
            if (hash != null) {
                this.table.getMergeManager().setMergeBlockSet(hash);
            }
            long gc = temp;
            long cgc = -1L;
            int gcTime = 0;
            do {
                if (cgc != -1L) {
                    gc = cgc;
                }
                System.gc();
            } while ((cgc = (max = Runtime.getRuntime().maxMemory()) - (free = Runtime.getRuntime().freeMemory())) < gc && ++gcTime < 100);
            System.out.println("GC\u540e\u6700\u5927\u53ef\u7528\u5185\u5b58:" + max / 1024L / 1024L + "M");
            System.out.println("GC\u540e\u7a7a\u95f2\u5185\u5b58:" + free / 1024L / 1024L + "M");
            System.out.println("GC\u540e\u5360\u7528\u5185\u5b58:" + (max - free) / 1024L / 1024L + "M");
            System.out.println("\u672c\u6b21GC\u91ca\u653e\u5185\u5b58:" + (temp - (max - free)) / 1024L / 1024L + "M");
        }
        catch (Exception ex) {
            System.out.println("GC\u5931\u8d25!");
            logger.error((Object)"err", (Throwable)ex);
        }
    }

    public static interface ProgressListener {
        public void startTask(Object var1);

        public void stopTask(Object var1, String var2);

        public void addTask(Object var1);

        public void setTaskNumber(int var1);

        public boolean isUserAborted();

        public void allCompleted();

        public void display(boolean var1);

        public void updateConnectTime();

        public void setExportThread(Thread var1);
    }

    static class ExcelFileFilter
    extends FileFilter {
        protected static final String POSTFIX = ".xls";
        protected static final String description = "Excel File";

        ExcelFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            return f.getName().toLowerCase(Locale.ENGLISH).endsWith(POSTFIX) || f.isDirectory();
        }

        @Override
        public String getDescription() {
            return ".xls(Excel File)";
        }
    }
}

