/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.ITravelPolicy;
import com.kingdee.cosmic.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellIndex;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import java.awt.event.ActionEvent;

public class KDTJumpToDataBlockEdge
extends KDTAbstractAction {
    private static final long serialVersionUID = 516465137020272193L;
    private short dirCode;
    public static final short DIR_UP = 0;
    public static final short DIR_LEFT = 1;
    public static final short DIR_DOWN = 2;
    public static final short DIR_RIGHT = 3;

    public KDTJumpToDataBlockEdge(KDTable table, short dirCode) {
        super(table);
        this.dirCode = dirCode;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ITravelPolicy travelPolicy = this.dirCode % 2 == 0 ? this.table.getKeyControlManager().getDataBlockColumnTravePolicy() : this.table.getKeyControlManager().getDataBlockRowTravelPolicy();
        KDTCellIndex cellIndex = null;
        KDTSelectManager sman = this.table.getSelectManager();
        int rowIndex = sman.getActiveRowIndex();
        int colIndex = sman.getActiveColumnIndex();
        if (rowIndex < 0) {
            rowIndex = 0;
        }
        if (colIndex < 0) {
            colIndex = 0;
        }
        if (!this.canTravel(rowIndex, colIndex)) {
            return;
        }
        cellIndex = this.dirCode < 2 ? travelPolicy.previousCellIndex(rowIndex, colIndex) : travelPolicy.nextCellIndex(rowIndex, colIndex);
        if (cellIndex == null) {
            return;
        }
        int verticalIndex = this.table.getViewManager().getVerticalIndex(sman.getActiveViewIndex());
        int horizonIndex = this.table.getViewManager().getHorizonIndex(sman.getActiveViewIndex());
        this.table.getLayoutManager().getVertical(verticalIndex).scrollToShowRow(cellIndex.getRowIndex());
        this.table.getLayoutManager().getHorizon(horizonIndex).scrollToShowCol(cellIndex.getColIndex());
        sman.select(cellIndex.getRowIndex(), cellIndex.getColIndex(), cellIndex.getRowIndex(), cellIndex.getColIndex());
    }

    private boolean canTravel(int rowIndex, int colIndex) {
        if (this.dirCode == 0 && rowIndex <= 0) {
            return false;
        }
        if (this.dirCode == 2 && rowIndex >= this.table.getRowCount3() - 1) {
            return false;
        }
        if (this.dirCode == 1 && colIndex <= 0) {
            return false;
        }
        return this.dirCode != 3 || colIndex < this.table.getColumnCount() - 1;
    }
}

