/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.CellBlock;
import com.kingdee.cosmic.ctrl.kdf.expr.CellPosition;
import com.kingdee.cosmic.ctrl.kdf.expr.Macro;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationKey;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.expr.TableRelations;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.table.ConstantManager;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.IScriptErrorHandler;
import com.kingdee.cosmic.ctrl.kdf.table.ITableAliasParser;
import com.kingdee.cosmic.ctrl.kdf.table.IVariableParser;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTConstant;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.ScriptErrorReporter;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTCellScriptListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTScriptEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTScriptListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;

public class KDTScriptManager {
    private static final Logger logger = LogUtil.getPackageLogger(KDTScriptManager.class);
    protected ConstantManager constantManager;
    protected IScriptErrorHandler errorHandler = new ScriptErrorReporter();
    protected KDTable table;
    protected boolean autoRun = true;
    protected boolean noScript = false;
    protected boolean autoAdjustFormula = true;
    protected EventListenerList macroListenerList = new EventListenerList();
    protected TableRelations relations;
    protected static final Integer TYPE_FORMULA = 1;
    protected static final Integer TYPE_MACRO = 2;
    protected HashMap macroCache;

    KDTScriptManager(KDTable table) {
        if (table == null) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("CannotConstructScriptManagerWithNullKDTableRef", "\u4e0d\u80fd\u4e3a\u7a7a\u7684KDTable\u5f15\u7528\u6784\u9020ScriptManager"));
        }
        this.table = table;
        this.constantManager = new ConstantManager();
    }

    HashMap getMacroCache() {
        if (this.macroCache == null) {
            this.macroCache = new HashMap();
        }
        return this.macroCache;
    }

    ConstantManager getConstantManager() {
        return this.constantManager;
    }

    Object removeConstant(String name) {
        return this.constantManager.removeKeyword(name);
    }

    void cellFormulaChanged(int rowIndex, int colIndex) {
        this.setFormula(rowIndex, colIndex);
        if (this.isAutoRun()) {
            this.run();
        }
    }

    public void setDiv0DefaultValue(String defaultValue) {
        ((ScriptErrorReporter)this.errorHandler).setDiv0Value(defaultValue);
    }

    void cellPropertyChanged(int rowIndex, int colIndex) {
        RelationKey key = new RelationKey((RelationsListener)this.table.getScriptContext(), (Object)new CellPosition(rowIndex, colIndex), null);
        String formula = this.getFormulaBubble(rowIndex, colIndex);
        Object value = this.getCellValue(rowIndex, colIndex);
        this.getRelationsObject().queue(key, value, formula);
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void rowFormulaChanged(int rowIndex) {
        if (!this.isAutoRun()) {
            return;
        }
        int colCount = this.table.getColumnCount();
        KDTCell cell = null;
        KDTColumn col = null;
        for (int i = 0; i < colCount; ++i) {
            cell = this.table.getBody().getRow(rowIndex).getCell(i);
            col = this.table.getColumn(i).getKDTColumn();
            if (cell.getExpressions() != null || col.getExpressions() != null) continue;
            this.setFormula(rowIndex, i);
        }
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void columnFormulaChanged(int colIndex) {
        int rowCount = this.table.getRowCount();
        KDTCell cell = null;
        for (int i = 0; i < rowCount; ++i) {
            cell = this.table.getBody().getRow(i).getCell(colIndex);
            if (null != cell.getExpressions()) continue;
            this.setFormula(i, colIndex);
        }
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void tableFormulaChanged() {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            if (this.table.getBody().getRow(i).getExpressions() != null) continue;
            for (int j = 0; j < colCount; ++j) {
                if (this.table.getColumn(j).getKDTColumn().getExpressions() != null || this.table.getBody().getRow(i).getCell(j).getExpressions() != null) continue;
                this.setFormula(i, j);
            }
        }
        if (this.isAutoRun()) {
            this.run();
        }
    }

    public Object getCellValue(int rowIndex, int colIndex) {
        IRow row = this.table.getRow(rowIndex);
        if (row == null) {
            return null;
        }
        ICell cell = row.getCell(colIndex);
        if (cell == null) {
            return null;
        }
        return cell.getValue();
    }

    public String getFormulaBubble(int rowIndex, int colIndex) {
        KDTColumn col;
        String macro = null;
        KDTRow row = this.table.getBody().getRow(rowIndex);
        if (row == null) {
            return null;
        }
        KDTCell cell = row.getCell(colIndex);
        if (cell != null) {
            macro = cell.getExpressions();
        }
        if (macro == null) {
            macro = row.getExpressions();
        }
        if (macro == null && (col = this.table.getColumns().getColumn(colIndex)) != null) {
            macro = col.getExpressions();
        }
        return macro;
    }

    public void runFormula(int rowIndex, int colIndex) {
        this.setFormula(rowIndex, colIndex);
        this.run();
    }

    protected void setFormula(int rowIndex, int colIndex) {
        RelationKey key = new RelationKey((RelationsListener)this.table.getScriptContext(), (Object)new CellPosition(rowIndex, colIndex), null);
        String formula = this.getFormulaBubble(rowIndex, colIndex);
        this.queueFormula(key, formula);
    }

    protected boolean queueFormula(RelationKey key, String formula) {
        return this.getRelationsObject().queue(key, formula);
    }

    public void run() {
        this.fireScriptBeginEvent();
        this.getRelationsObject().calculateQueue();
        this.table.repaint();
        this.fireScriptEndEvent();
    }

    public void runAll() {
        this.fireScriptBeginEvent();
        this.getRelationsObject().recalcAll((RelationsListener)this.table.getScriptContext());
        this.table.repaint();
        this.fireScriptEndEvent();
    }

    public void removeAll() {
        this.getRelationsObject().removeAll((RelationsListener)this.table.getScriptContext());
    }

    private void fireScriptBeginEvent() {
        KDTScriptEvent evt = null;
        EventListener[] listeners = this.macroListenerList.getListeners(KDTScriptListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (evt == null) {
                evt = new KDTScriptEvent(this, this.table);
            }
            ((KDTScriptListener)listeners[i]).scriptBegin(evt);
        }
    }

    public Variant run(String formula) {
        if (StringUtil.isEmptyString((String)formula)) {
            return null;
        }
        char firstChar = formula.charAt(0);
        if (firstChar == '=') {
            if (formula.charAt(formula.length() - 1) != ';') {
                formula = formula + ";";
            }
            formula = "returnValue" + formula;
        } else if (firstChar == '@') {
            formula = formula.substring(1);
        }
        Macro macro = this.getRelationsObject().getNewMacroEngine((RelationsListener)this.table.getScriptContext(), formula);
        if (!macro.execute()) {
            this.getErrorHandler().handle(this.table, (Exception)macro.getSyntaxError(), null, null, macro.getErrorPos());
            return null;
        }
        Variant result = macro.getVariableValue("returnValue");
        this.getRelationsObject().releaseMacroEngine(macro);
        return result;
    }

    private void fireScriptEndEvent() {
        KDTScriptEvent evt = null;
        EventListener[] listeners = this.macroListenerList.getListeners(KDTScriptListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (evt == null) {
                evt = new KDTScriptEvent(this, this.table);
            }
            ((KDTScriptListener)listeners[i]).scriptEnd(evt);
        }
    }

    protected void queueMacro(KDTRange range) {
        String macro = this.getMacro(range);
        Iterator iter = range.iterator();
        IBlock block = null;
        try {
            while (iter.hasNext()) {
                block = (IBlock)iter.next();
                this.queueMacroInBlock(block, macro);
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }

    protected void queueMacroInBlock(IBlock block, String macro) {
        for (int j = block.getTop(); j <= block.getBottom(); ++j) {
            for (int i = block.getLeft(); i <= block.getRight(); ++i) {
                this.setMacroInCell(macro, j, i);
            }
        }
    }

    protected void setMacroInCell(String macro, int rowIndex, int colIndex) {
        RelationKey key = new RelationKey((RelationsListener)this.table.getScriptContext(), (Object)new CellPosition(rowIndex, colIndex), (Object)TYPE_MACRO);
        this.getRelationsObject().queue(key, macro);
    }

    public boolean isRunFormulaAfterModify() {
        return this.autoRun;
    }

    public void setRunFormulaAfterModify(boolean runAfterModify) {
        this.autoRun = runAfterModify;
    }

    public Object putConstant(KDTConstant keyword) {
        return this.constantManager.putKeyword(keyword);
    }

    EventListenerList getMacroListenerList() {
        return this.macroListenerList;
    }

    public void setRelationsObject(TableRelations relations) {
        this.relations = relations;
    }

    public void setAliasParser(ITableAliasParser parser) {
        this.table.getScriptContext().setAliasParser(parser);
    }

    public void setVariableParser(IVariableParser variableParser) {
        this.table.getScriptContext().setVariableParser(variableParser);
    }

    public TableRelations getRelationsObject() {
        if (this.relations == null) {
            this.relations = new TableRelations();
        }
        return this.relations;
    }

    void adjustInsertRow(int rowIndex) {
        CellBlock cb = CellBlock.getNewCellBlock((RelationsListener)this.table.getRelationsListener(), (int)rowIndex, (int)0, (int)rowIndex, (int)Integer.MAX_VALUE);
        this.adjustFormula(cb, true, false);
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void adjustInsertCol(int colIndex) {
        CellBlock cb = CellBlock.getNewCellBlock((RelationsListener)this.table.getRelationsListener(), (int)0, (int)colIndex, (int)Integer.MAX_VALUE, (int)colIndex);
        this.adjustFormula(cb, true, true);
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void adjustDeleteCol(int colIndex) {
        CellBlock cb = CellBlock.getNewCellBlock((RelationsListener)this.table.getRelationsListener(), (int)0, (int)colIndex, (int)Integer.MAX_VALUE, (int)colIndex);
        this.adjustFormula(cb, false, true);
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void adjustDeleteRow(int rowIndex) {
        CellBlock cb = CellBlock.getNewCellBlock((RelationsListener)this.table.getRelationsListener(), (int)rowIndex, (int)0, (int)rowIndex, (int)Integer.MAX_VALUE);
        this.adjustFormula(cb, false, false);
        if (this.isAutoRun()) {
            this.run();
        }
    }

    void adjustFormula(CellBlock cb, boolean insert, boolean xDir) {
        if (this.isAutoAdjustFormula()) {
            this.getRelationsObject().insdelBlock(cb, insert, xDir);
        }
    }

    public boolean isRunMacroAfterModify() {
        return this.autoRun;
    }

    public void setRunMacroAfterModify(boolean runMacroAfterModify) {
        this.autoRun = runMacroAfterModify;
    }

    public String setMacro(KDTRange range, String macro) {
        String result = this.getMacroCache().put(range, macro);
        this.queueMacro(range);
        if (this.isAutoRun()) {
            this.run();
        }
        return result;
    }

    public String clearMacro(KDTRange range) {
        return (String)this.getMacroCache().remove(range);
    }

    public String getMacro(KDTRange range) {
        return (String)this.getMacroCache().get(range);
    }

    public IScriptErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(IScriptErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean addFunctionProvider(Object object) {
        return this.getRelationsObject().getDefaultFunctionProvider().add(object);
    }

    public boolean removeFunctionProvider(Object object) {
        return this.getRelationsObject().getDefaultFunctionProvider().remove(object);
    }

    public boolean addFunctionProviderList(ArrayList list) {
        return this.getRelationsObject().getDefaultFunctionProvider().addAll(list);
    }

    public boolean removeFunctionProviderList(ArrayList list) {
        return this.getRelationsObject().getDefaultFunctionProvider().removeAll(list);
    }

    static CellPosition getOutterPosition(CellPosition pos) {
        if (pos.col < 0 || pos.row < 0) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("IndexOutOfBound", "\u7d22\u5f15\u8d8a\u754c\uff0c\u811a\u672c\u5f15\u64ce\u4e2d\u7684\u5355\u5143\u683c\u884c\u5217\u7d22\u5f15\u4e0d\u80fd\u5c0f\u4e8e1"));
        }
        return new CellPosition(pos.row + 1, pos.col + 1);
    }

    static RelationKey getOutterKey(RelationKey key) {
        if (key.getIndex() instanceof CellPosition) {
            return new RelationKey(key.getRelationsListener(), (Object)KDTScriptManager.getOutterPosition((CellPosition)key.getIndex()), key.getProperty());
        }
        return key;
    }

    static CellPosition getInnerPosition(CellPosition pos) {
        if (pos.col < 0 || pos.row < 0) {
            throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("IndexOutOfBound", "\u7d22\u5f15\u8d8a\u754c\uff0c\u811a\u672c\u5f15\u64ce\u4e2d\u7684\u5355\u5143\u683c\u884c\u5217\u7d22\u5f15\u4e0d\u80fd\u5c0f\u4e8e1"));
        }
        return new CellPosition(pos.row, pos.col);
    }

    static RelationKey getInnerKey(RelationKey key) {
        if (key.getIndex() instanceof CellPosition) {
            return new RelationKey(key.getRelationsListener(), (Object)KDTScriptManager.getInnerPosition((CellPosition)key.getIndex()), key.getProperty());
        }
        return key;
    }

    public void addKDTScriptListener(KDTScriptListener listener) {
        this.macroListenerList.add(KDTScriptListener.class, listener);
    }

    public void removeKDTScriptListener(KDTScriptListener listener) {
        this.macroListenerList.remove(KDTScriptListener.class, listener);
    }

    public void addKDTCellScriptListener(KDTCellScriptListener listener) {
        this.macroListenerList.add(KDTCellScriptListener.class, listener);
    }

    public void removeKDTCellScriptListener(KDTCellScriptListener listener) {
        this.macroListenerList.remove(KDTCellScriptListener.class, listener);
    }

    public boolean isAutoRun() {
        return this.autoRun && this.table.isScriptAutoRun();
    }

    public void setAutoRun(boolean autoRun) {
        this.autoRun = autoRun;
    }

    public boolean isScriptDisabled() {
        return this.noScript;
    }

    public void setScriptDisabled(boolean disabled) {
        this.noScript = disabled;
    }

    public boolean isAutoAdjustFormula() {
        return this.autoAdjustFormula && this.table.isScriptAutoAdjust();
    }

    public void setAutoAdjustFormula(boolean autoAdjustFormula) {
        this.autoAdjustFormula = autoAdjustFormula;
    }
}

