/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.BasicView;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IEnterTravelAction;
import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTBody;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.cosmic.ctrl.kdf.table.KDTView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTActiveCellListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;

public class KDTSelectManager {
    public static final int MODEL_LIST = 0;
    public static final int MODEL_EDIT = 1;
    public static final int NO_SELECT = 0;
    public static final int CELL_SELECT = 1;
    public static final int ROW_SELECT = 2;
    public static final int COLUMN_SELECT = 4;
    public static final int MULTIPLE_CELL_SELECT = 15;
    public static final int MULTIPLE_ROW_SELECT = 10;
    public static final int MULTIPLE_COLUMN_SELECT = 12;
    public static final int TABLE_SELECT = 8;
    private static final int MULTIPLE_SELECT = 8;
    private boolean resetPrevBlock = true;
    private boolean ctrlKeyDown = false;
    private boolean isForSingleCell = false;
    private KDTable table;
    private ArrayList blocks;
    private KDTSelectBlock prevBlock;
    private int selectMode;
    private Color selectColor;
    private int selectPaintMode = 0;
    private int activeViewIndex;
    private int activeRowIndex;
    private int activeColumnIndex;
    IEnterTravelAction travelAction;

    void savePrevBlockCopy(KDTSelectBlock block) {
        if (this.isResetPrevBlock()) {
            this.prevBlock = new KDTSelectBlock(block);
            this.setResetPrevBlock(false);
        }
    }

    public KDTSelectManager(KDTable table) {
        this.table = table;
        this.selectMode = 15;
        this.selectColor = KDTStyleConstants.SELECT_COLOR;
        this.activeViewIndex = table.getViewManager().getDefaultActiveViewIndex();
        this.activeRowIndex = -1;
        this.activeColumnIndex = -1;
        this.blocks = new ArrayList();
    }

    public KDTSelectBlock getPrevBlock() {
        return this.prevBlock;
    }

    void setPrevBlock(KDTSelectBlock oldBlock) {
        this.prevBlock = oldBlock;
    }

    public int getSelectMode() {
        return this.selectMode;
    }

    public void setSelectMode(int selectMode) {
        if (this.selectMode != selectMode) {
            this.selectMode = selectMode;
            this.removeAll2();
        }
    }

    public Color getSelectColor() {
        return this.selectColor;
    }

    public void setSelectColor(Color selectColor) {
        this.selectColor = selectColor;
    }

    int getActiveViewIndex() {
        return this.activeViewIndex;
    }

    void setActiveViewIndex(int activeViewIndex) {
        this.activeViewIndex = activeViewIndex;
    }

    public int getActiveRowIndex() {
        return this.activeRowIndex;
    }

    public void setActiveRowIndex(int activeRowIndex) {
        this.activeRowIndex = activeRowIndex;
    }

    public int getActiveColumnIndex() {
        return this.activeColumnIndex;
    }

    public void setActiveColumnIndex(int activeColumnIndex) {
        this.activeColumnIndex = activeColumnIndex;
    }

    void setActiveCell(int rowIndex, int colIndex) {
        if (rowIndex == this.activeRowIndex && colIndex == this.activeColumnIndex) {
            return;
        }
        int prevRowIndex = this.activeRowIndex;
        int prevColumnIndex = this.activeColumnIndex;
        this.setActiveRowIndex(rowIndex);
        this.setActiveColumnIndex(colIndex);
        KDTView view = (KDTView)this.table.getViewManager().getView(this.getActiveViewIndex());
        if (rowIndex < view.getTopRow() || rowIndex > view.getBottomRow() || colIndex < view.getLeftCol() || colIndex > view.getRightCol()) {
            int count = this.table.getViewManager().getViewCount();
            for (int i = 0; i < count; ++i) {
                BasicView bview = this.table.getViewManager().getView(i);
                if (!bview.getClass().isAssignableFrom(KDTView.class) || rowIndex < (view = (KDTView)bview).getTopRow() || rowIndex > view.getBottomRow() || colIndex > view.getRightCol()) continue;
                this.setActiveViewIndex(view.getIndex());
                break;
            }
        }
        if (rowIndex >= 0 && colIndex >= 0 && this.table.getActiveCellStatus() == 1) {
            this.table.getEditManager().editCellAt(rowIndex, colIndex, false);
        }
        KDTActiveCellEvent e = new KDTActiveCellEvent(this.table, this.activeViewIndex, prevRowIndex, prevColumnIndex, rowIndex, colIndex);
        this.fireActiveCellChanged(e);
    }

    public int size() {
        return this.blocks.size();
    }

    private void copySelectBlock(KDTSelectBlock src, KDTSelectBlock dest) {
        dest.setTop(src.getTop());
        dest.setBottom(src.getBottom());
        dest.setLeft(src.getLeft());
        dest.setRight(src.getRight());
        dest.setMode(src.getMode());
    }

    public KDTSelectBlock get(int index) {
        if (index < 0 || index >= this.blocks.size()) {
            return null;
        }
        KDTSelectBlock sb = (KDTSelectBlock)this.blocks.get(index);
        sb.setTable(this.table);
        KDTSelectBlock sbTemp = new KDTSelectBlock();
        sbTemp.setTable(this.table);
        this.copySelectBlock(sb, sbTemp);
        this.getMaxSelectBlock(sbTemp);
        return sbTemp;
    }

    public KDTSelectBlock get() {
        return this.get(this.blocks.size() - 1);
    }

    KDTSelectBlock getOrigin(int index) {
        if (index < 0 || index >= this.blocks.size()) {
            return null;
        }
        return (KDTSelectBlock)this.blocks.get(index);
    }

    KDTSelectBlock getOrigin() {
        return this.getOrigin(this.blocks.size() - 1);
    }

    public int add(KDTSelectBlock sb) {
        return this.add(sb, true);
    }

    public int add(KDTSelectBlock sb, boolean fireEvent) {
        this.setPrevBlock(this.get());
        this.addBlock(this.checkSelectBlock(sb));
        this.setActiveCell(sb.getBeginRow(), sb.getBeginCol());
        if (fireEvent) {
            this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.getPrevBlock(), this.get()));
        }
        this.update();
        return this.blocks.size() - 1;
    }

    private void addBlock(KDTSelectBlock block) {
        block.setTable(this.table);
        int size = this.blocks.size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock aBlock = (KDTSelectBlock)this.blocks.get(i);
            if (!aBlock.equals(block) && !aBlock.contains(block)) continue;
            return;
        }
        this.blocks.add(block);
    }

    public boolean isBlockContained(KDTSelectBlock block) {
        block.setTable(this.table);
        int size = this.blocks.size();
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock aBlock = (KDTSelectBlock)this.blocks.get(i);
            if (!aBlock.equals(block) && !aBlock.contains(block)) continue;
            return true;
        }
        return false;
    }

    public int add(int top, int left, int bottom, int right, int mode) {
        KDTSelectBlock sb = new KDTSelectBlock(top, left, bottom, right, mode);
        return this.add(sb);
    }

    public int add(int top, int left, int bottom, int right) {
        return this.add(top, left, bottom, right, this.getCellSelectMode());
    }

    public int add(int top, int left, int mode) {
        return this.add(top, left, top, left, mode);
    }

    public int add(int top, int left) {
        return this.add(top, left, this.getCellSelectMode());
    }

    public int select(KDTSelectBlock sb) {
        return this.select(sb, true);
    }

    public int select(KDTSelectBlock sb, boolean fireEvent) {
        this.setPrevBlock(this.get());
        this.removeAll2();
        this.addBlock(this.checkSelectBlock(sb));
        this.setActiveCell(sb.getTop(), sb.getLeft());
        if (fireEvent) {
            this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.getPrevBlock(), this.get()));
        }
        this.update();
        return this.blocks.size() - 1;
    }

    public int select(int top, int left, int bottom, int right, int mode) {
        KDTSelectBlock sb = new KDTSelectBlock();
        sb.setTop(top);
        sb.setLeft(left);
        sb.setBottom(bottom);
        sb.setRight(right);
        sb.setMode(mode);
        sb.setTable(this.table);
        return this.select(sb);
    }

    public int select(int top, int left, int bottom, int right) {
        return this.select(top, left, bottom, right, this.getCellSelectMode());
    }

    public int select(int top, int left, int mode) {
        return this.select(top, left, top, left, mode);
    }

    public int select(int top, int left) {
        return this.select(top, left, this.getCellSelectMode());
    }

    public void unselect(KDTSelectBlock block, boolean fireEvent) {
        int i;
        block.setTable(this.table);
        int size = this.blocks.size();
        int[] removes = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            removes[i2] = 0;
        }
        ArrayList<KDTSelectBlock> adds = new ArrayList<KDTSelectBlock>();
        block5: for (i = 0; i < size; ++i) {
            KDTSelectBlock aBlock = (KDTSelectBlock)this.blocks.get(i);
            if (aBlock.equals(block)) {
                removes[i] = 1;
                continue;
            }
            if (!aBlock.contains(block)) continue;
            removes[i] = 1;
            switch (block.getMode()) {
                case 2: {
                    if (aBlock.getTop() == block.getTop()) {
                        int top = aBlock.getTop();
                        if (aBlock.getMode() == 8) {
                            aBlock.setMode(2);
                            aBlock.setBottom(aBlock.getTable().getRowCount3() - 1);
                        } else {
                            int bottom = aBlock.getBottom();
                            aBlock.setBottom(bottom);
                        }
                        aBlock.setTop(top + 1);
                        adds.add(aBlock);
                        continue block5;
                    }
                    if (block.getBottom() == (aBlock.getMode() == 8 ? aBlock.getTable().getRowCount3() - 1 : aBlock.getBottom())) {
                        int bottom = aBlock.getBottom();
                        int top = aBlock.getTop();
                        aBlock.setTop(top);
                        if (aBlock.getMode() == 8) {
                            aBlock.setMode(2);
                            aBlock.setBottom(aBlock.getTable().getRowCount3() - 2);
                        } else {
                            aBlock.setBottom(bottom - 1);
                        }
                        adds.add(aBlock);
                        continue block5;
                    }
                    KDTSelectBlock copy = new KDTSelectBlock(block);
                    int s = copy.getTop();
                    copy.setTop(s + 1);
                    if (aBlock.getMode() == 8) {
                        aBlock.setMode(2);
                        copy.setBottom(aBlock.getTable().getRowCount3() - 1);
                    } else {
                        copy.setBottom(aBlock.getBottom());
                    }
                    int top = aBlock.getTop();
                    aBlock.setTop(top);
                    aBlock.setBottom(s - 1);
                    adds.add(aBlock);
                    adds.add(copy);
                    continue block5;
                }
                case 4: {
                    if (aBlock.getLeft() == block.getLeft()) {
                        int left = aBlock.getLeft();
                        if (aBlock.getMode() == 8) {
                            aBlock.setMode(4);
                            aBlock.setRight(aBlock.getTable().getColumnCount() - 1);
                        } else {
                            int right = aBlock.getRight();
                            aBlock.setRight(right);
                        }
                        aBlock.setLeft(left + 1);
                        adds.add(aBlock);
                        continue block5;
                    }
                    if (block.getRight() == (aBlock.getMode() == 8 ? aBlock.getTable().getColumnCount() - 1 : aBlock.getRight())) {
                        int right = aBlock.getRight();
                        int left = aBlock.getLeft();
                        aBlock.setLeft(left);
                        if (aBlock.getMode() == 8) {
                            aBlock.setMode(4);
                            aBlock.setRight(aBlock.getTable().getColumnCount() - 2);
                        } else {
                            aBlock.setRight(right - 1);
                        }
                        adds.add(aBlock);
                        continue block5;
                    }
                    KDTSelectBlock copy = new KDTSelectBlock(block);
                    int s = copy.getLeft();
                    copy.setLeft(s + 1);
                    if (aBlock.getMode() == 8) {
                        aBlock.setMode(4);
                        copy.setRight(aBlock.getTable().getColumnCount() - 1);
                    } else {
                        copy.setRight(aBlock.getRight());
                    }
                    int left = aBlock.getLeft();
                    aBlock.setLeft(left);
                    aBlock.setRight(s - 1);
                    adds.add(aBlock);
                    adds.add(copy);
                    continue block5;
                }
            }
        }
        for (i = size - 1; i >= 0; --i) {
            if (removes[i] == 0) continue;
            this.remove(i);
            this.setPrevBlock(null);
        }
        for (i = 0; i < adds.size(); ++i) {
            KDTSelectBlock b = (KDTSelectBlock)adds.get(i);
            if (this.isBlockContained(b)) continue;
            this.add(b, false);
        }
    }

    public void set(int index, KDTSelectBlock sb) {
        this.set(index, sb, true);
    }

    public void set(int index, KDTSelectBlock sb, boolean fireEvent) {
        this.setPrevBlock(this.get(index));
        this.blocks.set(index, this.checkSelectBlock(sb));
        if (index == this.blocks.size() - 1) {
            this.setActiveCell(sb.getTop(), sb.getLeft());
        }
        if (fireEvent) {
            this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.getPrevBlock(), this.get(index)));
        }
        this.update();
    }

    public void set(int top, int left, int bottom, int right, int mode, int index) {
        KDTSelectBlock sb = this.getOrigin(index);
        if (sb != null) {
            sb.setTop(top);
            sb.setLeft(left);
            sb.setBottom(bottom);
            sb.setRight(right);
            sb.setMode(mode);
            this.set(index, sb);
        }
    }

    public void set(int top, int left, int bottom, int right, int mode) {
        this.set(top, left, bottom, right, mode, this.blocks.size() - 1);
    }

    public void set(int top, int left, int bottom, int right) {
        this.set(top, left, bottom, right, this.getCellSelectMode());
    }

    public void set(int top, int left, int mode) {
        this.set(top, left, top, left, mode);
    }

    public void set(int top, int left) {
        this.set(top, left, top, left);
    }

    public void remove() {
        int index = this.blocks.size() - 1;
        this.remove(index);
    }

    public void remove(int index) {
        if (index < 0 || index >= this.blocks.size()) {
            return;
        }
        this.blocks.remove(index);
        this.update();
    }

    public void removeAll() {
        this.blocks.clear();
        this.setActiveCell(-1, -1);
        this.update();
    }

    public void removeAll(boolean isfireActiveCellEvent) {
        if (isfireActiveCellEvent) {
            this.removeAll();
        } else {
            this.removeAll1();
        }
    }

    void removeAll1() {
        this.blocks.clear();
        this.setActiveRowIndex(-1);
        this.setActiveColumnIndex(-1);
        this.update();
    }

    void removeAll2() {
        this.blocks.clear();
        this.update();
    }

    protected KDTSelectBlock checkSelectBlock(KDTSelectBlock sb) {
        int rowCount = this.table.getRowCount();
        int colCount = this.table.getColumnCount();
        if (rowCount == -1) {
            rowCount = Integer.MAX_VALUE;
        }
        if (sb.getTop() < 0) {
            sb.setTop(0);
        } else if (sb.getTop() >= rowCount) {
            sb.setTop(rowCount - 1);
        }
        if (sb.getBottom() < 0) {
            sb.setBottom(0);
        } else if (sb.getBottom() >= rowCount) {
            sb.setBottom(rowCount - 1);
        }
        if (sb.getLeft() < 0) {
            sb.setLeft(0);
        } else if (sb.getLeft() >= colCount) {
            sb.setLeft(colCount - 1);
        }
        if (sb.getRight() < 0) {
            sb.setRight(0);
        } else if (sb.getRight() >= colCount) {
            sb.setRight(colCount - 1);
        }
        return sb;
    }

    public boolean isMultipleSelectable() {
        return (this.selectMode & 8) != 0;
    }

    boolean isCellSelectable() {
        return (this.selectMode & 1) != 0;
    }

    boolean isRowSelectable() {
        return (this.selectMode & 2) != 0;
    }

    boolean isColumnSelectable() {
        return (this.selectMode & 4) != 0;
    }

    int getCellSelectMode() {
        if (this.isCellSelectable()) {
            return 1;
        }
        if (this.isColumnSelectable()) {
            return 4;
        }
        if (this.isRowSelectable()) {
            return 2;
        }
        if (this.selectMode == 8) {
            return 8;
        }
        return 0;
    }

    private void getMaxSelectBlock(KDTSelectBlock sb) {
        if (sb.getMode() == 1) {
            KDTBody rows = this.table.getBody();
            while (this.expandSelectBlock(sb, rows)) {
            }
        }
    }

    private boolean expandSelectBlock(KDTSelectBlock sb, IRows rows) {
        int r1 = sb.getTop();
        int r2 = sb.getBottom();
        int c1 = sb.getLeft();
        int c2 = sb.getRight();
        int nr1 = r1;
        int nr2 = r2;
        int nc1 = c1;
        int nc2 = c2;
        for (int i = r1; i <= r2; ++i) {
            KDTMergeBlock mb;
            KDTCell cell;
            KDTRow row = rows.getRow2(i);
            if (row == null) {
                return false;
            }
            if (i == r1 || i == r2) {
                for (int j = c1; j <= c2; ++j) {
                    cell = row.getCell(j);
                    if (cell == null || (mb = cell.getViewBlock()) == null) continue;
                    if (nr1 > mb.top) {
                        nr1 = mb.top;
                    }
                    if (nr2 < mb.bottom) {
                        nr2 = mb.bottom;
                    }
                    if (nc1 > mb.left) {
                        nc1 = mb.left;
                    }
                    if (nc2 >= mb.right) continue;
                    nc2 = mb.right;
                }
                continue;
            }
            cell = row.getCell(c1);
            if (cell == null) continue;
            mb = cell.getMergeBlock();
            if (mb != null) {
                if (nr1 > mb.top) {
                    nr1 = mb.top;
                }
                if (nr2 < mb.bottom) {
                    nr2 = mb.bottom;
                }
                if (nc1 > mb.left) {
                    nc1 = mb.left;
                }
                if (nc2 < mb.right) {
                    nc2 = mb.right;
                }
            }
            if ((cell = row.getCell(c2)) == null || (mb = cell.getMergeBlock()) == null) continue;
            if (nr1 > mb.top) {
                nr1 = mb.top;
            }
            if (nr2 < mb.bottom) {
                nr2 = mb.bottom;
            }
            if (nc1 > mb.left) {
                nc1 = mb.left;
            }
            if (nc2 >= mb.right) continue;
            nc2 = mb.right;
        }
        boolean retVal = false;
        if (nr1 < r1) {
            sb.setTop(nr1);
            retVal = true;
        }
        if (nr2 > r2) {
            sb.setBottom(nr2);
            retVal = true;
        }
        if (nc1 < c1) {
            sb.setLeft(nc1);
            retVal = true;
        }
        if (nc2 > c2) {
            sb.setRight(nc2);
            retVal = true;
        }
        return retVal;
    }

    void update() {
        this.table.repaint();
    }

    public void addKDTSelectListener(KDTSelectListener l) {
        this.table.getListenerList().add(KDTSelectListener.class, l);
    }

    public void removeKDTSelectListener(KDTSelectListener l) {
        this.table.getListenerList().remove(KDTSelectListener.class, l);
    }

    void fireTableSelectChanged(KDTSelectEvent e) {
        KDTSelectBlock sbOld = e.getPrevSelectBlock();
        KDTSelectBlock sb = e.getSelectBlock();
        if (sbOld == null && sb == null) {
            return;
        }
        if (sb != null && sb.equals(sbOld)) {
            return;
        }
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTSelectListener.class) continue;
            ((KDTSelectListener)listeners[i + 1]).tableSelectChanged(e);
        }
    }

    public void addKDTActiveCellListener(KDTActiveCellListener l) {
        this.table.getListenerList().add(KDTActiveCellListener.class, l);
    }

    public void removeKDTActiveCellListener(KDTActiveCellListener l) {
        this.table.getListenerList().remove(KDTActiveCellListener.class, l);
    }

    void fireActiveCellChanged(KDTActiveCellEvent e) {
        Object[] listeners = this.table.getListenerList().getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != KDTActiveCellListener.class) continue;
            ((KDTActiveCellListener)listeners[i + 1]).activeCellChanged(e);
        }
    }

    public int getBlockIndexActiveCellIn() {
        int row = this.getActiveRowIndex();
        int col = this.getActiveColumnIndex();
        return this.getSelectBlockIndexOfCell(row, col);
    }

    private boolean isCellInBlock(int row, int col, KDTSelectBlock block) {
        return row >= block.getTop() && row <= block.getBottom() && col >= block.getLeft() && col <= block.getRight();
    }

    int nextRowIndex(int rowIndex, int colIndex) {
        int rowCount = this.table.getRowCount1();
        if (rowIndex >= rowCount) {
            throw new IllegalArgumentException("row index out of bounds");
        }
        if (rowIndex < 0) {
            return 0;
        }
        int result = rowIndex;
        do {
            KDTMergeBlock block;
            result = this.getSelectMode() != 2 && this.getSelectMode() != 10 ? (null == (block = this.table.getMergeManager().getMergeBlockOfCell(result, colIndex)) ? ++result : block.getBottom() + 1) : ++result;
            if (result < rowCount) continue;
            result = rowCount;
            break;
        } while (this.table.getBody().getRowHeight(result) <= 0);
        return result;
    }

    int nextRowIndex(int rowIndex, int colIndex, boolean isJumpLockRow) {
        int rowCount = this.table.getRowCount1();
        if (rowIndex >= rowCount) {
            throw new IllegalArgumentException("column index out of bounds");
        }
        if (colIndex < 0) {
            return 0;
        }
        int result = rowIndex;
        do {
            KDTMergeBlock block;
            result = this.getSelectMode() != 2 && this.getSelectMode() != 10 ? (null == (block = this.table.getMergeManager().getMergeBlockOfCell(result, colIndex)) ? ++result : block.getBottom() + 1) : ++result;
            if (result < rowCount) continue;
            result = rowCount;
            break;
        } while (this.isJumpRow(result, colIndex, isJumpLockRow) || this.table.getBody().getRowHeight(result) <= 0);
        return result;
    }

    boolean isJumpRow(int rowIndex, int colIndex, boolean isJumbLockRow) {
        if (this.table.getRow(rowIndex).getHeight() <= 0) {
            return true;
        }
        if (isJumbLockRow) {
            if (!this.table.isEditable() || !this.table.isEnabled() || this.table.getStyleAttributes().isLocked()) {
                return false;
            }
            Style style = null;
            ICell cell = this.table.getCell(rowIndex, colIndex);
            if (cell != null) {
                style = cell.getStyle();
            }
            if (style != null && style.isLocked()) {
                return true;
            }
        }
        return false;
    }

    int previousRowIndex(int rowIndex, int colIndex) {
        if (rowIndex >= this.table.getRowCount1()) {
            throw new IllegalArgumentException("row index out of bounds");
        }
        if (rowIndex < 0) {
            return 0;
        }
        int result = rowIndex;
        do {
            KDTMergeBlock block;
            result = this.getSelectMode() != 2 && this.getSelectMode() != 10 ? (null == (block = this.table.getMergeManager().getMergeBlockOfCell(result, colIndex)) ? --result : block.getTop() - 1) : --result;
            if (result >= 0) continue;
            result = rowIndex;
            break;
        } while (this.table.getBody().getRowHeight(result) <= 0);
        return result;
    }

    int nextColIndex(int rowIndex, int colIndex) {
        return this.nextColIndex(rowIndex, colIndex, false);
    }

    int nextColIndex(int rowIndex, int colIndex, boolean isJumpLockCol) {
        int colCount = this.table.getColumnCount();
        if (colIndex >= colCount) {
            throw new IllegalArgumentException("column index out of bounds");
        }
        if (colIndex < 0) {
            return 0;
        }
        int result = colIndex;
        do {
            KDTMergeBlock block;
            result = null == (block = this.table.getMergeManager().getMergeBlockOfCell(rowIndex, result)) ? ++result : block.getRight() + 1;
            if (result < colCount) continue;
            result = colCount;
            break;
        } while (this.isJumpCol(rowIndex, result, isJumpLockCol));
        return result;
    }

    boolean isJumpCol(int rowIndex, int colIndex, boolean isJumbLockCol) {
        if (this.table.getColumns().getColumnWidth(colIndex) <= 0) {
            return true;
        }
        if (isJumbLockCol) {
            if (!this.table.isEditable() || !this.table.isEnabled() || this.table.getStyleAttributes().isLocked()) {
                return false;
            }
            Style style = null;
            ICell cell = this.table.getCell(rowIndex, colIndex);
            if (cell != null) {
                style = cell.getStyle();
            }
            if (style != null && style.isLocked()) {
                return true;
            }
        }
        return false;
    }

    public int previousColIndex(int rowIndex, int colIndex) {
        return this.previousColIndex(rowIndex, colIndex, false);
    }

    int previousColIndex(int rowIndex, int colIndex, boolean isJumpLockCol) {
        if (colIndex >= this.table.getColumnCount()) {
            throw new IllegalArgumentException("column index out of bounds");
        }
        if (colIndex < 0) {
            return 0;
        }
        int result = colIndex;
        do {
            KDTMergeBlock block;
            result = null == (block = this.table.getMergeManager().getMergeBlockOfCell(rowIndex, result)) ? --result : block.getLeft() - 1;
            if (result >= 0) continue;
            result = -1;
            break;
        } while (this.isJumpCol(rowIndex, result, isJumpLockCol));
        return result;
    }

    public ArrayList getBlocks() {
        return this.blocks;
    }

    public KDTSelectBlock getSelectBlockOfCell(int rowIndex, int colIndex) {
        for (int i = this.blocks.size() - 1; i >= 0; --i) {
            KDTSelectBlock block = (KDTSelectBlock)this.blocks.get(i);
            if (!this.isCellInBlock(rowIndex, colIndex, block)) continue;
            return block;
        }
        return null;
    }

    public int getSelectBlockIndexOfCell(int rowIndex, int colIndex) {
        for (int i = this.blocks.size() - 1; i >= 0; --i) {
            KDTSelectBlock block = (KDTSelectBlock)this.blocks.get(i);
            if (!this.isCellInBlock(rowIndex, colIndex, block)) continue;
            return i;
        }
        return -1;
    }

    public boolean isResetPrevBlock() {
        return this.resetPrevBlock;
    }

    public KDTRange getSelectRange() {
        KDTRange range = new KDTRange();
        for (KDTSelectBlock block : this.getBlocks()) {
            int left = block.getLeft();
            int right = block.getRight();
            int top = block.getTop();
            int bottom = block.getBottom();
            KDTBlock rangeBlock = new KDTBlock(top, left, bottom, right);
            range.add(rangeBlock);
        }
        return range;
    }

    public void setResetPrevBlock(boolean b) {
        this.resetPrevBlock = b;
    }

    boolean isRowSelected(int rowIndex) {
        for (KDTSelectBlock block : this.getBlocks()) {
            if (block.getMode() != 2 || block.getTop() > rowIndex || block.getBottom() < rowIndex) continue;
            return true;
        }
        return false;
    }

    public KDTRange toRange() {
        int size = this.size();
        KDTRange range = new KDTRange();
        for (int i = 0; i < size; ++i) {
            range.add(this.get(i));
        }
        return range;
    }

    public boolean isRowCrossSelectedRange(int rowIndex) {
        for (KDTSelectBlock block : this.getBlocks()) {
            if (rowIndex < block.getTop() || rowIndex > block.getBottom()) continue;
            return true;
        }
        return false;
    }

    public boolean isColumnCrossSelectedRange(int colIndex) {
        Iterator iter = this.getBlocks().iterator();
        while (iter.hasNext()) {
            IBlock block = KDTBlock.change(this.table, (KDTSelectBlock)iter.next());
            if (colIndex < block.getLeft() || colIndex > block.getRight()) continue;
            return true;
        }
        return false;
    }

    public boolean isCellSelected(int rowIndex, int colIndex) {
        for (KDTSelectBlock block : this.getBlocks()) {
            if (rowIndex <= -1 || colIndex <= -1) continue;
            if (block.getMode() == 8) {
                return true;
            }
            if (block.getMode() == 2 && rowIndex >= block.getTop() && rowIndex <= block.getBottom()) {
                return true;
            }
            if (block.getMode() == 4 && colIndex >= block.getLeft() && colIndex <= block.getRight()) {
                return true;
            }
            if (block.getMode() != 1 || rowIndex < block.getTop() || rowIndex > block.getBottom() || colIndex < block.getLeft() || colIndex > block.getRight()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeftestColumnOfBlock(int colIndex) {
        for (KDTSelectBlock block : this.getBlocks()) {
            if (colIndex != block.getLeft()) continue;
            return true;
        }
        return false;
    }

    public boolean isTopestRowOfBlock(int rowIndex) {
        for (KDTSelectBlock block : this.getBlocks()) {
            if (rowIndex != block.getTop()) continue;
            return true;
        }
        return false;
    }

    void adjustDeleteRow(int index) {
        int rowCount = this.table.getRowCount1();
        if (rowCount < 0) {
            this.removeAll();
            return;
        }
        int lastRow = rowCount - 1;
        while (this.table.getBody().getRowHeight(lastRow) != -1 && this.table.getBody().getRowHeight(lastRow) <= 0) {
            --lastRow;
        }
        if (lastRow < 0) {
            this.blocks.clear();
            if (this.getActiveRowIndex() > lastRow) {
                this.setActiveRowIndex(lastRow);
            }
        } else {
            int size = this.blocks.size();
            if (size > 0) {
                this.prevBlock = new KDTSelectBlock((KDTSelectBlock)this.blocks.get(size - 1));
            }
            boolean fireEvent = false;
            for (int i = size - 1; i >= 0; --i) {
                KDTSelectBlock mb = (KDTSelectBlock)this.blocks.get(i);
                boolean out = false;
                if (mb.getBeginRow() > lastRow) {
                    out = true;
                    mb.setTop(lastRow);
                    fireEvent = true;
                }
                if (mb.getEndRow() > lastRow) {
                    out = true;
                    mb.setBottom(lastRow);
                    fireEvent = true;
                }
                if (!out || size <= 1) continue;
                this.blocks.remove(i);
                --size;
                fireEvent = true;
            }
            if (this.getActiveRowIndex() > lastRow) {
                this.setActiveRowIndex(lastRow);
            }
            if (fireEvent) {
                if (size > 0) {
                    this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.prevBlock, (KDTSelectBlock)this.blocks.get(size - 1)));
                } else {
                    this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.prevBlock, null));
                }
            }
        }
    }

    void adjustDeleteCol(int index) {
        int colCount = this.table.getColumnCount();
        if (colCount < 0) {
            this.removeAll();
            return;
        }
        int lastCol = colCount - 1;
        if (lastCol < 0) {
            this.blocks.clear();
            if (this.getActiveColumnIndex() > lastCol) {
                this.setActiveColumnIndex(lastCol);
            }
        } else {
            int size = this.blocks.size();
            if (size > 0) {
                this.prevBlock = new KDTSelectBlock((KDTSelectBlock)this.blocks.get(size - 1));
            }
            boolean fireEvent = false;
            for (int i = size - 1; i >= 0; --i) {
                KDTSelectBlock mb = (KDTSelectBlock)this.blocks.get(i);
                boolean out = false;
                if (mb.getBeginCol() > lastCol) {
                    out = true;
                    mb.setLeft(lastCol);
                    fireEvent = true;
                }
                if (mb.getEndCol() > lastCol) {
                    out = true;
                    mb.setRight(lastCol);
                    fireEvent = true;
                }
                if (!out || size <= 1) continue;
                this.blocks.remove(i);
                --size;
                fireEvent = true;
            }
            if (this.getActiveColumnIndex() > lastCol) {
                this.setActiveColumnIndex(lastCol);
            }
            if (fireEvent) {
                if (size > 0) {
                    this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.prevBlock, (KDTSelectBlock)this.blocks.get(size - 1)));
                } else {
                    this.fireTableSelectChanged(new KDTSelectEvent(this.table, this.prevBlock, null));
                }
            }
        }
    }

    public int getSelectPaintMode() {
        return this.selectPaintMode;
    }

    public void setSelectPaintMode(int selectPaintMode) {
        this.selectPaintMode = selectPaintMode;
    }

    public void setEnterTravelAction(IEnterTravelAction action) {
        this.travelAction = action;
    }

    public IEnterTravelAction getEnterTravelAction() {
        return this.travelAction;
    }

    public boolean isCtrlKeyDown() {
        return this.ctrlKeyDown;
    }

    public void setCtrlKeyDown(boolean ctrlKeyDown) {
        this.ctrlKeyDown = ctrlKeyDown;
    }

    public boolean isForSingleCell() {
        return this.isForSingleCell;
    }

    public void setForSingleCell(boolean isForSingleCell) {
        this.isForSingleCell = isForSingleCell;
    }
}

