/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSytyleBlushListener;
import java.util.ArrayList;
import java.util.List;

public class KDTStyleBlush
implements KDTSelectListener {
    private List tableList = new ArrayList();
    private KDTable table;
    private KDTable toTable;
    ArrayList listerers = new ArrayList();
    private boolean isAlways = false;
    private KDTSelectBlock preSelectBlock = null;

    @Override
    public void tableSelectChanged(KDTSelectEvent e) {
        KDTSelectBlock pre = e.getPrevSelectBlock();
        KDTSelectBlock curr = e.getSelectBlock();
        if (pre == null && curr != null) {
            if (this.preSelectBlock == null) {
                return;
            }
            pre = new KDTSelectBlock(this.preSelectBlock);
        } else if (pre != null && curr != null && this.preSelectBlock != null) {
            pre = new KDTSelectBlock(this.preSelectBlock);
        }
        if (pre == null || curr == null) {
            return;
        }
        this.table = pre.getTable();
        this.toTable = curr.getTable();
        if (pre.getMode() == 4 && curr.getMode() == 4) {
            this.table.getColumn(curr.getBeginCol()).setWidth(this.table.getColumn(pre.getBeginCol()).getWidth());
        }
        pre = this.change(pre);
        curr = this.change(curr);
        if (pre == null || curr == null) {
            return;
        }
        if (curr.getTable().getUndoManager() != null) {
            curr.getTable().getUndoManager().createStyleEdit(curr);
        }
        int fromX = pre.getBeginRow();
        int fromY = pre.getBeginCol();
        if (pre.size() == 1) {
            this.oneToMulti(fromX, fromY, 0, 0, 1, 1, curr);
        } else if (curr.size() == 1) {
            this.multiToOne(pre, curr);
        } else {
            this.multiToMulti(pre, curr);
        }
        this.table.repaint();
        if (!this.isAlways) {
            this.close();
        }
    }

    private void multiToOne(KDTSelectBlock pre, KDTSelectBlock curr) {
        int bottom = curr.getBottom() + (pre.getBottom() - pre.getTop());
        int right = curr.getRight() + (pre.getRight() - pre.getLeft());
        int maxRow = this.table.getRowCount();
        int maxCol = this.table.getColumnCount();
        if (bottom >= maxRow) {
            bottom = maxRow - 1;
        }
        if (right >= maxCol) {
            right = maxCol - 1;
        }
        curr.setBottom(bottom);
        curr.setRight(right);
        this.multiToMulti(pre, curr);
    }

    private KDTSelectBlock change(KDTSelectBlock selectBlock) {
        if (selectBlock.getMode() == 1) {
            return selectBlock;
        }
        int maxRow = this.table.getRowCount();
        int maxCol = this.table.getColumnCount();
        if (selectBlock.getMode() == 4) {
            selectBlock.setBottom(maxRow - 1);
            selectBlock.setRight(selectBlock.getBeginCol());
        } else if (selectBlock.getMode() == 2) {
            selectBlock.setBottom(selectBlock.getEndRow());
            selectBlock.setRight(maxCol - 1);
        } else if (selectBlock.getMode() == 8) {
            selectBlock.setTop(0);
            selectBlock.setLeft(0);
            selectBlock.setBottom(maxRow - 1);
            selectBlock.setRight(maxCol - 1);
        }
        selectBlock.setMode(1);
        return selectBlock;
    }

    private void multiToMulti(KDTSelectBlock fromSelectBlock, KDTSelectBlock toSelectBlock) {
        int fromX1 = fromSelectBlock.getBeginRow();
        int fromY1 = fromSelectBlock.getBeginCol();
        int fromX2 = fromSelectBlock.getEndRow();
        int fromY2 = fromSelectBlock.getEndCol();
        int width = fromY2 - fromY1 + 1;
        int height = fromX2 - fromX1 + 1;
        for (int i = fromX1; i <= fromX2; ++i) {
            for (int j = fromY1; j <= fromY2; ++j) {
                int px = i - fromX1;
                int py = j - fromY1;
                this.oneToMulti(i, j, px, py, width, height, toSelectBlock);
            }
        }
    }

    private void oneToMulti(int fromX, int fromY, int px, int py, int width, int height, KDTSelectBlock toSelectBlock) {
        int toX1 = toSelectBlock.getBeginRow();
        int toY1 = toSelectBlock.getBeginCol();
        int toX2 = toSelectBlock.getEndRow();
        int toY2 = toSelectBlock.getEndCol();
        for (int i = toX1 + px; i <= toX2; i += height) {
            for (int j = toY1 + py; j <= toY2; j += width) {
                this.oneToOne(fromX, fromY, i, j);
            }
        }
    }

    private void oneToOne(int fromX, int fromY, int toX, int toY) {
        KDTCell fromCell = this.table.getCell(fromX, fromY).getKDTCell();
        KDTCell toCell = this.toTable.getCell(toX, toY).getKDTCell();
        toCell.setFormattedValue(null);
        toCell.setSSA(fromCell.getSSA());
        toCell.setStyle(fromCell.getStyle());
        this.toTable.getRow(toX).setHeight(this.table.getRow(fromX).getHeight());
    }

    private void setAlways(boolean isEnable) {
        this.isAlways = isEnable;
    }

    private void fireListener(boolean eanble) {
        for (KDTSytyleBlushListener listener : this.listerers) {
            if (eanble) {
                listener.enable();
                continue;
            }
            listener.disable();
        }
        this.listerers.clear();
    }

    public void addListener(KDTSytyleBlushListener listener) {
        this.listerers.add(listener);
    }

    private synchronized void setTableList(List tables) {
        for (KDTable this.table : tables) {
            this.tableList.add(this.table);
        }
        this.registerTableList();
    }

    private synchronized void addTable(KDTable table) {
        this.tableList.add(table);
        this.registerTableList();
    }

    public synchronized void removeTable(KDTable table) {
        this.tableList.remove(table);
    }

    private void registerTableList() {
        for (KDTable this.table : this.tableList) {
            this.table.addKDTSelectListener(this);
        }
    }

    private void unRegisterTableList() {
        for (KDTable this.table : this.tableList) {
            this.table.removeKDTSelectListener(this);
        }
    }

    public void close() {
        this.fireListener(false);
        this.unRegisterTableList();
        this.tableList = new ArrayList();
        this.listerers.clear();
        this.preSelectBlock = null;
        this.table = null;
        this.toTable = null;
        this.isAlways = false;
    }

    private void setCurrentTable(KDTable currentTable) {
        KDTSelectBlock block = currentTable.getSelectManager().get();
        if (block != null) {
            this.preSelectBlock = block;
        }
    }

    public void start(List list, KDTable currentTable, boolean isAlways) {
        this.setTableList(list);
        this.setCurrentTable(currentTable);
        this.setAlways(isAlways);
    }

    public void start(KDTable currentTable, boolean isAlways) {
        this.addTable(currentTable);
        this.setCurrentTable(currentTable);
        this.setAlways(isAlways);
    }
}

