/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.table.DataTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import java.awt.GraphicsEnvironment;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.log4j.Logger;
import sun.awt.AppContext;

public class KDTTransferHandle
implements Serializable {
    private static final Logger logger = LogUtil.getPackageLogger(KDTTransferHandle.class);
    private static final long serialVersionUID = 23434536L;
    private KDTable table;
    private int mark;
    private boolean canAccessSystemClipboard = true;
    private static Object SandboxClipboardKey = new Object();

    public KDTTransferHandle(KDTable table) {
        this(table, 15);
    }

    public KDTTransferHandle(KDTable table, int mark) {
        this.mark = mark;
        this.table = table;
    }

    private boolean canAccessSystemClipboard() {
        if (this.canAccessSystemClipboard) {
            if (GraphicsEnvironment.isHeadless()) {
                this.canAccessSystemClipboard = false;
                return false;
            }
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                try {
                    sm.checkSystemClipboardAccess();
                    return true;
                }
                catch (SecurityException se) {
                    this.canAccessSystemClipboard = false;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void exportToClipboard() {
        Clipboard clip = this.getClipboard();
        if (clip != null) {
            KDTTransferable tf = new KDTTransferable(this.mark);
            clip.setContents(tf, null);
        }
    }

    public boolean isClipboardDataAvailable() {
        boolean isAvailable = false;
        Clipboard clip = this.getClipboard();
        if (clip == null) {
            return false;
        }
        Transferable tf = clip.getContents(null);
        if (tf == null) {
            return false;
        }
        DataFlavor[] flavors = tf.getTransferDataFlavors();
        DataFlavor flavor = this.getKDTDataFlavor(flavors);
        DataFlavor flavor2 = this.getStringFlavor(flavors);
        if (flavor == null && flavor2 != null) {
            flavor = flavor2;
        }
        if (flavor != null) {
            try {
                Object data = tf.getTransferData(flavor);
                return data != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAvailable;
    }

    public void importFromClipboard() {
        Transferable tf;
        Clipboard clip = this.getClipboard();
        if (clip != null && (tf = clip.getContents(null)) != null) {
            DataFlavor[] flavors = tf.getTransferDataFlavors();
            DataFlavor flavor = this.getKDTDataFlavor(flavors);
            if (flavor != null) {
                Object data = null;
                try {
                    data = tf.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (data instanceof String) {
                    String str = (String)data;
                    this.table.getEditHelper().parseXmlFromClipboard(str, this.mark);
                }
                return;
            }
            flavor = this.getStringFlavor(flavors);
            if (flavor != null) {
                Object data = null;
                try {
                    data = tf.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException str) {
                }
                catch (IOException str) {
                    // empty catch block
                }
                if (data instanceof String) {
                    String str = (String)data;
                    this.table.getEditHelper().parseStringFromClipboard(str);
                }
                return;
            }
        }
    }

    public KDTSelectBlock preImportFromClipboard() {
        Transferable tf;
        Clipboard clip = this.getClipboard();
        if (clip != null && (tf = clip.getContents(null)) != null) {
            DataFlavor[] flavors = tf.getTransferDataFlavors();
            DataFlavor flavor = this.getKDTDataFlavor(flavors);
            if (flavor != null) {
                Object data = null;
                try {
                    data = tf.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (data instanceof String) {
                    String str = (String)data;
                    return this.table.getEditHelper().preParseXmlFromClipboard(str, this.mark);
                }
                return null;
            }
            flavor = this.getStringFlavor(flavors);
            if (flavor != null) {
                Object data = null;
                try {
                    data = tf.getTransferData(flavor);
                }
                catch (UnsupportedFlavorException str) {
                }
                catch (IOException str) {
                    // empty catch block
                }
                if (data instanceof String) {
                    String str = (String)data;
                    return this.table.getEditHelper().preParseStringFromClipboard(str);
                }
                return null;
            }
        }
        return null;
    }

    DataFlavor getKDTDataFlavor(DataFlavor[] flavors) {
        int length = flavors.length;
        for (int i = 0; i < length; ++i) {
            if (!KDTTransferHandle.isKDTDataFlavor(flavors[i])) continue;
            return flavors[i];
        }
        return null;
    }

    DataFlavor getStringFlavor(DataFlavor[] flavors) {
        int length = flavors.length;
        for (int i = 0; i < length; ++i) {
            if (!KDTTransferHandle.isStringFlavor(flavors[i])) continue;
            return flavors[i];
        }
        return null;
    }

    private Clipboard getClipboard() {
        if (this.canAccessSystemClipboard()) {
            return this.table.getToolkit().getSystemClipboard();
        }
        AppContext appContext = AppContext.getAppContext();
        Clipboard clipboard = (Clipboard)appContext.get(SandboxClipboardKey);
        if (clipboard == null) {
            clipboard = new Clipboard("Sandboxed Component Clipboard");
            appContext.put(SandboxClipboardKey, clipboard);
        }
        return clipboard;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor == DataFlavor.stringFlavor) {
            return true;
        }
        return KDTTransferHandle.isKDTDataFlavor(flavor);
    }

    private static boolean isKDTDataFlavor(DataFlavor flavor) {
        return "application".equals(flavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(flavor.getSubType()) && flavor.getRepresentationClass().isAssignableFrom(KDTable.class);
    }

    private static boolean isStringFlavor(DataFlavor flavor) {
        return DataFlavor.stringFlavor == flavor;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    public class KDTTransferable
    implements Transferable {
        private DataFlavor[] flavors;
        private String xmlSpreadSheet;
        private String strSpreadSheet;

        public KDTTransferable(int mark) {
            DataTable dt = new DataTable(mark);
            this.xmlSpreadSheet = KDTTransferHandle.this.table.getEditHelper().getXmlForClipboard(dt);
            this.strSpreadSheet = KDTTransferHandle.this.table.getEditHelper().getStringForClipboard(dt);
        }

        DataFlavor[] getDataFlavors() {
            if (this.flavors == null) {
                this.flavors = new DataFlavor[2];
                String mimeType = "application/x-java-jvm-local-objectref;class=com.kingdee.cosmic.ctrl.kdf.table.KDTable";
                try {
                    this.flavors[0] = new DataFlavor(mimeType);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                this.flavors[1] = DataFlavor.stringFlavor;
            }
            return this.flavors;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(flavor)) {
                if (KDTTransferHandle.isKDTDataFlavor(flavor)) {
                    return this.xmlSpreadSheet;
                }
                if (flavor.isFlavorTextType()) {
                    return this.strSpreadSheet;
                }
                return "";
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.getDataFlavors();
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return KDTTransferHandle.this.isDataFlavorSupported(flavor);
        }
    }
}

