/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.BasicView;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTreeColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class KDTTreeColumnView
extends BasicView {
    private static final long serialVersionUID = 1922996417221213272L;
    private KDTTreeColumn treeColumn;
    private int topRow;
    private int bottomRow;
    private IRows body;
    private int x2;
    private int y2;

    public KDTTreeColumnView(KDTable table) {
        super(table);
        this.body = table.getBody();
        this.treeColumn = table.getTreeColumn();
        this.addMouseListener(new MouseHandle());
    }

    @Override
    public Object clone() {
        KDTTreeColumnView view = new KDTTreeColumnView(this.table);
        return view;
    }

    @Override
    public void paint(Graphics g) {
        Color cBottom;
        int wBottom;
        Color cRight;
        int wRight;
        KDTable.printDebugInfo(this.getClass().toString() + " begin:" + (System.currentTimeMillis() - KDTable.beginDate));
        KDTVertical vertical = this.table.getLayoutManager().getVertical(this.table.getViewManager().getVerticalIndex(this.getIndex()));
        this.topRow = vertical.getFirst();
        this.bottomRow = vertical.getLast();
        if (this.bottomRow == -1) {
            return;
        }
        this.x2 = this.treeColumn.getWidth();
        this.y2 = this.body.getHeight(this.topRow, this.bottomRow);
        if (this.x2 > this.getWidth()) {
            this.x2 = this.getWidth();
        }
        if (this.y2 > this.getHeight()) {
            this.y2 = this.getHeight();
        }
        IBasicRender renderer = this.treeColumn.getRenderer();
        Style style = this.treeColumn.getStyle();
        Graphics2D bufferGraphics = (Graphics2D)g;
        Color oldColor = bufferGraphics.getColor();
        Styles.Position pos = Styles.Position.RIGHT;
        LineStyle ls = style.getBorderLineStyle(pos);
        if (LineStyle.isNull((LineStyle)ls)) {
            wRight = 1;
            cRight = this.table.getGridLineColor();
        } else {
            wRight = ls.getWidth();
            cRight = style.getBorderColor(pos);
        }
        int xPos = this.x2 - wRight;
        int yPos = this.y2;
        bufferGraphics.setColor(style.getBackground());
        bufferGraphics.fillRect(0, 0, xPos, yPos);
        bufferGraphics.setColor(cRight);
        bufferGraphics.drawLine(xPos, 0, xPos, yPos);
        int y = 0;
        Rectangle rOuter = new Rectangle();
        rOuter.width = this.treeColumn.getLevelWidth();
        int halfWidth = rOuter.width / 2;
        bufferGraphics.setColor(this.table.getGridLineColor());
        for (int i = this.topRow; i <= this.bottomRow; ++i) {
            int level = this.treeColumn.getTreeLevel(i);
            rOuter.x = level * rOuter.width + 3;
            int height = this.body.getRowHeight(i);
            if (height <= 0) continue;
            rOuter.y = y;
            rOuter.height = height;
            y += height;
            int iconType = this.treeColumn.getTreeIconType(i);
            renderer.draw((Graphics)bufferGraphics, (Shape)rOuter, (Object)iconType, style);
            if (this.treeColumn.getOrientation() != 0) continue;
            if (iconType == 2) {
                rOuter.x += halfWidth;
                int ty = rOuter.y + (rOuter.height - 12) / 2 + 12;
                bufferGraphics.drawLine(rOuter.x, ty, rOuter.x, y - 1);
            }
            if (level <= 0 || this.treeColumn.getOrientation() != 0) continue;
            int nextLevel = this.getNextVisibleTreeLevel(i + 1);
            while (level > 0) {
                rOuter.x = (level - 1) * rOuter.width + 3 + halfWidth;
                if (nextLevel <= level - 1) {
                    bufferGraphics.drawLine(rOuter.x, rOuter.y, rOuter.x, y - 2);
                    bufferGraphics.drawLine(rOuter.x, y - 2, rOuter.x + halfWidth - 1, y - 2);
                } else {
                    bufferGraphics.drawLine(rOuter.x, rOuter.y, rOuter.x, y - 1);
                }
                --level;
            }
        }
        pos = Styles.Position.BOTTOM;
        ls = style.getBorderLineStyle(pos);
        if (LineStyle.isNull((LineStyle)ls)) {
            wBottom = 1;
            cBottom = this.table.getGridLineColor();
        } else {
            wBottom = ls.getWidth();
            cBottom = style.getBorderColor(pos);
        }
        if (y < this.getHeight()) {
            yPos = this.y2 - wBottom;
            bufferGraphics.setColor(cBottom);
            bufferGraphics.drawLine(0, yPos, xPos, yPos);
        }
        bufferGraphics.setColor(oldColor);
        KDTable.printDebugInfo(this.getClass().toString() + " after:" + (System.currentTimeMillis() - KDTable.beginDate));
    }

    private int getNextVisibleTreeLevel(int rowIndex) {
        int rHeight = -1;
        int size = this.body.size();
        do {
            if ((rHeight = this.body.getRowHeight(rowIndex)) <= 0) continue;
            return this.treeColumn.getTreeLevel(rowIndex);
        } while (++rowIndex < size);
        return -1;
    }

    protected void drawCells(Graphics2D g) {
        this.drawCells(g, this.topRow, 0, this.bottomRow, 1, 0, 0);
    }

    protected void drawCells(Graphics2D g, int top, int left, int bottom, int right, int dx, int dy) {
        IBasicRender renderer = this.treeColumn.getRenderer();
        Style style = this.treeColumn.getStyle();
        int y = dy;
        Rectangle rOuter = new Rectangle();
        rOuter.width = this.treeColumn.getLevelWidth();
        for (int i = top; i <= bottom; ++i) {
            int level = this.treeColumn.getTreeLevel(i);
            rOuter.x = level * rOuter.width + 3;
            int height = this.body.getRowHeight(i);
            if (height <= 0) continue;
            rOuter.y = y;
            rOuter.height = height;
            y += height;
            int iconType = this.treeColumn.getTreeIconType(i);
            renderer.draw((Graphics)g, (Shape)rOuter, (Object)iconType, style);
        }
    }

    @Override
    protected void drawBottomBorder(Graphics2D g, Rectangle rect, Style style) {
    }

    @Override
    protected void drawRightBorder(Graphics2D g, Rectangle rect, Style style) {
    }

    @Override
    public void scroll(IBlock oldPage, IBlock newPage) {
        this.repaint();
    }

    int getRowIndex(int y) {
        if (y <= this.y2) {
            int span = 0;
            for (int i = this.topRow; i <= this.bottomRow; ++i) {
                if ((span += this.body.getRowHeight(i)) <= y) continue;
                return i;
            }
        }
        return -1;
    }

    class MouseHandle
    extends MouseAdapter {
        MouseHandle() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int y;
            int rowIndex;
            if (KDTTreeColumnView.this.table.getEditManager().isEditing() && 0 != KDTTreeColumnView.this.table.getEditManager().stopEditing()) {
                return;
            }
            if (!KDTTreeColumnView.this.table.isFocusOwner()) {
                KDTTreeColumnView.this.table.requestFocusInWindow();
            }
            if ((rowIndex = KDTTreeColumnView.this.getRowIndex(y = e.getY())) >= 0) {
                KDTTreeColumnView.this.treeColumn.treeClick(rowIndex);
            }
        }
    }
}

