/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.kdf.table.BasicView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCornerView;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTTreeColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class KDTTreeCornerView
extends BasicView {
    private KDWorkButton[] btns;
    private ButtonAction action;

    public KDTTreeCornerView(KDTable table) {
        super(table);
        this.setLayout(new InnerLayout());
        this.action = new ButtonAction();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Rectangle rect = this.getBounds();
        rect.x = 0;
        rect.y = 0;
        Color[] headVerges = this.table.getHeadVergesColor();
        KDTCornerView.fillRectWithVerge(g, rect, headVerges, this.table.getHeadStyle().getBackground());
    }

    private void refresh() {
        int levels = this.table.getTreeColumn().getDepth();
        if (this.btns == null || this.btns.length != levels) {
            this.btns = new KDWorkButton[levels];
            this.removeAll();
            for (int i = 0; i < levels; ++i) {
                this.btns[i] = this.createButton(i);
                this.add((Component)this.btns[i]);
            }
        }
    }

    private KDWorkButton createButton(int level) {
        KDWorkButton btn = new KDWorkButton();
        btn.setUserObject((Object)level);
        btn.setFont(new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 7));
        btn.setAction((Action)this.action);
        btn.setText(String.valueOf(level + 1));
        return btn;
    }

    class InnerLayout
    implements LayoutManager {
        InnerLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w;
            KDTTreeCornerView.this.refresh();
            int ph = parent.getHeight();
            KDTTreeColumn treeCol = KDTTreeCornerView.this.table.getTreeColumn();
            int h = w = treeCol.getLevelWidth();
            int x = 3;
            int y = ph - h - 2;
            int size = parent.getComponentCount();
            for (int i = 0; i < size; ++i) {
                parent.getComponent(i).setBounds(x, y, w, h);
                x += w;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return null;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    class ButtonAction
    extends AbstractAction {
        ButtonAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            KDWorkButton btn = (KDWorkButton)e.getSource();
            int level = (Integer)btn.getUserObject();
            KDTTreeColumn tc = KDTTreeCornerView.this.table.getTreeColumn();
            int maxLevel = tc.getDepth() - 1;
            int rowCount = KDTTreeCornerView.this.table.getRowCount3();
            boolean refresh = KDTTreeCornerView.this.table.isRefresh();
            KDTTreeCornerView.this.table.setRefresh(false);
            for (int i = 0; i < rowCount; ++i) {
                KDTRow row = KDTTreeCornerView.this.table.getBody().getRow(i);
                if (row == null) continue;
                int rLevel = row.getTreeLevel();
                if (rLevel == level && rLevel < maxLevel) {
                    tc.doCollapse(i);
                    continue;
                }
                if (rLevel >= level) continue;
                row.setCollapse(false);
                tc.doExpand(i);
            }
            KDTTreeCornerView.this.table.setRefresh(refresh);
            KDTTreeCornerView.this.table.repaint();
        }
    }
}

