/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.BasicView;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.IRows;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCellPosition;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTColumns;
import com.kingdee.cosmic.ctrl.kdf.table.KDTEditManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTHorizon;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.cosmic.ctrl.kdf.table.KDTVertical;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.KDTableHelper;
import com.kingdee.cosmic.ctrl.kdf.table.cursor.ICursorProvider;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTResizeEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kdf.table.render.RenderObject;
import com.kingdee.cosmic.ctrl.kdf.util.render.CellCheckBoxRenderer;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.render.IExtBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Area;
import javax.swing.Timer;
import javax.swing.event.MouseInputListener;

public class KDTView
extends BasicView
implements MouseInputListener,
ActionListener,
MouseWheelListener {
    private static final long serialVersionUID = 5269207014091937141L;
    protected final short MOUSE_FOCUS_SPAN = (short)5;
    protected KDTColumns columns;
    protected IRows rows;
    protected Area selectArea = new Area();
    protected Rectangle activeCellRect = new Rectangle(0, 0, 0, 0);
    protected int topRow;
    protected int leftCol;
    protected int bottomRow;
    protected int rightCol;
    protected int x2;
    protected int y2;
    protected int status = 0;
    public static final int ACTION_KEEP_CUESOR = -1;
    public static final int ACTION_NORMAL = 0;
    public static final int ACTION_RIGHT_BORDER = 1;
    public static final int ACTION_COL_RESIZING = 2;
    public static final int ACTION_BOTTOM_BORDER = 3;
    public static final int ACTION_ROW_RESIZING = 4;
    public static final int ACTION_SELECTING = 5;
    public static final int ACTION_EDITING = 6;
    public static final int ACTION_COL_MOVE = 7;
    protected int activeCol;
    protected int activeColWidth;
    protected int activeColRight;
    protected int activeRowType;
    protected int activeRow;
    protected int activeRowHeight;
    protected int activeRowBottom;
    protected Timer timer;
    protected int dragScrollX;
    protected int dragScrollY;
    KDTResizeEvent colResizeEvent = new KDTResizeEvent(this.table);
    KDTResizeEvent rowResizeEvent = new KDTResizeEvent(this.table);
    protected int activeHeight = 0;
    protected int activeWidth = 0;

    public KDTView(KDTable table, KDTColumns columns, IRows rows) {
        super(table);
        this.viewType = 1;
        this.columns = columns;
        this.rows = rows;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.timer = new Timer(70, this);
        this.setDoubleBuffered(false);
        this.getActionMap().setParent(this.table.getActionMap());
        this.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public Object clone() {
        KDTView view = new KDTView(this.table, this.columns, this.rows);
        view.topRow = this.topRow;
        view.leftCol = this.leftCol;
        return view;
    }

    @Override
    public void paint(Graphics g) {
        KDTable.printDebugInfo(this.getClass().toString() + " begin:" + (System.currentTimeMillis() - KDTable.beginDate));
        this.updateBounds();
        if (this.bottomRow == -1 || this.rightCol == -1) {
            return;
        }
        this.x2 = this.columns.getWidth(this.leftCol, this.rightCol);
        this.y2 = this.rows.getHeight(this.topRow, this.bottomRow);
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.x2 > width) {
            this.x2 = width;
        }
        if (this.y2 > height) {
            this.y2 = height;
        }
        this.activeWidth = this.x2;
        this.activeHeight = this.y2;
        if (this.x2 == 0 || this.y2 == 0) {
            return;
        }
        Graphics2D bufferGraphics = (Graphics2D)g;
        Stroke oldStroke = bufferGraphics.getStroke();
        Color oldColor = bufferGraphics.getColor();
        this.drawCells(bufferGraphics);
        this.drawSelect(bufferGraphics);
        bufferGraphics.setStroke(oldStroke);
        bufferGraphics.setColor(oldColor);
        super.paint(g);
        KDTable.printDebugInfo(this.getClass().toString() + " after:" + (System.currentTimeMillis() - KDTable.beginDate));
    }

    @Override
    public void updateBounds() {
        if (!this.table.enableRepaint) {
            return;
        }
        KDTVertical vertical = this.table.getLayoutManager().getVertical(this.table.getViewManager().getVerticalIndex(this.getIndex()));
        KDTHorizon horizon = this.table.getLayoutManager().getHorizon(this.table.getViewManager().getHorizonIndex(this.getIndex()));
        if (vertical != null) {
            this.topRow = vertical.getFirst();
            this.bottomRow = vertical.getLast();
        }
        if (horizon != null) {
            this.leftCol = horizon.getFirst();
            this.rightCol = horizon.getLast();
        }
        this.updateBounds(this.topRow, this.leftCol, this.bottomRow, this.rightCol);
    }

    protected void updateBounds(int top, int left, int bottom, int right) {
        this.topRow = top;
        this.bottomRow = bottom;
        this.leftCol = left;
        this.rightCol = right;
    }

    public int getTopRow() {
        return this.topRow;
    }

    public int getLeftCol() {
        return this.leftCol;
    }

    public int getBottomRow() {
        return this.bottomRow;
    }

    public int getRightCol() {
        return this.rightCol;
    }

    private void drawSelectIntoArea(Graphics2D g) {
        if (this.rows.size() <= 0) {
            return;
        }
        KDTSelectManager selectManager = this.table.getSelectManager();
        int size = selectManager.size();
        block6: for (int i = 0; i < size; ++i) {
            KDTSelectBlock block = selectManager.get(i);
            switch (block.getMode()) {
                case 1: {
                    this.drawCellSelect(g, block);
                    continue block6;
                }
                case 2: {
                    this.drawRowSelect(g, block);
                    continue block6;
                }
                case 4: {
                    this.drawColumnSelect(g, block);
                    continue block6;
                }
                case 8: {
                    this.drawTableSelect(g, block);
                }
            }
        }
    }

    protected void drawCells(Graphics2D g) {
        this.drawCells(g, this.topRow, this.leftCol, this.bottomRow, this.rightCol, 0, 0);
    }

    protected void drawCells(Graphics2D g, int top, int left, int bottom, int right, int dx, int dy) {
        Rectangle rOuter = new Rectangle();
        Rectangle rInner = new Rectangle();
        Rectangle rTemp = new Rectangle();
        KDTEditManager editEngine = this.table.getEditManager();
        int editorStatus = 0;
        if (editEngine.isEditing() && editEngine.getEditView() == this && editEngine.getEditor().isDisplayable()) {
            editorStatus = 1;
        }
        int activeRowIndex = this.table.getSelectManager().getActiveRowIndex();
        int activeColIndex = this.table.getSelectManager().getActiveColumnIndex();
        int width = 0;
        int height = 0;
        int x = dx;
        int y = dy;
        for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
            boolean freezed;
            KDTRow row = this.rows.getRow(rowIndex);
            if (row == null) continue;
            height = this.rows.getRowHeight(rowIndex);
            if (height > this.getBounds().height + ((freezed = this.table.getViewManager().isFreeze()) ? 2 : 0)) {
                height = this.getBounds().height;
            }
            rTemp.y = y;
            rTemp.height = height;
            y += height;
            x = dx;
            width = 0;
            for (int colIndex = left; colIndex <= right; ++colIndex) {
                Style style;
                int drawCellRowIndex = rowIndex;
                int drawCellColIndex = colIndex;
                KDTColumn column = this.columns.getColumn(colIndex);
                width = this.columns.getColumnWidth(colIndex);
                if (width > this.getBounds().width + (freezed ? 2 : 0)) {
                    width = this.getBounds().width;
                }
                rTemp.x = x;
                rTemp.width = width;
                x += width;
                KDTCell cell = row.getCell(colIndex);
                if (cell == null) {
                    this.getCellOuterBounds(rOuter, rTemp);
                    style = this.getBlankCellStyle(row.getSSA(), column.getSSA());
                } else {
                    KDTMergeBlock mergeBlock = cell.getViewBlock();
                    if (mergeBlock != null) {
                        rOuter.y = mergeBlock.top < this.topRow ? this.topRow : mergeBlock.top;
                        int n = rOuter.x = mergeBlock.left < this.leftCol ? this.leftCol : mergeBlock.left;
                        if (rOuter.x != colIndex || rOuter.y != rowIndex) continue;
                        drawCellRowIndex = mergeBlock.top;
                        drawCellColIndex = mergeBlock.left;
                        if (this.rows.getRow2(mergeBlock.top) != null) {
                            cell = this.rows.getRow2(mergeBlock.top).getCell(mergeBlock.left);
                        }
                        rOuter.y = this.rows.getHeight(mergeBlock.top, rowIndex - 1);
                        rOuter.x = this.columns.getWidth(mergeBlock.left, colIndex - 1);
                        rOuter.height = rOuter.y + this.rows.getHeight(rowIndex, mergeBlock.bottom);
                        rOuter.width = rOuter.x + this.columns.getWidth(colIndex, mergeBlock.right);
                        rOuter.y = rTemp.y - rOuter.y;
                        rOuter.x = rTemp.x - rOuter.x;
                        style = cell.getStyle();
                    } else {
                        this.getCellOuterBounds(rOuter, rTemp);
                        style = cell.getStyle();
                    }
                }
                if (editorStatus == 1 && editEngine.getEditRowIndex() == rowIndex && editEngine.getEditColIndex() == colIndex) {
                    int eHeight;
                    int eWidth;
                    editEngine.setEditorVisible(true);
                    if (editEngine.isEditorAlignTop()) {
                        eWidth = rTemp.width > this.getWidth() ? this.getWidth() - 1 : rTemp.width - 1;
                        eHeight = rTemp.height > this.getHeight() ? this.getHeight() - 1 : rTemp.height - 1;
                    } else {
                        eWidth = rOuter.width > this.getWidth() ? this.getWidth() - 1 : rOuter.width - 1;
                        int n = eHeight = rOuter.height > this.getHeight() ? this.getHeight() - 1 : rOuter.height - 1;
                    }
                    if (editEngine.isEditorHasBorder()) {
                        editEngine.setEditorBounds(rOuter.x - 1, rOuter.y - 1, eWidth + 2, eHeight + 2);
                    } else {
                        editEngine.setEditorBounds(rOuter.x, rOuter.y, eWidth, eHeight);
                    }
                    editorStatus = 2;
                    this.fillRect(g, rOuter, style);
                    this.drawBottomBorder(g, rOuter, style);
                    this.drawRightBorder(g, rOuter, style);
                    continue;
                }
                if (rOuter.height <= 0 || rOuter.width <= 0) continue;
                IBasicRender render = this.getCellRender(drawCellRowIndex, drawCellColIndex);
                if (render != null) {
                    if (render instanceof IExtBasicRender) {
                        IExtBasicRender extRender = (IExtBasicRender)render;
                        if (!extRender.isFillBackground()) {
                            this.fillRect(g, rOuter, style);
                        }
                        if (cell != null && !cell.isHide()) {
                            Object value = this.table.getCellDisplayValue(cell, drawCellRowIndex, drawCellColIndex);
                            style = cell.getStyle();
                            RenderObject ro = new RenderObject(this.table, cell, drawCellRowIndex, drawCellColIndex);
                            if (extRender.isClip()) {
                                this.getCellInnerBounds(rInner, rOuter);
                                extRender.draw((Graphics)g, (Shape)rInner, value, style, (Object)ro);
                            } else {
                                extRender.draw((Graphics)g, (Shape)rOuter, value, style, (Object)ro);
                            }
                        } else {
                            RenderObject ro = new RenderObject(this.table, cell, drawCellRowIndex, drawCellColIndex);
                            if (extRender.isClip()) {
                                this.getCellInnerBounds(rInner, rOuter);
                                extRender.draw((Graphics)g, (Shape)rInner, null, style, (Object)ro);
                            } else {
                                extRender.draw((Graphics)g, (Shape)rOuter, null, style, (Object)ro);
                            }
                        }
                        if (!extRender.isDrawBorder()) {
                            this.drawCellBorder(g, rOuter, style);
                        }
                    } else {
                        this.fillRect(g, rOuter, style);
                        if (cell != null && !cell.isHide()) {
                            this.getCellInnerBounds(rInner, rOuter);
                            if (rInner.height > 0 && rInner.width > 0) {
                                Object value = this.table.getCellDisplayValue(cell, drawCellRowIndex, drawCellColIndex);
                                style = cell.getStyle();
                                if (render instanceof CellCheckBoxRenderer && ((CellCheckBoxRenderer)render).isAlignTop()) {
                                    Rectangle r = new Rectangle();
                                    r.x = rInner.x;
                                    r.y = rInner.y;
                                    r.width = rTemp.width - 6;
                                    r.height = rTemp.height - 0;
                                    render.draw((Graphics)g, (Shape)r, value, style);
                                } else if (render != null) {
                                    render.draw((Graphics)g, (Shape)rInner, value, style);
                                }
                            }
                        }
                        this.drawCellBorder(g, rOuter, style);
                    }
                }
                if (activeRowIndex != rowIndex || activeColIndex != colIndex) continue;
                this.activeCellRect.setBounds(rOuter);
            }
        }
        if (editorStatus == 1) {
            editEngine.setEditorVisible(false);
        }
    }

    protected void getCellOuterBounds(Rectangle outer, Rectangle origin) {
        outer.x = origin.x;
        outer.y = origin.y;
        outer.height = origin.height;
        outer.width = origin.width;
    }

    protected void getCellInnerBounds(Rectangle inner, Rectangle origin) {
        inner.x = origin.x + 3;
        inner.y = origin.y + 0;
        inner.width = origin.width - 6;
        inner.height = origin.height - 0;
    }

    protected void drawCellBorder(Graphics2D g, Rectangle rect, Style style) {
        this.drawTopBorder(g, rect, style);
        this.drawLeftBorder(g, rect, style);
        this.drawBottomBorder(g, rect, style);
        this.drawRightBorder(g, rect, style);
    }

    protected void fillRect(Graphics2D g, Rectangle rect, Color backColor) {
        g.setColor(backColor);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
    }

    protected void fillRect(Graphics2D g, Rectangle rect, Style style) {
        if (style == null) {
            return;
        }
        Paint paint = style.getFillPaint();
        if (paint != null && !paint.equals(Styles.getNullColor())) {
            g.setPaint(paint);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            Color clr = style.getBackground();
            if (clr.getAlpha() == 0) {
                clr = Color.WHITE;
            }
            g.setColor(clr);
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
    }

    protected Style getBlankCellStyle(ShareStyleAttributes ssaRow, ShareStyleAttributes ssaCol) {
        return this.table.getBlankCellStyle(ssaRow, ssaCol);
    }

    public KDTCellPosition getCellPosition(int x, int y) {
        int i;
        int span;
        KDTCellPosition pos = new KDTCellPosition();
        pos.colIndex = -1;
        pos.rowIndex = -1;
        if (x <= this.x2) {
            span = 0;
            for (i = this.leftCol; i <= this.rightCol; ++i) {
                if ((span += this.columns.getColumnWidth(i)) <= x) continue;
                pos.colIndex = i;
                break;
            }
        }
        if (y <= this.y2) {
            span = 0;
            for (i = this.topRow; i <= this.bottomRow && this.rows.getRow2(i) != null; ++i) {
                if ((span += this.rows.getRowHeight(i)) <= y) continue;
                pos.rowIndex = i;
                break;
            }
        }
        return pos;
    }

    public KDTCellPosition getCellPosition2(int x, int y) {
        KDTMergeBlock mb;
        KDTCell cell;
        KDTCellPosition pos = this.getCellPosition(x, y);
        if (pos.rowIndex != -1 && pos.colIndex != -1 && (cell = this.rows.getRow2(pos.rowIndex).getCell(pos.colIndex)) != null && (mb = cell.getViewBlock()) != null) {
            pos.rowIndex = mb.top;
            pos.colIndex = mb.left;
        }
        return pos;
    }

    @Override
    public Rectangle getCellRectangle(int rowIndex, int colIndex) {
        Rectangle rect = new Rectangle();
        rect.x = this.columns.getWidth(this.leftCol, colIndex - 1);
        rect.y = this.rows.getHeight(this.topRow, rowIndex - 1);
        rect.width = this.columns.getColumnWidth(colIndex);
        rect.height = this.rows.getRowHeight(rowIndex);
        return rect;
    }

    public Rectangle getCellRectangle2(int rowIndex, int colIndex) {
        KDTMergeBlock mb = this.rows.getRow2(rowIndex).getCell(colIndex).getMergeBlock();
        int fromRow = rowIndex;
        int toRow = rowIndex;
        int fromCol = colIndex;
        int toCol = colIndex;
        if (mb != null) {
            fromRow = mb.top;
            toRow = mb.bottom;
            fromCol = mb.left;
            toCol = mb.right;
        }
        Rectangle rect = new Rectangle();
        rect.x = this.columns.getWidth(this.leftCol, colIndex - 1);
        rect.y = this.rows.getHeight(this.topRow, rowIndex - 1);
        rect.width = this.columns.getWidth(fromCol, toCol);
        rect.height = this.rows.getHeight(fromRow, toRow);
        return rect;
    }

    protected void drawCellSelect(Graphics2D g, KDTSelectBlock block) {
        int top = block.getTop();
        int left = block.getLeft();
        int bottom = block.getBottom();
        int right = block.getRight();
        if (top > this.bottomRow || left > this.rightCol || bottom < this.topRow || right < this.leftCol) {
            return;
        }
        top = top < this.topRow ? this.topRow : top;
        left = left < this.leftCol ? this.leftCol : left;
        bottom = bottom > this.bottomRow ? this.bottomRow : bottom;
        right = right > this.rightCol ? this.rightCol : right;
        int x = this.columns.getWidth(this.leftCol, left - 1);
        int w = this.columns.getWidth(left, right) - 1;
        int y = this.rows.getHeight(this.topRow, top - 1);
        int h = this.rows.getHeight(top, bottom) - 1;
        this.drawSelectBlock(g, x, y, w, h);
    }

    protected void drawRowSelect(Graphics2D g, KDTSelectBlock block) {
        int top = block.getTop();
        int bottom = block.getBottom();
        if (top > this.bottomRow || bottom < this.topRow) {
            return;
        }
        top = top < this.topRow ? this.topRow : top;
        bottom = bottom > this.bottomRow ? this.bottomRow : bottom;
        int y = this.rows.getHeight(this.topRow, top - 1);
        int h = this.rows.getHeight(top, bottom);
        this.drawSelectBlock(g, 0, y, this.x2, h);
    }

    protected void drawColumnSelect(Graphics2D g, KDTSelectBlock block) {
        int left = block.getLeft();
        int right = block.getRight();
        if (left > this.rightCol || right < this.leftCol) {
            return;
        }
        left = left < this.leftCol ? this.leftCol : left;
        right = right > this.rightCol ? this.rightCol : right;
        int x = this.columns.getWidth(this.leftCol, left - 1);
        int w = this.columns.getWidth(left, right);
        this.drawSelectBlock(g, x, 0, w, this.y2);
    }

    protected void drawTableSelect(Graphics2D g, KDTSelectBlock block) {
        this.drawSelectBlock(g, 0, 0, this.x2, this.y2);
    }

    protected void drawSelectBlock(Graphics2D g, int x, int y, int w, int h) {
        this.selectArea.add(new Area(new Rectangle(x, y, w, h)));
    }

    protected void drawSelect(Graphics2D g) {
        this.selectArea.reset();
        this.drawSelectIntoArea(g);
        if (this.viewType == 1) {
            if (this.table.getSelectManager().getSelectPaintMode() == 0) {
                this.drawSelectListModel(g);
            } else {
                this.drawSelectEditModel(g);
            }
        } else {
            g.setColor(this.table.getSelectManager().getSelectColor());
            g.fill(this.selectArea);
        }
    }

    protected void drawSelectEditModel(Graphics2D g) {
        if (this.table.getSelectManager().size() == 1) {
            Rectangle rect = this.selectArea.getBounds();
            int w = 2;
            rect.x += w;
            rect.y += w;
            rect.width -= 2 * w;
            rect.height -= 2 * w;
            this.selectArea.reset();
            this.selectArea.add(new Area(rect));
            this.selectArea.subtract(new Area(this.activeCellRect));
            g.setColor(this.table.getSelectManager().getSelectColor());
            g.fill(this.selectArea);
            w = 2;
            rect.x -= w;
            rect.y -= w;
            rect.width += 2 * w - 1;
            rect.height += 2 * w - 1;
            g.setColor(KDTStyleConstants.SELECT_BORDER_COLOR_OUTTER);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            --rect.x;
            --rect.y;
            rect.width += 2;
            rect.height += 2;
            g.setColor(KDTStyleConstants.SELECT_BORDER_COLOR_INNER);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
            --rect.x;
            --rect.y;
            rect.width += 2;
            rect.height += 2;
            g.setColor(KDTStyleConstants.SELECT_BORDER_COLOR_OUTTER);
            g.drawRect(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.selectArea.subtract(new Area(this.activeCellRect));
            g.setColor(this.table.getSelectManager().getSelectColor());
            g.fill(this.selectArea);
            g.setColor(KDTStyleConstants.SELECT_BORDER_COLOR_OUTTER);
            g.drawRect(this.activeCellRect.x + 1, this.activeCellRect.y + 1, this.activeCellRect.width - 4, this.activeCellRect.height - 4);
        }
    }

    protected void drawSelectListModel(Graphics2D g) {
        g.setColor(this.table.getSelectManager().getSelectColor());
        g.fill(this.selectArea);
    }

    public int getStatus() {
        return this.status;
    }

    protected void setStatus(int status) {
        this.setStatus(status, -1, -1);
    }

    protected void setStatus(int status, int x, int y) {
        switch (status) {
            case -1: {
                status = 0;
                break;
            }
            case 0: {
                Cursor cursor = this.getRenderCursor(x, y);
                if (cursor == null) {
                    cursor = Cursor.getDefaultCursor();
                }
                if (cursor.equals(this.getCursor())) break;
                this.setCursor(cursor);
                break;
            }
            case 1: {
                this.setCursor(this.activeColWidth == 0 ? ResourceManager.getCustomCursor(this, "column_split.gif") : ResourceManager.getCustomCursor(this, "column_move.gif"));
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.setCursor(this.activeRowHeight == 0 ? ResourceManager.getCustomCursor(this, "row_split.gif") : ResourceManager.getCustomCursor(this, "row_move.gif"));
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.setCursor(Cursor.getPredefinedCursor(13));
                break;
            }
        }
        this.status = status;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        this.table.hideCellDetailInfo();
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.isControlDown() && this.viewType == 1) {
                KDTCellPosition p = this.getCellPosition2(x, y);
                if (p.rowIndex == -1 || p.colIndex == -1) {
                    return;
                }
                this.table.showCellDetailInfo(p.rowIndex, p.colIndex);
                this.setStatus(0, x, y);
                return;
            }
            if (this.isAboveRightBorder(x)) {
                int colCount = this.table.getColumnCount();
                for (int i = 0; i < colCount; ++i) {
                    if (this.table.getColumn(i).getStyleAttributes().isHided()) continue;
                    KDTableHelper.autoFitColumnWidth(this.table, i);
                }
                this.setStatus(0, x, y);
                return;
            }
            if (this.isAboveBottomBorder(y)) {
                int rowCount = this.table.getBody().size();
                for (int i = 0; i < rowCount; ++i) {
                    boolean flag = false;
                    IRow row = this.table.getRow2(i);
                    boolean bl = row == null ? false : (flag = !row.getStyleAttributes().isHided());
                    if (!flag) continue;
                    KDTableHelper.autoFitRowHeight(this.table, i, 2, this.viewType == 2);
                }
                this.setStatus(0, x, y);
                return;
            }
        }
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.rowIndex == -1 || p.colIndex == -1) {
            return;
        }
        if (e.getButton() == 1) {
            this.startEditing(e, p.rowIndex, p.colIndex);
        }
        this.fireCellClick(e, p.rowIndex, p.colIndex);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.table.getEditManager().isEditing() && 0 != this.table.getEditManager().stopEditing()) {
            return;
        }
        if (!this.table.isFocusOwner()) {
            this.table.requestFocusInWindow();
        }
        if (e.getButton() == 1 || e.getButton() == 3) {
            int x = e.getX();
            int y = e.getY();
            if (this.status == 5) {
                this.status = 0;
            }
            switch (this.status) {
                case 0: {
                    KDTCellPosition p = this.getCellPosition2(x, y);
                    if (p.rowIndex == -1 || p.colIndex == -1 || e.getButton() == 3 && this.table.getSelectManager().isCellSelected(p.rowIndex, p.colIndex)) break;
                    this.selectBegin(p.rowIndex, p.colIndex, e.isControlDown(), e.isShiftDown());
                    break;
                }
                case 1: {
                    this.colResizeBegin();
                    break;
                }
                case 3: {
                    this.rowResizeBegin();
                    break;
                }
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.status) {
            case 5: {
                this.selectEnd();
                break;
            }
            case 2: {
                this.colResizeEnd();
                break;
            }
            case 4: {
                this.rowResizeEnd();
                break;
            }
        }
        if (this.isAboveBottomBorder(y)) {
            this.setStatus(3);
        } else if (this.isAboveRightBorder(x)) {
            this.setStatus(1);
        } else {
            this.setStatus(0, x, y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.status) {
            case 2: {
                this.colResizeing(x);
                this.table.reLayoutAndPaint();
                break;
            }
            case 4: {
                this.rowResizing(y);
                this.table.reLayoutAndPaint();
                break;
            }
            case 5: {
                this.selecting(x, y);
                break;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        switch (this.status) {
            case 0: {
                if (this.isAboveBottomBorder(y)) {
                    this.setStatus(3);
                    break;
                }
                if (this.isAboveRightBorder(x)) {
                    this.setStatus(1);
                    break;
                }
                this.setStatus(0, x, y);
                break;
            }
            case 1: {
                if (x - this.activeColRight < 2 && x - this.activeColRight > -2) break;
                this.setStatus(0, x, y);
                break;
            }
            case 3: {
                if (y - this.activeRowBottom < 2 && y - this.activeRowBottom > -2) break;
                this.setStatus(0, x, y);
                break;
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doScrollAndSelect(this.dragScrollX, this.dragScrollY);
    }

    public int doScrollAndSelect(int x, int y) {
        KDTSelectBlock sb;
        KDTVertical vertical;
        int vIndex;
        KDTHorizon horizon;
        int hIndex;
        int returnValue = 0;
        Rectangle rect = this.getBounds();
        if (x > rect.width) {
            hIndex = this.table.getViewManager().getHorizonIndex(this.getIndex());
            horizon = this.table.getLayoutManager().getHorizon(hIndex);
            if (horizon.getLast() < this.table.getColumnCount() - 1) {
                horizon.scrollToNextUnit();
                this.rightCol = horizon.getLast();
                x = rect.width - 2;
                returnValue = 1;
            }
        }
        if (x < 0) {
            hIndex = this.table.getViewManager().getHorizonIndex(this.getIndex());
            horizon = this.table.getLayoutManager().getHorizon(hIndex);
            horizon.scrollToPrevUnit();
            this.rightCol = horizon.getLast();
            x = 2;
            returnValue = 1;
        }
        if (y > rect.height) {
            vIndex = this.table.getViewManager().getVerticalIndex(this.getIndex());
            vertical = this.table.getLayoutManager().getVertical(vIndex);
            vertical.scrollToNextUnit();
            this.bottomRow = vertical.getLast();
            y = rect.height - 2;
            returnValue = 1;
        }
        if (y < 0) {
            vIndex = this.table.getViewManager().getVerticalIndex(this.getIndex());
            vertical = this.table.getLayoutManager().getVertical(vIndex);
            vertical.scrollToPrevUnit();
            this.bottomRow = vertical.getLast();
            y = 2;
            returnValue = 1;
        }
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.colIndex == -1) {
            p.colIndex = this.rightCol;
        }
        if (p.rowIndex == -1) {
            p.rowIndex = this.bottomRow;
        }
        if ((sb = this.table.getSelectManager().getOrigin()) != null) {
            sb.setBottom(p.rowIndex);
            sb.setRight(p.colIndex);
        }
        this.table.repaint();
        return returnValue;
    }

    protected void fireCellClick(MouseEvent e, int rowIndex, int colIndex) {
        KDTMouseEvent mouseEvent = new KDTMouseEvent(this.table, e, rowIndex, colIndex, 1);
        this.table.fireTableClick(mouseEvent);
    }

    protected void startEditing(MouseEvent e, int rowIndex, int colIndex) {
        if (!this.table.getEditManager().isEditing()) {
            this.table.getEditManager().editCellAt(rowIndex, colIndex, e);
        }
    }

    protected void selectBegin(int rowIndex, int colIndex, boolean isCtrl, boolean isShift) {
        this.setStatus(5);
        KDTSelectManager sm = this.table.getSelectManager();
        sm.setActiveViewIndex(this.getIndex());
        int mode = sm.getCellSelectMode();
        this.doSelect(rowIndex, colIndex, mode, isCtrl, isShift);
    }

    protected void selecting(int x, int y) {
        if (this.table.getSelectManager().isMultipleSelectable()) {
            if (this.timer.isRunning()) {
                this.timer.stop();
            }
            if (this.doScrollAndSelect(x, y) == 1) {
                this.dragScrollX = x;
                this.dragScrollY = y;
                this.timer.start();
            }
        }
    }

    protected void selectEnd() {
        if (this.timer.isRunning()) {
            this.timer.stop();
        }
        this.table.getSelectManager().fireTableSelectChanged(new KDTSelectEvent(this.table, this.table.getSelectManager().getPrevBlock(), this.table.getSelectManager().get()));
    }

    protected void doSelect(int rowIndex, int colIndex, int mode, boolean isCtrl, boolean isShift) {
        KDTSelectManager sm = this.table.getSelectManager();
        if (isShift) {
            if (sm.isMultipleSelectable()) {
                KDTSelectBlock sbOld = sm.getOrigin();
                KDTSelectBlock sb = new KDTSelectBlock();
                sb.setBottom(rowIndex);
                sb.setRight(colIndex);
                sb.setMode(mode);
                if (sbOld == null) {
                    sb.setTop(rowIndex);
                    sb.setLeft(colIndex);
                    sm.select(sb, false);
                } else {
                    sb.setTop(sbOld.getBeginRow());
                    sb.setLeft(sbOld.getBeginCol());
                    sm.set(sm.size() - 1, sb, false);
                }
            }
        } else if (sm.isCtrlKeyDown() || isCtrl) {
            if (sm.isMultipleSelectable()) {
                KDTSelectBlock sb = new KDTSelectBlock();
                this.setBlock(sb, rowIndex, colIndex, mode);
                sb.setTable(this.table);
                if (sm.isBlockContained(sb) && (mode == 2 || mode == 4)) {
                    sm.unselect(sb, false);
                    if (sm.toRange().size() == 0) {
                        sm.setPrevBlock(sb);
                    }
                    return;
                }
                sm.add(sb, false);
            }
        } else {
            KDTSelectBlock sb = new KDTSelectBlock();
            this.setBlock(sb, rowIndex, colIndex, mode);
            sm.select(sb, false);
        }
    }

    private void setBlock(KDTSelectBlock sb, int rowIndex, int colIndex, int mode) {
        sb.setTop(rowIndex);
        sb.setLeft(colIndex);
        if (mode == 4) {
            sb.setBottom(this.table.getRowCount() - 1);
        } else {
            sb.setBottom(rowIndex);
        }
        if (mode == 2) {
            sb.setRight(this.table.getColumnCount() - 1);
        } else {
            sb.setRight(colIndex);
        }
        sb.setMode(mode);
    }

    protected boolean isAboveBottomBorder(int y) {
        return false;
    }

    protected boolean isAboveRightBorder(int x) {
        return false;
    }

    protected void colResizeBegin() {
        this.colResizeEvent.setIndex(this.activeCol);
        this.colResizeEvent.setType(1);
        this.colResizeEvent.setOldValue(this.columns.getColumnWidth(this.activeCol));
        this.setStatus(2);
    }

    protected void colResizeing(int x) {
        int activeColWidth2 = x - this.activeColRight + this.activeColWidth;
        if (activeColWidth2 < 0) {
            activeColWidth2 = 0;
        }
        KDTColumn resizeColumn = this.columns.getColumn(this.activeCol);
        int oldWidth = this.columns.getColumnWidth(this.activeCol);
        resizeColumn.setWidth(activeColWidth2);
        int newWidth = activeColWidth2;
        int delta = oldWidth - newWidth;
        this.accommodateDelta(this.activeCol, delta);
    }

    @Override
    public void setWidthsFromPreferredWidths(boolean inverse) {
        int totalWidth = this.getWidth();
        int totalPreferred = this.getPreferredSize().width;
        int target = !inverse ? totalWidth : totalPreferred;
        Resizable3 r = new Resizable3(){

            @Override
            public int getElementCount() {
                return KDTView.this.columns.size();
            }

            @Override
            public int getLowerBoundAt(int i) {
                return 0;
            }

            @Override
            public int getUpperBoundAt(int i) {
                return Integer.MAX_VALUE;
            }

            @Override
            public int getMidPointAt(int i) {
                return KDTView.this.columns.getColumnWidth(i);
            }

            @Override
            public void setSizeAt(int s, int i) {
                KDTView.this.columns.getColumn(i).setWidth(s);
            }
        };
        this.adjustSizes((long)target, r, inverse);
    }

    @Override
    public void accommodateDelta(int resizingColumnIndex, int delta) {
        int autoResizeMode = this.table.getColumnsAutoResizeMode();
        if (autoResizeMode == 0 || this.table.getViewManager().isFreeze()) {
            return;
        }
        int columnCount = this.table.getColumnCount();
        int from = resizingColumnIndex;
        int to = columnCount;
        switch (autoResizeMode) {
            case 1: {
                to = Math.min(++from + 1, columnCount);
                break;
            }
            case 2: {
                ++from;
                to = columnCount;
                break;
            }
            case 3: {
                from = columnCount - 1;
                to = from + 1;
                break;
            }
            case 4: {
                from = 0;
                to = columnCount;
                break;
            }
            default: {
                return;
            }
        }
        final int start = from;
        final int end = to;
        final KDTColumns cm = this.columns;
        Resizable3 r = new Resizable3(){

            @Override
            public int getElementCount() {
                return end - start;
            }

            @Override
            public int getLowerBoundAt(int i) {
                return 0;
            }

            @Override
            public int getUpperBoundAt(int i) {
                return Integer.MAX_VALUE;
            }

            @Override
            public int getMidPointAt(int i) {
                return KDTView.this.columns.getColumnWidth(i + start);
            }

            @Override
            public void setSizeAt(int s, int i) {
                cm.getColumn(i + start).setWidth(s);
            }
        };
        int totalWidth = 0;
        for (int i = from; i < to; ++i) {
            int input = this.columns.getColumnWidth(i);
            totalWidth += input;
        }
        this.adjustSizes((long)(totalWidth + delta), r, false);
        delta = this.getWidth() - this.columns.getWidth();
        if (delta != 0) {
            KDTColumn col = this.columns.getColumn(this.activeCol);
            int w = this.columns.getColumnWidth(this.activeCol);
            col.setWidth(w + delta);
        }
    }

    private void adjustSizes(long target, final Resizable3 r, boolean inverse) {
        int N = r.getElementCount();
        long totalPreferred = 0L;
        for (int i = 0; i < N; ++i) {
            totalPreferred += (long)r.getMidPointAt(i);
        }
        Resizable2 s = target < totalPreferred == !inverse ? new Resizable2(){

            @Override
            public int getElementCount() {
                return r.getElementCount();
            }

            @Override
            public int getLowerBoundAt(int i) {
                return r.getLowerBoundAt(i);
            }

            @Override
            public int getUpperBoundAt(int i) {
                return r.getMidPointAt(i);
            }

            @Override
            public void setSizeAt(int newSize, int i) {
                r.setSizeAt(newSize, i);
            }
        } : new Resizable2(){

            @Override
            public int getElementCount() {
                return r.getElementCount();
            }

            @Override
            public int getLowerBoundAt(int i) {
                return r.getMidPointAt(i);
            }

            @Override
            public int getUpperBoundAt(int i) {
                return r.getUpperBoundAt(i);
            }

            @Override
            public void setSizeAt(int newSize, int i) {
                r.setSizeAt(newSize, i);
            }
        };
        this.adjustSizes(target, s, !inverse);
    }

    private void adjustSizes(long target, Resizable2 r, boolean limitToRange) {
        int i;
        long totalLowerBound = 0L;
        long totalUpperBound = 0L;
        for (i = 0; i < r.getElementCount(); ++i) {
            totalLowerBound += (long)r.getLowerBoundAt(i);
            totalUpperBound += (long)r.getUpperBoundAt(i);
        }
        if (limitToRange) {
            target = Math.min(Math.max(totalLowerBound, target), totalUpperBound);
        }
        for (i = 0; i < r.getElementCount(); ++i) {
            int newSize;
            int lowerBound = r.getLowerBoundAt(i);
            int upperBound = r.getUpperBoundAt(i);
            if (totalLowerBound == totalUpperBound) {
                newSize = lowerBound;
            } else {
                double f = (double)(target - totalLowerBound) / (double)(totalUpperBound - totalLowerBound);
                newSize = (int)Math.round((double)lowerBound + f * (double)(upperBound - lowerBound));
            }
            r.setSizeAt(newSize, i);
            target -= (long)newSize;
            totalLowerBound -= (long)lowerBound;
            totalUpperBound -= (long)upperBound;
        }
    }

    protected void colResizeEnd() {
        this.colResizeEvent.setNewValue(this.columns.getColumnWidth(this.activeCol));
        this.table.fireTableColumnResize(this.colResizeEvent);
    }

    protected void rowResizeBegin() {
        this.rowResizeEvent.setIndex(this.activeRow);
        this.rowResizeEvent.setType(this.activeRowType);
        this.rowResizeEvent.setOldValue(this.table.getBody().getRowHeight(this.activeRow));
        this.setStatus(4);
    }

    protected void rowResizing(int y) {
        int activeRowHeight2 = y - this.activeRowBottom + this.activeRowHeight;
        if (activeRowHeight2 < 0) {
            activeRowHeight2 = 0;
        }
        if (this.activeRowType == 0) {
            if (y >= this.table.getHeight() - 17 - 3) {
                return;
            }
            if (this.activeRow == 0 && activeRowHeight2 <= 0) {
                activeRowHeight2 = 1;
            }
            this.table.getHead().setRowHeight(this.activeRow, activeRowHeight2);
        } else {
            this.table.getBody().setRowHeight(this.activeRow, activeRowHeight2);
        }
    }

    protected void rowResizeEnd() {
        int rowH;
        if (this.viewType == 1 || this.viewType == 3) {
            rowH = this.table.getBody().getRowHeight(this.activeRow);
            if (this.table.getRowsAutoResizeMode() == 5) {
                this.table.getBody().setRowHeight(this.activeRow, -1);
                this.table.setDefaultRowHeight(rowH);
                this.table.reLayoutAndPaint();
            }
        } else {
            rowH = this.table.getHead().getRowHeight(this.activeRow);
        }
        this.rowResizeEvent.setNewValue(rowH);
        this.table.fireTableRowResize(this.rowResizeEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.table == null || event == null) {
            return;
        }
        int index = this.table.getSelectManager().getActiveViewIndex();
        index = this.table.getViewManager().getVerticalIndex(index);
        KDTVertical ver = this.table.getLayoutManager().getVertical(index);
        if (ver != null) {
            ver.onMouseWheelMoved(event);
        }
    }

    public void fillBackground(Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(x, y, width, height);
        g.setColor(oldColor);
    }

    @Override
    public void scroll(IBlock oldPage, IBlock newPage) {
        int orientation = 0;
        int oTop = oldPage.getTop();
        int oLeft = oldPage.getLeft();
        int oBottom = oldPage.getBottom();
        int oRight = oldPage.getRight();
        int nTop = newPage.getTop();
        int nLeft = newPage.getLeft();
        int nBottom = newPage.getBottom();
        int nRight = newPage.getRight();
        if (oTop < nTop) {
            orientation |= 4;
        }
        if (oTop > nTop) {
            orientation |= 1;
        }
        if (oLeft < nLeft) {
            orientation |= 8;
        }
        if (oLeft > nLeft) {
            orientation |= 2;
        }
        if (orientation == 1) {
            int ox = 0;
            int ow = this.columns.getWidth(oLeft, oRight);
            int oy = this.rows.getHeight(nTop, oTop - 1);
            int oh = this.rows.getHeight(oTop, oBottom);
            Graphics2D g = (Graphics2D)this.getGraphics();
            g.copyArea(ox, 0, ow, oh, ox, oy);
            this.updateBounds(nTop, nLeft, nBottom, nRight);
            this.drawCells(g, nTop, oLeft, oTop - 1, oRight, 0, 0);
        } else if (orientation == 2) {
            int ox = this.columns.getWidth(nLeft, oLeft - 1);
            int ow = this.columns.getWidth(oLeft, oRight);
            int oy = 0;
            int oh = this.rows.getHeight(oTop, oBottom);
            Graphics2D g = (Graphics2D)this.getGraphics();
            g.copyArea(0, oy, ow, oh, ox, oy);
            this.updateBounds(nTop, nLeft, nBottom, nRight);
            this.drawCells(g, oTop, nLeft, oBottom, oLeft - 1, 0, 0);
        } else if (orientation == 4) {
            int wLast;
            int last;
            if ((oldPage.getMode() & 1) == 1) {
                last = oBottom;
                wLast = 0;
            } else {
                last = oBottom - 1;
                wLast = this.rows.getRowHeight(oBottom);
            }
            int ox = 0;
            int oy = this.rows.getHeight(oTop, nTop - 1);
            int ow = this.columns.getWidth(oLeft, oRight);
            int oh = this.rows.getHeight(nTop, last);
            Graphics2D g = (Graphics2D)this.getGraphics();
            g.copyArea(ox, oy, ow, oh, -ox, -oy);
            this.updateBounds(nTop, nLeft, nBottom, nRight);
            this.drawCells(g, last + 1, oLeft, nBottom, oRight, 0, oh);
            int fixHeight = this.rows.getHeight(last + 1, nBottom);
            oy = oy - fixHeight + wLast;
            if (oy > 0) {
                this.fillBackground(g, 0, oh + fixHeight, ow, oy);
            }
        } else if (orientation == 8) {
            int wLast;
            int last;
            if ((oldPage.getMode() & 1) == 1) {
                last = oRight;
                wLast = 0;
            } else {
                last = oRight - 1;
                wLast = this.columns.getColumnWidth(oRight);
            }
            int ox = this.columns.getWidth(oLeft, nLeft - 1);
            int oy = 0;
            int ow = this.columns.getWidth(nLeft, last);
            int oh = this.rows.getHeight(oTop, oBottom);
            Graphics2D g = (Graphics2D)this.getGraphics();
            g.copyArea(ox, oy, ow, oh, -ox, -oy);
            this.updateBounds(nTop, nLeft, nBottom, nRight);
            this.drawCells(g, oTop, last + 1, oBottom, nRight, ow, 0);
            int fixWidth = this.columns.getWidth(last + 1, nRight);
            ox = ox - fixWidth + wLast;
            if (ox > 0) {
                this.fillBackground(g, ow + fixWidth, 0, ox, oh);
            }
        } else if (orientation == 3 || orientation == 9 || orientation == 6 || orientation == 12) {
            // empty if block
        }
    }

    @Override
    public int getActiveHeight() {
        return this.rows.getHeight(this.topRow, this.bottomRow);
    }

    @Override
    public int getActiveWidth() {
        return this.columns.getWidth(this.leftCol, this.rightCol);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        KDTCellPosition p = this.getCellPosition2(x, y);
        if (p.rowIndex == -1 || p.colIndex == -1) {
            return null;
        }
        int r = p.rowIndex;
        int c = p.colIndex;
        Object value = this.table.getCell(r, c).getValue();
        return value == null ? null : value.toString();
    }

    protected IBasicRender getCellRender(int rowIndex, int colIndex) {
        return this.table.getCellRenderer(rowIndex, colIndex);
    }

    private Cursor getRenderCursor(int x, int y) {
        ICursorProvider cp = this.getCursorProvider(x, y);
        if (cp != null) {
            return cp.getCursor();
        }
        return null;
    }

    private ICursorProvider getCursorProvider(int x, int y) {
        if (x == -1 || y == -1) {
            return null;
        }
        KDTCellPosition p = this.getCellPosition2(x, y);
        int r = p.rowIndex;
        int c = p.colIndex;
        if (r == -1 || c == -1) {
            return null;
        }
        IBasicRender render = null;
        if (this.viewType == 1) {
            render = this.table.getCellRenderer(r, c);
        } else if (this.viewType == 2) {
            render = this.table.getHeadCellRenderer(r, c);
        }
        if (render instanceof ICursorProvider) {
            return (ICursorProvider)render;
        }
        return null;
    }

    private static interface Resizable3
    extends Resizable2 {
        public int getMidPointAt(int var1);
    }

    private static interface Resizable2 {
        public int getElementCount();

        public int getLowerBoundAt(int var1);

        public int getUpperBoundAt(int var1);

        public void setSizeAt(int var1, int var2);
    }
}

