/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.table.DefaultProgressImpl;
import com.kingdee.cosmic.ctrl.kdf.table.ProgramElement;
import com.kingdee.cosmic.ctrl.kdf.table.ProgramListCellRender;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import org.apache.log4j.Logger;

class ProgramList
extends JList {
    private static final Logger logger = LogUtil.getPackageLogger(ProgramList.class);
    Hashtable table = new Hashtable();
    public static final long serialVersionUID = 0L;
    int index = 0;

    ProgramList() {
        this.setModel(new DefaultListModel());
        this.setCellRenderer(new ProgramListCellRender());
        this.setSelectionBackground(Color.blue);
        this.setSelectionForeground(Color.white);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
    }

    public void addElement(ProgramElement element) {
        this.table.put(element.getName(), element);
        ((DefaultListModel)this.getModel()).addElement(element.getName());
        ((DefaultListModel)this.getModel()).addElement(element.getBindProgress());
    }

    public void removeAllElement() {
        ArrayList list = new ArrayList();
        Iterator iter = this.table.keySet().iterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            ProgramElement ele = (ProgramElement)this.table.remove(list.get(i));
            ((DefaultListModel)this.getModel()).removeElement(ele.getName());
            ((DefaultListModel)this.getModel()).removeElement((Object)ele.getBindProgress());
        }
    }

    public ProgramElement getElementByName(Object key) {
        return (ProgramElement)this.table.get(key);
    }

    void stopTask(Object key, String absoluteFilePath) {
        ProgramElement ele = this.getElementByName(key);
        if (ele != null) {
            ele.setStatus(DefaultProgressImpl.getComplete());
            ele.setAbsoluteFilePath(absoluteFilePath);
            ele.getBindProgress().stop();
            ele.getBindProgress().setValue(100);
        }
    }

    void startTask(Object key) {
        ProgramElement ele = this.getElementByName(key);
        if (ele != null) {
            ele.setStatus(DefaultProgressImpl.getTranslating());
            ele.setAbsoluteFilePath(null);
            ele.getBindProgress().start();
            try {
                this.scrollRectToVisible(new Rectangle(0, this.indexToLocation((int)(2 * this.index++)).y + 20, 0, 0));
                this.revalidate();
            }
            catch (Throwable ex) {
                logger.error((Object)"err", ex);
            }
        }
    }
}

