/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.SAXBasicTableHandler;
import com.kingdee.cosmic.ctrl.kdf.table.SAXColumnGroupHandler;
import com.kingdee.cosmic.ctrl.kdf.table.SAXRowsHandler;
import com.kingdee.cosmic.ctrl.kdf.table.SAXTableUserObjectHandler;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXInnerSheetHandler
extends SAXBasicTableHandler {
    public SAXInnerSheetHandler() {
        this.handlerMap = new HashMap();
        this.handlerMap.put("t:ColumnGroup", new SAXColumnGroupHandler());
        this.handlerMap.put("t:Head", new SAXRowsHandler());
        this.handlerMap.put("t:Body", new SAXRowsHandler());
        this.handlerMap.put("t:UserObject", new SAXTableUserObjectHandler());
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        super.endElement(namespaceURI, sName, qName);
        if ("t:ColumnGroup".equals(qName)) {
            this.currentHandler = null;
        } else if ("t:Head".equals(qName)) {
            this.currentHandler = null;
        } else if ("t:Body".equals(qName)) {
            this.currentHandler = null;
        }
        if ("t:Table".equals(qName)) {
            this.currentHandler = null;
        }
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        if ("t:Table".equals(qName)) {
            this.fillTableAttributes(this.getTable(), attrs);
        } else {
            super.startElement(namespaceURI, sName, qName, attrs);
        }
    }

    private void fillTableAttributes(KDTable objTable, Attributes attrs) {
        ShareStyleAttributes ssa;
        String attVal = attrs.getValue("t:columnWidth");
        if (!StringUtil.isEmptyString((String)attVal)) {
            objTable.setDefaultColumnWidth(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:headRowHeight")))) {
            objTable.setDefaultHeadRowHeight(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:rowHeight")))) {
            objTable.setDefaultRowHeight(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:selectMode")))) {
            objTable.getSelectManager().setSelectMode(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:mergeMode")))) {
            objTable.getMergeManager().setMergeMode(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:dataRequestMode")))) {
            objTable.getDataRequestManager().setDataRequestMode(Integer.parseInt(attVal));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:name")))) {
            objTable.setName(attVal);
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:styleID")))) {
            ssa = this.getKDF().getStyleAttributes(attVal.trim());
            objTable.setSSA(ssa);
            objTable.setStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
        if (!StringUtil.isEmptyString((String)(attVal = attrs.getValue("t:headStyleID")))) {
            ssa = this.getKDF().getStyleAttributes(attVal.trim());
            objTable.setHeadSSA(ssa);
            objTable.setHeadStyle(Styles.getStyle((ShareStyleAttributes)ssa));
        }
    }
}

