/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.SAXBasicTableHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXSelectionHandler
extends SAXBasicTableHandler {
    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        KDTSelectBlock block;
        if ("t:Block".equals(qName) && null != (block = this.parseSelectBlock(attrs))) {
            this.table.getSelectManager().add(block);
        }
    }

    private KDTSelectBlock parseSelectBlock(Attributes attrs) {
        KDTSelectBlock block = new KDTSelectBlock();
        try {
            String top = attrs.getValue("t:top");
            String right = attrs.getValue("t:right");
            String left = attrs.getValue("t:left");
            String bottom = attrs.getValue("t:bottom");
            String mode = attrs.getValue("t:mode");
            if (StringUtil.isEmptyString((String)top) || StringUtil.isEmptyString((String)right) || StringUtil.isEmptyString((String)left) || StringUtil.isEmptyString((String)bottom)) {
                throw new IllegalArgumentException(CtrlKDTableMessages.getMLS("selectionBlockParamIncomplete", "\u9009\u62e9\u5757\u53c2\u6570\u4e0d\u5b8c\u6574"));
            }
            block.setLeft(Integer.parseInt(left));
            block.setRight(Integer.parseInt(right));
            block.setTop(Integer.parseInt(top));
            block.setBottom(Integer.parseInt(bottom));
            block.setMode(Integer.parseInt(mode));
            return block;
        }
        catch (Exception err) {
            return null;
        }
    }
}

