/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.expr.CellPosition;
import com.kingdee.cosmic.ctrl.kdf.expr.Macro;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationKey;
import com.kingdee.cosmic.ctrl.kdf.expr.RelationsListener;
import com.kingdee.cosmic.ctrl.kdf.expr.Variant;
import com.kingdee.cosmic.ctrl.kdf.table.AbstractMacroProxy;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.ITableAliasParser;
import com.kingdee.cosmic.ctrl.kdf.table.IVariableParser;
import com.kingdee.cosmic.ctrl.kdf.table.KDTCell;
import com.kingdee.cosmic.ctrl.kdf.table.KDTConstant;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTScriptManager;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTCellScriptEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTCellScriptListener;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import java.util.EventListener;

public class ScriptContext
implements RelationsListener {
    protected KDTable table;
    protected ITableAliasParser aliasParser;
    protected IVariableParser variableParser;

    private static String getErrMsgCellNull() {
        return CtrlKDTableMessages.getMLS("parameterCellCannotBeNull", "\u53c2\u6570cell\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private static String getErrMsgColumnNull() {
        return CtrlKDTableMessages.getMLS("parameterColumnCannotBeNull", "\u53c2\u6570column\u4e0d\u80fd\u4e3a\u7a7a");
    }

    private static String getErrMsgRowNull() {
        return CtrlKDTableMessages.getMLS("parameterRowCannotBeNull", "\u53c2\u6570row\u4e0d\u80fd\u4e3a\u7a7a");
    }

    protected static final String getErrMsgNullParser() {
        return CtrlKDTableMessages.getMLS("setVariableParserCannotBeNull", "\u8bbe\u7f6e\u7684\u53d8\u91cf\u89e3\u6790\u5668\u4e0d\u53ef\u4e3anull");
    }

    public ScriptContext(KDTable table) {
        this.table = table;
        this.prepare(this.table, null);
    }

    void setVariableParser(IVariableParser variableParser) {
        if (variableParser == null) {
            throw new IllegalArgumentException(ScriptContext.getErrMsgNullParser());
        }
        this.variableParser = variableParser;
    }

    IVariableParser getVariableParser() {
        return this.variableParser;
    }

    public boolean intepretedComplete(boolean succeed, RelationKey key, Macro m) {
        if (key.getIndex() instanceof CellPosition) {
            Variant varValuableInstance = Variant.getNewEmptyVariant();
            this.queryInstance(key, key, varValuableInstance);
            if (succeed) {
                Variant var = m.getVariableValue("$Value");
                if (var != null) {
                    ((MacroCellProxy)varValuableInstance.getValue()).setValue(var.getValue());
                    this.table.repaint();
                }
            } else {
                this.table.getScriptManager().getErrorHandler().handle(this.table, (Exception)m.getSyntaxError(), (CellPosition)key.getIndex(), null, m.getErrorPos());
            }
            this.fireCellScriptEndEvent((CellPosition)key.getIndex());
        }
        return true;
    }

    public boolean formulaChanged(RelationKey key, String newFormula) {
        if (key.getIndex() instanceof CellPosition) {
            CellPosition cpos = (CellPosition)key.getIndex();
            if (key.getRelationsListener() instanceof ScriptContext) {
                KDTCell cell;
                ScriptContext context = (ScriptContext)key.getRelationsListener();
                KDTRow row = context.getTable().getBody().getRow(cpos.row);
                if (row != null && (cell = row.getCell(cpos.col)) != null) {
                    cell.setExpressions(newFormula);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean preIntepreted(RelationKey key) {
        if (key.getIndex() instanceof CellPosition) {
            this.fireCellScriptBeginEvent((CellPosition)key.getIndex());
            this.prepare(this.table, (CellPosition)key.getIndex());
        }
        return true;
    }

    private void fireCellScriptBeginEvent(CellPosition pos) {
        ICell cell = this.table.getRow(pos.row).getCell(pos.col, false);
        Object value = null;
        if (cell != null) {
            value = cell.getValue();
        }
        KDTCellScriptEvent evt = new KDTCellScriptEvent(this, value, this.table, pos.row, pos.col);
        EventListener[] listeners = this.table.getScriptManager().getMacroListenerList().getListeners(KDTCellScriptListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((KDTCellScriptListener)listeners[i]).cellScriptEnd(evt);
        }
    }

    private void fireCellScriptEndEvent(CellPosition pos) {
        ICell cell = this.table.getRow(pos.row).getCell(pos.col, false);
        Object value = null;
        if (cell != null) {
            value = cell.getValue();
        }
        KDTCellScriptEvent evt = new KDTCellScriptEvent(this, value, this.table, pos.row, pos.col);
        EventListener[] listeners = this.table.getScriptManager().getMacroListenerList().getListeners(KDTCellScriptListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            ((KDTCellScriptListener)listeners[i]).cellScriptBegin(evt);
        }
    }

    protected void prepare(KDTable table, CellPosition pos) {
    }

    public boolean queryFormula(RelationKey key, Variant varFormula) {
        if (key.getIndex() instanceof CellPosition) {
            CellPosition cpos = (CellPosition)key.getIndex();
            if (key.getRelationsListener() instanceof ScriptContext) {
                String formula;
                ScriptContext context = (ScriptContext)key.getRelationsListener();
                if (key.getProperty() == null && !StringUtil.isEmptyString((String)(formula = context.getTable().getScriptManager().getFormulaBubble(cpos.row, cpos.col)))) {
                    varFormula.setObject((Object)formula, 11);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean queryInstance(RelationKey key, RelationKey keyPos, Variant varInstance) {
        Object index = key.getIndex();
        if (index instanceof CellPosition) {
            if (key.getRelationsListener() instanceof ScriptContext) {
                CellPosition cp = (CellPosition)index;
                varInstance.setObject((Object)this.createCellProxy(cp.row, cp.col), 17);
                return true;
            }
            return false;
        }
        return key.getRelationsListener().queryVariable(keyPos, index.toString(), null, varInstance);
    }

    private Object getLocalVariable(RelationKey key, String name) {
        Object retValue = null;
        Object index = key.getIndex();
        if (index instanceof CellPosition) {
            CellPosition cp = (CellPosition)index;
            CellPosition cp0 = KDTScriptManager.getOutterPosition(cp);
            if (name.equalsIgnoreCase("cell")) {
                retValue = this.createCellProxy(cp.row, cp.col);
            } else if (name.equalsIgnoreCase("row")) {
                retValue = this.createRowProxy(cp.row);
            } else if (name.equalsIgnoreCase("column")) {
                retValue = this.createColIndex(cp.col);
            } else if (name.equalsIgnoreCase("ROW_INDEX")) {
                retValue = this.createRowIndex(cp0.row);
            } else if (name.equalsIgnoreCase("COLUMN_INDEX")) {
                retValue = this.createColIndex(cp0.col);
            } else if (name.equalsIgnoreCase("table")) {
                retValue = this.createTableProxy();
            }
        }
        return retValue;
    }

    public boolean queryRelationsListener(String listenerName, Variant varInstance) {
        if (this.getAliasParser() == null) {
            return false;
        }
        KDTable table = this.getAliasParser().parseAlias(listenerName);
        if (table == null) {
            return false;
        }
        varInstance.setObject((Object)table.getScriptContext());
        return true;
    }

    public boolean queryVariable(RelationKey key, String variableName, Variant varFormula, Variant varValue) {
        Object value = this.getLocalVariable(key, variableName);
        if (value != null) {
            varValue.setObject(value);
            return true;
        }
        KDTConstant constant = this.table.getScriptManager().getConstantManager().getKeyword(variableName);
        if (constant != null) {
            if (constant.getType() == 0) {
                varFormula.setObject(constant.getValue(), 11);
            } else {
                varValue.setObject(constant.getValue());
            }
            return true;
        }
        if (this.getVariableParser() != null) {
            return this.getVariableParser().parseVariable(variableName, varFormula, varValue);
        }
        return false;
    }

    ITableAliasParser getAliasParser() {
        return this.aliasParser;
    }

    void setAliasParser(ITableAliasParser aliasParser) {
        this.aliasParser = aliasParser;
    }

    public KDTable getTable() {
        return this.table;
    }

    public String getMethodName(String methodName) {
        return methodName;
    }

    public boolean queryValue(RelationKey key, Variant varResult) {
        if (key.getIndex() instanceof CellPosition) {
            ScriptContext sc = (ScriptContext)key.getRelationsListener();
            CellPosition cp = (CellPosition)key.getIndex();
            KDTRow row = sc.getTable().getBody().getRow(cp.row);
            if (row == null || cp.col < 0 || cp.col >= sc.getTable().getColumnCount()) {
                return false;
            }
            KDTCell cell = row.getCell(cp.col);
            Object value = null;
            if (cell != null) {
                value = cell.getValue();
            }
            if ("".equals(value)) {
                value = null;
            }
            varResult.setObject(value);
            return true;
        }
        return false;
    }

    private Integer createRowIndex(int index) {
        return index;
    }

    private Integer createColIndex(int index) {
        return index;
    }

    private MacroCellProxy createCellProxy(int rowIndex, int colIndex) {
        return new MacroCellProxy(this.table.getRow(rowIndex).getCell(colIndex));
    }

    private MacroRowProxy createRowProxy(int rowIndex) {
        return new MacroRowProxy(this.table.getRow(rowIndex));
    }

    private MacroTableProxy createTableProxy() {
        return new MacroTableProxy(this.table);
    }

    public static class MacroTableProxy
    extends AbstractMacroProxy {
        protected KDTable table;

        MacroTableProxy() {
        }

        MacroTableProxy(KDTable table) {
            this.table = table;
        }

        public Object getUserObject() {
            return this.table.getUserObject();
        }

        public String getID() {
            return this.table.getID();
        }

        @Override
        public void formatValue(String formatString) {
            this.getStyleAttributes().setNumberFormat(formatString);
        }

        @Override
        public String getFormat() {
            return this.getInnerStyle().getNumberFormat();
        }

        @Override
        Style getInnerStyle() {
            return this.table.getStyle();
        }

        @Override
        StyleAttributes getStyleAttributes() {
            return this.table.getStyleAttributes();
        }

        public KDTable getTable() {
            return this.table;
        }

        @Override
        public Object getInstance() {
            return this.table;
        }
    }

    public static class MacroRowProxy
    extends AbstractMacroProxy {
        private IRow row;

        MacroRowProxy() {
        }

        @Override
        public Object getInstance() {
            return this.row;
        }

        MacroRowProxy(IRow row) {
            this.row = row;
        }

        @Override
        public void formatValue(String formatString) {
            this.getStyleAttributes().setNumberFormat(formatString);
        }

        void setRow(IRow row) {
            if (null == row) {
                throw new IllegalArgumentException(ScriptContext.getErrMsgRowNull());
            }
            this.row = row;
        }

        IRow getRow() {
            return this.row;
        }

        @Override
        StyleAttributes getStyleAttributes() {
            return this.getRow().getStyleAttributes();
        }

        @Override
        Style getInnerStyle() {
            return this.getRow().getKDTRow().getStyle();
        }

        @Override
        public String getFormat() {
            return this.getInnerStyle().getNumberFormat();
        }
    }

    public static class MacroColumnProxy
    extends AbstractMacroProxy {
        private IColumn column;

        MacroColumnProxy() {
        }

        MacroColumnProxy(IColumn column) {
            this.column = column;
        }

        @Override
        Style getInnerStyle() {
            return this.getColumn().getKDTColumn().getStyle();
        }

        IColumn getColumn() {
            return this.column;
        }

        void setColumn(IColumn column) {
            if (null == column) {
                throw new IllegalArgumentException(ScriptContext.getErrMsgColumnNull());
            }
            this.column = column;
        }

        @Override
        public Object getInstance() {
            return this.column;
        }

        @Override
        StyleAttributes getStyleAttributes() {
            return this.getColumn().getStyleAttributes();
        }

        @Override
        public void formatValue(String formatString) {
            this.getStyleAttributes().setNumberFormat(formatString);
        }

        @Override
        public String getFormat() {
            return this.getInnerStyle().getNumberFormat();
        }
    }

    public static class MacroCellProxy
    extends AbstractMacroProxy {
        protected ICell cell;

        MacroCellProxy() {
        }

        MacroCellProxy(ICell cell) {
            this.setCell(cell);
        }

        @Override
        public void formatValue(String formatString) {
            this.getStyleAttributes().setNumberFormat(formatString);
        }

        public ICell getCell() {
            return this.cell;
        }

        @Override
        public Object getInstance() {
            return this.cell;
        }

        public void setCell(ICell cell) {
            if (null == cell) {
                throw new IllegalArgumentException(ScriptContext.getErrMsgCellNull());
            }
            this.cell = cell;
        }

        public Object getValue() {
            return this.getCell().getValue();
        }

        @Override
        StyleAttributes getStyleAttributes() {
            return this.getCell().getStyleAttributes();
        }

        public void setValue(Object value) {
            ((KDTable.XCell)this.cell).setValue2(value);
        }

        @Override
        public String getFormat() {
            return this.getInnerStyle().getNumberFormat();
        }

        @Override
        Style getInnerStyle() {
            return this.getCell().getKDTCell().getStyle();
        }
    }

    static class State {
        private Integer rowIndex;
        private Integer colIndex;
        private MacroCellProxy cell;
        private MacroRowProxy row;
        private MacroColumnProxy col;
        private MacroTableProxy table;
        private String tableAlias;

        State() {
        }

        MacroCellProxy getCell() {
            return this.cell;
        }

        void setCell(MacroCellProxy cell) {
            this.cell = cell;
        }

        MacroColumnProxy getCol() {
            return this.col;
        }

        void setCol(MacroColumnProxy col) {
            this.col = col;
        }

        Integer getColIndex() {
            return this.colIndex;
        }

        void setColIndex(Integer colIndex) {
            this.colIndex = colIndex;
        }

        MacroRowProxy getRow() {
            return this.row;
        }

        void setRow(MacroRowProxy row) {
            this.row = row;
        }

        Integer getRowIndex() {
            return this.rowIndex;
        }

        void setRowIndex(Integer rowIndex) {
            this.rowIndex = rowIndex;
        }

        MacroTableProxy getTable() {
            return this.table;
        }

        void setTable(MacroTableProxy table) {
            this.table = table;
        }

        String getTableAlias() {
            return this.tableAlias;
        }

        void setTableAlias(String tableAlias) {
            this.tableAlias = tableAlias;
        }
    }
}

