/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table;

import com.kingdee.cosmic.ctrl.kdf.table.ITipContentProvider;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class TipPanel
extends KDPanel
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -2232597878202015123L;
    private HashMap providers;

    public TipPanel() {
        this.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.updateContent(e);
        this.updatePosition(e);
        this.setVisible(true);
    }

    protected void updateContent(MouseEvent e) {
        Object obj = this.getProviders().get(e.getSource());
        if (obj instanceof ITipContentProvider) {
            ITipContentProvider pro = (ITipContentProvider)obj;
            pro.setTipContent(this, e);
        } else {
            this.removeAll();
        }
    }

    protected void updatePosition(MouseEvent e) {
        if (this.getParent() == null) {
            return;
        }
        Point pt = SwingUtilities.convertPoint((Component)e.getSource(), e.getX(), e.getY(), this.getParent());
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (pt.x + width > this.getParent().getWidth()) {
            pt.x -= width + 20;
        }
        if (pt.y + height > this.getParent().getHeight()) {
            pt.y -= height + 20;
        }
        this.setBounds(pt.x, pt.y, width, height);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setVisible(false);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.isVisible()) {
            // empty if block
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.setVisible(false);
    }

    public void addComponent(Component com, ITipContentProvider provider) {
        com.addMouseListener(this);
        com.addMouseMotionListener(this);
        this.getProviders().put(com, provider);
    }

    public ITipContentProvider removeComponent(Component com) {
        com.removeMouseListener(this);
        com.removeMouseMotionListener(this);
        return (ITipContentProvider)this.getProviders().remove(com);
    }

    public void setParentComponent(JComponent com) {
        com.add((Component)((Object)this), 0);
    }

    HashMap getProviders() {
        if (this.providers == null) {
            this.providers = new HashMap();
        }
        return this.providers;
    }
}

