/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.print;

import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.print.config.extendui.TablePageSetupModel;
import com.kingdee.cosmic.ctrl.print.config.ui.PrintConfigModel;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.cosmic.ctrl.print.printjob.table.TablePrintPagination;
import com.kingdee.cosmic.ctrl.print.ui.component.Canvas;
import com.kingdee.cosmic.ctrl.print.ui.component.DimensionFloat;
import com.kingdee.cosmic.ctrl.print.ui.component.IPainter;
import com.kingdee.cosmic.ctrl.print.ui.component.Page;

public class KDTablePagination
extends TablePrintPagination {
    KDTable table;
    ITableForPrint headSheet;

    public KDTablePagination(ITableForPrint sheet, PrintConfigModel printmode, TablePageSetupModel configmodel) {
        super(sheet, printmode, configmodel);
    }

    private void setTable(KDTable table) {
        this.table = table;
        this.headSheet.setTable((Object)table);
    }

    public Object getTable() {
        return this.table;
    }

    public void setHeadSheet(ITableForPrint sheet) {
        this.headSheet = sheet;
    }

    protected Canvas createRowIndexArea(ITableForPrint sheet, TablePrintPagination.SheetPoint pStart, TablePrintPagination.SheetPoint pEnd, int pageIndex) {
        TablePrintPagination.SheetPoint p2;
        TablePrintPagination.SheetPoint p1;
        this.setTable((KDTable)sheet.getTable());
        if (!this.configmodel.isColumnIndex()) {
            return null;
        }
        int headRowCount = this.table.getHeadRowCount();
        int maxRow = 0;
        if (headRowCount == 0 || sheet.getColumnHeaderHeight() <= 0) {
            return null;
        }
        maxRow = headRowCount - 1;
        Canvas canvas = new Canvas();
        float x = 0.0f;
        int isNeed = this.isNeedTopTitleRowORLeftTitleColumn(pageIndex);
        if (isNeed == 2 || isNeed == 3) {
            int[] indexs = this.getLeftTitleColumnsIndexs();
            p1 = new TablePrintPagination.SheetPoint(0, indexs[0]);
            p2 = new TablePrintPagination.SheetPoint(maxRow, indexs[1]);
            Canvas leftTitle = this.createPrintBody(this.headSheet, p1, p2, false, true);
            float width = (float)leftTitle.getPainterSize().getWidth();
            float height = (float)leftTitle.getPainterSize().getHeight();
            leftTitle.setPainterBounds(x, 0.0f, width, height);
            canvas.addPainter((IPainter)leftTitle);
            x += width;
        }
        p1 = new TablePrintPagination.SheetPoint(0, pStart.y);
        p2 = new TablePrintPagination.SheetPoint(maxRow, pEnd.y);
        Canvas titleRow = this.createPrintBody(this.headSheet, p1, p2, false, true);
        float width = (float)titleRow.getPainterSize().getWidth();
        float height = (float)titleRow.getPainterSize().getHeight();
        x = x > 0.0f ? x - 1.0f : 0.0f;
        titleRow.setPainterBounds(x, 0.0f, width, height);
        canvas.addPainter((IPainter)titleRow);
        canvas.setPainterSize(x += width, (float)sheet.getColumnHeaderHeight());
        int pX = 0;
        if (this.configmodel.isRowIndex()) {
            pX = sheet.getRowHeaderWidth() - 1;
        }
        canvas.setPainterLocation((float)pX, 0.0f);
        return canvas;
    }

    protected Style getColumnIndexStyle() {
        return this.table.getIndexColumn().getStyle();
    }

    protected Style getTopLeftCornerStyle() {
        return this.getColumnIndexStyle();
    }

    public Page getPage(int index, DimensionFloat rect) {
        if (this.table != null) {
            this.table.enableRepaint(false);
        }
        Page ret = super.getPage(index, rect);
        if (this.table != null) {
            this.table.enableRepaint(true);
        }
        return ret;
    }
}

