/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.print;

import com.kingdee.cosmic.ctrl.common.CtrlUIEnv;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.print.FrugalPrintManager;
import com.kingdee.cosmic.ctrl.kdf.table.print.IRequestTableData;
import com.kingdee.cosmic.ctrl.kdf.table.print.MultiPrintModel;
import com.kingdee.cosmic.ctrl.print.IConfigChangeListener;
import com.kingdee.cosmic.ctrl.swing.KDOptionPane;
import java.awt.Component;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiPrint {
    private static final Logger logger = LogUtil.getPackageLogger(MultiPrint.class);
    private MultiPrintModel model = new MultiPrintModel();
    private FrugalPrintManager printManager;
    private boolean optionPrintAll = false;

    public MultiPrint(Component parentWindow) {
        this.model.setParentWindow(parentWindow);
        this.printManager = new FrugalPrintManager(this.model);
        this.printManager.setPreviewWindowType((short)0);
        this.printManager.setParent(parentWindow);
        this.printManager.getPrinter().addConfigChangeListener((IConfigChangeListener)this.model);
    }

    public boolean showPrintOption() throws Exception {
        boolean optionSwapPage;
        int isPrintAll = KDOptionPane.showConfirmDialog((Component)this.model.getParentWindow(), (Object)CtrlKDTableMessages.getMLS("continuousPrint", "\u662f\u5426\u8fde\u7eed\u6253\u5370\uff1f"), (String)"confirm", (int)2);
        boolean bl = optionSwapPage = isPrintAll != 0;
        if (!optionSwapPage) {
            this.setFrugalPrint(true);
            this.printManager.setBlockSpace(20);
        } else {
            this.setFrugalPrint(false);
        }
        return true;
    }

    public void setFrugalPrint(boolean isFrugal) {
        this.printManager.setFrugalPrint(isFrugal);
        this.model.setFrugal(isFrugal);
    }

    public void setBlockSpace(int space) {
        this.printManager.setBlockSpace(space);
    }

    public boolean isPrintAll() {
        return this.optionPrintAll;
    }

    public void setParentComponent(Component parentWindow) {
        this.printManager.setParent(parentWindow);
    }

    public MultiPrintModel getMultiPrintModel() {
        return this.model;
    }

    public void print() {
        this.printManager.print();
    }

    public void preview() {
        this.printManager.printPreview();
    }

    public void addPrintData(String name) {
        this.getMultiPrintModel().addPrintJob(name, null);
    }

    public void addPrintData(String name, Map headVarMap) {
        this.getMultiPrintModel().addPrintJob(name, headVarMap);
    }

    public void setTable(KDTable tblMain) {
        this.getMultiPrintModel().setTable(tblMain);
    }

    public void setRequestData(IRequestTableData requestData) {
        this.getMultiPrintModel().setRequestData(requestData);
    }

    public static void main(String[] args) {
        CtrlUIEnv.setKingdeeLAF();
        final KDTable myTable = new KDTable(3, 1, 10);
        MultiPrint multiPrint = new MultiPrint(myTable);
        multiPrint.setFrugalPrint(true);
        multiPrint.setTable(myTable);
        multiPrint.addPrintData("test1");
        multiPrint.addPrintData("test2");
        multiPrint.addPrintData("test3");
        multiPrint.addPrintData("test4");
        multiPrint.addPrintData("test5");
        multiPrint.setRequestData(new IRequestTableData(){

            @Override
            public void requestTableData(String arg0) {
                for (int i = 0; i < 10; ++i) {
                    myTable.getRow(i).getCell(0).setValue(arg0);
                }
            }
        });
        try {
            multiPrint.preview();
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
    }
}

