/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.print;

import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTStyleConstants;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.print.TableUtil2;
import com.kingdee.cosmic.ctrl.kdf.table.splitrectangle.KDTableSplitRectangleInfo;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.print.printjob.table.IBlockComparator;
import com.kingdee.cosmic.ctrl.print.printjob.table.ITableForPrint;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.resource.Resources;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class TablePrintJobImp
implements ITableForPrint {
    KDTable table;

    public TablePrintJobImp(KDTable table) {
        this.table = table;
    }

    public void setTable(Object table) {
        this.table = (KDTable)table;
    }

    public int getType() {
        return 1;
    }

    public boolean isEmpty() {
        return TableUtil2.isEmpty(this.table);
    }

    public int getMaxRowIndex() {
        return TableUtil2.getMaxRowIndex(this.table);
    }

    public int getMaxColIndex() {
        return TableUtil2.getMaxColIndex(this.table);
    }

    public Iterator getSelectIterator(boolean bAscend) {
        ArrayList list = this.table.getSelectManager().getBlocks();
        ArrayList<SelectBlock> sList = new ArrayList<SelectBlock>();
        ArrayList selectRange = new ArrayList(list);
        if (this.table.getSelectManager().getSelectMode() != 15) {
            Comparator com = new Comparator(){

                public int compare(Object arg0, Object arg1) {
                    KDTSelectBlock o1 = (KDTSelectBlock)arg0;
                    KDTSelectBlock o2 = (KDTSelectBlock)arg1;
                    int row = o1.getBottom();
                    int col = o1.getRight();
                    int row2 = o2.getBottom();
                    int col2 = o2.getRight();
                    if (row < row2) {
                        return -1;
                    }
                    if (row > row2) {
                        return 1;
                    }
                    if (col < col2) {
                        return -1;
                    }
                    if (col > col2) {
                        return 1;
                    }
                    return 0;
                }
            };
            Collections.sort(selectRange, com);
            int size = selectRange.size();
            for (int i = 1; i < size; ++i) {
                KDTSelectBlock block = (KDTSelectBlock)selectRange.get(i);
                KDTSelectBlock block2 = (KDTSelectBlock)selectRange.get(i - 1);
                int beginRow = block2.getTop();
                int beginCol = block2.getLeft();
                int endRow = block2.getBottom();
                int endCol = block2.getRight();
                if (!block.contains(beginCol, beginRow) && !block.contains(endCol, endRow)) continue;
                beginRow = Math.min(beginRow, block.getTop());
                endRow = Math.max(endRow, block.getBottom());
                beginCol = Math.min(beginCol, block.getLeft());
                endCol = Math.max(endCol, block.getRight());
                block.setBottom(endRow);
                block.setLeft(beginCol);
                block.setTop(beginRow);
                block.setRight(endCol);
                selectRange.remove(block2);
                i = 0;
                size = selectRange.size();
            }
        }
        int length = selectRange.size();
        for (int i = 0; i < length; ++i) {
            KDTSelectBlock block = (KDTSelectBlock)selectRange.get(i);
            SelectBlock sBlock = new SelectBlock(block);
            sList.add(sBlock);
        }
        Collections.sort(sList, new IBlockComparator());
        return sList.iterator();
    }

    public int getRowHeight(int i) {
        return TableUtil2.getRowHeight(this.table, i);
    }

    public int getColumnWidth(int j) {
        return TableUtil2.getColumnWidth(this.table, j);
    }

    public Style getCellStyle(int i, int j) {
        return TableUtil2.getCellStyle(this.table, i, j);
    }

    public ITableForPrint.ICell getCell(int i, int j, boolean b) {
        Cell proxyCell = null;
        ICell cell = TableUtil2.getTableCell(this.table, i, j);
        if (cell != null) {
            proxyCell = new Cell(cell);
        }
        return proxyCell;
    }

    public Style getVirtualCellStyle(int row, int col, Styles.Dir dir) {
        return null;
    }

    public Rectangle2D getCellRect(int x, int y, boolean b) {
        return null;
    }

    public Rectangle2D getBlockRect(ITableForPrint.IBlock mergeBlock, boolean b) {
        return null;
    }

    public int getRowHeaderWidth() {
        return this.table.getIndexColumn().getWidth();
    }

    public int getColumnHeaderHeight() {
        return this.table.getHead().getHeight() + 1;
    }

    public int getColumnSpacing() {
        return 1;
    }

    public int getRowSpacing() {
        return 1;
    }

    public int getRowSpacing(int index) {
        IRow row = null;
        row = index >= this.table.getRowCount() && this.table.isHasFoot() ? this.table.getFootRow(index - this.table.getRowCount()) : this.table.getRow2(index);
        if (row != null && row.getStyleAttributes().isHided()) {
            return 0;
        }
        return this.getRowSpacing();
    }

    public int getColumnSpacing(int index) {
        IColumn col = this.table.getColumn(index);
        if (col != null && col.getStyleAttributes().isHided()) {
            return 0;
        }
        return this.getColumnSpacing();
    }

    public String getColumnName(int colIndex) {
        return this.table.getColumnKey(colIndex);
    }

    public String getName() {
        return this.table.getID();
    }

    public int getColumnIndexByName(String str) {
        return KDTableUtil.getColumnIndexByName(str);
    }

    public Object getTable() {
        return this.table;
    }

    public Color getGridColor() {
        return KDTStyleConstants.GRID_LINE_COLOR;
    }

    public boolean isHorizonGridLineVisible() {
        return this.table.isVerticalGridLineVisible();
    }

    public boolean isVerticalGridLineVisible() {
        return this.table.isHorizonGridLineVisible();
    }

    public ITableForPrint.IBlock getMergerBlock(int x, int y) {
        ICell cell = null;
        KDTMergeBlock block = null;
        int rCnt = this.table.getRowCount();
        boolean footSpecial = x >= rCnt && this.table.isHasFoot();
        ICell iCell = cell = footSpecial ? this.table.getFootRow(x - rCnt).getCell(y) : this.table.getCell(x, y);
        if (cell != null) {
            block = cell.getMergeBlock();
            if (block != null) {
                KDTMergeBlock tmpBlock = (KDTMergeBlock)block.clone();
                if (footSpecial && !block.contains(x, y)) {
                    tmpBlock.setTop(block.getTop() + rCnt);
                    tmpBlock.setBottom(block.getBottom() + rCnt);
                }
                MergBlock mrgBlock = new MergBlock(tmpBlock);
                return mrgBlock;
            }
            return null;
        }
        return null;
    }

    public void setWidth(int index, int width) {
        this.table.getColumn(index).setWidth(width);
    }

    public int getTextSpace() {
        return 2;
    }

    public int getAllColWidth() {
        return this.table.getColumns().getWidth();
    }

    public int getAllRowHeight() {
        if (this.table.getDataRequestManager().getDataRequestMode() == 0) {
            int footHeight = this.table.isHasFoot() ? this.table.getFootManager().getFoot().getHeight() : 0;
            return this.table.getBody().getHeight() + footHeight;
        }
        return 0;
    }

    public PlugablePaginationAdvice getPlugablePaginationAdvice() {
        return this.table.getPrintManager().getPlugablePaginationAdvice();
    }

    public class Cell
    implements ITableForPrint.ICell {
        ICell cell;

        public Cell(ICell cell) {
            this.cell = cell;
        }

        public ITableForPrint.IBlock getMerge() {
            MergBlock mBlock = null;
            KDTMergeBlock block = this.cell.getMergeBlock();
            if (block != null) {
                mBlock = new MergBlock(block);
            }
            return mBlock;
        }

        public String getText() {
            Object value = TablePrintJobImp.this.table.getCellDisplayValue(this.cell);
            if (value instanceof Boolean) {
                String sv = ((Boolean)value).toString();
                return Resources.getMsg((String)sv);
            }
            return TablePrintJobImp.this.table.getCellDisplayText(this.cell);
        }

        public boolean isDiagonalCell() {
            return this.cell.getValue() != null && this.cell.getValue() instanceof KDTableSplitRectangleInfo;
        }

        public Object getDiagonalHeader() {
            return this.cell.getValue();
        }

        public Object getRender() {
            return TablePrintJobImp.this.table.getCellRenderer(this.cell.getRowIndex(), this.cell.getColumnIndex());
        }

        public Object getValue() {
            return this.cell.getValue();
        }
    }

    static class SelectBlock
    implements ITableForPrint.IBlock {
        KDTSelectBlock block;
        protected int mode;

        public SelectBlock(KDTSelectBlock block) {
            this.mode = block.getMode();
            this.block = block;
        }

        public int getMode() {
            return this.mode;
        }

        public int getCol2() {
            return this.block.getRight();
        }

        public int getRow() {
            return this.block.getTop();
        }

        public int getCol() {
            return this.block.getLeft();
        }

        public int getRow2() {
            return this.block.getBottom();
        }

        public void set(int row, int col, int row2, int col2) {
            throw new UnsupportedOperationException();
        }
    }

    static class MergBlock
    implements ITableForPrint.IBlock {
        KDTMergeBlock block;
        int model;

        public MergBlock(KDTMergeBlock block) {
            this.model = block.getMode();
            this.block = block;
        }

        public int getCol2() {
            return this.block.getRight();
        }

        public int getRow() {
            return this.block.getTop();
        }

        public int getCol() {
            return this.block.getLeft();
        }

        public int getRow2() {
            return this.block.getBottom();
        }

        public void set(int row, int col, int row2, int col2) {
            throw new UnsupportedOperationException();
        }

        public int getMode() {
            return this.model;
        }

        public boolean equals(Object ablock) {
            if (ablock instanceof MergBlock) {
                ITableForPrint.IBlock block = (ITableForPrint.IBlock)ablock;
                return block.getCol() == this.getCol() && block.getCol2() == this.getCol2() && block.getRow() == this.getRow() && block.getRow2() == this.getRow2() && block.getMode() == this.getMode();
            }
            return false;
        }
    }
}

