/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.script;

import com.kingdee.cosmic.ctrl.common.ui.editor.styled.MiniScriptEditor;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.common.i18n.CtrlKDTableMessages;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.script.KDTableScript;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeLookAndFeel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.security.SecureRandom;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.apache.log4j.Logger;

public class KDTableScriptFrame
extends JFrame {
    private static final Logger logger = LogUtil.getPackageLogger(KDTableScriptFrame.class);
    private String tableName = "table";
    private KDTable tbl = new KDTable(3, 1, 10);
    private MiniScriptEditor editor = new MiniScriptEditor();
    private JTextArea outer = new JTextArea();

    public KDTableScriptFrame() {
        this.init();
    }

    private void init() {
        this.setTitle("[Test] KDTable Script");
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 100, 800, 600);
        Container p = this.getContentPane();
        p.setLayout(new BorderLayout());
        JPanel top = new JPanel();
        top.setLayout(new FlowLayout(0, 5, 5));
        this.editor.setPreferredSize(new Dimension(500, 150));
        top.add(new JScrollPane((Component)this.editor));
        JButton jbRun = new JButton(CtrlKDTableMessages.getMLS("runScript", "\u6267\u884c\u811a\u672c"));
        jbRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KDTableScriptFrame.this.runScript();
            }
        });
        top.add(jbRun);
        p.add((Component)top, "North");
        p.add((Component)this.tbl, "Center");
        this.outer.setPreferredSize(new Dimension(500, 150));
        p.add((Component)new JScrollPane(this.outer), "South");
        SecureRandom random = new SecureRandom();
        IRow row = this.tbl.getHeadRow(0);
        row.getCell(0).setValue("A");
        row.getCell(1).setValue("B");
        row.getCell(2).setValue("C");
        int n = this.tbl.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tbl.getRow(i);
            row.getCell(0).setValue("Row-" + i);
            row.getCell(1).setValue(Float.valueOf(random.nextFloat() * 1000.0f - 500.0f));
            row.getCell(2).setValue(Float.valueOf(random.nextFloat() * 100.0f));
            row.getCell(1).setValue((int)(random.nextFloat() * 1000.0f) - 500);
            row.getCell(2).setValue(Float.valueOf(random.nextFloat() * 100.0f));
        }
        PrintStream ps = new PrintStream(new ByteArrayOutputStream(){

            @Override
            public synchronized void write(byte[] b, int off, int len) {
                SwingUtilities.invokeLater(new PrintMsgRunnable(new String(b, off, len)));
            }
        });
        System.setOut(ps);
        System.setErr(ps);
        this.editor.addStyledKey(this.tableName, new Color(0x990000));
        this.editor.addStyledKey("color", new Color(0x990000));
        this.setVisible(true);
    }

    public void runScript() {
        this.outer.setText(null);
        String s = this.editor.getText().trim();
        KDTableScript ks = new KDTableScript(this.tableName, this.tbl);
        ks.putVar("color", Color.class);
        try {
            ks.exeuteScript(s);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
            JOptionPane.showMessageDialog(this, e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel((LookAndFeel)new KingdeeLookAndFeel());
        new KDTableScriptFrame();
    }

    class PrintMsgRunnable
    implements Runnable {
        String msg;

        PrintMsgRunnable(String aMsg) {
            this.msg = aMsg;
        }

        @Override
        public void run() {
            KDTableScriptFrame.this.outer.append(this.msg);
            KDTableScriptFrame.this.outer.setCaretPosition(KDTableScriptFrame.this.outer.getDocument().getLength());
        }
    }
}

