/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.undo;

import com.kingdee.cosmic.ctrl.kdf.table.KDTColumn;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRange;
import com.kingdee.cosmic.ctrl.kdf.table.KDTRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.undo.AddColEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.AddRowEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.CellsStyleEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.CutEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.DeleteEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.EditListener;
import com.kingdee.cosmic.ctrl.kdf.table.undo.RemoveColumnEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.RemoveRowEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.SplitBlockEdit;
import com.kingdee.cosmic.ctrl.kdf.table.undo.TypeEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

public class KDTableUndoManager
extends UndoManager {
    private static final long serialVersionUID = -2755543816851380261L;
    private KDTable table;
    private EditListener editListener;
    boolean isPause = false;

    public KDTableUndoManager(KDTable table2) {
        this.table = table2;
        this.setLimit(16);
        this.registerEditListerer();
    }

    public void createDeleteEdit(KDTRange range) {
        DeleteEdit deleteEdit = new DeleteEdit(this.table, range);
        this.addEdit(deleteEdit);
    }

    private void registerEditListerer() {
        this.editListener = new EditListener(this.table, this);
        this.table.addKDTEditListener(this.editListener);
    }

    public void clear() {
        this.table.removeKDTEditListener(this.editListener);
        this.discardAllEdits();
    }

    public void createTypeEdit(int rowIndex, int colIndex, Object oldValue) {
        TypeEdit typeEdit = new TypeEdit(this.table);
        typeEdit.setPosition(rowIndex, colIndex);
        typeEdit.setValue(oldValue);
        this.addEdit(typeEdit);
    }

    public void createStyleEdit(KDTSelectBlock selectBlock) {
        KDTRange range = new KDTRange();
        range.add(0, selectBlock);
        this.createStyleEdit(range);
    }

    public void createStyleEdit(KDTRange selectRange) {
        CellsStyleEdit edit = new CellsStyleEdit(this.table, selectRange);
        this.addEdit(edit);
    }

    public void createPasteEdit() {
        KDTRange range = new KDTRange();
        KDTSelectBlock block = this.table.getEditHelper().prePaste();
        range.add(0, block);
        CutEdit paseEdit = new CutEdit(this.table, range);
        this.addEdit(paseEdit);
    }

    public void createCutEdit(KDTRange range) {
        CutEdit cutEdit = new CutEdit(this.table, range);
        this.addEdit(cutEdit);
    }

    public void createSplitBlockEdit(int top, int left, int bottom, int right) {
        KDTSelectBlock block = new KDTSelectBlock(top, left, bottom, right);
        SplitBlockEdit splitEdit = new SplitBlockEdit(this.table, block);
        this.addEdit(splitEdit);
    }

    public void createAddRowEdit(int rowIndex, KDTRow row) {
        AddRowEdit rowEdit = new AddRowEdit(this.table, rowIndex, row);
        this.addEdit(rowEdit);
    }

    public void createRemoveRowEdit(int rowIndex) {
        RemoveRowEdit rowEdit = new RemoveRowEdit(this.table, rowIndex);
        this.addEdit(rowEdit);
    }

    public void createAddColEdit(int colIndex, KDTColumn column) {
        AddColEdit colEdit = new AddColEdit(this.table, colIndex, column);
        this.addEdit(colEdit);
    }

    public void createRemoveColEdit(int colIndex) {
        RemoveColumnEdit rowEdit = new RemoveColumnEdit(this.table, colIndex);
        this.addEdit(rowEdit);
    }

    @Override
    public synchronized boolean addEdit(UndoableEdit anEdit) {
        if (!this.isPause) {
            return super.addEdit(anEdit);
        }
        return false;
    }

    public void setPause(boolean isPause) {
        this.isPause = isPause;
    }

    public boolean isPause() {
        return this.isPause;
    }
}

