/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kdf.table.util;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IBlock;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IColumn;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableHeaderModel;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.swing.KDFont;
import com.kingdee.cosmic.ctrl.swing.util.CtrlFormatUtilities;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class KDTableUtil {
    public static void setTableHeader(KDTableHeaderModel mm, KDTable tbl) {
        int i;
        if (mm == null) {
            return;
        }
        String[][] data = mm.getData();
        List mergedRegionList = mm.getMergedRegionList();
        int[] freezedColumns = mm.getFreezedColumnIndexices();
        int[] hiddenColumns = mm.getHiddenColumnIndexices();
        int[] alignColumns = mm.getAlignColumns();
        String[] columnsFormat = mm.getColumnsFormat();
        int[] columnWidths = mm.getColumnWidths();
        int cols = data[0].length;
        for (i = 0; i < cols; ++i) {
            IColumn column = tbl.addColumn();
            if (columnWidths == null) continue;
            column.setWidth(columnWidths[i]);
        }
        for (i = 0; i < data.length; ++i) {
            IRow row = tbl.addHeadRow();
            for (int j = 0; j < cols; ++j) {
                row.getCell(j).setValue(data[i][j]);
            }
        }
        if (mergedRegionList != null && mergedRegionList.size() > 0) {
            for (i = 0; i < mergedRegionList.size(); ++i) {
                int[] region = (int[])mergedRegionList.get(i);
                KDTMergeBlock mb = new KDTMergeBlock();
                mb.setLeft(region[0]);
                mb.setTop(region[1]);
                mb.setRight(region[2]);
                mb.setBottom(region[3]);
                tbl.getHeadMergeManager().getMergeBlockSet().add(mb);
            }
        }
        if (columnsFormat != null) {
            for (i = 0; i < cols; ++i) {
                if (columnsFormat[i] == null) continue;
                tbl.getColumn(i).getStyleAttributes().setNumberFormat(columnsFormat[i]);
            }
        }
        if (alignColumns != null) {
            int cc = Math.min(cols, alignColumns.length);
            for (int i2 = 0; i2 < cc; ++i2) {
                Styles.HorizontalAlignment align = alignColumns[i2] == 1 ? Styles.HorizontalAlignment.CENTER : (alignColumns[i2] == 2 ? Styles.HorizontalAlignment.RIGHT : Styles.HorizontalAlignment.LEFT);
                tbl.getColumn(i2).getStyleAttributes().setHorizontalAlign(align);
            }
        }
        if (hiddenColumns != null) {
            for (i = 0; i < hiddenColumns.length; ++i) {
                tbl.getColumn(hiddenColumns[i]).getStyleAttributes().setHided(true);
            }
        }
        if (freezedColumns != null) {
            for (i = 0; i < freezedColumns.length; ++i) {
                tbl.getColumn(freezedColumns[i]).getStyleAttributes().setLocked(true);
            }
        }
    }

    public static void fillTableRow(Object[][] rowData, Object[] rowObject, int insertRowIndex, KDTable table) {
        KDTableUtil.fillToTable(rowData, rowObject, null, insertRowIndex, table);
    }

    public static void fillToTable(Object[][] data, Object[] userRowObjects, Color[] rowColors, int insertRowIndex, KDTable table) {
        if (data.length == 0) {
            return;
        }
        boolean refresh = table.isRefresh();
        table.setRefresh(false);
        int cols = table.getColumnCount();
        for (int i = 0; i < data.length; ++i) {
            IRow row = table.addRow(insertRowIndex++);
            if (userRowObjects != null) {
                row.setUserObject(userRowObjects[i]);
            }
            if (rowColors != null && rowColors[i] != null) {
                row.getStyleAttributes().setBackground(rowColors[i]);
            }
            for (int j = 0; j < cols; ++j) {
                row.getCell(j).setValue(data[i][j]);
            }
        }
        table.setRefresh(refresh);
        table.repaint();
    }

    public static int[] getSelectedRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return new int[0];
        }
        if (table.getRowCount() == 0) {
            return new int[0];
        }
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 0; i < table.getSelectManager().size(); ++i) {
            IBlock block = KDTSelectBlock.change(table, table.getSelectManager().get(i));
            for (int j = block.getTop(); j <= block.getBottom(); ++j) {
                set.add(j);
            }
        }
        int[] rows = new int[set.size()];
        Iterator iter = set.iterator();
        int k = 0;
        while (iter.hasNext()) {
            rows[k] = (Integer)iter.next();
            ++k;
        }
        return rows;
    }

    public static int getSelectedRowCount(KDTable table) {
        return KDTableUtil.getSelectedRows(table).length;
    }

    public static void setSelectedRow(KDTable table, int row) {
        table.getSelectManager().setActiveRowIndex(row);
        KDTSelectBlock block = new KDTSelectBlock();
        block.setTop(row);
        block.setBottom(row);
        block.setLeft(0);
        block.setRight(table.getColumnCount());
        block.setTable(table);
        table.getSelectManager().select(block, true);
    }

    public static IRow getSelectedRow(KDTable table) {
        return table.getRow(table.getSelectManager().getActiveRowIndex());
    }

    public static int getLastVisibleColumnIndex(KDTable table) {
        int lastIndex;
        for (lastIndex = table.getColumnCount() - 1; lastIndex >= 0 && (table.getColumn(lastIndex).getStyleAttributes().isHided() || table.getColumn(lastIndex).getWidth() <= 0); --lastIndex) {
        }
        return lastIndex;
    }

    public static int getLastVisibleRowIndex(KDTable table) {
        int lastIndex;
        for (lastIndex = table.getRowCount() - 1; lastIndex >= 0 && (table.getRow(lastIndex).getStyleAttributes().isHided() || table.getRow(lastIndex).getHeight() <= 0); --lastIndex) {
        }
        return lastIndex;
    }

    public static int getFirstVisibleRowIndex(KDTable table) {
        int firstIndex;
        int rowCount = table.getRowCount() - 1;
        for (firstIndex = 0; firstIndex < rowCount && (table.getRow(firstIndex).getStyleAttributes().isHided() || table.getRow(firstIndex).getHeight() <= 0); ++firstIndex) {
        }
        return firstIndex;
    }

    public static int getFirstVisibleColumnIndex(KDTable table) {
        int firstIndex;
        int colCount = table.getColumnCount() - 1;
        for (firstIndex = 0; firstIndex < colCount && (table.getColumn(firstIndex).getStyleAttributes().isHided() || table.getColumn(firstIndex).getWidth() <= 0); ++firstIndex) {
        }
        return firstIndex;
    }

    public int getCellTextWidth(KDTable table, int rowIndex, int colIndex) {
        ICell cell = table.getCell(rowIndex, colIndex);
        String text = table.getCellDisplayText(cell);
        Graphics2D g2d = KDTable.getBufferGraphics();
        FontRenderContext context = null;
        int width = 0;
        if (g2d != null) {
            context = g2d.getFontRenderContext();
        }
        if (!StringUtil.isEmptyString((String)text)) {
            Style style = cell.getStyle();
            KDFont font = style.getKDFont();
            Rectangle2D fontRect = font.getStringBounds(text, context);
            width = (int)fontRect.getWidth() + 6;
        }
        return width;
    }

    public static void checkInvalideSA(StyleAttributes sa) {
        String format = sa.getNumberFormat();
        if (format != null && format.startsWith("&")) {
            sa.setNumberFormat(KDTableUtil.getGlobalformat(format));
        }
    }

    private static String getGlobalformat(String fmt) {
        if (fmt != null) {
            if (fmt.equals("&int")) {
                fmt = CtrlFormatUtilities.getIntegerFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    DecimalFormat format = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
                    if (format == null) {
                        format = CtrlFormatUtilities.getDisplayNumberFormat();
                    }
                    if (format != null) {
                        format = (DecimalFormat)format.clone();
                        format.setMaximumFractionDigits(0);
                        format.setDecimalSeparatorAlwaysShown(false);
                        format.setParseIntegerOnly(true);
                        fmt = format.toPattern();
                    } else {
                        format = (DecimalFormat)NumberFormat.getIntegerInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&double")) {
                fmt = CtrlFormatUtilities.getDecimalFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    DecimalFormat format = (DecimalFormat)CtrlFormatUtilities.getDecimalFormat();
                    if (format == null) {
                        format = CtrlFormatUtilities.getDisplayNumberFormat();
                    }
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (DecimalFormat)NumberFormat.getNumberInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&currency")) {
                fmt = CtrlFormatUtilities.getCurrencyFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    DecimalFormat format = (DecimalFormat)CtrlFormatUtilities.getCurrencyFormat();
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (DecimalFormat)NumberFormat.getCurrencyInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&date")) {
                fmt = CtrlFormatUtilities.getDateFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    SimpleDateFormat format = (SimpleDateFormat)CtrlFormatUtilities.getDateFormat();
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (SimpleDateFormat)DateFormat.getDateInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&time")) {
                fmt = CtrlFormatUtilities.getTimeFormatString();
                if (StringUtil.isEmptyString((String)fmt)) {
                    SimpleDateFormat format = (SimpleDateFormat)CtrlFormatUtilities.getTimeFormat();
                    if (format != null) {
                        fmt = format.toPattern();
                    } else {
                        format = (SimpleDateFormat)DateFormat.getTimeInstance();
                        fmt = format.toPattern();
                    }
                }
            } else if (fmt.equals("&datetime") && StringUtil.isEmptyString((String)(fmt = CtrlFormatUtilities.getDateTimeFormatString()))) {
                SimpleDateFormat format = (SimpleDateFormat)CtrlFormatUtilities.getDateTimeFormat();
                if (format != null) {
                    fmt = format.toPattern();
                } else {
                    format = (SimpleDateFormat)DateFormat.getDateTimeInstance();
                    fmt = format.toPattern();
                }
            }
        }
        return fmt;
    }

    public static int getColumnIndexByName(String name) {
        int index = 0;
        char[] chars = name.toCharArray();
        int rate = 1;
        char A = 'A';
        for (int i = chars.length - 1; i >= 0; --i) {
            char bit = chars[i];
            if (bit < A || bit > 'z') {
                return -1;
            }
            index += (bit - A + 1) * rate;
            rate *= 26;
        }
        return --index;
    }
}

