/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MDContextFactory;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgSwitchFacade;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.OrgSwitchFacadeFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.org.TransportOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.org.service.OrgCommonUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.FrameWorkException;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FrameWorkUtils {
    private static final Logger logger = Logger.getLogger(FrameWorkUtils.class);
    public static final String strDataBase_Assistant = "com.kingdee.eas.basedata.assistant";
    public static final String strDataBase_Master = "com.kingdee.eas.basedata.master";
    public static final String CURRENT_COMPANY = "CurCompanyId";
    public static final String CURRENT_COMPANYINFO = "CompanyInfo";
    private static String oldSessionId = null;
    private static HashMap switchOrgMap = new HashMap();
    private static final String WIN_ID = "Windows";
    public static final String cmd = "rundll32 url.dll,FileProtocolHandler ";
    public static final String windowsXP = "Windows XP";
    public static final String windows2003 = "Windows 2003";
    public static final String windows7 = "Windows 7";
    public static final String macos = "Mac OS";

    private FrameWorkUtils() {
    }

    public static String getClassAlias(CoreBaseInfo dataBaseInfo) {
        if (dataBaseInfo == null) {
            return "";
        }
        String name = null;
        try {
            SimpleEntity entity = FrameWorkUtils.getEntity(null, dataBaseInfo.getBOSType());
            if (entity == null || entity.getAlias() == null) {
                IMetaDataPK pk = MDContextFactory.getRemoteInstance().entityMapping.getProperty(dataBaseInfo.getBOSType());
                if (pk != null) {
                    name = pk.getFullName();
                }
            } else {
                name = entity.getAlias();
            }
        }
        catch (BOSException bOSException) {
            // empty catch block
        }
        return name;
    }

    public static String getCodeRuleClient(BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        String companyID = billInfo.getCompany().getId().toString();
        return FrameWorkUtils.getCodeRuleClient(billInfo, companyID);
    }

    public static String getCodeRuleClient(CoreBillBaseInfo coreBillInfo, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)coreBillInfo, companyID) && iCodingRuleManager.isAddView((IObjectValue)coreBillInfo, companyID)) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)coreBillInfo, companyID);
        }
        return sysNumber;
    }

    public static String getCodeRuleClient(CoreBaseInfo info, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingRuleManager.isExist((IObjectValue)info, companyID) && iCodingRuleManager.isAddView((IObjectValue)info, companyID)) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)info, companyID);
        }
        return sysNumber;
    }

    public static String getCodeRuleServer(Context ctx, CoreBaseInfo info, String companyID) throws CodingRuleException, EASBizException, BOSException {
        String sysNumber = null;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        RuleStatus rStatus = iCodingRuleManager.getRuleStatus((IObjectValue)info, companyID);
        if (rStatus != null && rStatus.isExist() && !rStatus.isAddView()) {
            sysNumber = iCodingRuleManager.getNumber((IObjectValue)info, companyID);
        }
        return sysNumber;
    }

    public static FilterInfo getF7FilterInfoByAuthorizedOrg(OrgType orgType, String orgFieldName) {
        return FrameWorkUtils.getF7FilterInfoByAuthorizedOrg(orgType, orgFieldName, false);
    }

    public static FilterInfo getF7FilterInfoByAuthorizedOrg(OrgType orgType, String orgFieldName, boolean includeNull) {
        NewOrgUnitFilterInfoProducer oufip = new NewOrgUnitFilterInfoProducer(orgType);
        FilterInfo filterInfo = oufip.getFilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        int num = filterItems.size();
        for (int i = 0; i < num; ++i) {
            filterItems.get(i).setPropertyName(orgFieldName);
        }
        if (includeNull) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo(orgFieldName, null, CompareType.EQUALS));
            try {
                filter.mergeFilter(filterInfo, "OR");
            }
            catch (BOSException e) {
                return filterInfo;
            }
            return filter;
        }
        return filterInfo;
    }

    public static void switchOrg(Context ctx, String orgID) throws Exception {
        if (ctx == null) {
            ctx = new Context();
        }
        HashMap map = null;
        String sessionId = SysContext.getSysContext().getSessionID();
        if (StringUtils.equals((String)sessionId, (String)oldSessionId)) {
            map = (HashMap)switchOrgMap.get(orgID);
        } else {
            switchOrgMap.clear();
        }
        if (map == null) {
            IOrgSwitchFacade iswitch = OrgSwitchFacadeFactory.getRemoteInstance();
            map = iswitch.getSwitchOrgs(orgID);
            oldSessionId = sessionId;
            switchOrgMap.put(orgID, map);
        }
        for (OrgType orgType : OrgType.getEnumList()) {
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)map.get(orgType);
            if (!OrgCommonUtils.isBasicOrgType((OrgType)orgType)) continue;
            FrameWorkUtils.setCurrentOrgUnit(ctx, orgType, orgUnitInfo);
        }
        FullOrgUnitInfo ouInfo = (FullOrgUnitInfo)map.get("CurOU");
        FrameWorkUtils.setCurrentOrgUnit(ctx, (OrgUnitInfo)ouInfo);
    }

    public static void setCurrentTransportUnit(Context ctx, TransportOrgUnitInfo tou) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Transport, (OrgUnitInfo)tou);
    }

    public static CtrlUnitInfo getCurrentCtrlUnit(Context ctx) {
        return (CtrlUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.ControlUnit);
    }

    public static void setCurrentCtrlUnit(Context ctx, CtrlUnitInfo cu) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.ControlUnit, (OrgUnitInfo)cu);
    }

    public static CompanyOrgUnitInfo getCurrentFIUnit(Context ctx) {
        return (CompanyOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.Company);
    }

    public static void setCurrentFIUnit(Context ctx, CompanyOrgUnitInfo company) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Company, (OrgUnitInfo)company);
    }

    public static AdminOrgUnitInfo getCurrentAdminUnit(Context ctx) {
        return (AdminOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.Admin);
    }

    public static void setCurrentAdminUnit(Context ctx, AdminOrgUnitInfo adminUnit) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Admin, (OrgUnitInfo)adminUnit);
    }

    public static ProfitCenterOrgUnitInfo getCurrentProfitUnit(Context ctx) {
        return (ProfitCenterOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.ProfitCenter);
    }

    public static void setCurrentProfitUnit(Context ctx, ProfitCenterOrgUnitInfo profitCenter) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.ProfitCenter, (OrgUnitInfo)profitCenter);
    }

    public static CostCenterOrgUnitInfo getCurrentCostUnit(Context ctx) {
        return (CostCenterOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.CostCenter);
    }

    public static void setCurrentCostUnit(Context ctx, CostCenterOrgUnitInfo costCenter) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.CostCenter, (OrgUnitInfo)costCenter);
    }

    public static SaleOrgUnitInfo getCurrentSaleUnit(Context ctx) {
        return (SaleOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.Sale);
    }

    public static void setCurrentSaleUnit(Context ctx, SaleOrgUnitInfo saleUnit) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Sale, (OrgUnitInfo)saleUnit);
    }

    public static QualityOrgUnitInfo getCurrentQualityUnit(Context ctx) {
        return (QualityOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.Quality);
    }

    public static void setCurrentQualityOrgUnitUnit(Context ctx, QualityOrgUnitInfo qualityUnit) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Quality, (OrgUnitInfo)qualityUnit);
    }

    public static StorageOrgUnitInfo getCurrentStorageUnit(Context ctx) {
        return (StorageOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.Storage);
    }

    public static void setCurrentStorageUnit(Context ctx, StorageOrgUnitInfo storageUnit) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Storage, (OrgUnitInfo)storageUnit);
    }

    public static PurchaseOrgUnitInfo getCurrentPurchaseUnit(Context ctx) {
        return (PurchaseOrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.Purchase);
    }

    public static void setCurrentPurchaseUnit(Context ctx, PurchaseOrgUnitInfo purchaseUnit) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.Purchase, (OrgUnitInfo)purchaseUnit);
    }

    public static OrgUnitInfo getCurrentOrgUnit(Context ctx, OrgType orgType) {
        return (OrgUnitInfo)ctx.get((Object)orgType);
    }

    public static void setCurrentOrgUnit(Context ctx, OrgType orgType, OrgUnitInfo orgUnit) {
        ctx.put((Object)orgType, (Object)orgUnit);
        if (orgType.equals((Object)OrgType.Company)) {
            ctx.put((Object)CURRENT_COMPANYINFO, (Object)orgUnit);
            if (orgUnit != null && orgUnit.getId() != null) {
                ctx.put((Object)CURRENT_COMPANY, (Object)orgUnit.getId().toString());
            }
        }
    }

    public static OrgUnitInfo getCurrentOrgUnit(Context ctx) {
        return (OrgUnitInfo)ctx.get((Object)"CurOU");
    }

    public static void setCurrentOrgUnit(Context ctx, OrgUnitInfo orgUnit) {
        ctx.put((Object)"CurOU", (Object)orgUnit);
    }

    public static HROrgUnitInfo getCurrentHRUnit(Context ctx) {
        return (HROrgUnitInfo)FrameWorkUtils.getCurrentOrgUnit(ctx, OrgType.HRO);
    }

    public static void setCurrentHRUnit(Context ctx, HROrgUnitInfo hroInfo) {
        FrameWorkUtils.setCurrentOrgUnit(ctx, OrgType.HRO, (OrgUnitInfo)hroInfo);
    }

    public static void checkIsOUSealUp(Context ctx, BOSObjectType type, Context mainOrgContext) throws Exception {
        int orgTypeValue = 0;
        String ouID = null;
        OrgUnitInfo org = null;
        if (ctx == null) {
            orgTypeValue = FrameWorkUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            OrgType orgType = OrgType.getEnum((int)orgTypeValue);
            org = FrameWorkUtils.getCurrentOrgUnit(mainOrgContext, orgType);
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.BIZORGNOTEQUAL, new Object[]{orgType});
            }
            NewOrgUnitFacadeFactory.getRemoteInstance().checkIsOUSealUp(ouID, orgTypeValue);
        } else {
            orgTypeValue = FrameWorkUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            OrgType orgType = OrgType.getEnum((int)orgTypeValue);
            org = FrameWorkUtils.getCurrentOrgUnit(ctx, orgType);
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.BIZORGNOTEQUAL, new Object[]{orgType});
            }
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).checkIsOUSealUp(ouID, orgTypeValue);
        }
    }

    public static void checkIsOUSealUp(Context ctx, BOSObjectType type, SysContext sysContext) throws Exception {
        int orgTypeValue = 0;
        String ouID = null;
        OrgUnitInfo org = null;
        if (ctx == null) {
            orgTypeValue = FrameWorkUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            OrgType orgType = OrgType.getEnum((int)orgTypeValue);
            org = sysContext.getCurrentOrgUnit(orgType);
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.BIZORGNOTEQUAL, new Object[]{orgType});
            }
            NewOrgUnitFacadeFactory.getRemoteInstance().checkIsOUSealUp(ouID, orgTypeValue);
        } else {
            orgTypeValue = FrameWorkUtils.getOrgTypeExtendedPropertyies(ctx, type);
            if (orgTypeValue < 0) {
                return;
            }
            OrgType orgType = OrgType.getEnum((int)orgTypeValue);
            org = FrameWorkUtils.getCurrentOrgUnit(ctx, orgType);
            String string = ouID = org != null ? org.getId().toString() : null;
            if (ouID == null) {
                throw new FrameWorkException(FrameWorkException.BIZORGNOTEQUAL, new Object[]{orgType});
            }
            NewOrgUnitFacadeFactory.getLocalInstance((Context)ctx).checkIsOUSealUp(ouID, orgTypeValue);
        }
    }

    private static SimpleEntity getEntity(Context ctx, BOSObjectType type) throws BOSException {
        EntitySelect select = new EntitySelect(type);
        select.selectAttribute("alias").extendPropertySelect().select(new String[]{"OrgType"});
        if (ctx != null) {
            return MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        }
        return MetaDataAccessFactory.getRemoteInstance().select(select);
    }

    public static int getOrgTypeExtendedPropertyies(Context ctx, BOSObjectType type) throws Exception {
        OrgType orgType;
        if (type == null) {
            return -1;
        }
        int orgTypeValue = 0;
        SimpleEntity entity = FrameWorkUtils.getEntity(ctx, type);
        String orgTypeStr = (String)entity.getExtendedProperties().get("OrgType");
        if (orgTypeStr == null) {
            orgTypeStr = "NONE";
        }
        if ((orgType = OrgCommonUtils.getOrgType((String)orgTypeStr)) != null) {
            orgTypeValue = orgType.getValue();
        }
        return orgTypeValue;
    }

    public static String getOrgPropertyNameByCoreBillBaseInfo(CoreBillBaseInfo vo) throws Exception {
        String orgPropertyName = null;
        if (vo != null) {
            orgPropertyName = vo.getBizOrgPropertyName();
        }
        return orgPropertyName;
    }

    public static IObjectPK getOrgPKByCoreBillBaseInfo(CoreBillBaseInfo vo) throws Exception {
        CoreBillBaseInfo abstractObjectValue;
        String orgPropertyName = null;
        orgPropertyName = FrameWorkUtils.getOrgPropertyNameByCoreBillBaseInfo(vo);
        if (orgPropertyName == null) {
            return null;
        }
        if (vo != null && (abstractObjectValue = vo).containsKey(orgPropertyName)) {
            Object orgValue = abstractObjectValue.get(orgPropertyName);
            if (orgValue == null) {
                return null;
            }
            OrgUnitInfo orgUnitInfo = (OrgUnitInfo)orgValue;
            if (orgUnitInfo.getId() == null) {
                return null;
            }
            return new ObjectUuidPK(orgUnitInfo.getId());
        }
        return null;
    }

    public static String geti18nDecimalFormate() {
        int len;
        char dec;
        String colFormat = CtrlFormatUtilities.getDecimalFormatString();
        int idx = colFormat.indexOf(String.valueOf(dec = CtrlFormatUtilities.getDecimalFormatSymbols().getGroupingSeparator()));
        if (idx + 1 < (len = colFormat.length())) {
            colFormat = colFormat + "######";
        }
        return colFormat;
    }

    public static String getTrimFileName(String s) {
        String fileName = s.trim();
        String regEx = "\\x20+";
        fileName = FrameWorkUtils.getTrimRegFileName(regEx, "_", fileName);
        regEx = "\\+";
        fileName = FrameWorkUtils.getTrimRegFileName(regEx, "-", fileName);
        regEx = "/+";
        fileName = FrameWorkUtils.getTrimRegFileName(regEx, "-", fileName);
        return fileName;
    }

    public static String getTrimRegFileName(String regEx, String replace, String s) {
        String fileName = s.trim();
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(fileName);
        if (mat.find()) {
            fileName = mat.replaceAll(replace);
        }
        return fileName;
    }

    public static void openByDefaultBrowser(String url) {
        if (url == null) {
            logger.info((Object)"url is empty,pls check it. record by eas_framework");
            return;
        }
        if (FrameWorkUtils.isWindowsPlatform()) {
            try {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler  " + url);
            }
            catch (Exception e) {
                FrameWorkUtils.openByIE(url);
            }
        } else if (FrameWorkUtils.isMacOS()) {
            try {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)(e.getMessage() + "-- record by eas_framework"), (Throwable)e);
            }
            catch (SecurityException e) {
                logger.error((Object)(e.getMessage() + "-- record by eas_framework"), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)(e.getMessage() + "-- record by eas_framework"), (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)(e.getMessage() + "-- record by eas_framework"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)(e.getMessage() + "-- record by eas_framework"), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)(e.getMessage() + "-- record by eas_framework"), (Throwable)e);
            }
        } else {
            logger.info((Object)"OS is not windows or MacOS,pls check it. record by eas_framework");
        }
    }

    public static void openByIE(String url) {
        try {
            Runtime.getRuntime().exec("start iexplore " + url);
        }
        catch (Exception er) {
            try {
                Runtime.getRuntime().exec("cmd /c start iexplore " + url);
            }
            catch (Exception err) {
                try {
                    Runtime.getRuntime().exec("command.com /c start iexplore " + url);
                }
                catch (Exception errr) {
                    logger.error((Object)("open ie browser error, pls check url. record by eas_framework \n" + errr.getMessage()));
                }
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static String getWindowsPlatform() {
        String os = System.getProperty("os.name");
        if (os == null) {
            os = "Unknown OS";
        }
        return os;
    }

    public static boolean isWindowsXP() {
        boolean b = false;
        if (FrameWorkUtils.isWindowsPlatform()) {
            b = windowsXP.equals(FrameWorkUtils.getWindowsPlatform());
        }
        return b;
    }

    public static boolean isWindows7() {
        boolean b = false;
        if (FrameWorkUtils.isWindowsPlatform()) {
            b = windows7.equals(FrameWorkUtils.getWindowsPlatform());
        }
        return b;
    }

    public static String getOSPlatform() {
        String os = System.getProperty("os.name", "Unknown OS");
        return os;
    }

    public static boolean isMacOS() {
        boolean b = false;
        b = macos.startsWith(FrameWorkUtils.getOSPlatform().trim());
        return b;
    }
}

