/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTMappingUtil;
import com.kingdee.bos.metadata.bot.BOTRelationEntryCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.spi.SPInfo;
import com.kingdee.bos.spi.SPManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.dap.DAPTransformResult;
import com.kingdee.eas.base.dap.DAPVoucherTypeEnum;
import com.kingdee.eas.base.dap.IDAPTransformerWrapper;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.BillBaseException;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.app.AbstractCoreBillBaseControllerBean;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class CoreBillBaseControllerBean
extends AbstractCoreBillBaseControllerBean {
    private static Logger logger = Logger.getLogger(CoreBillBaseControllerBean.class);
    private static final String VOUCHERFLAG = "fiVouchered";

    @Override
    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        CoreBillBaseInfo info = (CoreBillBaseInfo)model;
        info.setCU(super.getCU(ctx, info));
        super._addnew(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CoreBillBaseInfo info = (CoreBillBaseInfo)model;
        info.setCU(super.getCU(ctx, info));
        return super._addnew(ctx, (IObjectValue)info);
    }

    @Override
    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._submit(ctx, model);
    }

    @Override
    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBillBaseInfo coreBillInfo = this.getCoreBillInfo(ctx, pk);
        if (this.isVoucherFlag(ctx, pk)) {
            throw new BillBaseException(BillBaseException.FIVOUCHERED2);
        }
        this.isCanDelete(ctx, pk, coreBillInfo);
        super._delete(ctx, pk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void isCanDelete(Context ctx, IObjectPK pk, CoreBillBaseInfo coreBillInfo) throws BOSException, EASBizException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        if (iBTPManager.ifHaveDestBills(pk.toString())) throw new BillBaseException(BillBaseException.HASFLOWERBILL);
        try {
            if (!(coreBillInfo instanceof CoreBillBaseInfo)) return;
            iBTPManager.removeAllSRCRelation(coreBillInfo);
            return;
        }
        catch (BTPException ex) {
            throw new BTPException(BTPException.RELATIONDELETEERROR, (Throwable)ex);
        }
    }

    protected boolean isVoucherFlag(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBillBaseInfo coreBillInfo = this.getCoreBillInfo(ctx, pk);
        return coreBillInfo.getBoolean(VOUCHERFLAG);
    }

    private CoreBillBaseInfo getCoreBillInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo(VOUCHERFLAG));
        CoreBillBaseInfo coreBillInfo = this.getCoreBillBaseInfo(ctx, pk, selector);
        return coreBillInfo;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        return null;
    }

    @Override
    protected void _checkOut(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coerBillBaseInfo = (CoreBillBaseInfo)model;
        if (super._isExistPropertyName(ctx, coerBillBaseInfo, "ClosedStatus")) {
            coerBillBaseInfo.setInt("ClosedStatus", 2);
            if (coerBillBaseInfo.getId() == null) {
                throw new BillBaseException(BillBaseException.NOEXIST);
            }
            super.update(ctx, pk, coerBillBaseInfo);
        }
    }

    @Override
    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        if (super._isExistPropertyName(ctx, coreBillBaseInfo, "CheckedStatus")) {
            coreBillBaseInfo.setInt("CheckedStatus", 2);
            if (coreBillBaseInfo.getId() == null) {
                throw new BillBaseException(BillBaseException.NOEXIST);
            }
            super.update(ctx, pk, coreBillBaseInfo);
        }
    }

    @Override
    protected void _unpassAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        if (super._isExistPropertyName(ctx, coreBillBaseInfo, "CheckedStatus")) {
            coreBillBaseInfo.setInt("CheckedStatus", 1);
            if (coreBillBaseInfo.getId() == null) {
                throw new BillBaseException(BillBaseException.NOEXIST);
            }
            super.update(ctx, pk, coreBillBaseInfo);
        }
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        if (super._isExistPropertyName(ctx, coreBillBaseInfo, "BlockedStatus")) {
            coreBillBaseInfo.setInt("BlockedStatus", 2);
            if (coreBillBaseInfo.getId() == null) {
                throw new BillBaseException(BillBaseException.NOEXIST);
            }
            super.update(ctx, pk, coreBillBaseInfo);
        }
    }

    @Override
    protected void _unfreeze(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        if (super._isExistPropertyName(ctx, coreBillBaseInfo, "BlockedStatus")) {
            coreBillBaseInfo.setInt("BlockedStatus", 1);
            if (coreBillBaseInfo.getId() == null) {
                throw new BillBaseException(BillBaseException.NOEXIST);
            }
            super.update(ctx, pk, coreBillBaseInfo);
        }
    }

    @Override
    protected boolean _checkStatusFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        CoreBillBaseInfo coreBillBaseInfo = null;
        coreBillBaseInfo = (CoreBillBaseInfo)super.getValue(ctx, pk);
        boolean retv = false;
        retv = Boolean.getBoolean(Integer.toString(coreBillBaseInfo.getInt("BlockedStatus")));
        return retv;
    }

    @Override
    protected boolean _checkNumberDup(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)coreBillBaseInfo.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (coreBillBaseInfo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)coreBillBaseInfo.getId().toString(), CompareType.NOTEQUALS));
            filter.setMaskString("#0 and #1");
        }
        if (FilterUtility.hasFilterItem(this.getFilterForCheckNumber(coreBillBaseInfo))) {
            filter.mergeFilter(this.getFilterForCheckNumber(coreBillBaseInfo), "AND");
        }
        if (super._exists(ctx, filter)) {
            throw new EASBizException(EASBizException.CHECKDUPNUMBER, new Object[]{coreBillBaseInfo.getString("number"), ""});
        }
        return true;
    }

    protected FilterInfo getFilterForCheckNumber(CoreBillBaseInfo model) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)model.getCU().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    @Override
    protected boolean _checkNumberBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        String number = coreBillBaseInfo.getNumber();
        if (number == null || number.equals("")) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"number"});
        }
        return true;
    }

    @Override
    protected boolean _checkHandleTimeBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        Date bizDate = null;
        bizDate = coreBillBaseInfo.getBizDate();
        if (bizDate == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"bizDate"});
        }
        return true;
    }

    @Override
    protected boolean _checkHandlerBlank(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        UserInfo handler = coreBillBaseInfo.getHandler();
        if (handler == null) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{"Handler"});
        }
        return true;
    }

    @Override
    protected boolean _checkLineExist(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        return false;
    }

    protected boolean _getBillBaseInfoByName(Context ctx, IObjectPK pk, String propertyName) throws EASBizException, BOSException {
        IMetaDataLoader loader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        CoreBillBaseInfo coreBillBaseInfo = null;
        EntityObjectInfo entity = null;
        coreBillBaseInfo = (CoreBillBaseInfo)super.getValue(ctx, pk);
        entity = loader.getEntity(coreBillBaseInfo.getBOSType());
        PropertyInfo property = null;
        property = entity.getPropertyByName(propertyName);
        if (property == null) {
            throw new BillBaseException(BillBaseException.NOEXIST);
        }
        return Boolean.getBoolean(coreBillBaseInfo.get(propertyName).toString());
    }

    @Override
    protected SystemEnum _getOwnedSys(Context ctx) throws EASBizException, BOSException {
        SystemEnum retValue = SystemEnum.ACCOUNTSPAYABLE;
        return retValue;
    }

    @Override
    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        CoreBillBaseInfo coreBillInfo = this.getCoreBillBaseInfo(ctx, sourceBillPk);
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        if (wrapper != null) {
            return wrapper.undoTransformFromBill(coreBillInfo, DAPVoucherTypeEnum.FIVoucher);
        }
        return false;
    }

    @Override
    protected IObjectPK _saveRelations(Context ctx, IObjectValue model, IObjectCollection relations) throws BOSException, EASBizException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        IObjectPK pk = this._save(ctx, (IObjectValue)coreBillBaseInfo);
        if (relations == null) {
            return pk;
        }
        for (int i = 0; i < relations.size(); ++i) {
            BOTRelationInfo info = new BOTRelationInfo();
            info = (BOTRelationInfo)relations.getObject(i);
            info.setIsEffected(false);
            if (info.getId() != null && iBOTRelation.exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                iBOTRelation.update((IObjectPK)new ObjectUuidPK(info.getId()), info);
                continue;
            }
            iBOTRelation.addnew(info);
        }
        return pk;
    }

    @Override
    protected IObjectPK _submitRelations(Context ctx, IObjectValue model, IObjectCollection relations) throws BOSException, EASBizException {
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
        boolean isNew = model.get("id") == null;
        CoreBillBaseInfo coreBillBaseInfo = (CoreBillBaseInfo)model;
        IBTPManager iBTPManger = BTPManagerFactory.getLocalInstance((Context)ctx);
        IObjectPK pk = this._submit(ctx, (IObjectValue)coreBillBaseInfo);
        if (relations == null) {
            return pk;
        }
        for (int i = 0; i < relations.size(); ++i) {
            IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            String entriesName = BOTMappingUtil.getEntriesName((BOTMappingInfo)iBOTMapping.getBOTMappingInfo((IObjectPK)new ObjectUuidPK(((BOTRelationInfo)relations.getObject(i)).getBOTMappingID())));
            BOTRelationInfo info = new BOTRelationInfo();
            info = (BOTRelationInfo)((BOTRelationInfo)relations.getObject(i)).clone();
            info.setIsEffected(true);
            int relationEntriesInt = info.getRelationEntries().size();
            for (int j = 0; j < relationEntriesInt; ++j) {
                info.getRelationEntries().removeObject(0);
            }
            if (entriesName != null) {
                IObjectCollection billBaseEntries = (IObjectCollection)model.get(entriesName);
                BOTRelationEntryCollection botRelationEntries = ((BOTRelationInfo)relations.getObject(i)).getRelationEntries();
                block2: for (int j = 0; j < billBaseEntries.size(); ++j) {
                    for (int k = 0; k < botRelationEntries.size(); ++k) {
                        if (((CoreBillEntryBaseInfo)billBaseEntries.getObject(j)).getId() == null || !((CoreBillEntryBaseInfo)billBaseEntries.getObject(j)).getId().toString().equals(botRelationEntries.get(k).getDestEntryID())) continue;
                        info.getRelationEntries().add(botRelationEntries.get(k));
                        continue block2;
                    }
                }
            }
            if (isNew) continue;
            if (((BOTRelationInfo)relations.getObject(i)).getId() != null && iBOTRelation.exists((IObjectPK)new ObjectUuidPK(((BOTRelationInfo)relations.getObject(i)).getId()))) {
                iBOTRelation.delete((IObjectPK)new ObjectUuidPK(((BOTRelationInfo)relations.getObject(i)).getId()));
                iBTPManger.delReverseWrite((BOTRelationInfo)relations.getObject(i));
            }
            iBOTRelation.addnew(info);
            iBTPManger.reverseWrite(info);
        }
        return pk;
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        this._generateVoucher(ctx, new IObjectPK[]{sourceBillPk});
    }

    @Override
    protected void _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        for (int i = 0; i < sourceBillPkList.length; ++i) {
            String id = sourceBillPkList[i].toString();
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)id);
            if (index != 0) {
                sbMaskString.append(" or ");
            }
            sbMaskString.append("#");
            sbMaskString.append(String.valueOf(index));
            filterInfo.getFilterItems().add(filterItemInfo);
            ++index;
        }
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (this.getBOTPSelectors() != null) {
            entityViewInfo.put("selector", (Object)this.getBOTPSelectors());
        }
        CoreBillBaseCollection sourceBillCollection = this.getCoreBillBaseCollection(ctx, entityViewInfo);
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        if (sourceBillCollection.size() == 1) {
            wrapper.generateVoucher(sourceBillCollection.get(0), DAPVoucherTypeEnum.FIVoucher);
        } else {
            CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
            for (int i = 0; i < sourceBillPkList.length; ++i) {
                if (sourceBillPkList[i] == null) continue;
                billCollection.add(sourceBillCollection.get(BOSUuid.read((String)sourceBillPkList[i].toString())));
            }
            wrapper.generateVoucher(billCollection, DAPVoucherTypeEnum.FIVoucher);
        }
    }

    protected SelectorItemCollection getBOTPSelectors() {
        return null;
    }

    public SelectorItemCollection getSelectItemForBTP() {
        return this.getBOTPSelectors();
    }

    protected void verifyBillList(CoreBillBaseCollection sourceBillCollection) throws EASBizException {
        Iterator iter = sourceBillCollection.iterator();
        while (iter.hasNext()) {
            CoreBillBaseInfo sourceBill = (CoreBillBaseInfo)iter.next();
            if (!sourceBill.getBoolean(VOUCHERFLAG)) continue;
            throw new BillBaseException(BillBaseException.FIVOUCHERED);
        }
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._canUpdate(ctx, pk);
        this.innerUpdate(ctx, pk, model);
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        this._reverseSave(ctx, srcBillPK, srcBillVO);
    }

    @Override
    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum billOperStateEnun, IObjectValue relationInfo, IObjectValue destBillVO) throws BOSException, EASBizException {
        this._reverseSave(ctx, srcBillPK, srcBillVO, billOperStateEnun, relationInfo);
    }

    @Override
    protected DAPTransformResult _generateVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        if (wrapper != null) {
            if (botMappingPK != null) {
                return wrapper.transform((CoreBillBaseCollection)sourceBillCollection, DAPVoucherTypeEnum.FIVoucher, botMappingPK);
            }
            return wrapper.transform((CoreBillBaseCollection)sourceBillCollection, DAPVoucherTypeEnum.FIVoucher);
        }
        return null;
    }

    @Override
    protected DAPTransformResult _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = this.getSourceBillCollection(ctx, sourceBillPkList, botpSelectors);
        return this.generateVoucher(ctx, sourceBillCollection, botMappingPK);
    }

    private CoreBillBaseCollection getSourceBillCollection(Context ctx, IObjectPK[] sourceBillPkList, SelectorItemCollection botpSelectors) throws BOSException {
        CoreBillBaseCollection allSourceBillCollection = new CoreBillBaseCollection();
        int total = sourceBillPkList.length;
        int step = 500;
        Object[] partSourceBillPkList = total < step ? new IObjectPK[total] : new IObjectPK[step];
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        if (botpSelectors != null) {
            entityViewInfo.put("selector", (Object)botpSelectors);
        }
        int i = 0;
        int j = 0;
        while (i < total) {
            partSourceBillPkList[j] = sourceBillPkList[i];
            if (j == step - 1 || i == total - 1) {
                FilterInfo filterInfo = new FilterInfo();
                StringBuffer sbMaskString = new StringBuffer();
                String strIdLists = StringUtils.arrayToString((Object[])partSourceBillPkList, (String)",");
                sbMaskString.append("#" + String.valueOf(filterInfo.getFilterItems().size()));
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
                filterInfo.setMaskString(sbMaskString.toString());
                entityViewInfo.setFilter(filterInfo);
                CoreBillBaseCollection partSourceBillCollection = this.getCoreBillBaseCollection(ctx, entityViewInfo);
                allSourceBillCollection.addCollection(partSourceBillCollection);
                partSourceBillPkList = total - i - 1 > 0 && total - i - 1 < step ? new IObjectPK[total - i - 1] : new IObjectPK[step];
                j = -1;
            }
            ++i;
            ++j;
        }
        CoreBillBaseCollection sourceBillCollection = new CoreBillBaseCollection();
        for (int i2 = 0; i2 < sourceBillPkList.length; ++i2) {
            if (sourceBillPkList[i2] == null) continue;
            sourceBillCollection.add(allSourceBillCollection.get(BOSUuid.read((String)sourceBillPkList[i2].toString())));
        }
        return sourceBillCollection;
    }

    @Override
    protected List _generateVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK[] botMappingPKList, List botpSelectorsList) throws BOSException, EASBizException {
        ArrayList<CoreBillBaseCollection> sourceBillColList = new ArrayList<CoreBillBaseCollection>();
        for (int i = 0; i < botMappingPKList.length; ++i) {
            CoreBillBaseCollection sourceBillCollection = this.getSourceBillCollection(ctx, sourceBillPkList, (SelectorItemCollection)botpSelectorsList.get(i));
            sourceBillColList.add(sourceBillCollection);
        }
        return this.generateVoucher(ctx, sourceBillColList, botMappingPKList);
    }

    @Override
    protected List _generateVoucher(Context ctx, List sourceBillColList, IObjectPK[] botMappingPKList) throws BOSException, EASBizException {
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        if (wrapper != null && botMappingPKList.length > 0) {
            return wrapper.transform(sourceBillColList, DAPVoucherTypeEnum.FIVoucher, botMappingPKList);
        }
        return null;
    }

    @Override
    protected DAPTransformResult _previewVoucher(Context ctx, IObjectPK[] sourceBillPkList, IObjectPK botMappingPK, SelectorItemCollection botpSelectors) throws BOSException, EASBizException {
        CoreBillBaseCollection sourceBillCollection = this.getSourceBillCollection(ctx, sourceBillPkList, botpSelectors);
        return this.previewVoucher(ctx, (IObjectCollection)sourceBillCollection, botMappingPK);
    }

    @Override
    protected DAPTransformResult _previewVoucher(Context ctx, IObjectCollection sourceBillCollection, IObjectPK botMappingPK) throws BOSException, EASBizException {
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        if (wrapper != null && botMappingPK != null) {
            return wrapper.transformForPreview((CoreBillBaseCollection)sourceBillCollection, DAPVoucherTypeEnum.FIVoucher, botMappingPK);
        }
        return null;
    }

    @Override
    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        CoreBillBaseInfo info = (CoreBillBaseInfo)super._getValue(ctx, pk, sic);
        return info.getNumber();
    }

    @Override
    protected void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws BOSException, EASBizException {
    }

    @Override
    protected void _handleAfterTransform(Context ctx, String action, IObjectValue objectValue) throws BOSException, EASBizException {
    }

    public final IDAPTransformerWrapper getDapWrapper(Context ctx) throws BOSException {
        IDAPTransformerWrapper wrapper = null;
        if (SPManager.isSPInstalled((String)"DAPServerProvider")) {
            SPInfo spInfo = SPManager.getInstance().getSeviceProvider("DAPServerProvider");
            try {
                Constructor constructor = spInfo.getProviderClass().getConstructor(Context.class);
                Object dapWrapper = constructor.newInstance(ctx);
                return (IDAPTransformerWrapper)dapWrapper;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (InvocationTargetException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return wrapper;
    }

    @Override
    protected void _recycleNumber(Context ctx, IObjectValue bizObject, String org, String bindingproperty, String customString, String number) throws BOSException, EASBizException {
    }

    @Override
    protected void _newHandleAfterTransform(Context ctx, String action, IObjectCollection collection, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
    }

    @Override
    protected void _newHandleAfterTransform(Context ctx, String action, IObjectValue objectValue, String mappingId, IObjectCollection relationCol) throws BOSException, EASBizException {
    }

    @Override
    protected String _getAppSolutionID(Context ctx, IObjectPK id, IObjectValue model, String type) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected boolean _deletePCAVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        CoreBillBaseInfo coreBillInfo = this.getCoreBillBaseInfo(ctx, sourceBillPk);
        IDAPTransformerWrapper wrapper = this.getDapWrapper(ctx);
        if (wrapper != null) {
            return wrapper.undoTransformFromBill(coreBillInfo, DAPVoucherTypeEnum.PCVoucher);
        }
        return false;
    }

    @Override
    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        return null;
    }
}

