/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.framework.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ActivityInstInfo;
import com.kingdee.bos.workflow.AssignmentInfo;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.WfAssignmentState;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.dap.IDAPTransformerWrapper;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.FrameHelperFacadeFactory;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.app.AbstractCoreBillListUIHandler;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.config.ConfigControllerFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class CoreBillListUIHandler
extends AbstractCoreBillListUIHandler {
    public static final String VOUCHERFLAG = "fiVouchered";

    @Override
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleInit(request, response, context);
        ParamControlFactory.getLocalInstance((Context)context).getParamValue(null, "IS_AUDIT_SIGN");
        FrameHelperFacadeFactory.getLocalInstance(context).getSignatrueConfig();
        if (request.getBosType() != null) {
            this._handleInitDapButtons(request, response, context);
        }
    }

    @Override
    protected ResponseContext _tableRequestData(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (request.getBosType() != null) {
            this._handleInitDapButtons(request, response, context);
        }
        try {
            ConfigControllerFactory.getLocalInstance(context).getUserConfigData("HeadView", request.getMetaDataPK().getFullName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super._tableRequestData(request, response, context);
    }

    protected void _handleInitDapButtons(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (request.get("isVoucherVisible") == null || request.getBosType() == null) {
            return;
        }
        IDAPTransformerWrapper wrapper = BaseFrameService.getDapWrapper(context);
        if (wrapper != null) {
            wrapper.isCanVoucher(request.getBosType().toString());
        }
    }

    protected CoreBillBaseCollection filterBillListForBTP(RequestContext request, Context context) throws Exception {
        List idList = request.getIdList();
        if (idList == null || idList.size() == 0) {
            return null;
        }
        Object[] filterObj = new Object[idList.size()];
        FilterInfo filterInfo = new FilterInfo();
        Iterator idIter = idList.iterator();
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        while (idIter.hasNext()) {
            String id = idIter.next().toString();
            filterObj[index] = id;
            ++index;
        }
        String strIdLists = StringUtils.arrayToString((Object[])idList.toArray(), (String)",");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        if (request.isVoucherAction()) {
            filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, (Object)Boolean.FALSE, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, null, CompareType.EQUALS));
            sbMaskString.append("#0 and (#1 or #2)");
        } else {
            sbMaskString.append("#0");
        }
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("id"));
        entityViewInfo.setFilter(filterInfo);
        ICoreBillBase coreBill = (ICoreBillBase)this.getBizInterface(request, context);
        CoreBillBaseCollection sourceBillCollection = coreBill.getCoreBillBaseCollection(entityViewInfo);
        return sourceBillCollection;
    }

    @Override
    protected void _handleActionCreateTo(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVoucherAction(false);
        this.filterBillListForBTP(request, context);
    }

    @Override
    protected void _handleActionCopyTo(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionTraceUp(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVoucherAction(false);
        this.filterBillListForBTP(request, context);
    }

    @Override
    protected void _handleActionTraceDown(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVoucherAction(false);
        this.filterBillListForBTP(request, context);
    }

    @Override
    protected void _handleActionVoucher(RequestContext request, ResponseContext response, Context context) throws Exception {
        request.setVoucherAction(true);
        CoreBillBaseCollection sourceBillCollection = this.filterBillListForBTP(request, context);
        if (sourceBillCollection != null && sourceBillCollection.size() > 0) {
            super.handleQuery(request, response, context);
        }
    }

    protected boolean isNoVoucherExist(RequestContext request, Context context) throws Exception {
        List list = request.getIdList();
        String strIdLists = StringUtils.arrayToString((Object[])list.toArray(), (String)",");
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        filterInfo.getFilterItems().clear();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)strIdLists, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, (Object)Boolean.TRUE, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo(VOUCHERFLAG, null, CompareType.EQUALS));
        maskString = new StringBuffer();
        maskString.append("#0 AND (#1 or #2)");
        filterInfo.setMaskString(maskString.toString());
        ICoreBillBase coreBill = (ICoreBillBase)this.getBizInterface(request, context);
        boolean isExist = coreBill.exists(filterInfo);
        return isExist;
    }

    @Override
    protected void _handleActionDelVoucher(RequestContext request, ResponseContext response, Context context) throws Exception {
        this.isNoVoucherExist(request, context);
    }

    public void handleDelVoucher(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.handleQuery(request, response, context);
    }

    @Override
    protected void _handleActionAuditResult(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewDoProccess(RequestContext request, ResponseContext response, Context context) throws Exception {
        String id = request.getId();
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        ProcessInstInfo processInstInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(id);
        BaseFrameService.getMultiKey(response, IEnactmentService.class, "getProcessInstanceByHoldedObjectId", new Class[]{String.class}, new Object[]{id}, procInsts);
        int n = procInsts.length;
        for (int i = 0; i < n; ++i) {
            if (!procInsts[i].getState().startsWith("open")) continue;
            processInstInfo = procInsts[i];
        }
        if (processInstInfo == null) {
            procInsts = service.getAllProcessInstancesByBizobjId(id);
            BaseFrameService.getMultiKey(response, IEnactmentService.class, "getAllProcessInstancesByBizobjId", new Class[]{String.class}, new Object[]{id}, procInsts);
        }
    }

    @Override
    protected void _handleActionMultiapprove(RequestContext request, ResponseContext response, Context context) throws Exception {
        ArrayList idList = (ArrayList)request.get("idList");
        if (!idList.isEmpty()) {
            String userID = (String)request.get("userID");
            IMetaDataPK uiObjPK = (IMetaDataPK)request.get("uiObjPK");
            String action = (String)request.get("action");
            IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
            Map assignmentInfoListMap = service.checkAssignmentInfo(idList.toArray(new String[idList.size()]), uiObjPK, action, userID);
            HashMap assignmentInfoMap = new HashMap();
            block0: for (Map.Entry entry : assignmentInfoListMap.entrySet()) {
                Object key = entry.getKey();
                List value = (List)entry.getValue();
                if (value == null || value.size() <= 0) continue;
                for (int i = 0; i <= value.size() - 1; ++i) {
                    AssignmentInfo assignmentInfo = (AssignmentInfo)value.get(i);
                    WfAssignmentState assignmentState = assignmentInfo.getState();
                    if (!WfAssignmentState.ASSIGNED.equals((Object)assignmentState) && !WfAssignmentState.ACCEPTED.equals((Object)assignmentState)) continue;
                    assignmentInfoMap.put(key, assignmentInfo.getAssignmentId().toString());
                    continue block0;
                }
            }
            Iterator iterator = assignmentInfoMap.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry entry;
                entry = iterator.next();
                String assignmentID = (String)entry.getValue();
                String actInstId = service.getAssignmentById(assignmentID).getActInstId();
                ActivityInstInfo actInstInfo = service.getActivityInstByActInstId(actInstId);
                service.getActDefByActInstInfo(actInstInfo);
            }
        }
    }

    @Override
    protected void _handleActionNextPerson(RequestContext request, ResponseContext response, Context context) throws Exception {
        String bizObjID = (String)request.get("bizObjID");
        String userID = (String)request.get("userID");
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        AssignmentInfo[] assignmentInfoArray = service.checkAssignmentInfos(bizObjID, userID);
        if (assignmentInfoArray != null && assignmentInfoArray.length > 0) {
            service.getProcessDefByDefineHashValue(assignmentInfoArray[assignmentInfoArray.length - 1].getProcDefHashValue());
        }
    }

    @Override
    protected void _handleActionWorkFlowG(RequestContext request, ResponseContext response, Context context) throws Exception {
        this._handleActionViewDoProccess(request, response, context);
    }

    @Override
    protected void _handleActionSendSmsMessage(RequestContext request, ResponseContext response, Context context) throws Exception {
        String id = (String)request.get("id");
        Locale locale = (Locale)request.get("locale");
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        Set result = service.getWfSendingMsgBundle(id, locale);
        BaseFrameService.getMultiKey(response, IEnactmentService.class, "getWfSendingMsgBundle", new Class[]{String.class, Locale.class}, new Object[]{id, locale}, result);
    }

    @Override
    protected void _handleactionWorkflowList(RequestContext request, ResponseContext response, Context context) throws Exception {
        String id = request.getId();
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)context);
        service.getProcessInstanceByHoldedObjectId(id);
    }

    @Override
    protected void _handleactoinViewSignature(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionSignature(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionExportSave(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionExportSelectedSave(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleactionProcductVal(RequestContext request, ResponseContext response, Context context) throws Exception {
    }
}

